/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.tools.html;

import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;

public abstract class PrintBugDescriptions {
    public void print() throws IOException {
        DetectorFactoryCollection factories = DetectorFactoryCollection.instance();
        HashSet<BugPattern> enabledPatternSet = new HashSet<BugPattern>();
        Iterator<Object> i = factories.factoryIterator();
        while (i.hasNext()) {
            DetectorFactory factory = i.next();
            if (!this.isEnabled(factory)) continue;
            enabledPatternSet.addAll(factory.getReportedBugPatterns());
        }
        this.prologue();
        i = DetectorFactoryCollection.instance().bugPatternIterator();
        while (i.hasNext()) {
            BugPattern bugPattern = (BugPattern)i.next();
            if (!enabledPatternSet.contains(bugPattern)) continue;
            this.emit(bugPattern);
        }
        this.epilogue();
    }

    protected boolean isEnabled(DetectorFactory factory) {
        return factory.isDefaultEnabled();
    }

    protected abstract void prologue() throws IOException;

    protected abstract void emit(BugPattern var1) throws IOException;

    protected abstract void epilogue() throws IOException;
}

