/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeNode;
import org.h2.message.Message;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.DataPage;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageBtreeLeaf
extends PageBtree {
    private static final int OFFSET_LENGTH = 2;

    private PageBtreeLeaf(PageBtreeIndex pageBtreeIndex, int n, Data data) {
        super(pageBtreeIndex, n, data);
    }

    public static Page read(PageBtreeIndex pageBtreeIndex, Data data, int n) throws SQLException {
        PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(pageBtreeIndex, n, data);
        pageBtreeLeaf.read();
        return pageBtreeLeaf;
    }

    static PageBtreeLeaf create(PageBtreeIndex pageBtreeIndex, int n, int n2) {
        PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(pageBtreeIndex, n, pageBtreeIndex.getPageStore().createData());
        pageBtreeLeaf.parentPageId = n2;
        pageBtreeLeaf.writeHead();
        pageBtreeLeaf.start = pageBtreeLeaf.data.length();
        return pageBtreeLeaf;
    }

    private void read() throws SQLException {
        this.data.reset();
        int n = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        this.onlyPosition = (n & 0x10) == 0;
        int n2 = this.data.readVarInt();
        if (n2 != this.index.getId()) {
            throw Message.getSQLException(90030, "page:" + this.getPos() + " expected index:" + this.index.getId() + "got:" + n2);
        }
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.rows = new SearchRow[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
    }

    int addRowTry(SearchRow searchRow) throws SQLException {
        int n;
        int n2;
        int n3;
        int n4 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
        int n5 = this.index.getPageStore().getPageSize();
        int n6 = n3 = this.entryCount == 0 ? n5 : this.offsets[this.entryCount - 1];
        if (n3 - n4 < this.start + 2) {
            if (this.entryCount > 1) {
                int n7 = this.find(searchRow, false, true, true);
                if (this.entryCount < 5) {
                    return this.entryCount / 2;
                }
                int n8 = this.entryCount / 3;
                return n7 < n8 ? n8 : (n7 >= 2 * n8 ? 2 * n8 : n7);
            }
            this.onlyPosition = true;
            n2 = n5;
            for (int i = 0; i < this.entryCount; ++i) {
                this.offsets[i] = n2 -= this.index.getRowSize(this.data, this.getRow(i), true);
            }
            n3 = this.entryCount == 0 ? n5 : this.offsets[this.entryCount - 1];
            n4 = this.index.getRowSize(this.data, searchRow, true);
            if (SysProperties.CHECK && n3 - n4 < this.start + 2) {
                throw Message.throwInternalError();
            }
        }
        this.written = false;
        n2 = n3 - n4;
        int[] nArray = new int[this.entryCount + 1];
        SearchRow[] searchRowArray = new SearchRow[this.entryCount + 1];
        if (this.entryCount == 0) {
            n = 0;
        } else {
            this.readAllRows();
            n = this.find(searchRow, false, true, true);
            System.arraycopy(this.offsets, 0, nArray, 0, n);
            System.arraycopy(this.rows, 0, searchRowArray, 0, n);
            if (n < this.entryCount) {
                for (int i = n; i < this.entryCount; ++i) {
                    nArray[i + 1] = this.offsets[i] - n4;
                }
                n2 = (n == 0 ? n5 : this.offsets[n - 1]) - n4;
                System.arraycopy(this.rows, n, searchRowArray, n + 1, this.entryCount - n);
            }
        }
        ++this.entryCount;
        this.start += 2;
        nArray[n] = n2;
        searchRowArray[n] = searchRow;
        this.offsets = nArray;
        this.rows = searchRowArray;
        this.index.getPageStore().updateRecord(this, true, this.data);
        return -1;
    }

    private void removeRow(int n) throws SQLException {
        this.readAllRows();
        --this.entryCount;
        this.written = false;
        if (this.entryCount <= 0) {
            Message.throwInternalError();
        }
        int[] nArray = new int[this.entryCount];
        SearchRow[] searchRowArray = new SearchRow[this.entryCount];
        System.arraycopy(this.offsets, 0, nArray, 0, n);
        System.arraycopy(this.rows, 0, searchRowArray, 0, n);
        int n2 = n > 0 ? this.offsets[n - 1] : this.index.getPageStore().getPageSize();
        int n3 = n2 - this.offsets[n];
        for (int i = n; i < this.entryCount; ++i) {
            nArray[i] = this.offsets[i + 1] + n3;
        }
        System.arraycopy(this.rows, n + 1, searchRowArray, n, this.entryCount - n);
        this.start -= 2;
        this.offsets = nArray;
        this.rows = searchRowArray;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    PageBtree split(int n) throws SQLException {
        int n2 = this.index.getPageStore().allocatePage();
        PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(this.index, n2, this.index.getPageStore().createData());
        pageBtreeLeaf.parentPageId = this.parentPageId;
        int n3 = n;
        while (n3 < this.entryCount) {
            pageBtreeLeaf.addRowTry(this.getRow(n));
            this.removeRow(n);
        }
        return pageBtreeLeaf;
    }

    PageBtreeLeaf getFirstLeaf() {
        return this;
    }

    PageBtreeLeaf getLastLeaf() {
        return this;
    }

    SearchRow remove(SearchRow searchRow) throws SQLException {
        int n = this.find(searchRow, false, false, true);
        SearchRow searchRow2 = this.getRow(n);
        if (this.index.compareRows(searchRow, searchRow2) != 0 || searchRow2.getKey() != searchRow.getKey()) {
            throw Message.getSQLException(90112, this.index.getSQL() + ": " + searchRow);
        }
        if (this.entryCount == 1) {
            return searchRow;
        }
        this.removeRow(n);
        this.index.getPageStore().updateRecord(this, true, this.data);
        if (n == this.entryCount) {
            return this.getRow(n - 1);
        }
        return null;
    }

    void freeChildren() {
    }

    int getRowCount() {
        return this.entryCount;
    }

    void setRowCountStored(int n) {
    }

    public int getByteCount(DataPage dataPage) {
        return this.index.getPageStore().getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.write();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void writeHead() {
        this.data.writeByte((byte)(4 | (this.onlyPosition ? 0 : 16)));
        this.data.writeShortInt(0);
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeShortInt(this.entryCount);
    }

    private void write() throws SQLException {
        int n;
        if (this.written) {
            return;
        }
        this.readAllRows();
        this.data.reset();
        this.writeHead();
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeShortInt(this.offsets[n]);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.index.writeRow(this.data, this.offsets[n], this.rows[n], this.onlyPosition);
        }
        this.written = true;
    }

    void find(PageBtreeCursor pageBtreeCursor, SearchRow searchRow, boolean bl) throws SQLException {
        int n = this.find(searchRow, bl, false, false);
        if (n > this.entryCount) {
            if (this.parentPageId == 0) {
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.find(pageBtreeCursor, searchRow, bl);
            return;
        }
        pageBtreeCursor.setCurrent(this, n);
    }

    void last(PageBtreeCursor pageBtreeCursor) {
        pageBtreeCursor.setCurrent(this, this.entryCount - 1);
    }

    void remapChildren() {
    }

    void nextPage(PageBtreeCursor pageBtreeCursor) throws SQLException {
        if (this.parentPageId == 0) {
            pageBtreeCursor.setCurrent(null, 0);
            return;
        }
        PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
        pageBtreeNode.nextPage(pageBtreeCursor, this.getPos());
    }

    void previousPage(PageBtreeCursor pageBtreeCursor) throws SQLException {
        if (this.parentPageId == 0) {
            pageBtreeCursor.setCurrent(null, 0);
            return;
        }
        PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
        pageBtreeNode.previousPage(pageBtreeCursor, this.getPos());
    }

    public String toString() {
        return "page[" + this.getPos() + "] b-tree leaf table:" + this.index.getId() + " entries:" + this.entryCount;
    }

    public void moveTo(Session session, int n) throws SQLException {
        PageStore pageStore = this.index.getPageStore();
        PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(this.index, n, pageStore.createData());
        this.readAllRows();
        pageBtreeLeaf.rows = this.rows;
        pageBtreeLeaf.entryCount = this.entryCount;
        pageBtreeLeaf.offsets = this.offsets;
        pageBtreeLeaf.onlyPosition = this.onlyPosition;
        pageBtreeLeaf.parentPageId = this.parentPageId;
        pageBtreeLeaf.start = this.start;
        pageStore.updateRecord(pageBtreeLeaf, false, null);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n);
        } else {
            PageBtreeNode pageBtreeNode = (PageBtreeNode)pageStore.getPage(this.parentPageId);
            pageBtreeNode.moveChild(this.getPos(), n);
        }
        pageStore.freePage(this.getPos(), true, this.data);
    }
}

