/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.CompressNo;
import org.h2.compress.Compressor;
import org.h2.compress.LZFInputStream;
import org.h2.compress.LZFOutputStream;
import org.h2.message.Message;
import org.h2.util.MemoryUtils;
import org.h2.util.StringUtils;

public class CompressTool {
    private static final CompressTool INSTANCE = new CompressTool();
    private static final int MAX_BUFFER_SIZE = 393216;
    private byte[] cachedBuffer;

    private CompressTool() {
    }

    private byte[] getBuffer(int n) {
        if (n > 393216) {
            return MemoryUtils.newBytes(n);
        }
        if (this.cachedBuffer == null || this.cachedBuffer.length < n) {
            this.cachedBuffer = MemoryUtils.newBytes(n);
        }
        return this.cachedBuffer;
    }

    public static CompressTool getInstance() {
        return INSTANCE;
    }

    public byte[] compress(byte[] byArray, String string) throws SQLException {
        int n = byArray.length;
        if (byArray.length < 5) {
            string = "NO";
        }
        Compressor compressor = this.getCompressor(string);
        byte[] byArray2 = this.getBuffer((n < 100 ? n + 100 : n) * 2);
        int n2 = this.compress(byArray, byArray.length, compressor, byArray2);
        byte[] byArray3 = MemoryUtils.newBytes(n2);
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    public synchronized int compress(byte[] byArray, int n, Compressor compressor, byte[] byArray2) {
        int n2 = 0;
        byArray2[0] = (byte)compressor.getAlgorithm();
        int n3 = 1 + this.writeInt(byArray2, 1, n);
        n2 = compressor.compress(byArray, n, byArray2, n3);
        if (n2 > n + n3 || n2 <= 0) {
            byArray2[0] = 0;
            System.arraycopy(byArray, 0, byArray2, n3, n);
            n2 = n + n3;
        }
        return n2;
    }

    public byte[] expand(byte[] byArray) throws SQLException {
        byte by = byArray[0];
        Compressor compressor = this.getCompressor(by);
        try {
            int n = this.readInt(byArray, 1);
            int n2 = 1 + this.getLength(n);
            byte[] byArray2 = MemoryUtils.newBytes(n);
            compressor.expand(byArray, n2, byArray.length - n2, byArray2, 0, n);
            return byArray2;
        }
        catch (Exception exception) {
            throw Message.getSQLException(90104, exception, new String[0]);
        }
    }

    public void expand(byte[] byArray, byte[] byArray2, int n) throws SQLException {
        byte by = byArray[0];
        Compressor compressor = this.getCompressor(by);
        try {
            int n2 = this.readInt(byArray, 1);
            int n3 = 1 + this.getLength(n2);
            compressor.expand(byArray, n3, byArray.length - n3, byArray2, n, n2);
        }
        catch (Exception exception) {
            throw Message.getSQLException(90104, exception, new String[0]);
        }
    }

    private int readInt(byte[] byArray, int n) {
        int n2;
        if ((n2 = byArray[n++] & 0xFF) < 128) {
            return n2;
        }
        if (n2 < 192) {
            return ((n2 & 0x3F) << 8) + (byArray[n] & 0xFF);
        }
        if (n2 < 224) {
            return ((n2 & 0x1F) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
        }
        if (n2 < 240) {
            return ((n2 & 0xF) << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
        }
        return ((byArray[n++] & 0xFF) << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    private int writeInt(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            byArray[n++] = -16;
            byArray[n++] = (byte)(n2 >> 24);
            byArray[n++] = (byte)(n2 >> 16);
            byArray[n++] = (byte)(n2 >> 8);
            byArray[n] = (byte)n2;
            return 5;
        }
        if (n2 < 128) {
            byArray[n] = (byte)n2;
            return 1;
        }
        if (n2 < 16384) {
            byArray[n++] = (byte)(0x80 | n2 >> 8);
            byArray[n] = (byte)n2;
            return 2;
        }
        if (n2 < 0x200000) {
            byArray[n++] = (byte)(0xC0 | n2 >> 16);
            byArray[n++] = (byte)(n2 >> 8);
            byArray[n] = (byte)n2;
            return 3;
        }
        if (n2 < 0x10000000) {
            byArray[n++] = (byte)(0xE0 | n2 >> 24);
            byArray[n++] = (byte)(n2 >> 16);
            byArray[n++] = (byte)(n2 >> 8);
            byArray[n] = (byte)n2;
            return 4;
        }
        byArray[n++] = -16;
        byArray[n++] = (byte)(n2 >> 24);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n] = (byte)n2;
        return 5;
    }

    private int getLength(int n) {
        if (n < 0) {
            return 5;
        }
        if (n < 128) {
            return 1;
        }
        if (n < 16384) {
            return 2;
        }
        if (n < 0x200000) {
            return 3;
        }
        if (n < 0x10000000) {
            return 4;
        }
        return 5;
    }

    private Compressor getCompressor(String string) throws SQLException {
        if (string == null) {
            string = "LZF";
        }
        int n = string.indexOf(32);
        String string2 = null;
        if (n > 0) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        int n2 = this.getCompressAlgorithm(string);
        Compressor compressor = this.getCompressor(n2);
        compressor.setOptions(string2);
        return compressor;
    }

    public int getCompressAlgorithm(String string) throws SQLException {
        if ("NO".equals(string = StringUtils.toUpperEnglish(string))) {
            return 0;
        }
        if ("LZF".equals(string)) {
            return 1;
        }
        if ("DEFLATE".equals(string)) {
            return 2;
        }
        throw Message.getSQLException(90103, string);
    }

    private Compressor getCompressor(int n) throws SQLException {
        switch (n) {
            case 0: {
                return new CompressNo();
            }
            case 1: {
                return new CompressLZF();
            }
            case 2: {
                return new CompressDeflate();
            }
        }
        throw Message.getSQLException(90103, "" + n);
    }

    public static OutputStream wrapOutputStream(OutputStream outputStream, String string, String string2) throws SQLException {
        try {
            if ("GZIP".equals(string)) {
                outputStream = new GZIPOutputStream(outputStream);
            } else if ("ZIP".equals(string)) {
                ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
                zipOutputStream.putNextEntry(new ZipEntry(string2));
                outputStream = zipOutputStream;
            } else if ("DEFLATE".equals(string)) {
                outputStream = new DeflaterOutputStream(outputStream);
            } else if ("LZF".equals(string)) {
                outputStream = new LZFOutputStream(outputStream);
            } else if (string != null) {
                throw Message.getSQLException(90103, string);
            }
            return outputStream;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    public static InputStream wrapInputStream(InputStream inputStream, String string, String string2) throws SQLException {
        try {
            if ("GZIP".equals(string)) {
                inputStream = new GZIPInputStream(inputStream);
            } else if ("ZIP".equals(string)) {
                ZipEntry zipEntry;
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                do {
                    if ((zipEntry = zipInputStream.getNextEntry()) != null) continue;
                    return null;
                } while (!string2.equals(zipEntry.getName()));
                inputStream = zipInputStream;
            } else if ("DEFLATE".equals(string)) {
                inputStream = new InflaterInputStream(inputStream);
            } else if ("LZF".equals(string)) {
                inputStream = new LZFInputStream(inputStream);
            } else if (string != null) {
                throw Message.getSQLException(90103, string);
            }
            return inputStream;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }
}

