/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess;

import com.ibm.db2.cmx.runtime.internal.repository.metadata.MetadataColumn;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.MetadataColumnUtilities;
import com.ibm.db2.cmx.runtime.internal.repository.util.Base64;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class GenericSQLWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeSQLUpdate(Connection connection, String string, Object[] objectArray) throws SQLException {
        int n2 = 0;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            for (int i10 = 0; i10 < objectArray.length; ++i10) {
                Object object = objectArray[i10];
                if (object instanceof String) {
                    preparedStatement.setString(i10 + 1, (String)object);
                    continue;
                }
                if (object instanceof byte[]) {
                    preparedStatement.setBytes(i10 + 1, (byte[])object);
                    continue;
                }
                if (object instanceof Integer) {
                    preparedStatement.setInt(i10 + 1, (Integer)object);
                    continue;
                }
                if (object instanceof Blob) {
                    preparedStatement.setBlob(i10 + 1, (Blob)object);
                    continue;
                }
                if (!(object instanceof Timestamp)) continue;
                preparedStatement.setTimestamp(i10 + 1, (Timestamp)object);
            }
            n2 = preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return n2;
    }

    public static PreparedStatement prepareInsert(Connection connection, String string, String string2, MetadataColumn[] metadataColumnArray) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("insert into ");
        stringBuilder.append(string);
        stringBuilder.append('.');
        stringBuilder.append(string2);
        stringBuilder.append(" (");
        String string3 = GenericSQLWriter.buildColumnClause(metadataColumnArray);
        stringBuilder.append(string3);
        stringBuilder.append(" ) VALUES( ");
        int n2 = MetadataColumnUtilities.getNumCols(metadataColumnArray, false);
        for (int i10 = 0; i10 < n2; ++i10) {
            if (i10 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(" ?");
        }
        stringBuilder.append(')');
        PreparedStatement preparedStatement = null;
        preparedStatement = connection.prepareStatement(stringBuilder.toString(), 1);
        return preparedStatement;
    }

    private static String buildColumnClause(MetadataColumn[] metadataColumnArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (MetadataColumn metadataColumn : metadataColumnArray) {
            if (metadataColumn == null || metadataColumn.isTableKey) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(metadataColumn.name);
        }
        return stringBuilder.toString();
    }

    public static Integer executeSQL(PreparedStatement preparedStatement, Object[] objectArray, MetadataColumn[] metadataColumnArray) throws SQLException {
        Integer n2 = null;
        int n3 = 1;
        for (int i10 = 0; i10 < metadataColumnArray.length; ++i10) {
            Object object;
            MetadataColumn metadataColumn = metadataColumnArray[i10];
            if (metadataColumn == null || metadataColumn.isTableKey) continue;
            if (metadataColumn.sqlType == 1 || metadataColumn.sqlType == 2005 || metadataColumn.sqlType == 12) {
                if (objectArray[i10] != null) {
                    preparedStatement.setString(n3, objectArray[i10].toString());
                } else {
                    preparedStatement.setString(n3, null);
                }
            } else if (metadataColumn.sqlType == 4) {
                if (objectArray[i10] != null) {
                    object = Integer.valueOf(objectArray[i10].toString());
                    preparedStatement.setInt(n3, (Integer)object);
                } else {
                    preparedStatement.setNull(n3, 4);
                }
            } else if (metadataColumn.sqlType == 8) {
                if (objectArray[i10] != null) {
                    double d10 = Double.valueOf(objectArray[i10].toString());
                    preparedStatement.setDouble(n3, d10);
                } else {
                    preparedStatement.setNull(n3, 8);
                }
            } else if (metadataColumn.sqlType == -5) {
                if (objectArray[i10] != null) {
                    long l8 = Long.valueOf(objectArray[i10].toString());
                    preparedStatement.setLong(n3, l8);
                } else {
                    preparedStatement.setNull(n3, -5);
                }
            } else if (metadataColumn.sqlType == 2004) {
                if (objectArray[i10] != null) {
                    object = objectArray[i10].toString();
                    byte[] byArray = Base64.decode(((String)object).toCharArray(), ((String)object).length());
                    preparedStatement.setBytes(n3, byArray);
                } else {
                    preparedStatement.setNull(n3, 2004);
                }
            } else if (metadataColumn.sqlType == 93) {
                if (objectArray[i10] != null) {
                    object = Timestamp.valueOf(objectArray[i10].toString());
                    preparedStatement.setTimestamp(n3, (Timestamp)object);
                } else {
                    preparedStatement.setNull(n3, 93);
                }
            } else {
                object = "unknown type " + metadataColumn.sqlType + " for column " + metadataColumn.name;
                System.out.println((String)object);
                throw new RuntimeException((String)object);
            }
            ++n3;
        }
        preparedStatement.executeUpdate();
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        if (resultSet != null && resultSet.next()) {
            n2 = resultSet.getInt(1);
            resultSet.close();
        }
        return n2;
    }
}

