/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core;

import com.microsoft.windowsazure.core.FilterableService;
import com.microsoft.windowsazure.core.UserAgentFilter;
import com.microsoft.windowsazure.core.UserAgentFilterAdapter;
import com.microsoft.windowsazure.core.pipeline.apache.HttpRequestInterceptorAdapter;
import com.microsoft.windowsazure.core.pipeline.apache.HttpResponseInterceptorAdapter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class ServiceClient<TClient>
implements FilterableService<TClient>,
Closeable {
    private final ExecutorService executorService;
    private CloseableHttpClient httpClient;
    private final HttpClientBuilder httpClientBuilder;

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            HttpHost proxy;
            String proxyHost = System.getProperty("http.proxyHost");
            String proxyPort = System.getProperty("http.proxyPort");
            if (proxyHost != null && proxyPort != null && (proxy = new HttpHost(proxyHost, Integer.parseInt(proxyPort))) != null) {
                this.httpClientBuilder.setProxy(proxy);
            }
            this.httpClient = this.httpClientBuilder.build();
        }
        return this.httpClient;
    }

    protected ServiceClient(HttpClientBuilder httpClientBuilder, ExecutorService executorService) {
        this.httpClientBuilder = httpClientBuilder;
        this.executorService = executorService;
        this.httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)new UserAgentFilterAdapter(new UserAgentFilter()));
    }

    protected abstract TClient newInstance(HttpClientBuilder var1, ExecutorService var2);

    @Override
    public TClient withRequestFilterFirst(ServiceRequestFilter serviceRequestFilter) {
        this.httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)new HttpRequestInterceptorAdapter(serviceRequestFilter));
        return this.newInstance(this.httpClientBuilder, this.executorService);
    }

    @Override
    public TClient withRequestFilterLast(ServiceRequestFilter serviceRequestFilter) {
        this.httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new HttpRequestInterceptorAdapter(serviceRequestFilter));
        return this.newInstance(this.httpClientBuilder, this.executorService);
    }

    @Override
    public TClient withResponseFilterFirst(ServiceResponseFilter serviceResponseFilter) {
        this.httpClientBuilder.addInterceptorFirst((HttpResponseInterceptor)new HttpResponseInterceptorAdapter(serviceResponseFilter));
        return this.newInstance(this.httpClientBuilder, this.executorService);
    }

    @Override
    public TClient withResponseFilterLast(ServiceResponseFilter serviceResponseFilter) {
        this.httpClientBuilder.addInterceptorLast((HttpResponseInterceptor)new HttpResponseInterceptorAdapter(serviceResponseFilter));
        return this.newInstance(this.httpClientBuilder, this.executorService);
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }
}

