/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.configuration;

import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.utils.KeyStoreCredential;
import com.microsoft.windowsazure.core.utils.KeyStoreType;
import com.microsoft.windowsazure.credentials.CertificateCloudCredentials;
import java.io.IOException;
import java.net.URI;
import org.apache.http.impl.client.LaxRedirectStrategy;

public final class ManagementConfiguration {
    public static final String SUBSCRIPTION_CLOUD_CREDENTIALS = "com.microsoft.windowsazure.Configuration.credentials";
    public static final String KEYSTORE_PATH = "management.keystore.path";
    public static final String KEYSTORE_PASSWORD = "management.keystore.password";
    public static final String KEYSTORE_TYPE = "management.keystore.type";
    public static final String URI = "management.uri";
    public static final String AZURE_TEST_MODE = "test.mode";
    public static final String SUBSCRIPTION_ID = "management.subscription.id";
    public static final String CLOUD_SERVICE_NAME = "management.cloud.service.name";
    public static final String JOB_COLLECTION_NAME = "management.job.collection.name";

    private ManagementConfiguration() {
    }

    public static Configuration configure(URI uri, String subscriptionId, String keyStoreLocation, String keyStorePassword) throws IOException {
        return ManagementConfiguration.configure(null, Configuration.getInstance(), uri, subscriptionId, keyStoreLocation, keyStorePassword);
    }

    public static Configuration configure(URI uri, String subscriptionId, String keyStoreLocation, String keyStorePassword, KeyStoreType type) throws IOException {
        return ManagementConfiguration.configure(null, Configuration.getInstance(), uri, subscriptionId, keyStoreLocation, keyStorePassword, type);
    }

    public static Configuration configure(URI uri, String subscriptionId, String keyStoreLocation, String keyStorePassword, KeyStoreType type, String cloudServiceName, String jobCollectionName) throws IOException {
        return ManagementConfiguration.configure(null, Configuration.getInstance(), uri, subscriptionId, keyStoreLocation, keyStorePassword, type, cloudServiceName, jobCollectionName);
    }

    public static Configuration configure(String profile, Configuration configuration, URI uri, String subscriptionId, String keyStoreLocation, String keyStorePassword) throws IOException {
        if (profile == null) {
            profile = "";
        } else if (profile.length() != 0 && !profile.endsWith(".")) {
            profile = profile + ".";
        }
        configuration.setProperty(profile + SUBSCRIPTION_ID, subscriptionId);
        configuration.setProperty(profile + KEYSTORE_PATH, keyStoreLocation);
        configuration.setProperty(profile + KEYSTORE_PASSWORD, keyStorePassword);
        configuration.setProperty(profile + SUBSCRIPTION_CLOUD_CREDENTIALS, new CertificateCloudCredentials(uri, subscriptionId, new KeyStoreCredential(keyStoreLocation, keyStorePassword)));
        configuration.setProperty(profile + "com.microsoft.windowsazure.Configuration.redirectStrategy", new LaxRedirectStrategy());
        return configuration;
    }

    public static Configuration configure(String profile, Configuration configuration, URI uri, String subscriptionId, String keyStoreLocation, String keyStorePassword, KeyStoreType keyStoreType) throws IOException {
        if (profile == null) {
            profile = "";
        } else if (profile.length() != 0 && !profile.endsWith(".")) {
            profile = profile + ".";
        }
        configuration.setProperty(profile + URI, uri);
        configuration.setProperty(profile + SUBSCRIPTION_ID, subscriptionId);
        configuration.setProperty(profile + KEYSTORE_PATH, keyStoreLocation);
        configuration.setProperty(profile + KEYSTORE_PASSWORD, keyStorePassword);
        configuration.setProperty(profile + KEYSTORE_TYPE, (Object)keyStoreType);
        KeyStoreCredential keyStoreCredential = new KeyStoreCredential(keyStoreLocation, keyStorePassword, keyStoreType);
        CertificateCloudCredentials cloudCredentials = new CertificateCloudCredentials(uri, subscriptionId, keyStoreCredential);
        configuration.setProperty(profile + SUBSCRIPTION_CLOUD_CREDENTIALS, cloudCredentials);
        configuration.setProperty(profile + "com.microsoft.windowsazure.Configuration.redirectStrategy", new LaxRedirectStrategy());
        return configuration;
    }

    public static Configuration configure(String profile, Configuration configuration, URI uri, String subscriptionId, String keyStoreLocation, String keyStorePassword, KeyStoreType keyStoreType, String cloudServiceName, String jobCollectionName) throws IOException {
        if (profile == null) {
            profile = "";
        } else if (profile.length() != 0 && !profile.endsWith(".")) {
            profile = profile + ".";
        }
        Configuration resultConfiguration = ManagementConfiguration.configure(profile, configuration, uri, subscriptionId, keyStoreLocation, keyStorePassword, keyStoreType);
        resultConfiguration.setProperty(profile + CLOUD_SERVICE_NAME, cloudServiceName);
        resultConfiguration.setProperty(profile + JOB_COLLECTION_NAME, jobCollectionName);
        return resultConfiguration;
    }
}

