/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.pipeline.jersey;

import com.microsoft.windowsazure.core.Builder;
import com.microsoft.windowsazure.core.pipeline.jersey.ClientConfigSettings;
import com.microsoft.windowsazure.core.pipeline.jersey.HttpURLConnectionClient;
import com.microsoft.windowsazure.core.utils.ExportUtils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.util.Map;

public class Exports
implements Builder.Exports {
    @Override
    public void register(Builder.Registry registry) {
        registry.add(new Builder.Factory<ClientConfig>(){

            @Override
            public <S> ClientConfig create(String profile, Class<S> service, Builder builder, Map<String, Object> properties) {
                DefaultClientConfig clientConfig = new DefaultClientConfig();
                ClientConfigSettings settings = builder.build(profile, service, ClientConfigSettings.class, properties);
                settings.applyConfig((ClientConfig)clientConfig);
                return clientConfig;
            }
        });
        registry.add(new Builder.Factory<ClientConfigSettings>(){

            @Override
            public <S> ClientConfigSettings create(String profile, Class<S> service, Builder builder, Map<String, Object> properties) {
                Object connectTimeout = ExportUtils.getPropertyIfExists(profile, properties, "com.microsoft.windowsazure.Configuration.connectTimeout");
                Object readTimeout = ExportUtils.getPropertyIfExists(profile, properties, "com.microsoft.windowsazure.Configuration.readTimeout");
                return new ClientConfigSettings(connectTimeout, readTimeout, ExportUtils.getPropertyIfExists(profile, properties, "com.microsoft.windowsazure.Configuration.logHttpRequests") != null);
            }
        });
        registry.add(new Builder.Factory<Client>(){

            @Override
            public <S> Client create(String profile, Class<S> service, Builder builder, Map<String, Object> properties) {
                ClientConfig clientConfig = builder.build(profile, service, ClientConfig.class, properties);
                ClientConfigSettings settings = builder.build(profile, service, ClientConfigSettings.class, properties);
                Client client = Client.create((ClientConfig)clientConfig);
                settings.applyConfig(client);
                return client;
            }
        });
        registry.add(new Builder.Factory<HttpURLConnectionClient>(){

            @Override
            public <S> HttpURLConnectionClient create(String profile, Class<S> service, Builder builder, Map<String, Object> properties) {
                ClientConfig clientConfig = builder.build(profile, service, ClientConfig.class, properties);
                ClientConfigSettings settings = builder.build(profile, service, ClientConfigSettings.class, properties);
                HttpURLConnectionClient client = HttpURLConnectionClient.create(clientConfig);
                settings.applyConfig(client);
                return client;
            }
        });
    }
}

