/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

/**
* The current status of a role instance.
*/
public abstract class RoleInstanceStatus {
    /**
    * The role state is currently unknown. The state should automatically be
    * resolved once the role state is detected, so no action is required.
    */
    public static final String ROLESTATEUNKNOWN = "RoleStateUnknown";
    
    /**
    * The host agent is currently creating resources for the Virtual Machine.
    */
    public static final String CREATINGVM = "CreatingVM";
    
    /**
    * The host agent is starting the Virtual Machine.
    */
    public static final String STARTINGVM = "StartingVM";
    
    /**
    * Azure is creating resources for the role.
    */
    public static final String CREATINGROLE = "CreatingRole";
    
    /**
    * Azure is starting the role.
    */
    public static final String STARTINGROLE = "StartingRole";
    
    /**
    * The role instance has started and is ready to be used.
    */
    public static final String READYROLE = "ReadyRole";
    
    /**
    * The role instance is unavailable for requests. This state is usually
    * generated while the role is being created or stopped.
    */
    public static final String BUSYROLE = "BusyRole";
    
    /**
    * Azure is stopping the role.
    */
    public static final String STOPPINGROLE = "StoppingRole";
    
    /**
    * The host agent is stopping the Virtual Machine. This status also
    * indicates that the role has already been stopped.
    */
    public static final String STOPPINGVM = "StoppingVM";
    
    /**
    * The Virtual Machine is being deleted by the host agent.
    */
    public static final String DELETINGVM = "DeletingVM";
    
    /**
    * The Virtual Machine is not running. This is the final state of the
    * shutdown process, and no other status messages should be received after
    * StoppedVM.
    */
    public static final String STOPPEDVM = "StoppedVM";
    
    /**
    * The role has unexpectedly stopped or has failed to start. This status
    * indicates that there is a problem with the role that is causing it to
    * crash or is preventing it from starting, which must be corrected before
    * the role can be started. The InstanceStateDetails and InstanceErrorCode
    * fields can hold information about the role error that caused this state,
    * which may be useful for identifying and debugging the problem.
    */
    public static final String RESTARTINGROLE = "RestartingRole";
    
    /**
    * The role has continually crashed after being started by Azure. This
    * status indicates that there is a problem with the role that prevents it
    * from starting, and may be generated after the StartingRole and ReadyRole
    * statuses are received. The problem in the role must be found and
    * corrected before the role can be started. The InstanceStateDetails and
    * InstanceErrorCode fields can hold information about the role error that
    * caused this state, which may be useful for identifying and debugging the
    * problem.
    */
    public static final String CYCLINGROLE = "CyclingRole";
    
    /**
    * The role has continually failed to start. This status indicates that
    * there is a problem with the role that prevents it from starting, and may
    * be generated after the process returns StartingRole. The problem in the
    * role must be found and corrected before the role can be started. The
    * InstanceStateDetails and InstanceErrorCode fields can hold information
    * about the role error that caused this state, which may be useful for
    * identifying and debugging the problem.
    */
    public static final String FAILEDSTARTINGROLE = "FailedStartingRole";
    
    /**
    * An Azure or container error is preventing the Virtual Machine from
    * starting. This status is generated by Azure, and does not indicate an
    * error with the role. It may be generated after the StartingRole state.
    */
    public static final String FAILEDSTARTINGVM = "FailedStartingVM";
    
    /**
    * The role has timed out before receiving a status message and is not
    * responding to requests.
    */
    public static final String UNRESPONSIVEROLE = "UnresponsiveRole";
    
    /**
    * Azure is provisioning the role.
    */
    public static final String PROVISIONING = "Provisioning";
}
