/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl;
import com.microsoft.windowsazure.management.compute.VirtualMachineExtensionOperations;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineExtensionListResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class VirtualMachineExtensionOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
VirtualMachineExtensionOperations {
    private ComputeManagementClientImpl client;

    VirtualMachineExtensionOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<VirtualMachineExtensionListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineExtensionListResponse>(){

            @Override
            public VirtualMachineExtensionListResponse call() throws Exception {
                return VirtualMachineExtensionOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineExtensionListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/resourceextensions";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineExtensionListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineExtensionListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element resourceExtensionsSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensions");
            if (resourceExtensionsSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)resourceExtensionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtension").size(); ++i1) {
                    Element publishedDateElement;
                    Element companyNameElement;
                    Element supportedOSElement;
                    Element disallowMajorVersionUpgradeElement;
                    Element isInternalExtensionElement;
                    Element isJsonExtensionElement;
                    Element homepageUriElement;
                    Element privacyUriElement;
                    Element eulaElement;
                    Element replicationCompletedElement;
                    Element sampleConfigElement;
                    Element privateConfigurationSchemaElement;
                    Element publicConfigurationSchemaElement;
                    Element descriptionElement;
                    Element labelElement;
                    Element versionElement;
                    Element nameElement;
                    Element resourceExtensionsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)resourceExtensionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtension").get(i1);
                    VirtualMachineExtensionListResponse.ResourceExtension resourceExtensionInstance = new VirtualMachineExtensionListResponse.ResourceExtension();
                    result.getResourceExtensions().add(resourceExtensionInstance);
                    Element publisherElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Publisher");
                    if (publisherElement != null) {
                        String publisherInstance = publisherElement.getTextContent();
                        resourceExtensionInstance.setPublisher(publisherInstance);
                    }
                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement.getTextContent();
                        resourceExtensionInstance.setName(nameInstance);
                    }
                    if ((versionElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                        String versionInstance = versionElement.getTextContent();
                        resourceExtensionInstance.setVersion(versionInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent();
                        resourceExtensionInstance.setLabel(labelInstance);
                    }
                    if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                        String descriptionInstance = descriptionElement.getTextContent();
                        resourceExtensionInstance.setDescription(descriptionInstance);
                    }
                    if ((publicConfigurationSchemaElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicConfigurationSchema")) != null) {
                        String publicConfigurationSchemaInstance = publicConfigurationSchemaElement.getTextContent() != null ? new String(Base64.decode((String)publicConfigurationSchemaElement.getTextContent())) : null;
                        resourceExtensionInstance.setPublicConfigurationSchema(publicConfigurationSchemaInstance);
                    }
                    if ((privateConfigurationSchemaElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivateConfigurationSchema")) != null) {
                        String privateConfigurationSchemaInstance = privateConfigurationSchemaElement.getTextContent() != null ? new String(Base64.decode((String)privateConfigurationSchemaElement.getTextContent())) : null;
                        resourceExtensionInstance.setPrivateConfigurationSchema(privateConfigurationSchemaInstance);
                    }
                    if ((sampleConfigElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SampleConfig")) != null) {
                        String sampleConfigInstance = sampleConfigElement.getTextContent() != null ? new String(Base64.decode((String)sampleConfigElement.getTextContent())) : null;
                        resourceExtensionInstance.setSampleConfig(sampleConfigInstance);
                    }
                    if ((replicationCompletedElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationCompleted")) != null && !(replicationCompletedElement.getTextContent() == null || replicationCompletedElement.getTextContent().isEmpty())) {
                        boolean replicationCompletedInstance = DatatypeConverter.parseBoolean((String)replicationCompletedElement.getTextContent().toLowerCase());
                        resourceExtensionInstance.setReplicationCompleted(replicationCompletedInstance);
                    }
                    if ((eulaElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Eula")) != null) {
                        URI eulaInstance = new URI(eulaElement.getTextContent());
                        resourceExtensionInstance.setEula(eulaInstance);
                    }
                    if ((privacyUriElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivacyUri")) != null) {
                        URI privacyUriInstance = new URI(privacyUriElement.getTextContent());
                        resourceExtensionInstance.setPrivacyUri(privacyUriInstance);
                    }
                    if ((homepageUriElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HomepageUri")) != null) {
                        URI homepageUriInstance = new URI(homepageUriElement.getTextContent());
                        resourceExtensionInstance.setHomepageUri(homepageUriInstance);
                    }
                    if ((isJsonExtensionElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsJsonExtension")) != null && !(isJsonExtensionElement.getTextContent() == null || isJsonExtensionElement.getTextContent().isEmpty())) {
                        boolean isJsonExtensionInstance = DatatypeConverter.parseBoolean((String)isJsonExtensionElement.getTextContent().toLowerCase());
                        resourceExtensionInstance.setIsJsonExtension(isJsonExtensionInstance);
                    }
                    if ((isInternalExtensionElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsInternalExtension")) != null && !(isInternalExtensionElement.getTextContent() == null || isInternalExtensionElement.getTextContent().isEmpty())) {
                        boolean isInternalExtensionInstance = DatatypeConverter.parseBoolean((String)isInternalExtensionElement.getTextContent().toLowerCase());
                        resourceExtensionInstance.setIsInternalExtension(isInternalExtensionInstance);
                    }
                    if ((disallowMajorVersionUpgradeElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DisallowMajorVersionUpgrade")) != null && !(disallowMajorVersionUpgradeElement.getTextContent() == null || disallowMajorVersionUpgradeElement.getTextContent().isEmpty())) {
                        boolean disallowMajorVersionUpgradeInstance = DatatypeConverter.parseBoolean((String)disallowMajorVersionUpgradeElement.getTextContent().toLowerCase());
                        resourceExtensionInstance.setDisallowMajorVersionUpgrade(disallowMajorVersionUpgradeInstance);
                    }
                    if ((supportedOSElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SupportedOS")) != null) {
                        String supportedOSInstance = supportedOSElement.getTextContent();
                        resourceExtensionInstance.setSupportedOS(supportedOSInstance);
                    }
                    if ((companyNameElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CompanyName")) != null) {
                        String companyNameInstance = companyNameElement.getTextContent();
                        resourceExtensionInstance.setCompanyName(companyNameInstance);
                    }
                    if ((publishedDateElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublishedDate")) == null || publishedDateElement.getTextContent() == null || publishedDateElement.getTextContent().isEmpty()) continue;
                    Calendar publishedDateInstance = DatatypeConverter.parseDateTime((String)publishedDateElement.getTextContent());
                    resourceExtensionInstance.setPublishedDate(publishedDateInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            VirtualMachineExtensionListResponse virtualMachineExtensionListResponse = result;
            return virtualMachineExtensionListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineExtensionListResponse> listVersionsAsync(final String publisherName, final String extensionName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineExtensionListResponse>(){

            @Override
            public VirtualMachineExtensionListResponse call() throws Exception {
                return VirtualMachineExtensionOperationsImpl.this.listVersions(publisherName, extensionName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineExtensionListResponse listVersions(String publisherName, String extensionName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (publisherName == null) {
            throw new NullPointerException("publisherName");
        }
        if (extensionName == null) {
            throw new NullPointerException("extensionName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("publisherName", publisherName);
            tracingParameters.put("extensionName", extensionName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listVersionsAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/resourceextensions/" + publisherName.trim() + "/" + extensionName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineExtensionListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineExtensionListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element resourceExtensionsSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtensions");
            if (resourceExtensionsSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)resourceExtensionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtension").size(); ++i1) {
                    Element publishedDateElement;
                    Element companyNameElement;
                    Element supportedOSElement;
                    Element disallowMajorVersionUpgradeElement;
                    Element isInternalExtensionElement;
                    Element isJsonExtensionElement;
                    Element homepageUriElement;
                    Element privacyUriElement;
                    Element eulaElement;
                    Element replicationCompletedElement;
                    Element sampleConfigElement;
                    Element privateConfigurationSchemaElement;
                    Element publicConfigurationSchemaElement;
                    Element descriptionElement;
                    Element labelElement;
                    Element versionElement;
                    Element nameElement;
                    Element resourceExtensionsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)resourceExtensionsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ResourceExtension").get(i1);
                    VirtualMachineExtensionListResponse.ResourceExtension resourceExtensionInstance = new VirtualMachineExtensionListResponse.ResourceExtension();
                    result.getResourceExtensions().add(resourceExtensionInstance);
                    Element publisherElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Publisher");
                    if (publisherElement != null) {
                        String publisherInstance = publisherElement.getTextContent();
                        resourceExtensionInstance.setPublisher(publisherInstance);
                    }
                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement.getTextContent();
                        resourceExtensionInstance.setName(nameInstance);
                    }
                    if ((versionElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Version")) != null) {
                        String versionInstance = versionElement.getTextContent();
                        resourceExtensionInstance.setVersion(versionInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent();
                        resourceExtensionInstance.setLabel(labelInstance);
                    }
                    if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                        String descriptionInstance = descriptionElement.getTextContent();
                        resourceExtensionInstance.setDescription(descriptionInstance);
                    }
                    if ((publicConfigurationSchemaElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublicConfigurationSchema")) != null) {
                        String publicConfigurationSchemaInstance = publicConfigurationSchemaElement.getTextContent() != null ? new String(Base64.decode((String)publicConfigurationSchemaElement.getTextContent())) : null;
                        resourceExtensionInstance.setPublicConfigurationSchema(publicConfigurationSchemaInstance);
                    }
                    if ((privateConfigurationSchemaElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivateConfigurationSchema")) != null) {
                        String privateConfigurationSchemaInstance = privateConfigurationSchemaElement.getTextContent() != null ? new String(Base64.decode((String)privateConfigurationSchemaElement.getTextContent())) : null;
                        resourceExtensionInstance.setPrivateConfigurationSchema(privateConfigurationSchemaInstance);
                    }
                    if ((sampleConfigElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SampleConfig")) != null) {
                        String sampleConfigInstance = sampleConfigElement.getTextContent() != null ? new String(Base64.decode((String)sampleConfigElement.getTextContent())) : null;
                        resourceExtensionInstance.setSampleConfig(sampleConfigInstance);
                    }
                    if ((replicationCompletedElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationCompleted")) != null && !(replicationCompletedElement.getTextContent() == null || replicationCompletedElement.getTextContent().isEmpty())) {
                        boolean replicationCompletedInstance = DatatypeConverter.parseBoolean((String)replicationCompletedElement.getTextContent().toLowerCase());
                        resourceExtensionInstance.setReplicationCompleted(replicationCompletedInstance);
                    }
                    if ((eulaElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Eula")) != null) {
                        URI eulaInstance = new URI(eulaElement.getTextContent());
                        resourceExtensionInstance.setEula(eulaInstance);
                    }
                    if ((privacyUriElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PrivacyUri")) != null) {
                        URI privacyUriInstance = new URI(privacyUriElement.getTextContent());
                        resourceExtensionInstance.setPrivacyUri(privacyUriInstance);
                    }
                    if ((homepageUriElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HomepageUri")) != null) {
                        URI homepageUriInstance = new URI(homepageUriElement.getTextContent());
                        resourceExtensionInstance.setHomepageUri(homepageUriInstance);
                    }
                    if ((isJsonExtensionElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsJsonExtension")) != null && !(isJsonExtensionElement.getTextContent() == null || isJsonExtensionElement.getTextContent().isEmpty())) {
                        boolean isJsonExtensionInstance = DatatypeConverter.parseBoolean((String)isJsonExtensionElement.getTextContent().toLowerCase());
                        resourceExtensionInstance.setIsJsonExtension(isJsonExtensionInstance);
                    }
                    if ((isInternalExtensionElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsInternalExtension")) != null && !(isInternalExtensionElement.getTextContent() == null || isInternalExtensionElement.getTextContent().isEmpty())) {
                        boolean isInternalExtensionInstance = DatatypeConverter.parseBoolean((String)isInternalExtensionElement.getTextContent().toLowerCase());
                        resourceExtensionInstance.setIsInternalExtension(isInternalExtensionInstance);
                    }
                    if ((disallowMajorVersionUpgradeElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DisallowMajorVersionUpgrade")) != null && !(disallowMajorVersionUpgradeElement.getTextContent() == null || disallowMajorVersionUpgradeElement.getTextContent().isEmpty())) {
                        boolean disallowMajorVersionUpgradeInstance = DatatypeConverter.parseBoolean((String)disallowMajorVersionUpgradeElement.getTextContent().toLowerCase());
                        resourceExtensionInstance.setDisallowMajorVersionUpgrade(disallowMajorVersionUpgradeInstance);
                    }
                    if ((supportedOSElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SupportedOS")) != null) {
                        String supportedOSInstance = supportedOSElement.getTextContent();
                        resourceExtensionInstance.setSupportedOS(supportedOSInstance);
                    }
                    if ((companyNameElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CompanyName")) != null) {
                        String companyNameInstance = companyNameElement.getTextContent();
                        resourceExtensionInstance.setCompanyName(companyNameInstance);
                    }
                    if ((publishedDateElement = XmlUtility.getElementByTagNameNS((Node)resourceExtensionsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PublishedDate")) == null || publishedDateElement.getTextContent() == null || publishedDateElement.getTextContent().isEmpty()) continue;
                    Calendar publishedDateInstance = DatatypeConverter.parseDateTime((String)publishedDateElement.getTextContent());
                    resourceExtensionInstance.setPublishedDate(publishedDateInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            VirtualMachineExtensionListResponse virtualMachineExtensionListResponse = result;
            return virtualMachineExtensionListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

