/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.storage;

import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.storage.StorageAccountOperations;
import com.microsoft.windowsazure.management.storage.StorageManagementClient;
import com.microsoft.windowsazure.management.storage.StorageManagementClientImpl;
import com.microsoft.windowsazure.management.storage.models.CheckNameAvailabilityResponse;
import com.microsoft.windowsazure.management.storage.models.GeoRegionStatus;
import com.microsoft.windowsazure.management.storage.models.StorageAccount;
import com.microsoft.windowsazure.management.storage.models.StorageAccountCreateParameters;
import com.microsoft.windowsazure.management.storage.models.StorageAccountGetKeysResponse;
import com.microsoft.windowsazure.management.storage.models.StorageAccountGetResponse;
import com.microsoft.windowsazure.management.storage.models.StorageAccountListResponse;
import com.microsoft.windowsazure.management.storage.models.StorageAccountProperties;
import com.microsoft.windowsazure.management.storage.models.StorageAccountRegenerateKeysParameters;
import com.microsoft.windowsazure.management.storage.models.StorageAccountRegenerateKeysResponse;
import com.microsoft.windowsazure.management.storage.models.StorageAccountStatus;
import com.microsoft.windowsazure.management.storage.models.StorageAccountUpdateParameters;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StorageAccountOperationsImpl
implements ServiceOperations<StorageManagementClientImpl>,
StorageAccountOperations {
    private StorageManagementClientImpl client;

    StorageAccountOperationsImpl(StorageManagementClientImpl client) {
        this.client = client;
    }

    public StorageManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationResponse> beginCreatingAsync(final StorageAccountCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.beginCreating(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginCreating(StorageAccountCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDescription() != null && parameters.getDescription().length() > 1024) {
            throw new IllegalArgumentException("parameters.Description");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        if (parameters.getName().length() < 3) {
            throw new IllegalArgumentException("parameters.Name");
        }
        if (parameters.getName().length() > 24) {
            throw new IllegalArgumentException("parameters.Name");
        }
        for (char nameChar : parameters.getName().toCharArray()) {
            if (Character.isLowerCase(nameChar) || Character.isDigit(nameChar)) continue;
            throw new IllegalArgumentException("parameters.Name");
        }
        int locationCount = (parameters.getAffinityGroup() != null ? 1 : 0) + (parameters.getLocation() != null ? 1 : 0);
        if (locationCount != 1) {
            throw new IllegalArgumentException("Only one of parameters.AffinityGroup, parameters.Location may be provided.");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, StorageAccountCreateParameters> tracingParameters = new HashMap<String, StorageAccountCreateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreatingAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/storageservices";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element createStorageServiceInputElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CreateStorageServiceInput");
        requestDoc.appendChild(createStorageServiceInputElement);
        Element serviceNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceName");
        serviceNameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        createStorageServiceInputElement.appendChild(serviceNameElement);
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            createStorageServiceInputElement.appendChild(descriptionElement);
        } else {
            Element emptyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            Attr nilAttribute = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
            nilAttribute.setValue("true");
            emptyElement.setAttributeNode(nilAttribute);
            createStorageServiceInputElement.appendChild(emptyElement);
        }
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getLabel().getBytes())));
        createStorageServiceInputElement.appendChild(labelElement);
        if (parameters.getAffinityGroup() != null) {
            Element affinityGroupElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AffinityGroup");
            affinityGroupElement.appendChild(requestDoc.createTextNode(parameters.getAffinityGroup()));
            createStorageServiceInputElement.appendChild(affinityGroupElement);
        }
        if (parameters.getLocation() != null) {
            Element locationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Location");
            locationElement.appendChild(requestDoc.createTextNode(parameters.getLocation()));
            createStorageServiceInputElement.appendChild(locationElement);
        }
        if (parameters.getExtendedProperties() != null && (!(parameters.getExtendedProperties() instanceof LazyCollection) || ((LazyCollection)parameters.getExtendedProperties()).isInitialized())) {
            Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
            for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                String extendedPropertiesKey = entry.getKey();
                String extendedPropertiesValue = entry.getValue();
                Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
            }
            createStorageServiceInputElement.appendChild(extendedPropertiesDictionaryElement);
        }
        if (parameters.getAccountType() != null) {
            Element accountTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AccountType");
            accountTypeElement.appendChild(requestDoc.createTextNode(parameters.getAccountType()));
            createStorageServiceInputElement.appendChild(accountTypeElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<CheckNameAvailabilityResponse> checkNameAvailabilityAsync(final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<CheckNameAvailabilityResponse>(){

            @Override
            public CheckNameAvailabilityResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.checkNameAvailability(accountName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckNameAvailabilityResponse checkNameAvailability(String accountName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"checkNameAvailabilityAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/storageservices/operations/isavailable/" + accountName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            CheckNameAvailabilityResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new CheckNameAvailabilityResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element availabilityResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailabilityResponse");
            if (availabilityResponseElement != null) {
                Element reasonElement;
                Element resultElement = XmlUtility.getElementByTagNameNS((Node)availabilityResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Result");
                if (resultElement != null) {
                    boolean resultInstance = DatatypeConverter.parseBoolean((String)resultElement.getTextContent().toLowerCase());
                    result.setIsAvailable(resultInstance);
                }
                if ((reasonElement = XmlUtility.getElementByTagNameNS((Node)availabilityResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Reason")) != null) {
                    boolean isNil = false;
                    Attr nilAttribute = reasonElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                    if (nilAttribute != null) {
                        isNil = "true".equals(nilAttribute.getValue());
                    }
                    if (!isNil) {
                        String reasonInstance = reasonElement.getTextContent();
                        result.setReason(reasonInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            CheckNameAvailabilityResponse checkNameAvailabilityResponse = result;
            return checkNameAvailabilityResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> createAsync(final StorageAccountCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.create(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse create(StorageAccountCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        StorageManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, StorageAccountCreateParameters> tracingParameters = new HashMap<String, StorageAccountCreateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (StorageManagementClient)((StorageManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getStorageAccountsOperations().beginCreatingAsync(parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.delete(accountName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String accountName) throws IOException, ServiceException {
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/storageservices/" + accountName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<StorageAccountGetResponse> getAsync(final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountGetResponse>(){

            @Override
            public StorageAccountGetResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.get(accountName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountGetResponse get(String accountName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/storageservices/" + accountName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new StorageAccountGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element storageServiceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageService");
            if (storageServiceElement != null) {
                Element extendedPropertiesSequenceElement;
                Element storageServicePropertiesElement;
                Element serviceNameElement;
                StorageAccount storageServiceInstance = new StorageAccount();
                result.setStorageAccount(storageServiceInstance);
                Element urlElement = XmlUtility.getElementByTagNameNS((Node)storageServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url");
                if (urlElement != null) {
                    URI urlInstance = new URI(urlElement.getTextContent());
                    storageServiceInstance.setUri(urlInstance);
                }
                if ((serviceNameElement = XmlUtility.getElementByTagNameNS((Node)storageServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) != null) {
                    String serviceNameInstance = serviceNameElement.getTextContent();
                    storageServiceInstance.setName(serviceNameInstance);
                }
                if ((storageServicePropertiesElement = XmlUtility.getElementByTagNameNS((Node)storageServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageServiceProperties")) != null) {
                    Element accountTypeElement;
                    Element statusOfSecondaryElement;
                    Element geoSecondaryRegionElement;
                    Element lastGeoFailoverTimeElement;
                    Element statusOfPrimaryElement;
                    Element geoPrimaryRegionElement;
                    Element endpointsSequenceElement;
                    Element statusElement;
                    Element labelElement;
                    Element locationElement;
                    Element affinityGroupElement;
                    StorageAccountProperties storageServicePropertiesInstance = new StorageAccountProperties();
                    storageServiceInstance.setProperties(storageServicePropertiesInstance);
                    Element descriptionElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description");
                    if (descriptionElement != null) {
                        boolean isNil = false;
                        Attr nilAttribute = descriptionElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                        if (nilAttribute != null) {
                            isNil = "true".equals(nilAttribute.getValue());
                        }
                        if (!isNil) {
                            String descriptionInstance = descriptionElement.getTextContent();
                            storageServicePropertiesInstance.setDescription(descriptionInstance);
                        }
                    }
                    if ((affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup")) != null) {
                        String affinityGroupInstance = affinityGroupElement.getTextContent();
                        storageServicePropertiesInstance.setAffinityGroup(affinityGroupInstance);
                    }
                    if ((locationElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                        String locationInstance = locationElement.getTextContent();
                        storageServicePropertiesInstance.setLocation(locationInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode((String)labelElement.getTextContent())) : null;
                        storageServicePropertiesInstance.setLabel(labelInstance);
                    }
                    if ((statusElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                        StorageAccountStatus statusInstance = StorageAccountStatus.valueOf(statusElement.getTextContent());
                        storageServicePropertiesInstance.setStatus(statusInstance);
                    }
                    if ((endpointsSequenceElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Endpoints")) != null) {
                        for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)endpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Endpoint").size(); ++i1) {
                            Element endpointsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)endpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Endpoint").get(i1);
                            storageServicePropertiesInstance.getEndpoints().add(new URI(endpointsElement.getTextContent()));
                        }
                    }
                    if ((geoPrimaryRegionElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GeoPrimaryRegion")) != null) {
                        String geoPrimaryRegionInstance = geoPrimaryRegionElement.getTextContent();
                        storageServicePropertiesInstance.setGeoPrimaryRegion(geoPrimaryRegionInstance);
                    }
                    if ((statusOfPrimaryElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StatusOfPrimary")) != null && !(statusOfPrimaryElement.getTextContent() == null || statusOfPrimaryElement.getTextContent().isEmpty())) {
                        GeoRegionStatus statusOfPrimaryInstance = GeoRegionStatus.valueOf(statusOfPrimaryElement.getTextContent());
                        storageServicePropertiesInstance.setStatusOfGeoPrimaryRegion(statusOfPrimaryInstance);
                    }
                    if ((lastGeoFailoverTimeElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastGeoFailoverTime")) != null && !(lastGeoFailoverTimeElement.getTextContent() == null || lastGeoFailoverTimeElement.getTextContent().isEmpty())) {
                        Calendar lastGeoFailoverTimeInstance = DatatypeConverter.parseDateTime((String)lastGeoFailoverTimeElement.getTextContent());
                        storageServicePropertiesInstance.setLastGeoFailoverTime(lastGeoFailoverTimeInstance);
                    }
                    if ((geoSecondaryRegionElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GeoSecondaryRegion")) != null) {
                        String geoSecondaryRegionInstance = geoSecondaryRegionElement.getTextContent();
                        storageServicePropertiesInstance.setGeoSecondaryRegion(geoSecondaryRegionInstance);
                    }
                    if ((statusOfSecondaryElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StatusOfSecondary")) != null && !(statusOfSecondaryElement.getTextContent() == null || statusOfSecondaryElement.getTextContent().isEmpty())) {
                        GeoRegionStatus statusOfSecondaryInstance = GeoRegionStatus.valueOf(statusOfSecondaryElement.getTextContent());
                        storageServicePropertiesInstance.setStatusOfGeoSecondaryRegion(statusOfSecondaryInstance);
                    }
                    if ((accountTypeElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AccountType")) != null) {
                        String accountTypeInstance = accountTypeElement.getTextContent();
                        storageServicePropertiesInstance.setAccountType(accountTypeInstance);
                    }
                }
                if ((extendedPropertiesSequenceElement = XmlUtility.getElementByTagNameNS((Node)storageServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperties")) != null) {
                    for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").size(); ++i2) {
                        Element extendedPropertiesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").get(i2);
                        String extendedPropertiesKey = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name").getTextContent();
                        String extendedPropertiesValue = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value").getTextContent();
                        storageServiceInstance.getExtendedProperties().put(extendedPropertiesKey, extendedPropertiesValue);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountGetResponse storageAccountGetResponse = result;
            return storageAccountGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<StorageAccountGetKeysResponse> getKeysAsync(final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountGetKeysResponse>(){

            @Override
            public StorageAccountGetKeysResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.getKeys(accountName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountGetKeysResponse getKeys(String accountName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getKeysAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/storageservices/" + accountName.trim() + "/keys";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountGetKeysResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new StorageAccountGetKeysResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element storageServiceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageService");
            if (storageServiceElement != null) {
                Element storageServiceKeysElement;
                Element urlElement = XmlUtility.getElementByTagNameNS((Node)storageServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url");
                if (urlElement != null) {
                    URI urlInstance = new URI(urlElement.getTextContent());
                    result.setUri(urlInstance);
                }
                if ((storageServiceKeysElement = XmlUtility.getElementByTagNameNS((Node)storageServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageServiceKeys")) != null) {
                    Element secondaryElement;
                    Element primaryElement = XmlUtility.getElementByTagNameNS((Node)storageServiceKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Primary");
                    if (primaryElement != null) {
                        String primaryInstance = primaryElement.getTextContent();
                        result.setPrimaryKey(primaryInstance);
                    }
                    if ((secondaryElement = XmlUtility.getElementByTagNameNS((Node)storageServiceKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Secondary")) != null) {
                        String secondaryInstance = secondaryElement.getTextContent();
                        result.setSecondaryKey(secondaryInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountGetKeysResponse storageAccountGetKeysResponse = result;
            return storageAccountGetKeysResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<StorageAccountListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountListResponse>(){

            @Override
            public StorageAccountListResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/storageservices";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new StorageAccountListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element storageServicesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageServices");
            if (storageServicesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)storageServicesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageService").size(); ++i1) {
                    Element extendedPropertiesSequenceElement;
                    Element storageServicePropertiesElement;
                    Element serviceNameElement;
                    Element storageServicesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)storageServicesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageService").get(i1);
                    StorageAccount storageServiceInstance = new StorageAccount();
                    result.getStorageAccounts().add(storageServiceInstance);
                    Element urlElement = XmlUtility.getElementByTagNameNS((Node)storageServicesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url");
                    if (urlElement != null) {
                        URI urlInstance = new URI(urlElement.getTextContent());
                        storageServiceInstance.setUri(urlInstance);
                    }
                    if ((serviceNameElement = XmlUtility.getElementByTagNameNS((Node)storageServicesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) != null) {
                        String serviceNameInstance = serviceNameElement.getTextContent();
                        storageServiceInstance.setName(serviceNameInstance);
                    }
                    if ((storageServicePropertiesElement = XmlUtility.getElementByTagNameNS((Node)storageServicesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageServiceProperties")) != null) {
                        Element accountTypeElement;
                        Element statusOfSecondaryElement;
                        Element geoSecondaryRegionElement;
                        Element lastGeoFailoverTimeElement;
                        Element statusOfPrimaryElement;
                        Element geoPrimaryRegionElement;
                        Element endpointsSequenceElement;
                        Element statusElement;
                        Element labelElement;
                        Element locationElement;
                        Element affinityGroupElement;
                        StorageAccountProperties storageServicePropertiesInstance = new StorageAccountProperties();
                        storageServiceInstance.setProperties(storageServicePropertiesInstance);
                        Element descriptionElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description");
                        if (descriptionElement != null) {
                            boolean isNil = false;
                            Attr nilAttribute = descriptionElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                            if (nilAttribute != null) {
                                isNil = "true".equals(nilAttribute.getValue());
                            }
                            if (!isNil) {
                                String descriptionInstance = descriptionElement.getTextContent();
                                storageServicePropertiesInstance.setDescription(descriptionInstance);
                            }
                        }
                        if ((affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup")) != null) {
                            String affinityGroupInstance = affinityGroupElement.getTextContent();
                            storageServicePropertiesInstance.setAffinityGroup(affinityGroupInstance);
                        }
                        if ((locationElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                            String locationInstance = locationElement.getTextContent();
                            storageServicePropertiesInstance.setLocation(locationInstance);
                        }
                        if ((labelElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                            String labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode((String)labelElement.getTextContent())) : null;
                            storageServicePropertiesInstance.setLabel(labelInstance);
                        }
                        if ((statusElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Status")) != null) {
                            StorageAccountStatus statusInstance = StorageAccountStatus.valueOf(statusElement.getTextContent());
                            storageServicePropertiesInstance.setStatus(statusInstance);
                        }
                        if ((endpointsSequenceElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Endpoints")) != null) {
                            for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)endpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Endpoint").size(); ++i2) {
                                Element endpointsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)endpointsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Endpoint").get(i2);
                                storageServicePropertiesInstance.getEndpoints().add(new URI(endpointsElement.getTextContent()));
                            }
                        }
                        if ((geoPrimaryRegionElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GeoPrimaryRegion")) != null) {
                            String geoPrimaryRegionInstance = geoPrimaryRegionElement.getTextContent();
                            storageServicePropertiesInstance.setGeoPrimaryRegion(geoPrimaryRegionInstance);
                        }
                        if ((statusOfPrimaryElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StatusOfPrimary")) != null && !(statusOfPrimaryElement.getTextContent() == null || statusOfPrimaryElement.getTextContent().isEmpty())) {
                            GeoRegionStatus statusOfPrimaryInstance = GeoRegionStatus.valueOf(statusOfPrimaryElement.getTextContent());
                            storageServicePropertiesInstance.setStatusOfGeoPrimaryRegion(statusOfPrimaryInstance);
                        }
                        if ((lastGeoFailoverTimeElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastGeoFailoverTime")) != null && !(lastGeoFailoverTimeElement.getTextContent() == null || lastGeoFailoverTimeElement.getTextContent().isEmpty())) {
                            Calendar lastGeoFailoverTimeInstance = DatatypeConverter.parseDateTime((String)lastGeoFailoverTimeElement.getTextContent());
                            storageServicePropertiesInstance.setLastGeoFailoverTime(lastGeoFailoverTimeInstance);
                        }
                        if ((geoSecondaryRegionElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"GeoSecondaryRegion")) != null) {
                            String geoSecondaryRegionInstance = geoSecondaryRegionElement.getTextContent();
                            storageServicePropertiesInstance.setGeoSecondaryRegion(geoSecondaryRegionInstance);
                        }
                        if ((statusOfSecondaryElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StatusOfSecondary")) != null && !(statusOfSecondaryElement.getTextContent() == null || statusOfSecondaryElement.getTextContent().isEmpty())) {
                            GeoRegionStatus statusOfSecondaryInstance = GeoRegionStatus.valueOf(statusOfSecondaryElement.getTextContent());
                            storageServicePropertiesInstance.setStatusOfGeoSecondaryRegion(statusOfSecondaryInstance);
                        }
                        if ((accountTypeElement = XmlUtility.getElementByTagNameNS((Node)storageServicePropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AccountType")) != null) {
                            String accountTypeInstance = accountTypeElement.getTextContent();
                            storageServicePropertiesInstance.setAccountType(accountTypeInstance);
                        }
                    }
                    if ((extendedPropertiesSequenceElement = XmlUtility.getElementByTagNameNS((Node)storageServicesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperties")) == null) continue;
                    for (int i3 = 0; i3 < XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").size(); ++i3) {
                        Element extendedPropertiesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)extendedPropertiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ExtendedProperty").get(i3);
                        String extendedPropertiesKey = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name").getTextContent();
                        String extendedPropertiesValue = XmlUtility.getElementByTagNameNS((Node)extendedPropertiesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Value").getTextContent();
                        storageServiceInstance.getExtendedProperties().put(extendedPropertiesKey, extendedPropertiesValue);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            StorageAccountListResponse storageAccountListResponse = result;
            return storageAccountListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<StorageAccountRegenerateKeysResponse> regenerateKeysAsync(final StorageAccountRegenerateKeysParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountRegenerateKeysResponse>(){

            @Override
            public StorageAccountRegenerateKeysResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.regenerateKeys(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAccountRegenerateKeysResponse regenerateKeys(StorageAccountRegenerateKeysParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, StorageAccountRegenerateKeysParameters> tracingParameters = new HashMap<String, StorageAccountRegenerateKeysParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"regenerateKeysAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/storageservices/" + parameters.getName().trim() + "/keys" + "?" + "action=regenerate";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element regenerateKeysElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RegenerateKeys");
        requestDoc.appendChild(regenerateKeysElement);
        Element keyTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "KeyType");
        keyTypeElement.appendChild(requestDoc.createTextNode(parameters.getKeyType().toString()));
        regenerateKeysElement.appendChild(keyTypeElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            StorageAccountRegenerateKeysResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new StorageAccountRegenerateKeysResponse();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            documentBuilderFactory2.setNamespaceAware(true);
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
            Element storageServiceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageService");
            if (storageServiceElement != null) {
                Element storageServiceKeysElement;
                Element urlElement = XmlUtility.getElementByTagNameNS((Node)storageServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url");
                if (urlElement != null) {
                    URI urlInstance = new URI(urlElement.getTextContent());
                    result.setUri(urlInstance);
                }
                if ((storageServiceKeysElement = XmlUtility.getElementByTagNameNS((Node)storageServiceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageServiceKeys")) != null) {
                    Element secondaryElement;
                    Element primaryElement = XmlUtility.getElementByTagNameNS((Node)storageServiceKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Primary");
                    if (primaryElement != null) {
                        String primaryInstance = primaryElement.getTextContent();
                        result.setPrimaryKey(primaryInstance);
                    }
                    if ((secondaryElement = XmlUtility.getElementByTagNameNS((Node)storageServiceKeysElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Secondary")) != null) {
                        String secondaryInstance = secondaryElement.getTextContent();
                        result.setSecondaryKey(secondaryInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            StorageAccountRegenerateKeysResponse storageAccountRegenerateKeysResponse = result;
            return storageAccountRegenerateKeysResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> updateAsync(final String accountName, final StorageAccountUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return StorageAccountOperationsImpl.this.update(accountName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse update(String accountName, StorageAccountUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        if (accountName.length() < 3) {
            throw new IllegalArgumentException("accountName");
        }
        if (accountName.length() > 24) {
            throw new IllegalArgumentException("accountName");
        }
        for (char accountNameChar : accountName.toCharArray()) {
            if (Character.isLowerCase(accountNameChar) || Character.isDigit(accountNameChar)) continue;
            throw new IllegalArgumentException("accountName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDescription() != null && parameters.getDescription().length() > 1024) {
            throw new IllegalArgumentException("parameters.Description");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("accountName", accountName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/storageservices/" + accountName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element updateStorageServiceInputElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpdateStorageServiceInput");
        requestDoc.appendChild(updateStorageServiceInputElement);
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            updateStorageServiceInputElement.appendChild(descriptionElement);
        } else {
            Element emptyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            Attr nilAttribute = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
            nilAttribute.setValue("true");
            emptyElement.setAttributeNode(nilAttribute);
            updateStorageServiceInputElement.appendChild(emptyElement);
        }
        if (parameters.getLabel() != null) {
            Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
            labelElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getLabel().getBytes())));
            updateStorageServiceInputElement.appendChild(labelElement);
        }
        if (parameters.getExtendedProperties() != null && (!(parameters.getExtendedProperties() instanceof LazyCollection) || ((LazyCollection)parameters.getExtendedProperties()).isInitialized())) {
            Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
            for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                String extendedPropertiesKey = entry.getKey();
                String extendedPropertiesValue = entry.getValue();
                Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
            }
            updateStorageServiceInputElement.appendChild(extendedPropertiesDictionaryElement);
        }
        if (parameters.getAccountType() != null) {
            Element accountTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AccountType");
            accountTypeElement.appendChild(requestDoc.createTextNode(parameters.getAccountType()));
            updateStorageServiceInputElement.appendChild(accountTypeElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

