/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.servicebus;

import com.microsoft.windowsazure.Configuration;

public abstract class ServiceBusConfiguration {
    public static final String CONNECTION_STRING = "serviceBus.connection.string";
    public static final String URI = "serviceBus.uri";
    public static final String WRAP_URI = "serviceBus.wrap.uri";
    public static final String WRAP_NAME = "serviceBus.wrap.name";
    public static final String WRAP_PASSWORD = "serviceBus.wrap.password";
    public static final String SAS_KEY_NAME = "serviceBus.sas.keyname";
    public static final String SAS_KEY = "serviceBus.sas.key";

    public static Configuration configureWithWrapAuthentication(String namespace, String authenticationName, String authenticationPassword, String serviceBusRootUri, String wrapRootUri) {
        return ServiceBusConfiguration.configureWithWrapAuthentication(null, Configuration.getInstance(), namespace, authenticationName, authenticationPassword, serviceBusRootUri, wrapRootUri);
    }

    public static Configuration configureWithWrapAuthentication(Configuration configuration, String namespace, String authenticationName, String authenticationPassword, String serviceBusRootUri, String wrapRootUri) {
        return ServiceBusConfiguration.configureWithWrapAuthentication(null, configuration, namespace, authenticationName, authenticationPassword, serviceBusRootUri, wrapRootUri);
    }

    public static Configuration configureWithWrapAuthentication(String profile, Configuration configuration, String namespace, String authenticationName, String authenticationPassword, String serviceBusRootUri, String wrapRootUri) {
        if (profile == null) {
            profile = "";
        } else if (profile.length() != 0 && !profile.endsWith(".")) {
            profile = profile + ".";
        }
        configuration.setProperty(profile + CONNECTION_STRING, null);
        configuration.setProperty(profile + URI, (Object)("https://" + namespace + serviceBusRootUri));
        configuration.setProperty(profile + WRAP_URI, (Object)("https://" + namespace + wrapRootUri));
        configuration.setProperty(profile + WRAP_NAME, (Object)authenticationName);
        configuration.setProperty(profile + WRAP_PASSWORD, (Object)authenticationPassword);
        return configuration;
    }

    public static Configuration configureWithSASAuthentication(String namespace, String sasKeyName, String sasKey, String serviceBusRootUri) {
        return ServiceBusConfiguration.configureWithSASAuthentication(null, Configuration.getInstance(), namespace, sasKeyName, sasKey, serviceBusRootUri);
    }

    public static Configuration configureWithSASAuthentication(Configuration configuration, String namespace, String sasKeyName, String sasKey, String serviceBusRootUri) {
        return ServiceBusConfiguration.configureWithSASAuthentication(null, configuration, namespace, sasKeyName, sasKey, serviceBusRootUri);
    }

    public static Configuration configureWithSASAuthentication(String profile, Configuration configuration, String namespace, String sasKeyName, String sasKey, String serviceBusRootUri) {
        if (profile == null) {
            profile = "";
        } else if (profile.length() != 0 && !profile.endsWith(".")) {
            profile = profile + ".";
        }
        configuration.setProperty(profile + CONNECTION_STRING, null);
        configuration.setProperty(profile + URI, (Object)("https://" + namespace + serviceBusRootUri));
        configuration.setProperty(profile + WRAP_URI, null);
        configuration.setProperty(profile + WRAP_NAME, null);
        configuration.setProperty(profile + WRAP_PASSWORD, null);
        configuration.setProperty(profile + SAS_KEY_NAME, (Object)sasKeyName);
        configuration.setProperty(profile + SAS_KEY, (Object)sasKey);
        return configuration;
    }

    public static Configuration configureWithConnectionString(String profile, Configuration configuration, String connectionString) {
        if (profile == null) {
            profile = "";
        } else if (profile.length() != 0 && !profile.endsWith(".")) {
            profile = profile + ".";
        }
        configuration.setProperty(profile + CONNECTION_STRING, (Object)connectionString);
        return configuration;
    }
}

