/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.servicebus.implementation;

import com.microsoft.windowsazure.core.utils.ConnectionStringSyntaxException;
import com.microsoft.windowsazure.services.servicebus.implementation.ServiceBusConnectionString;
import java.net.URI;
import java.net.URISyntaxException;

class ServiceBusConnectionSettings {
    private String uri;
    private String wrapUri;
    private String wrapName;
    private String wrapPassword;
    private String sharedAccessKeyName;
    private String sharedAccessKey;

    public ServiceBusConnectionSettings(String connectionString, String uri, String wrapUri, String wrapName, String wrapPassword, String sharedAccessKeyName, String sharedAccessKey) throws ConnectionStringSyntaxException, URISyntaxException {
        if (connectionString != null) {
            this.parseConnectionString(connectionString);
        } else {
            this.uri = uri;
            this.wrapUri = wrapUri;
            this.wrapName = wrapName;
            this.wrapPassword = wrapPassword;
            this.sharedAccessKey = sharedAccessKey;
            this.sharedAccessKeyName = sharedAccessKeyName;
        }
    }

    public String getUri() {
        return this.uri;
    }

    public String getWrapUri() {
        return this.wrapUri;
    }

    public String getWrapName() {
        return this.wrapName;
    }

    public String getWrapPassword() {
        return this.wrapPassword;
    }

    public String getSharedAccessKeyName() {
        return this.sharedAccessKeyName;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }

    public boolean isSasAuthentication() {
        return this.sharedAccessKeyName != null && this.sharedAccessKey != null;
    }

    private boolean parseConnectionString(String connectionString) throws URISyntaxException, ConnectionStringSyntaxException {
        ServiceBusConnectionString cs = new ServiceBusConnectionString(connectionString);
        this.setUri(cs);
        this.setWrapUri(cs);
        this.wrapName = cs.getSharedSecretIssuer();
        this.wrapPassword = cs.getSharedSecretValue();
        this.sharedAccessKeyName = cs.getSharedAccessKeyName();
        this.sharedAccessKey = cs.getSharedAccessKey();
        return true;
    }

    private void setUri(ServiceBusConnectionString connectionString) {
        this.uri = connectionString.getEndpoint().replaceFirst("^sb://", "https://");
    }

    private void setWrapUri(ServiceBusConnectionString connectionString) throws URISyntaxException {
        if (connectionString.getStsEndpoint() == null || connectionString.getStsEndpoint().isEmpty()) {
            URI hostUri = new URI(this.uri);
            String namespace = hostUri.getHost().split("\\.")[0];
            this.wrapUri = "https://" + namespace + "-sb.accesscontrol.windows.net/WRAPv0.9";
        } else {
            this.wrapUri = connectionString.getStsEndpoint().replaceAll("\\/$", "") + "/WRAPv0.9";
        }
    }
}

