/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.servicebus.models;

import com.microsoft.windowsazure.services.servicebus.implementation.BrokerProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BrokeredMessage {
    private BrokerProperties brokerProperties;
    private InputStream body;
    private String contentType;
    private Date date;
    private Map<String, Object> customProperties;

    public BrokeredMessage() {
        this(new BrokerProperties());
    }

    public BrokeredMessage(InputStream body) {
        this(new BrokerProperties());
        this.body = body;
    }

    public BrokeredMessage(byte[] body) {
        this(new BrokerProperties());
        this.body = body == null ? null : new ByteArrayInputStream(body);
    }

    public BrokeredMessage(String body) {
        this(new BrokerProperties());
        try {
            this.body = body == null ? null : new ByteArrayInputStream(body.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public BrokeredMessage(BrokerProperties properties) {
        this.brokerProperties = properties;
        this.customProperties = new HashMap<String, Object>();
    }

    public BrokerProperties getBrokerProperties() {
        return this.brokerProperties;
    }

    public InputStream getBody() {
        return this.body;
    }

    public BrokeredMessage setBody(InputStream body) {
        this.body = body;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BrokeredMessage setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Date getDate() {
        return this.date;
    }

    public BrokeredMessage setDate(Date date) {
        this.date = date;
        return this;
    }

    public Object getProperty(String name) {
        return this.customProperties.get(name);
    }

    public BrokeredMessage setProperty(String name, Object value) {
        this.customProperties.put(name, value);
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.customProperties;
    }

    public Integer getDeliveryCount() {
        return this.brokerProperties.getDeliveryCount();
    }

    public String getMessageId() {
        return this.brokerProperties.getMessageId();
    }

    public BrokeredMessage setMessageId(String messageId) {
        this.brokerProperties.setMessageId(messageId);
        return this;
    }

    public Long getSequenceNumber() {
        return this.brokerProperties.getSequenceNumber();
    }

    public Double getTimeToLive() {
        return this.brokerProperties.getTimeToLive();
    }

    public BrokeredMessage setTimeToLive(Double timeToLive) {
        this.brokerProperties.setTimeToLive(timeToLive);
        return this;
    }

    public String getLockToken() {
        return this.brokerProperties.getLockToken();
    }

    public Date getLockedUntilUtc() {
        return this.brokerProperties.getLockedUntilUtc();
    }

    public String getCorrelationId() {
        return this.brokerProperties.getCorrelationId();
    }

    public BrokeredMessage setCorrelationId(String correlationId) {
        this.brokerProperties.setCorrelationId(correlationId);
        return this;
    }

    public String getSessionId() {
        return this.brokerProperties.getSessionId();
    }

    public BrokeredMessage setSessionId(String sessionId) {
        this.brokerProperties.setSessionId(sessionId);
        return this;
    }

    public String getLabel() {
        return this.brokerProperties.getLabel();
    }

    public BrokeredMessage setLabel(String label) {
        this.brokerProperties.setLabel(label);
        return this;
    }

    public String getReplyTo() {
        return this.brokerProperties.getReplyTo();
    }

    public BrokeredMessage setReplyTo(String replyTo) {
        this.brokerProperties.setReplyTo(replyTo);
        return this;
    }

    public String getTo() {
        return this.brokerProperties.getTo();
    }

    public BrokeredMessage setTo(String to) {
        this.brokerProperties.setTo(to);
        return this;
    }

    public Date getScheduledEnqueueTimeUtc() {
        return this.brokerProperties.getScheduledEnqueueTimeUtc();
    }

    public BrokeredMessage setScheduledEnqueueTimeUtc(Date scheduledEnqueueTimeUtc) {
        this.brokerProperties.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtc);
        return this;
    }

    public String getReplyToSessionId() {
        return this.brokerProperties.getReplyToSessionId();
    }

    public BrokeredMessage setReplyToSessionId(String replyToSessionId) {
        this.brokerProperties.setReplyToSessionId(replyToSessionId);
        return this;
    }

    public String getMessageLocation() {
        return this.brokerProperties.getMessageLocation();
    }

    public String getLockLocation() {
        return this.brokerProperties.getLockLocation();
    }
}

