/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.table;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.table.EdmType;
import com.microsoft.azure.storage.table.EntityProperty;
import com.microsoft.azure.storage.table.TableEntity;
import com.microsoft.azure.storage.table.TablePayloadFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class TableEntitySerializer {
    private static JsonFactory jsonFactory = new JsonFactory();

    TableEntitySerializer() {
    }

    static void writeSingleEntityToStream(OutputStream outStream, TablePayloadFormat format, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws XMLStreamException, StorageException, IOException {
        if (format == TablePayloadFormat.AtomPub) {
            TableEntitySerializer.writeSingleAtomEntity(outStream, entity, isTableEntry, opContext);
        } else {
            TableEntitySerializer.writeSingleJsonEntity(outStream, format, entity, isTableEntry, opContext);
        }
    }

    static void writeSingleEntityToString(StringWriter strWriter, TablePayloadFormat format, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws XMLStreamException, StorageException, IOException {
        if (format == TablePayloadFormat.AtomPub) {
            TableEntitySerializer.writeSingleAtomEntity(strWriter, entity, isTableEntry, opContext);
        } else {
            TableEntitySerializer.writeSingleJsonEntity(strWriter, format, entity, isTableEntry, opContext);
        }
    }

    private static void writeAtomEntity(TableEntity entity, boolean isTableEntry, XMLStreamWriter xmlw, OperationContext opContext) throws XMLStreamException, StorageException {
        HashMap<String, EntityProperty> properties = entity.writeEntity(opContext);
        if (properties == null) {
            properties = new HashMap();
        }
        if (!isTableEntry) {
            Utility.assertNotNull("PartitionKey", entity.getPartitionKey());
            Utility.assertNotNull("RowKey", entity.getRowKey());
            Utility.assertNotNull("Timestamp", entity.getTimestamp());
        }
        xmlw.writeStartElement("entry");
        xmlw.writeNamespace("d", "http://schemas.microsoft.com/ado/2007/08/dataservices");
        xmlw.writeNamespace("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
        xmlw.writeNamespace(null, "http://www.w3.org/2005/Atom");
        xmlw.writeStartElement("content");
        xmlw.writeAttribute("type", "application/xml");
        xmlw.writeStartElement("m", "properties", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
        if (!isTableEntry) {
            xmlw.writeStartElement("d", "PartitionKey", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            xmlw.writeAttribute("xml", "xml", "space", "preserve");
            xmlw.writeCharacters(entity.getPartitionKey());
            xmlw.writeEndElement();
            xmlw.writeStartElement("d", "RowKey", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            xmlw.writeAttribute("xml", "xml", "space", "preserve");
            xmlw.writeCharacters(entity.getRowKey());
            xmlw.writeEndElement();
            if (entity.getTimestamp() == null) {
                entity.setTimestamp(new Date());
            }
            xmlw.writeStartElement("d", "Timestamp", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            xmlw.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type", EdmType.DATE_TIME.toString());
            xmlw.writeCharacters(Utility.getJavaISO8601Time(entity.getTimestamp()));
            xmlw.writeEndElement();
        }
        for (Map.Entry<String, EntityProperty> ent : properties.entrySet()) {
            String edmTypeString;
            if (ent.getKey().equals("PartitionKey") || ent.getKey().equals("RowKey") || ent.getKey().equals("Timestamp") || ent.getKey().equals("Etag")) continue;
            EntityProperty currProp = ent.getValue();
            xmlw.writeStartElement("d", ent.getKey(), "http://schemas.microsoft.com/ado/2007/08/dataservices");
            if (currProp.getEdmType() == EdmType.STRING) {
                xmlw.writeAttribute("xml", "xml", "space", "preserve");
            } else if (currProp.getEdmType().toString().length() != 0 && (edmTypeString = currProp.getEdmType().toString()).length() != 0) {
                xmlw.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type", edmTypeString);
            }
            if (currProp.getIsNull()) {
                xmlw.writeAttribute("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "null", "true");
            }
            xmlw.writeCharacters(currProp.getValueAsString());
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndElement();
        xmlw.writeEndElement();
    }

    private static void writeSingleAtomEntity(OutputStream outStream, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws XMLStreamException, StorageException {
        XMLStreamWriter xmlw = Utility.createXMLStreamWriter(outStream, "UTF-8");
        xmlw.writeStartDocument("UTF-8", "1.0");
        TableEntitySerializer.writeAtomEntity(entity, isTableEntry, xmlw, opContext);
        xmlw.writeEndDocument();
        xmlw.flush();
    }

    private static void writeSingleAtomEntity(StringWriter strWriter, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws XMLStreamException, StorageException {
        XMLStreamWriter xmlw = Utility.createXMLStreamWriter(strWriter);
        xmlw.writeStartDocument("UTF-8", "1.0");
        TableEntitySerializer.writeAtomEntity(entity, isTableEntry, xmlw, opContext);
        xmlw.writeEndDocument();
        xmlw.flush();
    }

    private static void writeJsonEntity(JsonGenerator generator, TablePayloadFormat format, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws StorageException, IOException {
        HashMap<String, EntityProperty> properties = entity.writeEntity(opContext);
        if (properties == null) {
            properties = new HashMap();
        }
        generator.writeStartObject();
        if (!isTableEntry) {
            Utility.assertNotNull("PartitionKey", entity.getPartitionKey());
            Utility.assertNotNull("RowKey", entity.getRowKey());
            Utility.assertNotNull("Timestamp", entity.getTimestamp());
            generator.writeStringField("PartitionKey", entity.getPartitionKey());
            generator.writeStringField("RowKey", entity.getRowKey());
            generator.writeStringField("Timestamp", Utility.getJavaISO8601Time(entity.getTimestamp()));
        }
        for (Map.Entry<String, EntityProperty> ent : properties.entrySet()) {
            String edmTypeString;
            if (ent.getKey().equals("PartitionKey") || ent.getKey().equals("RowKey") || ent.getKey().equals("Timestamp") || ent.getKey().equals("Etag")) continue;
            EntityProperty currProp = ent.getValue();
            if (currProp.getEdmType().mustAnnotateType()) {
                edmTypeString = currProp.getEdmType().toString();
                generator.writeStringField(ent.getKey() + "@odata.type", edmTypeString);
                generator.writeStringField(ent.getKey(), ent.getValue().getValueAsString());
                continue;
            }
            if (currProp.getEdmType() == EdmType.DOUBLE && !currProp.getIsNull()) {
                edmTypeString = currProp.getEdmType().toString();
                Double value = currProp.getValueAsDouble();
                if (value.equals(Double.POSITIVE_INFINITY) || value.equals(Double.NEGATIVE_INFINITY) || value.equals(Double.NaN)) {
                    generator.writeStringField(ent.getKey() + "@odata.type", edmTypeString);
                    generator.writeStringField(ent.getKey(), ent.getValue().getValueAsString());
                    continue;
                }
                TableEntitySerializer.writeJsonProperty(generator, ent);
                continue;
            }
            TableEntitySerializer.writeJsonProperty(generator, ent);
        }
        generator.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSingleJsonEntity(OutputStream outStream, TablePayloadFormat format, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws StorageException, IOException {
        JsonGenerator generator = jsonFactory.createGenerator(outStream);
        try {
            TableEntitySerializer.writeJsonEntity(generator, format, entity, isTableEntry, opContext);
        }
        finally {
            generator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSingleJsonEntity(StringWriter strWriter, TablePayloadFormat format, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws StorageException, IOException {
        JsonGenerator generator = jsonFactory.createGenerator((Writer)strWriter);
        try {
            TableEntitySerializer.writeJsonEntity(generator, format, entity, isTableEntry, opContext);
        }
        finally {
            generator.close();
        }
    }

    private static void writeJsonProperty(JsonGenerator generator, Map.Entry<String, EntityProperty> prop) throws JsonGenerationException, IOException {
        EdmType edmType = prop.getValue().getEdmType();
        if (prop.getValue().getIsNull()) {
            generator.writeNullField(prop.getKey());
        } else if (edmType == EdmType.BOOLEAN) {
            generator.writeBooleanField(prop.getKey(), prop.getValue().getValueAsBoolean());
        } else if (edmType == EdmType.DOUBLE) {
            generator.writeNumberField(prop.getKey(), prop.getValue().getValueAsDouble());
        } else if (edmType == EdmType.INT32) {
            generator.writeNumberField(prop.getKey(), prop.getValue().getValueAsInteger());
        } else {
            generator.writeStringField(prop.getKey(), prop.getValue().getValueAsString());
        }
    }
}

