/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.scp;

import com.jcraft.jsch.JSchException;
import com.pastdev.jsch.SessionFactory;
import com.pastdev.jsch.scp.CopyMode;
import com.pastdev.jsch.scp.ScpEntry;
import com.pastdev.jsch.scp.ScpInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpFileInputStream
extends InputStream {
    private static Logger logger = LoggerFactory.getLogger(ScpFileInputStream.class);
    private ScpInputStream inputStream;
    private ScpEntry scpEntry;

    ScpFileInputStream(SessionFactory sessionFactory, String path) throws JSchException, IOException {
        logger.debug("Opening ScpInputStream to {} {}", (Object)sessionFactory, (Object)path);
        this.inputStream = new ScpInputStream(sessionFactory, path, CopyMode.FILE_ONLY);
        this.scpEntry = this.inputStream.getNextEntry();
    }

    public String getMode() {
        return this.scpEntry.getMode();
    }

    public String getName() {
        return this.scpEntry.getName();
    }

    public long getSize() {
        return this.scpEntry.getSize();
    }

    @Override
    public void close() throws IOException {
        logger.debug("Closing ScpInputStream");
        this.inputStream.closeEntry();
        this.inputStream.close();
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }
}

