/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.scp;

import com.jcraft.jsch.JSchException;
import com.pastdev.jsch.SessionFactory;
import com.pastdev.jsch.scp.CopyMode;
import com.pastdev.jsch.scp.ScpConnection;
import com.pastdev.jsch.scp.ScpEntry;
import com.pastdev.jsch.scp.ScpMode;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpInputStream
extends InputStream {
    private static Logger logger = LoggerFactory.getLogger(ScpInputStream.class);
    private ScpConnection connection;
    private InputStream inputStream;

    public ScpInputStream(SessionFactory sessionFactory, String path, CopyMode copyMode) throws JSchException, IOException {
        logger.debug("Opening ScpInputStream");
        this.connection = new ScpConnection(sessionFactory, path, ScpMode.FROM, copyMode);
    }

    @Override
    public void close() throws IOException {
        logger.debug("Closing ScpInputStream");
        this.connection.close();
        this.inputStream = null;
    }

    public void closeEntry() throws IOException {
        this.connection.closeEntry();
        this.inputStream = null;
    }

    public ScpEntry getNextEntry() throws IOException {
        ScpEntry entry = this.connection.getNextEntry();
        this.inputStream = this.connection.getCurrentInputStream();
        return entry;
    }

    @Override
    public int read() throws IOException {
        if (this.inputStream == null) {
            throw new IllegalStateException("no current entry, cannot read");
        }
        return this.inputStream.read();
    }
}

