/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.tunnel;

import com.jcraft.jsch.JSchException;
import com.pastdev.jsch.IOUtils;
import com.pastdev.jsch.SessionFactory;
import com.pastdev.jsch.proxy.SshProxy;
import com.pastdev.jsch.tunnel.Tunnel;
import com.pastdev.jsch.tunnel.TunnelConnection;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelConnectionManager
implements Closeable {
    private static final Pattern PATTERN_TUNNELS_CFG_COMMENT_LINE = Pattern.compile("^\\s*(?:#.*)?$");
    private static Logger logger = LoggerFactory.getLogger(TunnelConnectionManager.class);
    private SessionFactory baseSessionFactory;
    private List<TunnelConnection> tunnelConnections;

    public TunnelConnectionManager(SessionFactory baseSessionFactory) throws JSchException {
        logger.debug("Creating TunnelConnectionManager");
        this.baseSessionFactory = baseSessionFactory;
    }

    public TunnelConnectionManager(SessionFactory baseSessionFactory, String ... pathAndSpecList) throws JSchException {
        this(baseSessionFactory, Arrays.asList(pathAndSpecList));
    }

    public TunnelConnectionManager(SessionFactory baseSessionFactory, Iterable<String> pathAndSpecList) throws JSchException {
        this(baseSessionFactory);
        this.setTunnelConnections(pathAndSpecList);
    }

    @Override
    public void close() {
        for (TunnelConnection tunnelConnection : this.tunnelConnections) {
            IOUtils.closeAndLogException(tunnelConnection);
        }
    }

    public void ensureOpen() throws JSchException {
        for (TunnelConnection tunnelConnection : this.tunnelConnections) {
            if (tunnelConnection.isOpen()) continue;
            tunnelConnection.reopen();
        }
    }

    public Tunnel getTunnel(String destinationHostname, int destinationPort) {
        for (TunnelConnection tunnelConnection : this.tunnelConnections) {
            Tunnel tunnel = tunnelConnection.getTunnel(destinationHostname, destinationPort);
            if (tunnel == null) continue;
            return tunnel;
        }
        return null;
    }

    public void open() throws JSchException {
        for (TunnelConnection tunnelConnection : this.tunnelConnections) {
            tunnelConnection.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTunnelConnectionsFromFile(File tunnelsConfig) throws IOException, JSchException {
        ArrayList<String> pathAndTunnels;
        block4: {
            pathAndTunnels = new ArrayList<String>();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(tunnelsConfig));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (PATTERN_TUNNELS_CFG_COMMENT_LINE.matcher(line).matches()) continue;
                    pathAndTunnels.add(line);
                }
                if (reader == null) break block4;
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    IOUtils.closeAndLogException(reader);
                }
                throw throwable;
            }
            IOUtils.closeAndLogException(reader);
        }
        this.setTunnelConnections(pathAndTunnels);
    }

    public void setTunnelConnections(Iterable<String> pathAndSpecList) throws JSchException {
        HashMap<String, HashSet<Tunnel>> tunnelMap = new HashMap<String, HashSet<Tunnel>>();
        for (String pathAndSpecString : pathAndSpecList) {
            String[] pathAndSpec = pathAndSpecString.trim().split("\\|");
            HashSet<Tunnel> tunnelList = (HashSet<Tunnel>)tunnelMap.get(pathAndSpec[0]);
            if (tunnelList == null) {
                tunnelList = new HashSet<Tunnel>();
                tunnelMap.put(pathAndSpec[0], tunnelList);
            }
            tunnelList.add(new Tunnel(pathAndSpec[1]));
        }
        this.tunnelConnections = new ArrayList<TunnelConnection>();
        SessionFactoryCache sessionFactoryCache = new SessionFactoryCache(this.baseSessionFactory);
        for (String path : tunnelMap.keySet()) {
            this.tunnelConnections.add(new TunnelConnection(sessionFactoryCache.getSessionFactory(path), new ArrayList<Tunnel>((Collection)tunnelMap.get(path))));
        }
    }

    static class SessionFactoryCache {
        private Map<String, SessionFactory> sessionFactoryByPath;
        private SessionFactory defaultSessionFactory;

        SessionFactoryCache(SessionFactory baseSessionFactory) {
            this.defaultSessionFactory = baseSessionFactory;
            this.sessionFactoryByPath = new HashMap<String, SessionFactory>();
        }

        public SessionFactory getSessionFactory(String path) throws JSchException {
            SessionFactory sessionFactory = null;
            String key = null;
            for (String part : path.split("\\-\\>")) {
                if (this.sessionFactoryByPath.containsKey(key = key == null ? part : key + "->" + part)) {
                    sessionFactory = this.sessionFactoryByPath.get(key);
                    continue;
                }
                SessionFactory.SessionFactoryBuilder builder = null;
                builder = sessionFactory == null ? this.defaultSessionFactory.newSessionFactoryBuilder() : sessionFactory.newSessionFactoryBuilder().setProxy(new SshProxy(sessionFactory));
                String[] userAtHost = part.split("\\@");
                String hostname = null;
                if (userAtHost.length == 2) {
                    builder.setUsername(userAtHost[0]);
                    hostname = userAtHost[1];
                } else {
                    hostname = userAtHost[0];
                }
                String[] hostColonPort = hostname.split("\\:");
                builder.setHostname(hostColonPort[0]);
                if (hostColonPort.length == 2) {
                    builder.setPort(Integer.parseInt(hostColonPort[1]));
                }
                sessionFactory = builder.build();
            }
            return sessionFactory;
        }
    }
}

