/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.tunnel;

import com.pastdev.jsch.tunnel.TunnelConnectionManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunneledDataSourceWrapper
implements DataSource,
Closeable {
    private static Logger log = LoggerFactory.getLogger(TunneledDataSourceWrapper.class);
    private DataSource dataSource;
    private TunnelConnectionManager tunnel;

    public TunneledDataSourceWrapper(TunnelConnectionManager tunnel, DataSource dataSource) {
        this.tunnel = tunnel;
        this.dataSource = dataSource;
    }

    @Override
    public void close() throws IOException {
        log.info("closing tunnel");
        this.tunnel.close();
    }

    private void ensureTunnelIsOpen() throws SQLException {
        try {
            this.tunnel.ensureOpen();
        }
        catch (Exception e) {
            throw new SQLException("unable to open tunnel", e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureTunnelIsOpen();
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.ensureTunnelIsOpen();
        return this.dataSource.getConnection(username, password);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (this.dataSource.getClass().equals(iface.getClass())) {
            return true;
        }
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.dataSource.getClass().equals(iface.getClass())) {
            return (T)this.dataSource;
        }
        return this.dataSource.unwrap(iface);
    }
}

