/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.pastdev.jsch.nio.file.AbstractSshPath;
import com.pastdev.jsch.nio.file.UnixSshFileSystem;
import com.pastdev.jsch.nio.file.UnixSshFileSystemWatchService;
import java.io.IOException;
import java.net.URI;
import java.nio.file.AccessMode;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class UnixSshPath
extends AbstractSshPath {
    private boolean absolute;
    private String[] parts;

    UnixSshPath(UnixSshFileSystem unixSshFileSystem, String path) {
        super(unixSshFileSystem);
        this.absolute = false;
        if (path == null || path.isEmpty()) {
            this.parts = new String[0];
        } else {
            String[] parts = path.split("/+", 0);
            if (parts.length == 0) {
                this.absolute = true;
                this.parts = parts;
            } else if (parts[0].isEmpty()) {
                this.absolute = true;
                this.parts = Arrays.copyOfRange(parts, 1, parts.length);
            } else {
                this.parts = parts;
            }
        }
    }

    private UnixSshPath(UnixSshFileSystem unixSshFileSystem, boolean isAbsolute, String ... parts) {
        super(unixSshFileSystem);
        this.absolute = isAbsolute;
        this.parts = parts == null ? new String[]{} : parts;
    }

    @Override
    public int compareTo(Path o) {
        if (!this.getFileSystem().provider().equals(o.getFileSystem().provider())) {
            throw new ClassCastException("cannot compare paths from 2 different provider instances");
        }
        return this.toString().compareTo(((UnixSshPath)o).toString());
    }

    @Override
    public boolean endsWith(Path path) {
        if (!this.getFileSystem().equals(path.getFileSystem())) {
            return false;
        }
        if (path.isAbsolute() && !this.isAbsolute()) {
            return false;
        }
        int count = this.getNameCount();
        int otherCount = path.getNameCount();
        if (otherCount > count) {
            return false;
        }
        --count;
        --otherCount;
        while (otherCount >= 0) {
            if (!path.getName(otherCount).toString().equals(this.getName(count).toString())) {
                return false;
            }
            --count;
            --otherCount;
        }
        return true;
    }

    @Override
    public boolean endsWith(String path) {
        return this.endsWith(new UnixSshPath(this.getFileSystem(), path));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UnixSshPath)) {
            return false;
        }
        UnixSshPath otherPath = (UnixSshPath)other;
        if (!otherPath.getFileSystem().equals(this.getFileSystem())) {
            return false;
        }
        return this.toString().equals(otherPath.toString());
    }

    @Override
    public UnixSshPath getFileName() {
        if (this.parts.length == 0) {
            return null;
        }
        return new UnixSshPath(this.getFileSystem(), false, this.getFileNameString());
    }

    String getFileNameString() {
        return this.parts[this.parts.length - 1];
    }

    @Override
    public UnixSshFileSystem getFileSystem() {
        return (UnixSshFileSystem)super.getFileSystem();
    }

    @Override
    public UnixSshPath getName(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index >= this.parts.length) {
            throw new IllegalArgumentException();
        }
        return new UnixSshPath(this.getFileSystem(), false, this.parts[index]);
    }

    @Override
    public int getNameCount() {
        return this.parts.length;
    }

    @Override
    public UnixSshPath getParent() {
        if (this.parts.length == 0 && !this.isAbsolute()) {
            return null;
        }
        if (this.parts.length <= 1) {
            return new UnixSshPath(this.getFileSystem(), this.isAbsolute(), new String[0]);
        }
        return new UnixSshPath(this.getFileSystem(), this.isAbsolute(), Arrays.copyOfRange(this.parts, 0, this.parts.length - 1));
    }

    @Override
    public Path getRoot() {
        if (this.isAbsolute()) {
            return new UnixSshPath(this.getFileSystem(), true, new String[0]);
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public UnixSshPath normalize() {
        ArrayList<String> partsList = new ArrayList<String>();
        for (String part : this.parts) {
            if (part.equals(".")) continue;
            if (part.equals("..")) {
                int size = partsList.size();
                if (size <= 0) continue;
                partsList.remove(size - 1);
                continue;
            }
            partsList.add(part);
        }
        return new UnixSshPath(this.getFileSystem(), this.isAbsolute(), partsList.toArray(new String[partsList.size()]));
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.register(watcher, events, new WatchEvent.Modifier[0]);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        if (watcher == null) {
            throw new NullPointerException();
        }
        if (!(watcher instanceof UnixSshFileSystemWatchService)) {
            throw new ProviderMismatchException();
        }
        if (!this.getFileSystem().provider().readAttributes((Path)this, BasicFileAttributes.class, new LinkOption[0]).isDirectory()) {
            throw new NotDirectoryException(this.toString());
        }
        this.getFileSystem().provider().checkAccess(this, AccessMode.READ);
        return ((UnixSshFileSystemWatchService)watcher).register(this, events, modifiers);
    }

    @Override
    public UnixSshPath relativize(Path other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (!(other instanceof UnixSshPath)) {
            throw new ProviderMismatchException();
        }
        UnixSshPath unixOther = (UnixSshPath)other;
        if (this.isAbsolute() && !unixOther.isAbsolute()) {
            throw new IllegalArgumentException("this and other must have same isAbsolute");
        }
        if (this.getNameCount() == 0) {
            return unixOther;
        }
        Path relative = null;
        Path remainingOther = null;
        Iterator<Path> otherIterator = unixOther.iterator();
        for (Path part : this) {
            if (relative != null) {
                relative = relative.resolve("..");
                continue;
            }
            if (otherIterator.hasNext()) {
                Path otherPart = otherIterator.next();
                if (part.equals(otherPart)) continue;
                remainingOther = otherPart;
                while (otherIterator.hasNext()) {
                    remainingOther = remainingOther.resolve(otherIterator.next());
                }
                relative = new UnixSshPath(this.getFileSystem(), "..");
                continue;
            }
            relative = new UnixSshPath(this.getFileSystem(), "..");
        }
        if (relative == null) {
            while (otherIterator.hasNext()) {
                if (remainingOther == null) {
                    remainingOther = new UnixSshPath(this.getFileSystem(), "");
                    continue;
                }
                remainingOther = remainingOther.resolve(otherIterator.next());
            }
            return remainingOther == null ? new UnixSshPath(this.getFileSystem(), "") : (UnixSshPath)remainingOther;
        }
        return remainingOther == null ? (UnixSshPath)relative : (UnixSshPath)relative.resolve(remainingOther);
    }

    @Override
    public UnixSshPath resolve(Path other) {
        if (other.isAbsolute()) {
            if (other instanceof UnixSshPath) {
                return (UnixSshPath)other;
            }
            return new UnixSshPath(this.getFileSystem(), other.toString());
        }
        if (other.getNameCount() == 0) {
            return this;
        }
        int count = other.getNameCount();
        String[] combined = new String[this.parts.length + count];
        System.arraycopy(this.parts, 0, combined, 0, this.parts.length);
        int index = this.parts.length;
        for (Path otherPart : other) {
            combined[index++] = otherPart.toString();
        }
        return new UnixSshPath(this.getFileSystem(), this.isAbsolute(), combined);
    }

    @Override
    public UnixSshPath resolve(String other) {
        return this.resolve(new UnixSshPath(this.getFileSystem(), other));
    }

    @Override
    public UnixSshPath resolveSibling(Path other) {
        return this.getParent().resolve(other);
    }

    @Override
    public UnixSshPath resolveSibling(String other) {
        return this.resolveSibling(new UnixSshPath(this.getFileSystem(), other));
    }

    @Override
    public boolean startsWith(Path other) {
        if (!this.getFileSystem().equals(other.getFileSystem())) {
            return false;
        }
        if (other.isAbsolute() && !this.isAbsolute() || this.isAbsolute() && !other.isAbsolute()) {
            return false;
        }
        int count = this.getNameCount();
        int otherCount = other.getNameCount();
        if (otherCount > count) {
            return false;
        }
        for (int i = 0; i < otherCount; ++i) {
            if (other.getName(i).toString().equals(this.getName(i).toString())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(new UnixSshPath(this.getFileSystem(), other));
    }

    @Override
    public UnixSshPath subpath(int start, int end) {
        String[] parts = new String[end - start];
        for (int i = start; i < end; ++i) {
            parts[i] = this.getName(i).toString();
        }
        return new UnixSshPath(this.getFileSystem(), false, parts);
    }

    @Override
    public UnixSshPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.getFileSystem().getDefaultDirectory().resolve(this);
    }

    @Override
    public UnixSshPath toRealPath(LinkOption ... linkOptions) throws IOException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.parts.length > 0) {
            for (String part : this.parts) {
                if (builder.length() > 0 || this.isAbsolute()) {
                    builder.append('/');
                }
                builder.append(part);
            }
        } else if (this.isAbsolute()) {
            builder.append('/');
        }
        return builder.toString();
    }

    @Override
    public URI toUri() {
        return this.getFileSystem().getUri().resolve(this.toAbsolutePath().toString());
    }
}

