[okio](../../index.md) / [okio](../index.md) / [Buffer](./index.md)

# Buffer

(js, jvm, native) `class Buffer : `[`BufferedSource`](../-buffered-source/index.md)`, `[`BufferedSink`](../-buffered-sink/index.md)

A collection of bytes in memory.

**Moving data from one buffer to another is fast.** Instead of copying bytes from one place in
memory to another, this class just changes ownership of the underlying byte arrays.

**This buffer grows with your data.** Just like ArrayList, each buffer starts small. It consumes
only the memory it needs to.

**This buffer pools its byte arrays.** When you allocate a byte array in Java, the runtime must
zero-fill the requested array before returning it to you. Even if you're going to write over that
space anyway. This class avoids zero-fill and GC churn by pooling byte arrays.

### Types

| Name | Summary |
|---|---|
| (jvm) [UnsafeCursor](-unsafe-cursor/index.md) | A handle to the underlying data in a buffer. This handle is unsafe because it does not enforce its own invariants. Instead, it assumes a careful user who has studied Okio's implementation details and their consequences.`class UnsafeCursor : `[`Closeable`](https://docs.oracle.com/javase/6/docs/api/java/io/Closeable.html) |

### Constructors

| Name | Summary |
|---|---|
| (js, jvm, native) [&lt;init&gt;](-init-.md) | A collection of bytes in memory.`<init>()` |

### Properties

| Name | Summary |
|---|---|
| (js, jvm, native) [buffer](buffer.md) | `val buffer: `[`Buffer`](./index.md) |
| (js, jvm, native) [size](size.md) | `var size: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |

### Functions

| Name | Summary |
|---|---|
| (jvm) [buffer](buffer.md) | Returns this source's internal buffer.`fun buffer(): `[`Buffer`](./index.md) |
| (js, jvm, native) [clear](clear.md) | Discards all bytes in this buffer. Calling this method when you're done with a buffer will return its segments to the pool.`fun clear(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [clone](clone.md) | Returns a deep copy of this buffer.`fun clone(): `[`Buffer`](./index.md) |
| (js, jvm, native) [close](close.md) | `fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (js, jvm, native) [completeSegmentByteCount](complete-segment-byte-count.md) | Returns the number of bytes in segments that are not writable. This is the number of bytes that can be flushed immediately to an underlying sink without harming throughput.`fun completeSegmentByteCount(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (js, jvm, native) [copy](copy.md) | Returns a deep copy of this buffer.`fun copy(): `[`Buffer`](./index.md) |
| [copyTo](copy-to.md) | Copy `byteCount` bytes from this, starting at `offset`, to `out`.(jvm) `fun copyTo(out: `[`OutputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/OutputStream.html)`, offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = 0L, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = size - offset): `[`Buffer`](./index.md)<br>(js, jvm) `fun copyTo(out: `[`Buffer`](./index.md)`, offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = 0L, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md)<br>(native) `fun copyTo(out: `[`Buffer`](./index.md)`, offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md)<br>Overload of [copyTo](copy-to.md#okio.Buffer$copyTo(okio.Buffer, kotlin.Long, kotlin.Long)) with byteCount = size - offset, work around for https://youtrack.jetbrains.com/issue/KT-30847(js, jvm) `fun copyTo(out: `[`Buffer`](./index.md)`, offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = 0L): `[`Buffer`](./index.md)<br>(native) `fun copyTo(out: `[`Buffer`](./index.md)`, offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md) |
| (js, jvm, native) [emit](emit.md) | `fun emit(): `[`Buffer`](./index.md) |
| (js, jvm, native) [emitCompleteSegments](emit-complete-segments.md) | `fun emitCompleteSegments(): `[`Buffer`](./index.md) |
| (js, jvm, native) [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| (js, jvm, native) [exhausted](exhausted.md) | `fun exhausted(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| (js, jvm, native) [flush](flush.md) | `fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (js, jvm, native) [get](get.md) | Returns the byte at `pos`.`operator fun get(pos: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html) |
| (jvm) [getByte](get-byte.md) | `fun ~~getByte~~(index: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html) |
| (js, jvm, native) [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| (jvm) [hmacSha1](hmac-sha1.md) | Returns the 160-bit SHA-1 HMAC of this buffer.`fun hmacSha1(key: `[`ByteString`](../-byte-string/index.md)`): `[`ByteString`](../-byte-string/index.md) |
| (jvm) [hmacSha256](hmac-sha256.md) | Returns the 256-bit SHA-256 HMAC of this buffer.`fun hmacSha256(key: `[`ByteString`](../-byte-string/index.md)`): `[`ByteString`](../-byte-string/index.md) |
| (jvm) [hmacSha512](hmac-sha512.md) | Returns the 512-bit SHA-512 HMAC of this buffer.`fun hmacSha512(key: `[`ByteString`](../-byte-string/index.md)`): `[`ByteString`](../-byte-string/index.md) |
| (js, jvm, native) [indexOf](index-of.md) | `fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>`fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, toIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>`fun indexOf(bytes: `[`ByteString`](../-byte-string/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>`fun indexOf(bytes: `[`ByteString`](../-byte-string/index.md)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of `b` in this at or beyond `fromIndex`, or -1 if this buffer does not contain `b` in that range.`fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (js, jvm, native) [indexOfElement](index-of-element.md) | `fun indexOfElement(targetBytes: `[`ByteString`](../-byte-string/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>`fun indexOfElement(targetBytes: `[`ByteString`](../-byte-string/index.md)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (jvm) [inputStream](input-stream.md) | Returns an input stream that reads from this source.`fun inputStream(): `[`InputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/InputStream.html) |
| (jvm) [isOpen](is-open.md) | `fun isOpen(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| (jvm) [md5](md5.md) | Returns the 128-bit MD5 hash of this buffer.`fun md5(): `[`ByteString`](../-byte-string/index.md) |
| (jvm) [outputStream](output-stream.md) | Returns an output stream that writes to this sink.`fun outputStream(): `[`OutputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/OutputStream.html) |
| (js, jvm, native) [peek](peek.md) | `fun peek(): `[`BufferedSource`](../-buffered-source/index.md) |
| (js, jvm, native) [rangeEquals](range-equals.md) | `fun rangeEquals(offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bytes: `[`ByteString`](../-byte-string/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>`fun rangeEquals(offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bytes: `[`ByteString`](../-byte-string/index.md)`, bytesOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [read](read.md) | (jvm) `fun read(sink: `[`ByteBuffer`](https://docs.oracle.com/javase/6/docs/api/java/nio/ByteBuffer.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(js, jvm, native) `fun read(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(js, jvm, native) `fun read(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(js, jvm, native) `fun read(sink: `[`Buffer`](./index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (js, jvm, native) [readAll](read-all.md) | `fun readAll(sink: `[`Sink`](../-sink/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (jvm) [readAndWriteUnsafe](read-and-write-unsafe.md) | `fun readAndWriteUnsafe(unsafeCursor: `[`Buffer.UnsafeCursor`](-unsafe-cursor/index.md)` = UnsafeCursor()): `[`Buffer.UnsafeCursor`](-unsafe-cursor/index.md) |
| (js, jvm, native) [readByte](read-byte.md) | `fun readByte(): `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html) |
| (js, jvm, native) [readByteArray](read-byte-array.md) | `fun readByteArray(): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>`fun readByteArray(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html) |
| (js, jvm, native) [readByteString](read-byte-string.md) | `fun readByteString(): `[`ByteString`](../-byte-string/index.md)<br>`fun readByteString(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`ByteString`](../-byte-string/index.md) |
| (js, jvm, native) [readDecimalLong](read-decimal-long.md) | `fun readDecimalLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (jvm) [readFrom](read-from.md) | Read and exhaust bytes from `input` into this.`fun readFrom(input: `[`InputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/InputStream.html)`): `[`Buffer`](./index.md)<br>Read `byteCount` bytes from `input` into this.`fun readFrom(input: `[`InputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/InputStream.html)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md) |
| (js, jvm, native) [readFully](read-fully.md) | `fun readFully(sink: `[`Buffer`](./index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`fun readFully(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (js, jvm, native) [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md) | `fun readHexadecimalUnsignedLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (js, jvm, native) [readInt](read-int.md) | `fun readInt(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| (js, jvm, native) [readIntLe](read-int-le.md) | `fun readIntLe(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| (js, jvm, native) [readLong](read-long.md) | `fun readLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (js, jvm, native) [readLongLe](read-long-le.md) | `fun readLongLe(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (js, jvm, native) [readShort](read-short.md) | `fun readShort(): `[`Short`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html) |
| (js, jvm, native) [readShortLe](read-short-le.md) | `fun readShortLe(): `[`Short`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html) |
| (jvm) [readString](read-string.md) | Removes all bytes from this, decodes them as `charset`, and returns the string.`fun readString(charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes `byteCount` bytes from this, decodes them as `charset`, and returns the string.`fun readString(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| (jvm) [readUnsafe](read-unsafe.md) | `fun readUnsafe(unsafeCursor: `[`Buffer.UnsafeCursor`](-unsafe-cursor/index.md)` = UnsafeCursor()): `[`Buffer.UnsafeCursor`](-unsafe-cursor/index.md) |
| (js, jvm, native) [readUtf8](read-utf8.md) | `fun readUtf8(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>`fun readUtf8(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| (js, jvm, native) [readUtf8CodePoint](read-utf8-code-point.md) | `fun readUtf8CodePoint(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| (js, jvm, native) [readUtf8Line](read-utf8-line.md) | `fun readUtf8Line(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| (js, jvm, native) [readUtf8LineStrict](read-utf8-line-strict.md) | `fun readUtf8LineStrict(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>`fun readUtf8LineStrict(limit: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| (js, jvm, native) [request](request.md) | `fun request(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| (js, jvm, native) [require](require.md) | `fun require(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [select](select.md) | (native) `fun select(options: <ERROR CLASS>): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(js, jvm) `fun select(options: `[`Options`](../-options/index.md)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| (jvm) [sha1](sha1.md) | Returns the 160-bit SHA-1 hash of this buffer.`fun sha1(): `[`ByteString`](../-byte-string/index.md) |
| (jvm) [sha256](sha256.md) | Returns the 256-bit SHA-256 hash of this buffer.`fun sha256(): `[`ByteString`](../-byte-string/index.md) |
| (jvm) [sha512](sha512.md) | Returns the 512-bit SHA-512 hash of this buffer.`fun sha512(): `[`ByteString`](../-byte-string/index.md) |
| (jvm) [size](size.md) | `fun ~~size~~(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (js, jvm, native) [skip](skip.md) | Discards `byteCount` bytes from the head of this buffer.`fun skip(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (js, jvm, native) [snapshot](snapshot.md) | Returns an immutable copy of this buffer as a byte string.`fun snapshot(): `[`ByteString`](../-byte-string/index.md)<br>Returns an immutable copy of the first `byteCount` bytes of this buffer as a byte string.`fun snapshot(byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ByteString`](../-byte-string/index.md) |
| (js, jvm, native) [timeout](timeout.md) | `fun timeout(): `[`Timeout`](../-timeout/index.md) |
| [toString](to-string.md) | Returns a human-readable string that describes the contents of this buffer. Typically this is a string like `[text=Hello]` or `[hex=0000ffff]`.(js, jvm) `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>(native) `fun toString(): <ERROR CLASS>` |
| [write](write.md) | (jvm) `fun write(source: `[`ByteBuffer`](https://docs.oracle.com/javase/6/docs/api/java/nio/ByteBuffer.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(js, jvm, native) `fun write(byteString: `[`ByteString`](../-byte-string/index.md)`): `[`Buffer`](./index.md)<br>(js, jvm) `fun write(byteString: `[`ByteString`](../-byte-string/index.md)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md)<br>(native) `fun write(byteString: `[`ByteString`](../-byte-string/index.md)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): <ERROR CLASS>`<br>(js, jvm, native) `fun write(source: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Buffer`](./index.md)<br>(js, jvm, native) `fun write(source: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md)<br>(js, jvm, native) `fun write(source: `[`Source`](../-source/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md)<br>(js, jvm, native) `fun write(source: `[`Buffer`](./index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (js, jvm, native) [writeAll](write-all.md) | `fun writeAll(source: `[`Source`](../-source/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (js, jvm, native) [writeByte](write-byte.md) | `fun writeByte(b: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md) |
| (js, jvm, native) [writeDecimalLong](write-decimal-long.md) | `fun writeDecimalLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md) |
| (js, jvm, native) [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md) | `fun writeHexadecimalUnsignedLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md) |
| (js, jvm, native) [writeInt](write-int.md) | `fun writeInt(i: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md) |
| (js, jvm, native) [writeIntLe](write-int-le.md) | `fun writeIntLe(i: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md) |
| (js, jvm, native) [writeLong](write-long.md) | `fun writeLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md) |
| (js, jvm, native) [writeLongLe](write-long-le.md) | `fun writeLongLe(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md) |
| (js, jvm, native) [writeShort](write-short.md) | `fun writeShort(s: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md) |
| (js, jvm, native) [writeShortLe](write-short-le.md) | `fun writeShortLe(s: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md) |
| (jvm) [writeString](write-string.md) | `fun writeString(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`Buffer`](./index.md)<br>`fun writeString(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`Buffer`](./index.md) |
| (jvm) [writeTo](write-to.md) | Write `byteCount` bytes from this to `out`.`fun writeTo(out: `[`OutputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/OutputStream.html)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = size): `[`Buffer`](./index.md) |
| (js, jvm, native) [writeUtf8](write-utf8.md) | `fun writeUtf8(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Buffer`](./index.md)<br>`fun writeUtf8(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md) |
| (js, jvm, native) [writeUtf8CodePoint](write-utf8-code-point.md) | `fun writeUtf8CodePoint(codePoint: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md) |

### Inherited Functions

| Name | Summary |
|---|---|
| (jvm) [buffer](../-buffered-source/buffer.md) | Returns this source's internal buffer.`abstract fun ~~buffer~~(): `[`Buffer`](./index.md) |
| (jvm) [inputStream](../-buffered-source/input-stream.md) | Returns an input stream that reads from this source.`abstract fun inputStream(): `[`InputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/InputStream.html) |
| (jvm) [outputStream](../-buffered-sink/output-stream.md) | Returns an output stream that writes to this sink.`abstract fun outputStream(): `[`OutputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/OutputStream.html) |
| (jvm) [readString](../-buffered-source/read-string.md) | Removes all bytes from this, decodes them as `charset`, and returns the string.`abstract fun readString(charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes `byteCount` bytes from this, decodes them as `charset`, and returns the string.`abstract fun readString(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| (jvm) [writeString](../-buffered-sink/write-string.md) | `abstract fun writeString(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`BufferedSink`](../-buffered-sink/index.md)<br>`abstract fun writeString(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`BufferedSink`](../-buffered-sink/index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| (jvm) [deflate](../deflate.md) | Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md#okio.Sink) while writing.`fun `[`Sink`](../-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](../-deflater-sink/index.md) |
| (jvm) [inflate](../inflate.md) | Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md#okio.Source) while reading.`fun `[`Source`](../-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](../-inflater-source/index.md) |
