[okio](../../index.md) / [okio](../index.md) / [BufferedSource](index.md) / [select](./select.md)

# select

(js, jvm) `abstract fun select(options: `[`Options`](../-options/index.md)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)

Finds the first string in `options` that is a prefix of this buffer, consumes it from this
buffer, and returns its index. If no byte string in `options` is a prefix of this buffer this
returns -1 and no bytes are consumed.

This can be used as an alternative to [readByteString](read-byte-string.md#okio.BufferedSource$readByteString()) or even [readUtf8](read-utf8.md#okio.BufferedSource$readUtf8()) if the set of
expected values is known in advance.

```
Options FIELDS = Options.of(
    ByteString.encodeUtf8("depth="),
    ByteString.encodeUtf8("height="),
    ByteString.encodeUtf8("width="));

Buffer buffer = new Buffer()
    .writeUtf8("width=640\n")
    .writeUtf8("height=480\n");

assertEquals(2, buffer.select(FIELDS));
assertEquals(640, buffer.readDecimalLong());
assertEquals('\n', buffer.readByte());
assertEquals(1, buffer.select(FIELDS));
assertEquals(480, buffer.readDecimalLong());
assertEquals('\n', buffer.readByte());
```

(native) `abstract fun select(options: <ERROR CLASS>): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)