[okio](../../index.md) / [okio](../index.md) / [ByteString](./index.md)

# ByteString

(js, jvm, native) `open class ByteString : `[`Comparable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)`<`[`ByteString`](./index.md)`>`

An immutable sequence of bytes.

Byte strings compare lexicographically as a sequence of **unsigned** bytes. That is, the byte
string `ff` sorts after `00`. This is counter to the sort order of the corresponding bytes,
where `-1` sorts before `0`.

**Full disclosure:** this class provides untrusted input and output streams with raw access to
the underlying byte array. A hostile stream implementation could keep a reference to the mutable
byte string, violating the immutable guarantee of this class. For this reason a byte string's
immutability guarantee cannot be relied upon for security in applets and other environments that
run both trusted and untrusted code in the same process.

### Properties

| Name | Summary |
|---|---|
| [size](size.md) | Returns the number of bytes in this ByteString.(js, jvm) `val size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(native) `val size: <ERROR CLASS>` |

### Functions

| Name | Summary |
|---|---|
| (jvm) [asByteBuffer](as-byte-buffer.md) | Returns a `ByteBuffer` view of the bytes in this `ByteString`.`open fun asByteBuffer(): `[`ByteBuffer`](https://docs.oracle.com/javase/6/docs/api/java/nio/ByteBuffer.html) |
| [base64](base64.md) | Returns this byte string encoded as [Base64](http://www.ietf.org/rfc/rfc2045.txt). In violation of the RFC, the returned string does not wrap lines at 76 columns.(js, jvm) `fun base64(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>(native) `open fun base64(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [base64Url](base64-url.md) | Returns this byte string encoded as [URL-safe Base64](http://www.ietf.org/rfc/rfc4648.txt).(js, jvm) `fun base64Url(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>(native) `open fun base64Url(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [compareTo](compare-to.md) | (js, jvm) `open fun compareTo(other: `[`ByteString`](./index.md)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(native) `open fun compareTo(other: `[`ByteString`](./index.md)`): <ERROR CLASS>` |
| [endsWith](ends-with.md) | (js, jvm) `fun endsWith(suffix: `[`ByteString`](./index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>(native) `fun endsWith(suffix: `[`ByteString`](./index.md)`): <ERROR CLASS>`<br>(js, jvm) `fun endsWith(suffix: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>(native) `fun endsWith(suffix: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): <ERROR CLASS>` |
| [equals](equals.md) | (js, jvm) `open fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>(native) `open fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): <ERROR CLASS>` |
| (js, jvm, native) [get](get.md) | Returns the byte at `index`.`operator fun get(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html) |
| (jvm) [getByte](get-byte.md) | `fun ~~getByte~~(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html) |
| [hashCode](hash-code.md) | (js, jvm) `open fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(native) `open fun hashCode(): <ERROR CLASS>` |
| [hex](hex.md) | Returns this byte string encoded in hexadecimal.(js, jvm) `fun hex(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>(native) `open fun hex(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| (jvm) [hmacSha1](hmac-sha1.md) | Returns the 160-bit SHA-1 HMAC of this byte string.`open fun hmacSha1(key: `[`ByteString`](./index.md)`): `[`ByteString`](./index.md) |
| (jvm) [hmacSha256](hmac-sha256.md) | Returns the 256-bit SHA-256 HMAC of this byte string.`open fun hmacSha256(key: `[`ByteString`](./index.md)`): `[`ByteString`](./index.md) |
| (jvm) [hmacSha512](hmac-sha512.md) | Returns the 512-bit SHA-512 HMAC of this byte string.`open fun hmacSha512(key: `[`ByteString`](./index.md)`): `[`ByteString`](./index.md) |
| [indexOf](index-of.md) | (js, jvm) `fun indexOf(other: `[`ByteString`](./index.md)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(native) `fun indexOf(other: `[`ByteString`](./index.md)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): <ERROR CLASS>`<br>(js, jvm) `fun indexOf(other: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(native) `open fun indexOf(other: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): <ERROR CLASS>` |
| [lastIndexOf](last-index-of.md) | (js, jvm) `fun lastIndexOf(other: `[`ByteString`](./index.md)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = size): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(native) `fun lastIndexOf(other: `[`ByteString`](./index.md)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): <ERROR CLASS>`<br>(js, jvm) `fun lastIndexOf(other: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = size): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>(native) `open fun lastIndexOf(other: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): <ERROR CLASS>` |
| (jvm) [md5](md5.md) | Returns the 128-bit MD5 hash of this byte string.`open fun md5(): `[`ByteString`](./index.md) |
| [rangeEquals](range-equals.md) | Returns true if the bytes of this in `[offset..offset+byteCount)` equal the bytes of `other` in `[otherOffset..otherOffset+byteCount)`. Returns false if either range is out of bounds.(js, jvm) `fun rangeEquals(offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, other: `[`ByteString`](./index.md)`, otherOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>(native) `open fun rangeEquals(offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, other: `[`ByteString`](./index.md)`, otherOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>(js, jvm) `fun rangeEquals(offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, other: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, otherOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>(native) `open fun rangeEquals(offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, other: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, otherOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| (jvm) [sha1](sha1.md) | Returns the 160-bit SHA-1 hash of this byte string.`open fun sha1(): `[`ByteString`](./index.md) |
| (jvm) [sha256](sha256.md) | Returns the 256-bit SHA-256 hash of this byte string.`open fun sha256(): `[`ByteString`](./index.md) |
| (jvm) [sha512](sha512.md) | Returns the 512-bit SHA-512 hash of this byte string.`open fun sha512(): `[`ByteString`](./index.md) |
| (jvm) [size](size.md) | `fun ~~size~~(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [startsWith](starts-with.md) | (js, jvm) `fun startsWith(prefix: `[`ByteString`](./index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>(native) `fun startsWith(prefix: `[`ByteString`](./index.md)`): <ERROR CLASS>`<br>(js, jvm) `fun startsWith(prefix: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>(native) `fun startsWith(prefix: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): <ERROR CLASS>` |
| (jvm) [string](string.md) | Constructs a new `String` by decoding the bytes using `charset`.`open fun string(charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [substring](substring.md) | Returns a byte string that is a substring of this byte string, beginning at the specified `beginIndex` and ends at the specified `endIndex`. Returns this byte string if `beginIndex` is 0 and `endIndex` is the length of this byte string.(js, jvm) `fun substring(beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = size): `[`ByteString`](./index.md)<br>(native) `open fun substring(beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ByteString`](./index.md) |
| [toAsciiLowercase](to-ascii-lowercase.md) | Returns a byte string equal to this byte string, but with the bytes 'A' through 'Z' replaced with the corresponding byte in 'a' through 'z'. Returns this byte string if it contains no bytes in 'A' through 'Z'.(js, jvm) `fun toAsciiLowercase(): `[`ByteString`](./index.md)<br>(native) `open fun toAsciiLowercase(): `[`ByteString`](./index.md) |
| [toAsciiUppercase](to-ascii-uppercase.md) | Returns a byte string equal to this byte string, but with the bytes 'a' through 'z' replaced with the corresponding byte in 'A' through 'Z'. Returns this byte string if it contains no bytes in 'a' through 'z'.(js, jvm) `fun toAsciiUppercase(): `[`ByteString`](./index.md)<br>(native) `open fun toAsciiUppercase(): `[`ByteString`](./index.md) |
| [toByteArray](to-byte-array.md) | Returns a byte array containing a copy of the bytes in this `ByteString`.(js, jvm) `fun toByteArray(): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>(native) `open fun toByteArray(): <ERROR CLASS>` |
| [toString](to-string.md) | Returns a human-readable string that describes the contents of this byte string. Typically this is a string like `[text=Hello]` or `[hex=0000ffff]`.(js, jvm) `open fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>(native) `open fun toString(): <ERROR CLASS>` |
| [utf8](utf8.md) | Constructs a new `String` by decoding the bytes as `UTF-8`.(js, jvm) `fun utf8(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>(native) `open fun utf8(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| (jvm) [write](write.md) | Writes the contents of this byte string to `out`.`open fun write(out: `[`OutputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/OutputStream.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| (js, jvm, native) [EMPTY](-e-m-p-t-y.md) | A singleton empty `ByteString`.`val EMPTY: `[`ByteString`](./index.md) |

### Companion Object Functions

| Name | Summary |
|---|---|
| (js, jvm, native) [decodeBase64](decode-base64.md) | Decodes the Base64-encoded bytes and returns their value as a byte string. Returns null if this is not a Base64-encoded sequence of bytes.`fun `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`.decodeBase64(): `[`ByteString`](./index.md)`?` |
| [decodeHex](decode-hex.md) | Decodes the hex-encoded bytes and returns their value a byte string.(js, jvm) `fun `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`.decodeHex(): `[`ByteString`](./index.md)<br>(native) `fun `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`.decodeHex(): <ERROR CLASS>` |
| (jvm) [encode](encode.md) | Returns a new [ByteString](index.md#okio.ByteString) containing the `charset`-encoded bytes of this [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).`fun `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`.encode(charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)` = Charsets.UTF_8): `[`ByteString`](./index.md) |
| (jvm) [encodeString](encode-string.md) | `fun ~~encodeString~~(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`ByteString`](./index.md) |
| (js, jvm, native) [encodeUtf8](encode-utf8.md) | Returns a new byte string containing the `UTF-8` bytes of this [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).`fun `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`.encodeUtf8(): `[`ByteString`](./index.md) |
| [of](of.md) | (jvm) `fun ~~of~~(buffer: `[`ByteBuffer`](https://docs.oracle.com/javase/6/docs/api/java/nio/ByteBuffer.html)`): `[`ByteString`](./index.md)<br>(jvm) `fun ~~of~~(array: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ByteString`](./index.md)<br>Returns a new byte string containing a clone of the bytes of `data`.(js, jvm) `fun of(vararg data: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`): `[`ByteString`](./index.md)<br>(native) `fun of(vararg data: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`): <ERROR CLASS>` |
| (jvm) [read](read.md) | `fun ~~read~~(inputstream: `[`InputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/InputStream.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ByteString`](./index.md) |
| (jvm) [readByteString](read-byte-string.md) | Reads `count` bytes from this [InputStream](https://docs.oracle.com/javase/6/docs/api/java/io/InputStream.html) and returns the result.`fun `[`InputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/InputStream.html)`.readByteString(byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ByteString`](./index.md) |
| [toByteString](to-byte-string.md) | Returns a [ByteString](index.md#okio.ByteString) containing a copy of this [ByteBuffer](https://docs.oracle.com/javase/6/docs/api/java/nio/ByteBuffer.html).(jvm) `fun `[`ByteBuffer`](https://docs.oracle.com/javase/6/docs/api/java/nio/ByteBuffer.html)`.toByteString(): `[`ByteString`](./index.md)<br>Returns a new [ByteString](index.md#okio.ByteString) containing a copy of `byteCount` bytes of this [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html) starting at `offset`.(js, jvm) `fun `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`.toByteString(offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = size): `[`ByteString`](./index.md)<br>(native) `fun `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`.toByteString(offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ByteString`](./index.md) |
