[okio](../../index.md) / [okio](../index.md) / [DeflaterSink](./index.md)

# DeflaterSink

(jvm) `class DeflaterSink : `[`Sink`](../-sink/index.md)

A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to
compress data written to another source.

### Sync flush

Aggressive flushing of this stream may result in reduced compression. Each
call to [flush](flush.md) immediately compresses all currently-buffered data;
this early compression may be less effective than compression performed
without flushing.

This is equivalent to using [Deflater](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Deflater.html) with the sync flush option.
This class does not offer any partial flush mechanism. For best performance,
only call [flush](flush.md) when application behavior requires it.

### Constructors

| Name | Summary |
|---|---|
| (jvm) [&lt;init&gt;](-init-.md) | `DeflaterSink(sink: `[`Sink`](../-sink/index.md)`, deflater: `[`Deflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Deflater.html)`)` |

### Functions

| Name | Summary |
|---|---|
| (jvm) [close](close.md) | `fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [flush](flush.md) | `fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [timeout](timeout.md) | `fun timeout(): `[`Timeout`](../-timeout/index.md) |
| (jvm) [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| (jvm) [write](write.md) | `fun write(source: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| (jvm) [deflate](../deflate.md) | Returns an [DeflaterSink](./index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md#okio.Sink) while writing.`fun `[`Sink`](../-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](./index.md) |
| (jvm) [gzip](../gzip.md) | Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](../-sink/index.md#okio.Sink) while writing.`fun `[`Sink`](../-sink/index.md)`.gzip(): `[`GzipSink`](../-gzip-sink/index.md) |
