[okio](../../index.md) / [okio](../index.md) / [ForwardingSink](./index.md)

# ForwardingSink

(jvm) `abstract class ForwardingSink : `[`Sink`](../-sink/index.md)

A [Sink](../-sink/index.md#okio.Sink) which forwards calls to another. Useful for subclassing.

### Constructors

| Name | Summary |
|---|---|
| (jvm) [&lt;init&gt;](-init-.md) | A [Sink](../-sink/index.md#okio.Sink) which forwards calls to another. Useful for subclassing.`ForwardingSink(delegate: `[`Sink`](../-sink/index.md)`)` |

### Properties

| Name | Summary |
|---|---|
| (jvm) [delegate](delegate.md) | [Sink](../-sink/index.md#okio.Sink) to which this instance is delegating.`val delegate: `[`Sink`](../-sink/index.md) |

### Functions

| Name | Summary |
|---|---|
| (jvm) [close](close.md) | `open fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [delegate](delegate.md) | `fun ~~delegate~~(): `[`Sink`](../-sink/index.md) |
| (jvm) [flush](flush.md) | `open fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [timeout](timeout.md) | `open fun timeout(): `[`Timeout`](../-timeout/index.md) |
| (jvm) [toString](to-string.md) | `open fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| (jvm) [write](write.md) | `open fun write(source: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| (jvm) [deflate](../deflate.md) | Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md#okio.Sink) while writing.`fun `[`Sink`](../-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](../-deflater-sink/index.md) |
| (jvm) [gzip](../gzip.md) | Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](../-sink/index.md#okio.Sink) while writing.`fun `[`Sink`](../-sink/index.md)`.gzip(): `[`GzipSink`](../-gzip-sink/index.md) |

### Inheritors

| Name | Summary |
|---|---|
| (jvm) [HashingSink](../-hashing-sink/index.md) | A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](../-hashing-sink/hash.md) to compute the final hash value.`class HashingSink : `[`ForwardingSink`](./index.md) |
