[okio](../../index.md) / [okio](../index.md) / [HashingSink](./index.md)

# HashingSink

(jvm) `class HashingSink : `[`ForwardingSink`](../-forwarding-sink/index.md)

A sink that computes a hash of the full stream of bytes it has accepted. To use, create an
instance with your preferred hash algorithm. Write all of the data to the sink and then call
[hash](hash.md) to compute the final hash value.

In this example we use `HashingSink` with a [BufferedSink](../-buffered-sink/index.md#okio.BufferedSink) to make writing to the
sink easier.

```
HashingSink hashingSink = HashingSink.sha256(s);
BufferedSink bufferedSink = Okio.buffer(hashingSink);

... // Write to bufferedSink and either flush or close it.

ByteString hash = hashingSink.hash();
```

### Properties

| Name | Summary |
|---|---|
| (jvm) [hash](hash.md) | Returns the hash of the bytes accepted thus far and resets the internal state of this sink.`val hash: `[`ByteString`](../-byte-string/index.md) |

### Functions

| Name | Summary |
|---|---|
| (jvm) [hash](hash.md) | `fun ~~hash~~(): `[`ByteString`](../-byte-string/index.md) |
| (jvm) [write](write.md) | `fun write(source: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| (jvm) [hmacSha1](hmac-sha1.md) | Returns a sink that uses the obsolete SHA-1 HMAC algorithm to produce 160-bit hashes.`fun hmacSha1(sink: `[`Sink`](../-sink/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSink`](./index.md) |
| (jvm) [hmacSha256](hmac-sha256.md) | Returns a sink that uses the SHA-256 HMAC algorithm to produce 256-bit hashes.`fun hmacSha256(sink: `[`Sink`](../-sink/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSink`](./index.md) |
| (jvm) [hmacSha512](hmac-sha512.md) | Returns a sink that uses the SHA-512 HMAC algorithm to produce 512-bit hashes.`fun hmacSha512(sink: `[`Sink`](../-sink/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSink`](./index.md) |
| (jvm) [md5](md5.md) | Returns a sink that uses the obsolete MD5 hash algorithm to produce 128-bit hashes.`fun md5(sink: `[`Sink`](../-sink/index.md)`): `[`HashingSink`](./index.md) |
| (jvm) [sha1](sha1.md) | Returns a sink that uses the obsolete SHA-1 hash algorithm to produce 160-bit hashes.`fun sha1(sink: `[`Sink`](../-sink/index.md)`): `[`HashingSink`](./index.md) |
| (jvm) [sha256](sha256.md) | Returns a sink that uses the SHA-256 hash algorithm to produce 256-bit hashes.`fun sha256(sink: `[`Sink`](../-sink/index.md)`): `[`HashingSink`](./index.md) |
| (jvm) [sha512](sha512.md) | Returns a sink that uses the SHA-512 hash algorithm to produce 512-bit hashes.`fun sha512(sink: `[`Sink`](../-sink/index.md)`): `[`HashingSink`](./index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| (jvm) [deflate](../deflate.md) | Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md#okio.Sink) while writing.`fun `[`Sink`](../-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](../-deflater-sink/index.md) |
| (jvm) [gzip](../gzip.md) | Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](../-sink/index.md#okio.Sink) while writing.`fun `[`Sink`](../-sink/index.md)`.gzip(): `[`GzipSink`](../-gzip-sink/index.md) |
