[okio](../../index.md) / [okio](../index.md) / [Pipe](index.md) / [cancel](./cancel.md)

# cancel

(jvm) `fun cancel(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)

Fail any in-flight and future operations. After canceling:

* Any attempt to write or flush [sink](sink.md) will fail immediately with an [IOException](../-i-o-exception/index.md#okio.IOException).
* Any attempt to read [source](source.md) will fail immediately with an [IOException](../-i-o-exception/index.md#okio.IOException).
* Any attempt to [fold](fold.md) will fail immediately with an [IOException](../-i-o-exception/index.md#okio.IOException).

Closing the source and the sink will complete normally even after a pipe has been canceled. If
this sink has been folded, closing it will close the folded sink. This operation may block.

This operation may be called by any thread at any time. It is safe to call concurrently while
operating on the source or the sink.

