[okio](../index.md) / [okio](./index.md)

## Package okio

### Types

| Name | Summary |
|---|---|
| (jvm) [-DeprecatedOkio](--deprecated-okio/index.md) | `object ~~-DeprecatedOkio~~` |
| (jvm) [-DeprecatedUtf8](--deprecated-utf8/index.md) | `object ~~-DeprecatedUtf8~~` |
| (jvm) [AsyncTimeout](-async-timeout/index.md) | This timeout uses a background thread to take action exactly when the timeout occurs. Use this to implement timeouts where they aren't supported natively, such as to sockets that are blocked on writing.`open class AsyncTimeout : `[`Timeout`](-timeout/index.md) |
| (js, jvm, native) [Buffer](-buffer/index.md) | A collection of bytes in memory.`class Buffer : `[`BufferedSource`](-buffered-source/index.md)`, `[`BufferedSink`](-buffered-sink/index.md) |
| (js, jvm, native) [BufferedSink](-buffered-sink/index.md) | A sink that keeps a buffer internally so that callers can do small writes without a performance penalty.`interface BufferedSink : `[`Sink`](-sink/index.md) |
| (js, jvm, native) [BufferedSource](-buffered-source/index.md) | A source that keeps a buffer internally so that callers can do small reads without a performance penalty. It also allows clients to read ahead, buffering as much as necessary before consuming input.`interface BufferedSource : `[`Source`](-source/index.md) |
| (js, jvm, native) [ByteString](-byte-string/index.md) | An immutable sequence of bytes.`open class ByteString : `[`Comparable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)`<`[`ByteString`](-byte-string/index.md)`>` |
| (jvm) [DeflaterSink](-deflater-sink/index.md) | A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source.`class DeflaterSink : `[`Sink`](-sink/index.md) |
| (jvm) [ForwardingSink](-forwarding-sink/index.md) | A [Sink](-sink/index.md#okio.Sink) which forwards calls to another. Useful for subclassing.`abstract class ForwardingSink : `[`Sink`](-sink/index.md) |
| (jvm) [ForwardingSource](-forwarding-source/index.md) | A [Source](-source/index.md#okio.Source) which forwards calls to another. Useful for subclassing.`abstract class ForwardingSource : `[`Source`](-source/index.md) |
| (jvm) [ForwardingTimeout](-forwarding-timeout/index.md) | A [Timeout](-timeout/index.md#okio.Timeout) which forwards calls to another. Useful for subclassing.`open class ForwardingTimeout : `[`Timeout`](-timeout/index.md) |
| (jvm) [GzipSink](-gzip-sink/index.md) | A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink.`class GzipSink : `[`Sink`](-sink/index.md) |
| (jvm) [GzipSource](-gzip-source/index.md) | A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to decompress data read from another source.`class GzipSource : `[`Source`](-source/index.md) |
| (jvm) [HashingSink](-hashing-sink/index.md) | A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](-hashing-sink/hash.md) to compute the final hash value.`class HashingSink : `[`ForwardingSink`](-forwarding-sink/index.md) |
| (jvm) [HashingSource](-hashing-source/index.md) | A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](-hashing-source/hash.md) to compute the final hash value.`class HashingSource : `[`ForwardingSource`](-forwarding-source/index.md) |
| (jvm) [InflaterSource](-inflater-source/index.md) | A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from another source.`class InflaterSource : `[`Source`](-source/index.md) |
| [Options](-options/index.md) | An indexed set of values that may be read with [BufferedSource.select](-buffered-source/select.md#okio.BufferedSource$select(okio.Options)).(js) `class Options : `[`AbstractList`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-abstract-list/index.html)`<`[`ByteString`](-byte-string/index.md)`>, `[`RandomAccess`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-random-access/index.html)<br>(jvm) `class Options : `[`AbstractList`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-abstract-list/index.html)`<`[`ByteString`](-byte-string/index.md)`>, `[`RandomAccess`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-random-access.html) |
| (jvm) [Pipe](-pipe/index.md) | A source and a sink that are attached. The sink's output is the source's input. Typically each is accessed by its own thread: a producer thread writes data to the sink and a consumer thread reads data from the source.`class Pipe` |
| (js, jvm, native) [Sink](-sink/index.md) | Receives a stream of bytes. Use this interface to write data wherever it's needed: to the network, storage, or a buffer in memory. Sinks may be layered to transform received data, such as to compress, encrypt, throttle, or add protocol framing.`interface Sink` |
| (js, jvm, native) [Source](-source/index.md) | Supplies a stream of bytes. Use this interface to read data from wherever it's located: from the network, storage, or a buffer in memory. Sources may be layered to transform supplied data, such as to decompress, decrypt, or remove protocol framing.`interface Source` |
| (jvm) [Throttler](-throttler/index.md) | Enables limiting of Source and Sink throughput. Attach to this throttler via [source](-throttler/source.md) and [sink](-throttler/sink.md) and set the desired throughput via [bytesPerSecond](-throttler/bytes-per-second.md). Multiple Sources and Sinks can be attached to a single Throttler and they will be throttled as a group, where their combined throughput will not exceed the desired throughput. The same Source or Sink can be attached to multiple Throttlers and its throughput will not exceed the desired throughput of any of the Throttlers.`class Throttler` |
| (js, jvm, native) [Timeout](-timeout/index.md) | A policy on how much time to spend on a task before giving up. When a task times out, it is left in an unspecified state and should be abandoned. For example, if reading from a source times out, that source should be closed and the read should be retried later. If writing to a sink times out, the same rules apply: close the sink and retry later.`open class Timeout` |

### Exceptions

| Name | Summary |
|---|---|
| [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md) | (js, jvm) `class ArrayIndexOutOfBoundsException : `[`IndexOutOfBoundsException`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-index-out-of-bounds-exception/index.html)<br>(native) `typealias ArrayIndexOutOfBoundsException = <ERROR CLASS>` |
| (js, jvm, native) [EOFException](-e-o-f-exception/index.md) | `open class EOFException : `[`IOException`](-i-o-exception/index.md) |
| [IOException](-i-o-exception/index.md) | (js, jvm) `open class IOException : `[`Exception`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)<br>(native) `open class IOException : `[`Exception`](https://docs.oracle.com/javase/6/docs/api/java/lang/Exception.html) |

### Extensions for External Classes

| Name | Summary |
|---|---|
| (jvm) [java.io.File](java.io.-file/index.md) |  |
| (jvm) [java.io.InputStream](java.io.-input-stream/index.md) |  |
| (jvm) [java.io.OutputStream](java.io.-output-stream/index.md) |  |
| (jvm) [java.net.Socket](java.net.-socket/index.md) |  |
| (jvm) [java.nio.file.Path](java.nio.file.-path/index.md) |  |
| (js, jvm) [kotlin.String](kotlin.-string/index.md) |  |

### Properties

| Name | Summary |
|---|---|
| (jvm) [Okio](-okio.md) | `val Okio: `[`-DeprecatedOkio`](--deprecated-okio/index.md) |
| (jvm) [Utf8](-utf8.md) | `val Utf8: `[`-DeprecatedUtf8`](--deprecated-utf8/index.md) |

### Functions

| Name | Summary |
|---|---|
| (js, jvm) [blackholeSink](blackhole-sink.md) | Returns a sink that writes nowhere.`fun blackholeSink(): `[`Sink`](-sink/index.md) |
| (js, jvm) [buffer](buffer.md) | Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data.`fun `[`Source`](-source/index.md)`.buffer(): `[`BufferedSource`](-buffered-source/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data.`fun `[`Sink`](-sink/index.md)`.buffer(): `[`BufferedSink`](-buffered-sink/index.md) |
| (jvm) [deflate](deflate.md) | Returns an [DeflaterSink](-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](-sink/index.md#okio.Sink) while writing.`fun `[`Sink`](-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](-deflater-sink/index.md) |
| (jvm) [gzip](gzip.md) | Returns a [GzipSink](-gzip-sink/index.md) that gzip-compresses to this [Sink](-sink/index.md#okio.Sink) while writing.`fun `[`Sink`](-sink/index.md)`.gzip(): `[`GzipSink`](-gzip-sink/index.md)<br>Returns a [GzipSource](-gzip-source/index.md) that gzip-decompresses this [Source](-source/index.md#okio.Source) while reading.`fun `[`Source`](-source/index.md)`.gzip(): `[`GzipSource`](-gzip-source/index.md) |
| (jvm) [inflate](inflate.md) | Returns an [InflaterSource](-inflater-source/index.md) that DEFLATE-decompresses this [Source](-source/index.md#okio.Source) while reading.`fun `[`Source`](-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](-inflater-source/index.md) |
