//[okio](../../../index.md)/[okio](../index.md)/[ForwardingTimeout](index.md)

# ForwardingTimeout

[jvm]\
open class [ForwardingTimeout](index.md)(delegate: [Timeout](../-timeout/index.md)) : [Timeout](../-timeout/index.md)

A [Timeout](../-timeout/index.md) which forwards calls to another. Useful for subclassing.

## Constructors

| | |
|---|---|
| [ForwardingTimeout](-forwarding-timeout.md) | [jvm]<br>fun [ForwardingTimeout](-forwarding-timeout.md)(delegate: [Timeout](../-timeout/index.md)) |

## Functions

| Name | Summary |
|---|---|
| [clearDeadline](clear-deadline.md) | [jvm]<br>open override fun [clearDeadline](clear-deadline.md)(): [Timeout](../-timeout/index.md)<br>Clears the deadline. |
| [clearTimeout](clear-timeout.md) | [jvm]<br>open override fun [clearTimeout](clear-timeout.md)(): [Timeout](../-timeout/index.md)<br>Clears the timeout. Operating system timeouts may still apply. |
| [deadline](../-timeout/deadline.md) | [jvm]<br>fun [deadline](../-timeout/deadline.md)(duration: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)<br>Set a deadline of now plus duration time. |
| [deadlineNanoTime](deadline-nano-time.md) | [jvm]<br>open override fun [deadlineNanoTime](deadline-nano-time.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.<br>[jvm]<br>open override fun [deadlineNanoTime](deadline-nano-time.md)(deadlineNanoTime: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Timeout](../-timeout/index.md)<br>Sets the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached. All operations must complete before this time. Use a deadline to set a maximum bound on the time spent on a sequence of operations. |
| [hasDeadline](has-deadline.md) | [jvm]<br>open override fun [hasDeadline](has-deadline.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if a deadline is enabled. |
| [intersectWith](../-timeout/intersect-with.md) | [jvm]<br>inline fun &lt;[T](../-timeout/intersect-with.md)&gt; [intersectWith](../-timeout/intersect-with.md)(other: [Timeout](../-timeout/index.md), block: () -&gt; [T](../-timeout/intersect-with.md)): [T](../-timeout/intersect-with.md)<br>Applies the minimum intersection between this timeout and other, run block, then finally rollback this timeout's values. |
| [setDelegate](set-delegate.md) | [jvm]<br>fun [setDelegate](set-delegate.md)(delegate: [Timeout](../-timeout/index.md)): [ForwardingTimeout](index.md) |
| [throwIfReached](throw-if-reached.md) | [jvm]<br>open override fun [throwIfReached](throw-if-reached.md)()<br>Throws an InterruptedIOException if the deadline has been reached or if the current thread has been interrupted. This method doesn't detect timeouts; that should be implemented to asynchronously abort an in-progress operation. |
| [timeout](timeout.md) | [jvm]<br>open override fun [timeout](timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)<br>Wait at most timeout time before aborting an operation. Using a per-operation timeout means that as long as forward progress is being made, no sequence of operations will fail. |
| [timeoutNanos](timeout-nanos.md) | [jvm]<br>open override fun [timeoutNanos](timeout-nanos.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the timeout in nanoseconds, or 0 for no timeout. |
| [waitUntilNotified](../-timeout/wait-until-notified.md) | [jvm]<br>fun [waitUntilNotified](../-timeout/wait-until-notified.md)(monitor: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))<br>Waits on monitor until it is notified. Throws [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if either the thread is interrupted or if this timeout elapses before monitor is notified. The caller must be synchronized on monitor. |

## Properties

| Name | Summary |
|---|---|
| [delegate](delegate.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "delegate")<br>var [delegate](delegate.md): [Timeout](../-timeout/index.md) |
