/* The following code was generated by JFlex 1.4.3 on 16-1-19 21:29 */

package com.thoughtworks.qdox.parser.impl;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import com.thoughtworks.qdox.parser.*;
import java.util.*;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 16-1-19 21:29 from the specification file
 * <tt>E:/java-workspace/github/qdox/target/checkout/src/grammar/lexer.flex</tt>
 */
public class JFlexLexer implements JavaLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int CODEBLOCK = 8;
  public static final int CHAR = 16;
  public static final int SINGLELINECOMMENT = 18;
  public static final int JAVADOCTAG = 4;
  public static final int NAME = 30;
  public static final int ANNOTATIONNOARG = 40;
  public static final int ANNOTATION = 22;
  public static final int ANNOSTRING = 24;
  public static final int TYPE = 38;
  public static final int STRING = 14;
  public static final int NAME_OR_MODIFIER = 44;
  public static final int ATANNOTATION = 42;
  public static final int MODULE = 36;
  public static final int ARGUMENTS = 28;
  public static final int ENUM = 34;
  public static final int JAVADOCLINE = 6;
  public static final int ANNOCHAR = 26;
  public static final int JAVADOC = 2;
  public static final int ASSIGNMENT = 12;
  public static final int PARENBLOCK = 10;
  public static final int YYINITIAL = 0;
  public static final int MULTILINECOMMENT = 20;
  public static final int ANNOTATIONTYPE = 32;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  1,  1,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5, 
     6,  6,  7,  7,  8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 
    14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\30\1\5\1\2\1\0\1\3\1\1\16\30\4\0\1\5\1\106"+
    "\1\103\1\0\1\27\1\77\1\67\1\104\1\75\1\64\1\4\1\100"+
    "\1\50\1\21\1\22\1\6\1\7\1\16\6\14\2\10\1\105\1\40"+
    "\1\65\1\74\1\66\1\70\1\71\1\12\1\15\1\12\1\23\1\20"+
    "\1\23\5\27\1\17\3\27\1\24\7\27\1\13\2\27\1\62\1\25"+
    "\1\63\1\101\1\11\1\0\1\43\1\53\1\45\1\36\1\33\1\54"+
    "\1\52\1\56\1\44\1\27\1\51\1\37\1\35\1\34\1\31\1\32"+
    "\1\76\1\46\1\41\1\42\1\26\1\47\1\60\1\61\1\55\1\57"+
    "\1\72\1\102\1\73\1\107\41\30\2\0\4\27\4\0\1\27\2\0"+
    "\1\30\7\0\1\27\4\0\1\27\5\0\27\27\1\0\37\27\1\0"+
    "\u01ca\27\4\0\14\27\16\0\5\27\7\0\1\27\1\0\1\27\21\0"+
    "\160\30\5\27\1\0\2\27\2\0\4\27\10\0\1\27\1\0\3\27"+
    "\1\0\1\27\1\0\24\27\1\0\123\27\1\0\213\27\1\0\5\30"+
    "\2\0\236\27\11\0\46\27\2\0\1\27\7\0\47\27\7\0\1\27"+
    "\1\0\55\30\1\0\1\30\1\0\2\30\1\0\2\30\1\0\1\30"+
    "\10\0\33\27\5\0\3\27\15\0\5\30\6\0\1\27\4\0\13\30"+
    "\5\0\53\27\37\30\4\0\2\27\1\30\143\27\1\0\1\27\10\30"+
    "\1\0\6\30\2\27\2\30\1\0\4\30\2\27\12\30\3\27\2\0"+
    "\1\27\17\0\1\30\1\27\1\30\36\27\33\30\2\0\131\27\13\30"+
    "\1\27\16\0\12\30\41\27\11\30\2\27\4\0\1\27\5\0\26\27"+
    "\4\30\1\27\11\30\1\27\3\30\1\27\5\30\22\0\31\27\3\30"+
    "\104\0\1\27\1\0\13\27\67\0\33\30\1\0\4\30\66\27\3\30"+
    "\1\27\22\30\1\27\7\30\12\27\2\30\2\0\12\30\1\0\7\27"+
    "\1\0\7\27\1\0\3\30\1\0\10\27\2\0\2\27\2\0\26\27"+
    "\1\0\7\27\1\0\1\27\3\0\4\27\2\0\1\30\1\27\7\30"+
    "\2\0\2\30\2\0\3\30\1\27\10\0\1\30\4\0\2\27\1\0"+
    "\3\27\2\30\2\0\12\30\4\27\7\0\1\27\5\0\3\30\1\0"+
    "\6\27\4\0\2\27\2\0\26\27\1\0\7\27\1\0\2\27\1\0"+
    "\2\27\1\0\2\27\2\0\1\30\1\0\5\30\4\0\2\30\2\0"+
    "\3\30\3\0\1\30\7\0\4\27\1\0\1\27\7\0\14\30\3\27"+
    "\1\30\13\0\3\30\1\0\11\27\1\0\3\27\1\0\26\27\1\0"+
    "\7\27\1\0\2\27\1\0\5\27\2\0\1\30\1\27\10\30\1\0"+
    "\3\30\1\0\3\30\2\0\1\27\17\0\2\27\2\30\2\0\12\30"+
    "\1\0\1\27\17\0\3\30\1\0\10\27\2\0\2\27\2\0\26\27"+
    "\1\0\7\27\1\0\2\27\1\0\5\27\2\0\1\30\1\27\7\30"+
    "\2\0\2\30\2\0\3\30\10\0\2\30\4\0\2\27\1\0\3\27"+
    "\2\30\2\0\12\30\1\0\1\27\20\0\1\30\1\27\1\0\6\27"+
    "\3\0\3\27\1\0\4\27\3\0\2\27\1\0\1\27\1\0\2\27"+
    "\3\0\2\27\3\0\3\27\3\0\14\27\4\0\5\30\3\0\3\30"+
    "\1\0\4\30\2\0\1\27\6\0\1\30\16\0\12\30\11\0\1\27"+
    "\7\0\3\30\1\0\10\27\1\0\3\27\1\0\27\27\1\0\12\27"+
    "\1\0\5\27\3\0\1\27\7\30\1\0\3\30\1\0\4\30\7\0"+
    "\2\30\1\0\2\27\6\0\2\27\2\30\2\0\12\30\22\0\2\30"+
    "\1\0\10\27\1\0\3\27\1\0\27\27\1\0\12\27\1\0\5\27"+
    "\2\0\1\30\1\27\7\30\1\0\3\30\1\0\4\30\7\0\2\30"+
    "\7\0\1\27\1\0\2\27\2\30\2\0\12\30\1\0\2\27\17\0"+
    "\2\30\1\0\10\27\1\0\3\27\1\0\51\27\2\0\1\27\7\30"+
    "\1\0\3\30\1\0\4\30\1\27\10\0\1\30\10\0\2\27\2\30"+
    "\2\0\12\30\12\0\6\27\2\0\2\30\1\0\22\27\3\0\30\27"+
    "\1\0\11\27\1\0\1\27\2\0\7\27\3\0\1\30\4\0\6\30"+
    "\1\0\1\30\1\0\10\30\22\0\2\30\15\0\60\27\1\30\2\27"+
    "\7\30\4\0\10\27\10\30\1\0\12\30\47\0\2\27\1\0\1\27"+
    "\2\0\2\27\1\0\1\27\2\0\1\27\6\0\4\27\1\0\7\27"+
    "\1\0\3\27\1\0\1\27\1\0\1\27\2\0\2\27\1\0\4\27"+
    "\1\30\2\27\6\30\1\0\2\30\1\27\2\0\5\27\1\0\1\27"+
    "\1\0\6\30\2\0\12\30\2\0\4\27\40\0\1\27\27\0\2\30"+
    "\6\0\12\30\13\0\1\30\1\0\1\30\1\0\1\30\4\0\2\30"+
    "\10\27\1\0\44\27\4\0\24\30\1\0\2\30\5\27\13\30\1\0"+
    "\44\30\11\0\1\30\71\0\53\27\24\30\1\27\12\30\6\0\6\27"+
    "\4\30\4\27\3\30\1\27\3\30\2\27\7\30\3\27\4\30\15\27"+
    "\14\30\1\27\17\30\2\0\46\27\1\0\1\27\5\0\1\27\2\0"+
    "\53\27\1\0\u014d\27\1\0\4\27\2\0\7\27\1\0\1\27\1\0"+
    "\4\27\2\0\51\27\1\0\4\27\2\0\41\27\1\0\4\27\2\0"+
    "\7\27\1\0\1\27\1\0\4\27\2\0\17\27\1\0\71\27\1\0"+
    "\4\27\2\0\103\27\2\0\3\30\40\0\20\27\20\0\125\27\14\0"+
    "\u026c\27\2\0\21\27\1\0\32\27\5\0\113\27\3\0\3\27\17\0"+
    "\15\27\1\0\4\27\3\30\13\0\22\27\3\30\13\0\22\27\2\30"+
    "\14\0\15\27\1\0\3\27\1\0\2\30\14\0\64\27\40\30\3\0"+
    "\1\27\3\0\2\27\1\30\2\0\12\30\41\0\3\30\2\0\12\30"+
    "\6\0\130\27\10\0\51\27\1\30\1\27\5\0\106\27\12\0\35\27"+
    "\3\0\14\30\4\0\14\30\12\0\12\30\36\27\2\0\5\27\13\0"+
    "\54\27\4\0\21\30\7\27\2\30\6\0\12\30\46\0\27\27\5\30"+
    "\4\0\65\27\12\30\1\0\35\30\2\0\13\30\6\0\12\30\15\0"+
    "\1\27\130\0\5\30\57\27\21\30\7\27\4\0\12\30\21\0\11\30"+
    "\14\0\3\30\36\27\15\30\2\27\12\30\54\27\16\30\14\0\44\27"+
    "\24\30\10\0\12\30\3\0\3\27\12\30\44\27\122\0\3\30\1\0"+
    "\25\30\4\27\1\30\4\27\3\30\2\27\11\0\300\27\47\30\25\0"+
    "\4\30\u0116\27\2\0\6\27\2\0\46\27\2\0\6\27\2\0\10\27"+
    "\1\0\1\27\1\0\1\27\1\0\1\27\1\0\37\27\2\0\65\27"+
    "\1\0\7\27\1\0\1\27\3\0\3\27\1\0\7\27\3\0\4\27"+
    "\2\0\6\27\4\0\15\27\5\0\3\27\1\0\7\27\16\0\5\30"+
    "\32\0\5\30\20\0\2\27\23\0\1\27\13\0\5\30\5\0\6\30"+
    "\1\0\1\27\15\0\1\27\20\0\15\27\3\0\33\27\25\0\15\30"+
    "\4\0\1\30\3\0\14\30\21\0\1\27\4\0\1\27\2\0\12\27"+
    "\1\0\1\27\3\0\5\27\6\0\1\27\1\0\1\27\1\0\1\27"+
    "\1\0\4\27\1\0\13\27\2\0\4\27\5\0\5\27\4\0\1\27"+
    "\21\0\51\27\u0a77\0\57\27\1\0\57\27\1\0\205\27\6\0\4\27"+
    "\3\30\2\27\14\0\46\27\1\0\1\27\5\0\1\27\2\0\70\27"+
    "\7\0\1\27\17\0\1\30\27\27\11\0\7\27\1\0\7\27\1\0"+
    "\7\27\1\0\7\27\1\0\7\27\1\0\7\27\1\0\7\27\1\0"+
    "\7\27\1\0\40\30\57\0\1\27\u01d5\0\3\27\31\0\11\27\6\30"+
    "\1\0\5\27\2\0\5\27\4\0\126\27\2\0\2\30\2\0\3\27"+
    "\1\0\132\27\1\0\4\27\5\0\51\27\3\0\136\27\21\0\33\27"+
    "\65\0\20\27\u0200\0\u19b6\27\112\0\u51cd\27\63\0\u048d\27\103\0\56\27"+
    "\2\0\u010d\27\3\0\20\27\12\30\2\27\24\0\57\27\1\30\4\0"+
    "\12\30\1\0\31\27\7\0\1\30\120\27\2\30\45\0\11\27\2\0"+
    "\147\27\2\0\4\27\1\0\4\27\14\0\13\27\115\0\12\27\1\30"+
    "\3\27\1\30\4\27\1\30\27\27\5\30\20\0\1\27\7\0\64\27"+
    "\14\0\2\30\62\27\21\30\13\0\12\30\6\0\22\30\6\27\3\0"+
    "\1\27\4\0\12\30\34\27\10\30\2\0\27\27\15\30\14\0\35\27"+
    "\3\0\4\30\57\27\16\30\16\0\1\27\12\30\46\0\51\27\16\30"+
    "\11\0\3\27\1\30\10\27\2\30\2\0\12\30\6\0\27\27\3\0"+
    "\1\27\1\30\4\0\60\27\1\30\1\27\3\30\2\27\2\30\5\27"+
    "\2\30\1\27\1\30\1\27\30\0\3\27\2\0\13\27\5\30\2\0"+
    "\3\27\2\30\12\0\6\27\2\0\6\27\2\0\6\27\11\0\7\27"+
    "\1\0\7\27\221\0\43\27\10\30\1\0\2\30\2\0\12\30\6\0"+
    "\u2ba4\27\14\0\27\27\4\0\61\27\u2104\0\u016e\27\2\0\152\27\46\0"+
    "\7\27\14\0\5\27\5\0\1\27\1\30\12\27\1\0\15\27\1\0"+
    "\5\27\1\0\1\27\1\0\2\27\1\0\2\27\1\0\154\27\41\0"+
    "\u016b\27\22\0\100\27\2\0\66\27\50\0\15\27\3\0\20\30\20\0"+
    "\7\30\14\0\2\27\30\0\3\27\31\0\1\27\6\0\5\27\1\0"+
    "\207\27\2\0\1\30\4\0\1\27\13\0\12\30\7\0\32\27\4\0"+
    "\1\27\1\0\32\27\13\0\131\27\3\0\6\27\2\0\6\27\2\0"+
    "\6\27\2\0\3\27\3\0\2\27\3\0\2\27\22\0\3\30\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\32\0\2\1\1\2\1\1\1\3\1\4\1\1\5\3"+
    "\1\5\6\3\1\6\1\3\1\7\1\10\1\11\1\12"+
    "\1\13\1\14\1\15\1\16\1\17\1\20\1\21\1\22"+
    "\1\23\1\24\3\25\1\26\1\27\1\1\1\30\1\31"+
    "\2\25\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\42\1\43\1\1\1\44\1\1\1\45\2\46"+
    "\1\1\1\47\1\50\2\51\1\52\1\4\11\3\1\53"+
    "\1\54\1\55\1\12\1\13\1\14\1\56\1\57\1\60"+
    "\1\61\1\62\1\63\1\64\1\65\1\66\1\67\1\70"+
    "\1\71\1\72\1\73\1\1\1\74\1\1\1\75\1\76"+
    "\1\77\1\100\1\1\12\100\2\3\1\101\1\102\4\3"+
    "\1\103\2\3\1\104\1\3\1\105\1\106\2\107\1\1"+
    "\1\110\1\4\5\1\3\0\1\111\1\112\3\0\24\3"+
    "\2\0\1\111\1\0\1\113\1\0\1\114\1\115\1\116"+
    "\1\117\1\120\1\121\1\51\1\122\3\0\1\51\2\0"+
    "\1\122\1\0\1\123\1\124\1\122\12\3\1\125\1\126"+
    "\1\127\1\130\1\131\1\132\1\133\1\134\1\135\1\136"+
    "\1\137\1\140\1\141\1\142\1\143\1\144\1\145\1\146"+
    "\1\0\1\147\1\0\1\150\1\0\22\100\6\3\1\151"+
    "\2\3\2\0\1\152\1\0\1\153\3\0\1\154\1\0"+
    "\1\155\5\0\1\156\1\0\7\3\1\157\16\3\2\0"+
    "\1\160\1\0\1\51\1\0\1\51\2\122\2\0\4\3"+
    "\1\161\5\3\1\162\1\163\1\164\1\0\6\100\1\157"+
    "\15\100\10\3\7\0\1\165\1\0\1\166\4\3\1\167"+
    "\20\3\1\0\1\165\6\0\1\3\1\170\1\3\1\171"+
    "\1\3\1\172\1\173\1\3\1\174\1\0\4\100\1\167"+
    "\17\100\2\3\1\175\4\3\1\176\5\0\1\177\1\0"+
    "\7\3\1\200\11\3\1\201\1\3\1\202\1\0\1\122"+
    "\2\0\1\3\1\203\1\204\1\205\1\0\6\100\1\200"+
    "\11\100\1\201\1\100\1\202\2\3\1\206\3\3\5\0"+
    "\1\207\4\3\1\210\1\211\1\212\3\3\1\213\2\3"+
    "\1\214\2\3\1\0\1\215\1\207\4\100\1\210\1\212"+
    "\3\100\1\213\2\100\1\214\2\100\5\3\1\216\1\0"+
    "\1\217\1\3\1\220\1\221\7\3\1\0\1\217\1\100"+
    "\1\220\1\221\7\100\1\222\1\223\1\3\1\224\1\3"+
    "\1\0\1\3\1\225\2\3\1\226\2\3\1\227\1\0"+
    "\1\100\1\225\2\100\1\226\2\100\1\227\1\230\1\231"+
    "\1\0\1\232\1\3\1\233\1\234\1\3\1\0\1\232"+
    "\1\100\1\233\1\234\1\100\1\0\1\3\1\235\1\236"+
    "\1\100\1\235\1\237\1\3\1\100\2\240";

  private static int [] zzUnpackAction() {
    int [] result = new int[628];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\110\0\220\0\330\0\u0120\0\u0168\0\u01b0\0\u01f8"+
    "\0\u0240\0\u0288\0\u02d0\0\u0318\0\u0360\0\u03a8\0\u03f0\0\u0438"+
    "\0\u0480\0\u04c8\0\u0510\0\u0558\0\u05a0\0\u05e8\0\u0630\0\u0678"+
    "\0\u06c0\0\u0708\0\u0750\0\u0798\0\u0750\0\u07e0\0\u0828\0\u0870"+
    "\0\u08b8\0\u0900\0\u0948\0\u0990\0\u09d8\0\u0a20\0\u0750\0\u0a68"+
    "\0\u0ab0\0\u0af8\0\u0b40\0\u0b88\0\u0bd0\0\u0750\0\u0c18\0\u0750"+
    "\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u0c60\0\u0750"+
    "\0\u0750\0\u0ca8\0\u0750\0\u0750\0\u0750\0\u0750\0\u0cf0\0\u0d38"+
    "\0\u0750\0\u0750\0\u0d38\0\u0750\0\u0750\0\u0d80\0\u0dc8\0\u0750"+
    "\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750"+
    "\0\u0750\0\u0e10\0\u0750\0\u0e58\0\u0750\0\u0ea0\0\u0750\0\u0ee8"+
    "\0\u0f30\0\u0f78\0\u0fc0\0\u1008\0\u1050\0\u1098\0\u10e0\0\u1128"+
    "\0\u1170\0\u11b8\0\u1200\0\u1248\0\u1290\0\u12d8\0\u1320\0\u0750"+
    "\0\u0750\0\u0750\0\u1368\0\u13b0\0\u13f8\0\u0750\0\u0750\0\u0750"+
    "\0\u1440\0\u0750\0\u1488\0\u14d0\0\u1518\0\u1560\0\u0750\0\u0750"+
    "\0\u15a8\0\u15f0\0\u0750\0\u1638\0\u0750\0\u1680\0\u0750\0\u0750"+
    "\0\u0750\0\u16c8\0\u1710\0\u1758\0\u17a0\0\u17e8\0\u1830\0\u1878"+
    "\0\u18c0\0\u1908\0\u1950\0\u1998\0\u19e0\0\u1a28\0\u1a70\0\u0750"+
    "\0\u0750\0\u1ab8\0\u1b00\0\u1b48\0\u1b90\0\u0750\0\u1bd8\0\u1c20"+
    "\0\u0750\0\u1c68\0\u0750\0\u0750\0\u1cb0\0\u0750\0\u1cf8\0\u1d40"+
    "\0\u0750\0\u1d88\0\u1dd0\0\u1e18\0\u1e60\0\u1ea8\0\u1ef0\0\u1f38"+
    "\0\u1f80\0\u1fc8\0\u0750\0\u08b8\0\u2010\0\u2058\0\u20a0\0\u20e8"+
    "\0\u2130\0\u2178\0\u21c0\0\u2208\0\u2250\0\u2298\0\u22e0\0\u2328"+
    "\0\u2370\0\u23b8\0\u2400\0\u2448\0\u2490\0\u24d8\0\u2520\0\u2568"+
    "\0\u25b0\0\u25f8\0\u0c60\0\u2640\0\u2688\0\u0d80\0\u0750\0\u26d0"+
    "\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u2718\0\u2760"+
    "\0\u27a8\0\u27f0\0\u2838\0\u0750\0\u2880\0\u1098\0\u0750\0\u28c8"+
    "\0\u0750\0\u0750\0\u2910\0\u2958\0\u29a0\0\u29e8\0\u2a30\0\u2a78"+
    "\0\u2ac0\0\u2b08\0\u2b50\0\u2b98\0\u2be0\0\u2c28\0\u0750\0\u2c70"+
    "\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750"+
    "\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u0750\0\u2cb8"+
    "\0\u0750\0\u1710\0\u0750\0\u2d00\0\u2d48\0\u2d90\0\u2dd8\0\u2e20"+
    "\0\u2e68\0\u2eb0\0\u2ef8\0\u2f40\0\u2f88\0\u2fd0\0\u3018\0\u3060"+
    "\0\u30a8\0\u30f0\0\u3138\0\u3180\0\u31c8\0\u3210\0\u3258\0\u32a0"+
    "\0\u32e8\0\u3330\0\u3378\0\u33c0\0\u0828\0\u3408\0\u3450\0\u3498"+
    "\0\u34e0\0\u0750\0\u1d88\0\u0750\0\u3528\0\u3570\0\u1dd0\0\u0750"+
    "\0\u1e18\0\u0750\0\u35b8\0\u3600\0\u3648\0\u3690\0\u36d8\0\u0750"+
    "\0\u3720\0\u3768\0\u37b0\0\u37f8\0\u3840\0\u3888\0\u38d0\0\u3918"+
    "\0\u0828\0\u3960\0\u39a8\0\u39f0\0\u3a38\0\u3a80\0\u3ac8\0\u3b10"+
    "\0\u3b58\0\u3ba0\0\u3be8\0\u3c30\0\u3c78\0\u3cc0\0\u3d08\0\u3d50"+
    "\0\u3d98\0\u0750\0\u3de0\0\u3e28\0\u3e70\0\u3eb8\0\u3f00\0\u3f48"+
    "\0\u3f90\0\u3fd8\0\u4020\0\u4068\0\u40b0\0\u40f8\0\u0828\0\u4140"+
    "\0\u4188\0\u41d0\0\u4218\0\u4260\0\u0750\0\u42a8\0\u0750\0\u42f0"+
    "\0\u4338\0\u4380\0\u43c8\0\u4410\0\u4458\0\u44a0\0\u16c8\0\u44e8"+
    "\0\u4530\0\u4578\0\u45c0\0\u4608\0\u4650\0\u4698\0\u46e0\0\u4728"+
    "\0\u4770\0\u47b8\0\u4800\0\u4848\0\u4890\0\u48d8\0\u4920\0\u4968"+
    "\0\u49b0\0\u49f8\0\u4a40\0\u4a88\0\u4ad0\0\u4b18\0\u4b60\0\u4ba8"+
    "\0\u4bf0\0\u4c38\0\u4c80\0\u4ad0\0\u4cc8\0\u0828\0\u4d10\0\u4d58"+
    "\0\u4da0\0\u4de8\0\u0828\0\u4e30\0\u4e78\0\u4ec0\0\u4f08\0\u4f50"+
    "\0\u4f98\0\u4fe0\0\u5028\0\u5070\0\u50b8\0\u5100\0\u5148\0\u5190"+
    "\0\u51d8\0\u5220\0\u5268\0\u52b0\0\u0750\0\u52f8\0\u5340\0\u5388"+
    "\0\u53d0\0\u5418\0\u5460\0\u54a8\0\u0828\0\u54f0\0\u0828\0\u5538"+
    "\0\u0828\0\u0828\0\u5580\0\u0750\0\u55c8\0\u5610\0\u5658\0\u56a0"+
    "\0\u56e8\0\u16c8\0\u5730\0\u5778\0\u57c0\0\u5808\0\u5850\0\u5898"+
    "\0\u58e0\0\u5928\0\u5970\0\u59b8\0\u5a00\0\u5a48\0\u5a90\0\u5ad8"+
    "\0\u5b20\0\u5b68\0\u5bb0\0\u0828\0\u5bf8\0\u5c40\0\u5c88\0\u5cd0"+
    "\0\u0828\0\u5d18\0\u5d60\0\u5da8\0\u5df0\0\u5e38\0\u0750\0\u5e80"+
    "\0\u5ec8\0\u5f10\0\u5f58\0\u5fa0\0\u5fe8\0\u6030\0\u6078\0\u0828"+
    "\0\u60c0\0\u6108\0\u6150\0\u6198\0\u61e0\0\u6228\0\u6270\0\u62b8"+
    "\0\u6300\0\u0828\0\u6348\0\u0828\0\u6390\0\u63d8\0\u6420\0\u6468"+
    "\0\u64b0\0\u0828\0\u0828\0\u0828\0\u64f8\0\u6540\0\u6588\0\u65d0"+
    "\0\u6618\0\u6660\0\u66a8\0\u16c8\0\u66f0\0\u6738\0\u6780\0\u67c8"+
    "\0\u6810\0\u6858\0\u68a0\0\u68e8\0\u6930\0\u16c8\0\u6978\0\u16c8"+
    "\0\u69c0\0\u6a08\0\u0828\0\u6a50\0\u6a98\0\u6ae0\0\u6b28\0\u6b70"+
    "\0\u6bb8\0\u6c00\0\u6c48\0\u0828\0\u6c90\0\u6cd8\0\u6d20\0\u6d68"+
    "\0\u0828\0\u0828\0\u0828\0\u6db0\0\u6df8\0\u6e40\0\u0828\0\u6e88"+
    "\0\u6ed0\0\u0828\0\u6f18\0\u6f60\0\u6fa8\0\u0828\0\u16c8\0\u6ff0"+
    "\0\u7038\0\u7080\0\u70c8\0\u16c8\0\u16c8\0\u7110\0\u7158\0\u71a0"+
    "\0\u16c8\0\u71e8\0\u7230\0\u16c8\0\u7278\0\u72c0\0\u7308\0\u7350"+
    "\0\u7398\0\u73e0\0\u7428\0\u1dd0\0\u7470\0\u0828\0\u74b8\0\u0828"+
    "\0\u0828\0\u7500\0\u7548\0\u7590\0\u75d8\0\u7620\0\u7668\0\u76b0"+
    "\0\u76f8\0\u16c8\0\u7740\0\u16c8\0\u16c8\0\u7788\0\u77d0\0\u7818"+
    "\0\u7860\0\u78a8\0\u78f0\0\u7938\0\u0828\0\u0828\0\u7980\0\u0828"+
    "\0\u79c8\0\u7a10\0\u7a58\0\u0828\0\u7aa0\0\u7ae8\0\u0828\0\u7b30"+
    "\0\u7b78\0\u0828\0\u7bc0\0\u7c08\0\u16c8\0\u7c50\0\u7c98\0\u16c8"+
    "\0\u7ce0\0\u7d28\0\u16c8\0\u0828\0\u0828\0\u7d70\0\u0828\0\u7db8"+
    "\0\u0828\0\u0828\0\u7e00\0\u7e48\0\u16c8\0\u7e90\0\u16c8\0\u16c8"+
    "\0\u7ed8\0\u7f20\0\u7f68\0\u0828\0\u0750\0\u7fb0\0\u16c8\0\u1dd0"+
    "\0\u7ff8\0\u8040\0\u0828\0\u16c8";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[628];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\33\1\34\2\33\1\35\1\33\1\36\2\33\3\37"+
    "\1\33\1\37\1\33\2\37\1\33\1\40\2\37\1\41"+
    "\2\37\1\33\1\42\1\43\1\44\1\45\1\46\2\37"+
    "\1\47\1\50\1\51\1\52\1\53\1\54\1\37\1\55"+
    "\1\56\3\37\1\57\5\37\1\60\1\61\1\62\1\63"+
    "\1\64\1\65\1\66\1\67\1\70\1\71\1\72\1\73"+
    "\1\37\4\33\1\74\1\75\4\33\1\34\106\33\1\76"+
    "\1\77\4\76\1\100\63\76\1\101\1\102\7\76\1\74"+
    "\1\75\3\76\1\33\1\34\4\33\1\103\55\33\1\104"+
    "\10\33\1\105\5\33\1\74\1\75\3\33\1\76\1\77"+
    "\4\76\1\100\13\76\1\106\11\76\1\107\3\76\1\110"+
    "\7\76\1\111\11\76\1\112\1\113\1\114\1\115\1\116"+
    "\3\76\1\117\1\120\1\76\1\121\5\76\1\74\1\75"+
    "\3\76\1\33\1\34\23\33\1\122\55\33\1\123\5\33"+
    "\1\34\23\33\1\124\56\33\1\125\4\33\1\126\1\127"+
    "\106\33\1\34\2\33\1\130\104\33\1\34\2\33\1\131"+
    "\1\33\1\132\1\133\1\134\3\37\1\134\1\37\1\134"+
    "\2\37\1\135\1\136\2\37\1\41\2\37\1\33\3\37"+
    "\1\137\1\37\1\140\1\141\1\33\1\142\1\143\1\37"+
    "\1\144\1\145\2\37\1\56\2\37\1\146\1\147\5\37"+
    "\1\150\1\151\1\152\1\153\1\154\1\155\1\66\1\156"+
    "\1\157\1\160\1\161\1\162\1\37\1\163\1\164\1\165"+
    "\1\166\1\167\1\170\1\171\1\172\1\173\1\33\1\34"+
    "\23\33\1\174\55\33\1\175\5\33\1\34\23\33\1\176"+
    "\56\33\1\177\4\33\1\34\2\33\1\131\1\33\1\132"+
    "\1\133\1\134\3\37\1\134\1\37\1\134\2\37\1\135"+
    "\1\136\2\37\1\41\2\37\1\33\3\37\1\137\1\37"+
    "\1\140\1\141\1\33\1\142\1\143\1\37\1\144\1\145"+
    "\2\37\1\56\2\37\1\146\1\147\5\37\1\150\1\151"+
    "\1\152\1\153\1\154\1\155\1\66\1\156\1\200\1\201"+
    "\1\161\1\162\1\37\1\163\1\164\1\165\1\166\1\167"+
    "\1\170\1\171\1\172\1\173\1\33\1\34\2\33\1\35"+
    "\1\33\1\36\2\33\3\202\1\33\1\202\1\33\2\202"+
    "\1\33\1\40\2\202\1\203\2\202\1\33\1\202\1\204"+
    "\1\205\1\206\3\202\1\33\1\207\1\210\1\211\1\212"+
    "\1\213\1\202\1\214\1\56\3\202\1\215\5\202\1\60"+
    "\1\61\1\62\1\63\1\64\1\65\1\66\1\67\1\70"+
    "\1\71\1\72\1\33\1\202\12\33\1\34\2\33\1\35"+
    "\1\33\1\36\2\33\3\37\1\33\1\37\1\33\2\37"+
    "\1\33\1\40\2\37\1\41\2\37\1\33\1\37\1\43"+
    "\1\44\1\45\1\37\1\216\1\37\1\47\1\50\1\51"+
    "\1\52\1\53\1\54\1\37\1\55\1\56\3\37\1\57"+
    "\5\37\1\60\1\61\1\62\1\63\1\64\1\65\1\66"+
    "\1\67\1\70\1\71\1\72\1\73\1\37\4\33\1\74"+
    "\1\75\4\33\1\34\2\33\1\35\1\33\1\36\2\33"+
    "\3\37\1\33\1\37\1\33\2\37\1\33\1\40\2\37"+
    "\1\41\2\37\1\33\1\37\1\43\1\44\1\45\1\37"+
    "\1\217\1\37\1\220\1\50\1\51\1\52\1\53\1\54"+
    "\1\37\1\55\1\56\3\37\1\57\5\37\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\1\66\1\67\1\70\1\71"+
    "\1\72\1\221\1\37\4\33\1\74\1\75\4\33\1\34"+
    "\4\33\1\103\2\33\3\37\1\33\1\37\1\33\2\37"+
    "\2\33\2\37\1\41\1\222\1\37\1\33\1\223\1\224"+
    "\1\225\4\37\1\226\1\37\1\227\3\37\1\230\1\37"+
    "\1\231\7\37\1\232\1\37\10\33\1\233\1\234\2\33"+
    "\1\37\12\33\1\34\2\33\1\35\1\33\1\36\2\33"+
    "\3\37\1\33\1\37\1\33\2\37\1\33\1\40\2\37"+
    "\1\41\2\37\1\33\1\37\1\43\1\44\1\45\1\37"+
    "\1\217\1\37\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\37\1\55\1\56\3\37\1\57\5\37\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\1\66\1\67\1\70\1\71"+
    "\1\72\1\73\1\37\4\33\1\74\1\75\4\33\1\235"+
    "\2\236\1\35\1\236\1\237\2\33\3\37\1\33\1\37"+
    "\1\33\2\37\1\33\1\40\2\37\1\41\2\37\1\33"+
    "\1\37\1\43\1\44\1\45\3\37\1\33\1\50\1\51"+
    "\1\52\1\53\1\54\1\37\1\55\1\56\3\37\1\57"+
    "\5\37\1\60\1\61\1\62\1\63\1\64\1\65\1\66"+
    "\1\67\1\70\1\71\1\72\1\33\1\37\12\33\1\34"+
    "\4\33\1\103\2\33\3\240\1\33\1\240\1\33\2\240"+
    "\1\33\1\241\2\240\1\242\2\240\1\33\7\240\1\33"+
    "\7\240\1\33\11\240\14\33\1\240\12\33\1\34\7\33"+
    "\3\243\1\33\1\243\1\33\2\243\2\33\2\243\1\244"+
    "\2\243\1\33\7\243\1\33\1\245\1\246\5\243\1\33"+
    "\11\243\14\33\1\243\11\33\11\0\3\247\1\0\1\247"+
    "\1\0\2\247\2\0\2\247\1\250\2\247\1\0\7\247"+
    "\1\0\7\247\1\0\11\247\14\0\1\247\33\0\1\251"+
    "\125\0\1\251\144\0\1\251\52\0\1\251\31\0\1\251"+
    "\2\0\1\251\124\0\1\33\111\0\1\252\1\0\1\253"+
    "\110\0\12\37\2\0\2\37\1\254\12\37\1\0\7\37"+
    "\1\0\11\37\14\0\1\37\33\0\1\255\113\0\1\256"+
    "\70\0\12\37\2\0\2\37\1\254\4\37\1\257\5\37"+
    "\1\0\7\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\1\260\11\37\1\0\2\37\1\261"+
    "\2\37\1\262\1\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\6\37\1\263\3\37\1\0"+
    "\7\37\1\0\10\37\1\264\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\5\37\1\265\4\37\1\0\2\37"+
    "\1\266\4\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\3\37\1\267\6\37\1\0\7\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\1\270\11\37\1\0\1\37\1\271\5\37\1\0"+
    "\4\37\1\272\4\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\5\37\1\273\1\37\1\0"+
    "\5\37\1\274\3\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\7\37\1\0\2\37\1\275"+
    "\6\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\6\37\1\276\1\277\2\37\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\11\37"+
    "\1\300\1\0\7\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\3\37\1\301\6\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\3\37\1\302\3\37\1\0"+
    "\11\37\14\0\1\37\12\0\3\303\1\0\1\303\36\0"+
    "\1\304\44\0\3\72\1\0\1\72\104\0\1\76\111\0"+
    "\1\305\1\0\1\253\102\0\2\306\2\0\1\306\57\0"+
    "\1\307\55\0\1\310\101\0\1\311\55\0\1\312\31\0"+
    "\1\311\56\0\1\313\5\0\1\127\113\0\1\314\175\0"+
    "\1\315\17\0\1\305\1\0\1\253\65\0\1\316\22\0"+
    "\1\317\1\320\1\321\1\0\1\322\1\317\1\323\1\317"+
    "\1\324\1\325\1\0\1\326\1\327\7\0\1\325\2\0"+
    "\1\327\1\324\13\0\1\323\1\327\4\0\1\322\35\0"+
    "\2\134\1\330\2\0\1\134\1\0\1\134\1\324\1\325"+
    "\1\0\1\326\1\327\7\0\1\325\2\0\1\327\1\324"+
    "\14\0\1\327\54\0\1\331\52\0\1\332\22\0\2\333"+
    "\3\0\1\333\1\0\1\333\100\0\12\37\2\0\2\37"+
    "\1\254\5\37\1\265\4\37\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\3\37"+
    "\1\334\6\37\1\0\7\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\3\37\1\335\6\37"+
    "\1\0\7\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\12\37\1\0\7\37\1\0\5\37"+
    "\1\336\3\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\12\37\1\0\5\37\1\337\1\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\6\37"+
    "\1\340\3\37\1\0\7\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\11\37\1\341\1\0"+
    "\7\37\1\0\5\37\1\342\3\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\7\37\1\0"+
    "\4\37\1\343\4\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\11\37\1\344\1\0\2\37\1\345\4\37"+
    "\1\0\11\37\14\0\1\37\76\0\1\346\6\0\1\347"+
    "\101\0\1\350\5\0\1\351\102\0\1\352\4\0\1\353"+
    "\107\0\1\354\107\0\1\355\107\0\1\356\3\0\1\357"+
    "\103\0\1\360\107\0\1\361\5\0\1\362\112\0\1\363"+
    "\76\0\1\364\40\0\1\365\55\0\1\366\31\0\1\365"+
    "\56\0\1\367\4\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\12\202\1\373\7\202\1\0"+
    "\11\202\10\0\1\373\2\0\1\373\1\202\37\0\1\374"+
    "\62\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\1\375\11\202\1\373\2\202\1\376\2\202"+
    "\1\377\1\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\6\202\1\u0100\3\202\1\373\7\202"+
    "\1\0\10\202\1\u0101\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\5\202\1\u0102\4\202\1\373\2\202\1\u0103"+
    "\4\202\1\0\11\202\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\1\u0104\11\202\1\373\1\202\1\u0105\5\202"+
    "\1\0\4\202\1\u0106\4\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\12\202\1\373\5\202\1\u0107\1\202"+
    "\1\0\5\202\1\u0108\3\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\12\202\1\373\7\202\1\0\2\202"+
    "\1\u0109\6\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\6\202\1\u010a\1\u010b\2\202\1\373\7\202\1\0"+
    "\11\202\10\0\1\373\2\0\1\373\1\202\12\0\3\370"+
    "\1\0\1\370\1\0\12\202\1\0\1\371\2\202\1\372"+
    "\11\202\1\u010c\1\373\7\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\3\202\1\u010d\6\202"+
    "\1\373\7\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\12\202\1\373\3\202\1\u010e\3\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\20\0"+
    "\12\37\2\0\2\37\1\254\5\37\1\u010f\4\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\5\37\1\u0110\4\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\1\u0111\6\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\4\37\1\u0112\5\37"+
    "\1\0\7\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\12\37\1\0\5\37\1\u0113\1\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\12\37\1\0\7\37\1\0\10\37\1\u0114\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\3\37\1\u0115"+
    "\6\37\1\0\7\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\5\37\1\u0116\4\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\3\37\1\u0117\3\37\1\0"+
    "\11\37\14\0\1\37\13\0\1\236\111\0\1\u0118\104\0"+
    "\3\u0119\1\0\1\u0119\1\0\12\240\1\0\1\u011a\2\240"+
    "\1\u011b\12\240\1\0\7\240\1\0\11\240\13\0\1\u011c"+
    "\1\240\37\0\1\u011d\62\0\3\u011e\1\0\1\u011e\1\0"+
    "\12\u011f\1\0\1\u0120\2\u011f\1\u0121\12\u011f\1\u0122\7\u011f"+
    "\1\0\11\u011f\14\0\1\u011f\37\0\1\u0123\62\0\3\u011e"+
    "\1\0\1\u011e\1\0\12\u011f\1\0\1\u0120\2\u011f\1\u0121"+
    "\12\u011f\1\u0122\1\u011f\1\u0124\5\u011f\1\0\11\u011f\14\0"+
    "\1\u011f\12\0\3\u011e\1\0\1\u011e\1\0\12\u011f\1\0"+
    "\1\u0120\2\u011f\1\u0121\12\u011f\1\u0122\5\u011f\1\u0125\1\u011f"+
    "\1\0\11\u011f\14\0\1\u011f\20\0\12\247\2\0\2\247"+
    "\1\250\12\247\1\0\7\247\1\0\11\247\14\0\1\247"+
    "\37\0\1\u0126\62\0\3\251\1\0\1\251\106\0\1\u0127"+
    "\125\0\1\u0128\74\0\2\u0129\1\0\1\u0129\1\0\3\u0129"+
    "\1\0\1\u0129\2\0\1\u0129\7\0\1\u0129\2\0\1\u0129"+
    "\4\0\1\u0129\1\0\1\u0129\5\0\2\u0129\42\0\12\37"+
    "\2\0\2\37\1\254\5\37\1\u012a\4\37\1\0\7\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\12\37\1\0\7\37\1\0\2\37\1\u012b\6\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\4\37\1\u012c\2\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\3\37\1\u012d\6\37"+
    "\1\0\3\37\1\u012e\3\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\1\u012f\11\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\1\37\1\u0130\5\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\7\37\1\0\7\37\1\u0131\1\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\1\37\1\u0132\5\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\10\37\1\u0133\1\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\4\37\1\u0134\5\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\2\37\1\u0135\2\37\1\u0136\1\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\6\37\1\u0137\3\37\1\0\7\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\2\37\1\u0138\4\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\5\37\1\u0139"+
    "\1\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\1\u013a\6\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\1\37\1\u013b\5\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\4\37\1\u013c\5\37"+
    "\1\0\7\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\12\37\1\0\2\37\1\u013d\4\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\11\37\1\u013e\1\0\7\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\6\37\1\u013f"+
    "\3\37\1\0\7\37\1\0\11\37\14\0\1\37\45\0"+
    "\1\u0140\57\0\1\u0141\163\0\1\u0142\36\0\1\317\1\320"+
    "\1\321\2\0\1\317\1\0\1\317\1\324\1\325\1\0"+
    "\1\326\1\327\7\0\1\325\2\0\1\327\1\324\14\0"+
    "\1\327\42\0\2\320\1\u0143\2\0\1\320\1\0\1\320"+
    "\1\0\1\325\1\0\1\326\1\327\7\0\1\325\2\0"+
    "\1\327\15\0\1\327\42\0\1\317\1\320\1\321\2\0"+
    "\1\317\1\0\1\317\100\0\2\u0144\1\0\1\u0144\1\0"+
    "\3\u0144\1\0\1\u0144\1\0\1\u0145\1\u0144\7\0\1\u0144"+
    "\2\0\1\u0144\4\0\1\u0144\1\0\1\u0144\5\0\2\u0144"+
    "\42\0\1\u0146\6\0\1\u0146\100\0\1\u0147\1\u0148\3\0"+
    "\1\u0148\1\0\1\u0148\2\0\1\u0149\56\0\1\u0149\16\0"+
    "\2\134\1\330\2\0\1\134\1\0\1\134\100\0\2\333"+
    "\1\u014a\2\0\1\333\1\0\1\333\1\0\1\325\2\0"+
    "\1\327\7\0\1\325\2\0\1\327\15\0\1\327\42\0"+
    "\12\37\2\0\2\37\1\254\1\u014b\11\37\1\0\7\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\6\37\1\u014c\3\37\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\3\37"+
    "\1\u014d\6\37\1\0\7\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\1\u014e\11\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\1\37\1\u014f\5\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\2\37\1\u0150\4\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\2\37\1\u0151\4\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\1\37\1\u0152"+
    "\5\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\3\37\1\u0153\6\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\11\37\1\u0154\1\0\7\37\1\0\11\37\14\0\1\37"+
    "\105\0\1\u0155\101\0\1\u0156\5\0\1\u0157\14\0\3\370"+
    "\1\0\1\370\14\0\1\371\15\0\1\373\31\0\1\373"+
    "\2\0\1\373\21\0\2\u0158\1\0\1\u0158\1\0\3\u0158"+
    "\1\0\1\u0158\2\0\1\u0158\7\0\1\u0158\2\0\1\u0158"+
    "\4\0\1\u0158\1\0\1\u0158\5\0\2\u0158\34\0\3\370"+
    "\1\0\1\370\1\0\12\202\1\0\1\371\2\202\1\372"+
    "\12\202\1\373\7\202\1\0\2\202\1\u0159\6\202\10\0"+
    "\1\373\2\0\1\373\1\202\12\0\3\370\1\0\1\370"+
    "\1\0\12\202\1\0\1\371\2\202\1\372\12\202\1\373"+
    "\4\202\1\u015a\2\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\3\202\1\u015b\6\202\1\373"+
    "\3\202\1\u015c\3\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\1\u015d\11\202\1\373\7\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\12\202\1\373\1\202\1\u015e\5\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\7\202\1\0\7\202\1\u015f\1\202\10\0\1\373"+
    "\2\0\1\373\1\202\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\12\202\1\373\1\202"+
    "\1\u0160\5\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\4\202\1\u0161\5\202\1\373\7\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\12\202\1\373\2\202\1\u0162\2\202\1\u0163\1\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\6\202\1\u0164\3\202\1\373\7\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\2\202\1\u0165\4\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\12\202\1\373\5\202"+
    "\1\u0166\1\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\12\202\1\373\1\u0167\6\202\1\0"+
    "\11\202\10\0\1\373\2\0\1\373\1\202\12\0\3\370"+
    "\1\0\1\370\1\0\12\202\1\0\1\371\2\202\1\372"+
    "\12\202\1\373\1\202\1\u0168\5\202\1\0\11\202\10\0"+
    "\1\373\2\0\1\373\1\202\12\0\3\370\1\0\1\370"+
    "\1\0\12\202\1\0\1\371\2\202\1\372\4\202\1\u0169"+
    "\5\202\1\373\7\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\12\202\1\373\2\202\1\u016a"+
    "\4\202\1\0\11\202\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\11\202\1\u016b\1\373\7\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\6\202"+
    "\1\u016c\3\202\1\373\7\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\7\37\1\0\3\37\1\u016d\5\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\7\37\1\0\3\37\1\u016e\5\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\5\37\1\u016f\4\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\5\37\1\u0170\4\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\3\37\1\u0171\6\37\1\0\7\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\4\37\1\u0172"+
    "\5\37\1\0\7\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\u0173\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\1\37\1\u0174\5\37\1\0\11\37\14\0"+
    "\1\37\15\0\1\u0175\104\0\3\u0119\1\0\1\u0119\14\0"+
    "\1\u011a\52\0\1\u011c\21\0\2\u0176\1\0\1\u0176\1\0"+
    "\3\u0176\1\0\1\u0176\2\0\1\u0176\7\0\1\u0176\2\0"+
    "\1\u0176\4\0\1\u0176\1\0\1\u0176\5\0\2\u0176\34\0"+
    "\3\u011e\1\0\1\u011e\14\0\1\u0120\15\0\1\u0122\56\0"+
    "\2\u0177\1\0\1\u0177\1\0\3\u0177\1\0\1\u0177\2\0"+
    "\1\u0177\7\0\1\u0177\2\0\1\u0177\4\0\1\u0177\1\0"+
    "\1\u0177\5\0\2\u0177\34\0\3\u011e\1\0\1\u011e\1\0"+
    "\12\u011f\1\0\1\u0120\2\u011f\1\u0121\12\u011f\1\u0122\2\u011f"+
    "\1\u0178\4\u011f\1\0\11\u011f\14\0\1\u011f\12\0\3\u011e"+
    "\1\0\1\u011e\1\0\12\u011f\1\0\1\u0120\2\u011f\1\u0121"+
    "\12\u011f\1\u0122\2\u011f\1\u0179\4\u011f\1\0\11\u011f\14\0"+
    "\1\u011f\20\0\2\u017a\1\0\1\u017a\1\0\3\u017a\1\0"+
    "\1\u017a\2\0\1\u017a\7\0\1\u017a\2\0\1\u017a\4\0"+
    "\1\u017a\1\0\1\u017a\5\0\2\u017a\33\0\4\u0175\1\u017b"+
    "\1\u0175\1\u017c\101\u0175\7\0\2\u017d\1\0\1\u017d\1\0"+
    "\3\u017d\1\0\1\u017d\2\0\1\u017d\7\0\1\u017d\2\0"+
    "\1\u017d\4\0\1\u017d\1\0\1\u017d\5\0\2\u017d\42\0"+
    "\12\37\2\0\2\37\1\254\6\37\1\u017e\3\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\11\37\1\u017f\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\7\37\1\0\1\u0180\10\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\1\37\1\u0181"+
    "\5\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\6\37\1\u0182\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\7\37"+
    "\1\u0183\2\37\1\0\7\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\5\37\1\u0184\4\37"+
    "\1\0\7\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\12\37\1\0\3\37\1\u0185\3\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\1\u0186\11\37\1\0\7\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\5\37\1\u0187"+
    "\4\37\1\0\7\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\1\37\1\u0188"+
    "\5\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\3\37\1\u0189\3\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\4\37\1\u018a\2\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\6\37\1\u018b"+
    "\3\37\1\0\7\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\3\37\1\u018c\6\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\1\37\1\u018d\5\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\5\37\1\u018e\4\37\1\0\7\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\3\37\1\u018f"+
    "\5\37\1\u0190\1\0\7\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\1\u0191"+
    "\6\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\2\37\1\u0192\4\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\2\37\1\u0193\4\37\1\0\11\37\14\0"+
    "\1\37\53\0\1\u0194\53\0\1\u0195\110\0\2\320\1\u0143"+
    "\2\0\1\320\1\0\1\320\100\0\2\u0144\1\u0196\1\u0144"+
    "\1\0\3\u0144\1\324\1\u0144\1\0\1\u0197\1\u0144\1\u0198"+
    "\5\0\1\u0198\1\u0144\2\0\1\u0144\1\324\3\0\1\u0144"+
    "\1\0\1\u0144\5\0\2\u0144\42\0\2\u0199\1\0\1\u0199"+
    "\1\0\3\u0199\1\0\1\u0199\2\0\1\u0199\7\0\1\u0199"+
    "\2\0\1\u0199\4\0\1\u0199\1\0\1\u0199\5\0\2\u0199"+
    "\42\0\1\u0146\1\0\1\u019a\4\0\1\u0146\1\324\17\0"+
    "\1\324\73\0\1\327\12\0\1\327\15\0\1\327\42\0"+
    "\2\u0148\1\u019b\2\0\1\u0148\1\0\1\u0148\4\0\1\327"+
    "\12\0\1\327\15\0\1\327\42\0\1\u0147\1\u0148\3\0"+
    "\1\u0148\1\0\1\u0148\100\0\2\333\1\u014a\2\0\1\333"+
    "\1\0\1\333\100\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\7\37\1\0\2\37\1\u019c\6\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\7\37"+
    "\1\0\1\37\1\u019d\7\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\12\37\1\0\5\37\1\u019e\1\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\5\37\1\u019f\4\37\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\1\u01a0\6\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\5\37\1\u01a1"+
    "\1\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\5\37\1\u01a2\4\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\2\37\1\u01a3\4\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\1\u014e\6\37\1\0\11\37\14\0\1\37\105\0\1\u01a4"+
    "\22\0\2\u01a5\1\0\1\u01a5\1\0\3\u01a5\1\0\1\u01a5"+
    "\2\0\1\u01a5\7\0\1\u01a5\2\0\1\u01a5\4\0\1\u01a5"+
    "\1\0\1\u01a5\5\0\2\u01a5\34\0\3\370\1\0\1\370"+
    "\1\0\12\202\1\0\1\371\2\202\1\372\11\202\1\u01a6"+
    "\1\373\7\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\12\202\1\373\7\202\1\0\1\u01a7"+
    "\10\202\10\0\1\373\2\0\1\373\1\202\12\0\3\370"+
    "\1\0\1\370\1\0\12\202\1\0\1\371\2\202\1\372"+
    "\12\202\1\373\1\202\1\u01a8\5\202\1\0\11\202\10\0"+
    "\1\373\2\0\1\373\1\202\12\0\3\370\1\0\1\370"+
    "\1\0\12\202\1\0\1\371\2\202\1\372\12\202\1\373"+
    "\6\202\1\u01a9\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\7\202\1\u01aa\2\202\1\373\7\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\5\202\1\u01ab\4\202\1\373\7\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\3\202\1\u01ac\3\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\5\202\1\u01ad\4\202"+
    "\1\373\7\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\12\202\1\373\1\202\1\u01ae\5\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\12\202\1\373\3\202\1\u01af\3\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\4\202\1\u01b0\2\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\6\202\1\u01b1\3\202"+
    "\1\373\7\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\3\202\1\u01b2\6\202\1\373\7\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\12\202\1\373\1\202\1\u01b3\5\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\5\202"+
    "\1\u01b4\4\202\1\373\7\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\3\202\1\u01b5\5\202"+
    "\1\u01b6\1\373\7\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\12\202\1\373\1\u01b7\6\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\12\202\1\373\2\202\1\u01b8\4\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\2\202\1\u01b9\4\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\2\37\1\u01ba\4\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\2\37\1\u01bb\4\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\1\u01bc\6\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\6\37\1\u01bd\3\37\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\6\37\1\u01be\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\3\37\1\u01bf\6\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\1\u01c0\11\37\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\7\37\1\0\5\37\1\u01c1\3\37\14\0\1\37"+
    "\11\0\4\u0175\1\u017b\103\u0175\7\0\2\u01c2\1\0\1\u01c2"+
    "\1\0\3\u01c2\1\0\1\u01c2\2\0\1\u01c2\7\0\1\u01c2"+
    "\2\0\1\u01c2\4\0\1\u01c2\1\0\1\u01c2\5\0\2\u01c2"+
    "\42\0\2\u01c3\1\0\1\u01c3\1\0\3\u01c3\1\0\1\u01c3"+
    "\2\0\1\u01c3\7\0\1\u01c3\2\0\1\u01c3\4\0\1\u01c3"+
    "\1\0\1\u01c3\5\0\2\u01c3\34\0\3\u011e\1\0\1\u011e"+
    "\1\0\12\u011f\1\0\1\u0120\2\u011f\1\u0121\12\u011f\1\u0122"+
    "\1\u011f\1\u01c4\5\u011f\1\0\11\u011f\14\0\1\u011f\12\0"+
    "\3\u011e\1\0\1\u011e\1\0\12\u011f\1\0\1\u0120\2\u011f"+
    "\1\u0121\6\u011f\1\u01c5\3\u011f\1\u0122\7\u011f\1\0\11\u011f"+
    "\14\0\1\u011f\20\0\2\u01c6\1\0\1\u01c6\1\0\3\u01c6"+
    "\1\0\1\u01c6\2\0\1\u01c6\7\0\1\u01c6\2\0\1\u01c6"+
    "\4\0\1\u01c6\1\0\1\u01c6\5\0\2\u01c6\33\0\4\u0175"+
    "\1\u017b\1\u0175\1\u01c7\101\u0175\7\0\2\u01c8\1\0\1\u01c8"+
    "\1\0\3\u01c8\1\0\1\u01c8\2\0\1\u01c8\7\0\1\u01c8"+
    "\2\0\1\u01c8\4\0\1\u01c8\1\0\1\u01c8\5\0\2\u01c8"+
    "\42\0\12\37\2\0\2\37\1\254\12\37\1\0\3\37"+
    "\1\u01c9\3\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\12\37\1\0\2\37\1\u01ca\4\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\5\37\1\u01cb\4\37\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\2\37\1\u01cc\4\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\6\37\1\u01cd\3\37"+
    "\1\0\7\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\12\37\1\0\6\37\1\u01ce\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\11\37\1\u01cf\1\0\7\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\5\37"+
    "\1\u01d0\1\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\12\37\1\0\3\37\1\u01d1\3\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\12\37\1\0\4\37\1\u01d2\2\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\7\37\1\0\5\37\1\u01d3\3\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\1\u01d4"+
    "\6\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\7\37\1\0\7\37\1\u01d5"+
    "\1\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\5\37\1\u01d6\1\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\5\37\1\u01d7\1\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\5\37\1\u01d8"+
    "\1\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\5\37\1\u01d9\4\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\1\u01da\6\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\1\37"+
    "\1\u01db\5\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\11\37\1\u01dc\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\44\0\1\u01dd\63\0\2\u0144\1\u0196"+
    "\1\u0144\1\0\3\u0144\1\0\1\u0144\2\0\1\u0144\7\0"+
    "\1\u0144\2\0\1\u0144\4\0\1\u0144\1\0\1\u0144\5\0"+
    "\2\u0144\42\0\2\u0199\1\0\1\u0199\1\0\3\u0199\1\0"+
    "\1\u0199\2\0\1\u0199\1\u0198\5\0\1\u0198\1\u0199\2\0"+
    "\1\u0199\4\0\1\u0199\1\0\1\u0199\5\0\2\u0199\42\0"+
    "\1\u01de\1\u0148\3\0\1\u0148\1\0\1\u0148\2\0\1\u01df"+
    "\56\0\1\u01df\16\0\2\u0199\1\u01e0\1\u0199\1\0\3\u0199"+
    "\1\0\1\u0199\2\0\1\u0199\1\u0198\5\0\1\u0198\1\u0199"+
    "\2\0\1\u0199\4\0\1\u0199\1\0\1\u0199\5\0\2\u0199"+
    "\42\0\1\u0146\1\0\1\u019a\4\0\1\u0146\100\0\2\u0148"+
    "\1\u019b\2\0\1\u0148\1\0\1\u0148\100\0\12\37\2\0"+
    "\2\37\1\254\11\37\1\u01e1\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\1\37\1\u01e2\5\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\1\u01e3"+
    "\6\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\1\37\1\u01e4\5\37\1\0"+
    "\11\37\14\0\1\37\20\0\2\u01e5\1\0\1\u01e5\1\0"+
    "\3\u01e5\1\0\1\u01e5\2\0\1\u01e5\7\0\1\u01e5\2\0"+
    "\1\u01e5\4\0\1\u01e5\1\0\1\u01e5\5\0\2\u01e5\34\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\12\202\1\373\3\202\1\u01e6\3\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\2\202\1\u01e7\4\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\5\202\1\u01e8\4\202"+
    "\1\373\7\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\12\202\1\373\2\202\1\u01e9\4\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\6\202\1\u01ea\3\202\1\373\7\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\6\202\1\u01eb\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\12\202\1\373\5\202\1\u01ec"+
    "\1\202\1\0\11\202\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\12\202\1\373\3\202\1\u01ed\3\202\1\0"+
    "\11\202\10\0\1\373\2\0\1\373\1\202\12\0\3\370"+
    "\1\0\1\370\1\0\12\202\1\0\1\371\2\202\1\372"+
    "\12\202\1\373\4\202\1\u01ee\2\202\1\0\11\202\10\0"+
    "\1\373\2\0\1\373\1\202\12\0\3\370\1\0\1\370"+
    "\1\0\12\202\1\0\1\371\2\202\1\372\12\202\1\373"+
    "\7\202\1\0\5\202\1\u01ef\3\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\12\202\1\373\1\u01f0\6\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\12\202\1\373\7\202\1\0\7\202\1\u01f1\1\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\5\202\1\u01f2\1\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\12\202\1\373\5\202"+
    "\1\u01f3\1\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\12\202\1\373\5\202\1\u01f4\1\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\5\202\1\u01f5\4\202\1\373\7\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\1\u01f6\6\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\12\202\1\373\1\202\1\u01f7"+
    "\5\202\1\0\11\202\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\11\202\1\u01f8\1\373\7\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\20\0\12\37\2\0"+
    "\2\37\1\254\1\u01f9\11\37\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\1\u01fa"+
    "\11\37\1\0\7\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\1\u01fb\6\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\12\37\1\0\3\37\1\u01fc\3\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\5\37\1\u01fd\1\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\3\37"+
    "\1\u01fe\3\37\1\0\11\37\14\0\1\37\20\0\2\u01ff"+
    "\1\0\1\u01ff\1\0\3\u01ff\1\0\1\u01ff\2\0\1\u01ff"+
    "\7\0\1\u01ff\2\0\1\u01ff\4\0\1\u01ff\1\0\1\u01ff"+
    "\5\0\2\u01ff\42\0\2\u0200\1\0\1\u0200\1\0\3\u0200"+
    "\1\0\1\u0200\2\0\1\u0200\7\0\1\u0200\2\0\1\u0200"+
    "\4\0\1\u0200\1\0\1\u0200\5\0\2\u0200\34\0\3\u011e"+
    "\1\0\1\u011e\1\0\12\u011f\1\0\1\u0120\2\u011f\1\u0121"+
    "\12\u011f\1\u0122\3\u011f\1\u0201\3\u011f\1\0\11\u011f\14\0"+
    "\1\u011f\12\0\3\u011e\1\0\1\u011e\1\0\12\u011f\1\0"+
    "\1\u0120\2\u011f\1\u0121\12\u011f\1\u0122\1\u0202\6\u011f\1\0"+
    "\11\u011f\14\0\1\u011f\20\0\2\u0203\1\0\1\u0203\1\0"+
    "\3\u0203\1\0\1\u0203\2\0\1\u0203\7\0\1\u0203\2\0"+
    "\1\u0203\4\0\1\u0203\1\0\1\u0203\5\0\2\u0203\42\0"+
    "\2\37\1\0\1\37\1\0\3\37\1\0\1\37\2\0"+
    "\1\37\7\0\1\37\2\0\1\37\4\0\1\37\1\0"+
    "\1\37\5\0\2\37\42\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\4\37\1\u0204\2\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\7\37\1\0\1\37\1\u0205\7\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\4\37\1\u0206"+
    "\2\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\1\37\1\u0207\5\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\10\37\1\u0208\1\37\1\0\7\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\5\37\1\u0209"+
    "\4\37\1\0\7\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\5\37\1\u020a\4\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\4\37\1\u020b\2\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\1\37\1\u020c\5\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\5\37\1\u020d\1\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\3\37\1\u020e"+
    "\3\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\1\u020f\6\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\2\37\1\u0210\4\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\7\37"+
    "\1\0\3\37\1\u0211\5\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\12\37\1\0\1\37\1\u0212\5\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\7\37\1\u0213\2\37\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\3\37\1\u0214\3\37\1\0\11\37\14\0\1\37"+
    "\57\0\1\u0215\50\0\1\u01de\1\u0148\3\0\1\u0148\1\0"+
    "\1\u0148\4\0\1\327\12\0\1\327\15\0\1\327\42\0"+
    "\1\u01de\1\u0148\3\0\1\u0148\1\0\1\u0148\100\0\2\u0199"+
    "\1\u01e0\1\u0199\1\0\3\u0199\1\0\1\u0199\2\0\1\u0199"+
    "\7\0\1\u0199\2\0\1\u0199\4\0\1\u0199\1\0\1\u0199"+
    "\5\0\2\u0199\42\0\12\37\2\0\2\37\1\254\5\37"+
    "\1\u0216\4\37\1\0\7\37\1\0\11\37\14\0\1\37"+
    "\20\0\2\202\1\0\1\202\1\0\3\202\1\0\1\202"+
    "\2\0\1\202\7\0\1\202\2\0\1\202\4\0\1\202"+
    "\1\0\1\202\5\0\2\202\34\0\3\370\1\0\1\370"+
    "\1\0\12\202\1\0\1\371\2\202\1\372\12\202\1\373"+
    "\4\202\1\u0217\2\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\12\202\1\373\7\202\1\0"+
    "\1\202\1\u0218\7\202\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\12\202\1\373\4\202\1\u0219\2\202\1\0"+
    "\11\202\10\0\1\373\2\0\1\373\1\202\12\0\3\370"+
    "\1\0\1\370\1\0\12\202\1\0\1\371\2\202\1\372"+
    "\12\202\1\373\1\202\1\u021a\5\202\1\0\11\202\10\0"+
    "\1\373\2\0\1\373\1\202\12\0\3\370\1\0\1\370"+
    "\1\0\12\202\1\0\1\371\2\202\1\372\10\202\1\u021b"+
    "\1\202\1\373\7\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\5\202\1\u021c\4\202\1\373"+
    "\7\202\1\0\11\202\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\12\202\1\373\4\202\1\u021d\2\202\1\0"+
    "\11\202\10\0\1\373\2\0\1\373\1\202\12\0\3\370"+
    "\1\0\1\370\1\0\12\202\1\0\1\371\2\202\1\372"+
    "\12\202\1\373\1\202\1\u021e\5\202\1\0\11\202\10\0"+
    "\1\373\2\0\1\373\1\202\12\0\3\370\1\0\1\370"+
    "\1\0\12\202\1\0\1\371\2\202\1\372\12\202\1\373"+
    "\5\202\1\u021f\1\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\12\202\1\373\3\202\1\u0220"+
    "\3\202\1\0\11\202\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\12\202\1\373\1\u0221\6\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\2\202\1\u0222\4\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\12\202\1\373\7\202"+
    "\1\0\3\202\1\u0223\5\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\12\202\1\373\1\202\1\u0224\5\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\7\202\1\u0225\2\202\1\373\7\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\3\202\1\u0226\3\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\20\0\12\37\2\0\2\37\1\254"+
    "\11\37\1\u0227\1\0\7\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\11\37\1\u0228\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\10\37\1\u0229\1\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\1\37\1\u022a\5\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\5\37\1\u022b\1\37\1\0\11\37\14\0\1\37\20\0"+
    "\2\240\1\0\1\240\1\0\3\240\1\0\1\240\2\0"+
    "\1\240\7\0\1\240\2\0\1\240\4\0\1\240\1\0"+
    "\1\240\5\0\2\240\42\0\2\u011f\1\0\1\u011f\1\0"+
    "\3\u011f\1\0\1\u011f\2\0\1\u011f\7\0\1\u011f\2\0"+
    "\1\u011f\4\0\1\u011f\1\0\1\u011f\5\0\2\u011f\34\0"+
    "\3\u011e\1\0\1\u011e\1\0\12\u011f\1\0\1\u0120\2\u011f"+
    "\1\u0121\12\u011f\1\u0122\4\u011f\1\u022c\2\u011f\1\0\11\u011f"+
    "\14\0\1\u011f\12\0\3\u011e\1\0\1\u011e\1\0\12\u011f"+
    "\1\0\1\u0120\2\u011f\1\u0121\12\u011f\1\u0122\3\u011f\1\u022d"+
    "\3\u011f\1\0\11\u011f\14\0\1\u011f\20\0\2\247\1\0"+
    "\1\247\1\0\3\247\1\0\1\247\2\0\1\247\7\0"+
    "\1\247\2\0\1\247\4\0\1\247\1\0\1\247\5\0"+
    "\2\247\42\0\12\37\2\0\2\37\1\254\5\37\1\u022e"+
    "\4\37\1\0\7\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\12\37\1\0\1\37\1\u022f"+
    "\5\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\5\37\1\u0230\4\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\1\u0231\6\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\7\37"+
    "\1\0\3\37\1\u0232\5\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\3\37\1\u0233\6\37\1\0\7\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\5\37\1\u0234\4\37\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\4\37\1\u0235\2\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\2\37"+
    "\1\u0236\4\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\5\37\1\u0237\4\37\1\0\7\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\11\37\1\u0238\1\0\7\37\1\0\11\37\14\0"+
    "\1\37\65\0\1\u0239\34\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\5\202\1\u023a\4\202"+
    "\1\373\7\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\12\202\1\373\1\202\1\u023b\5\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\5\202\1\u023c\4\202\1\373\7\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\1\u023d\6\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\12\202\1\373\7\202\1\0"+
    "\3\202\1\u023e\5\202\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\3\202\1\u023f\6\202\1\373\7\202\1\0"+
    "\11\202\10\0\1\373\2\0\1\373\1\202\12\0\3\370"+
    "\1\0\1\370\1\0\12\202\1\0\1\371\2\202\1\372"+
    "\5\202\1\u0240\4\202\1\373\7\202\1\0\11\202\10\0"+
    "\1\373\2\0\1\373\1\202\12\0\3\370\1\0\1\370"+
    "\1\0\12\202\1\0\1\371\2\202\1\372\12\202\1\373"+
    "\4\202\1\u0241\2\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\12\202\1\373\2\202\1\u0242"+
    "\4\202\1\0\11\202\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\5\202\1\u0243\4\202\1\373\7\202\1\0"+
    "\11\202\10\0\1\373\2\0\1\373\1\202\12\0\3\370"+
    "\1\0\1\370\1\0\12\202\1\0\1\371\2\202\1\372"+
    "\11\202\1\u0244\1\373\7\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\1\37\1\u0245\5\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\1\37\1\u0246\5\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\5\37\1\u0247\4\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\1\u0248\6\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\5\37"+
    "\1\u0249\4\37\1\0\7\37\1\0\11\37\14\0\1\37"+
    "\12\0\3\u011e\1\0\1\u011e\1\0\12\u011f\1\0\1\u0120"+
    "\2\u011f\1\u0121\12\u011f\1\u0122\1\u011f\1\u024a\5\u011f\1\0"+
    "\11\u011f\14\0\1\u011f\20\0\12\37\2\0\2\37\1\254"+
    "\5\37\1\u024b\4\37\1\0\7\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\4\37\1\u024c"+
    "\5\37\1\0\7\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\6\37\1\u024d\3\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\6\37\1\u024e\3\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\20\0\12\37\2\0\2\37\1\254"+
    "\12\37\1\0\1\37\1\u024f\5\37\1\0\11\37\14\0"+
    "\1\37\20\0\12\37\2\0\2\37\1\254\12\37\1\0"+
    "\4\37\1\u0250\2\37\1\0\11\37\14\0\1\37\20\0"+
    "\12\37\2\0\2\37\1\254\6\37\1\u0251\3\37\1\0"+
    "\7\37\1\0\11\37\14\0\1\37\20\0\12\37\2\0"+
    "\2\37\1\254\5\37\1\u0252\4\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\54\0\1\u0253\45\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\5\202"+
    "\1\u0254\4\202\1\373\7\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\4\202\1\u0255\5\202"+
    "\1\373\7\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\6\202\1\u0256\3\202\1\373\7\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\6\202\1\u0257\3\202\1\373\7\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\1\202\1\u0258\5\202\1\0\11\202\10\0\1\373"+
    "\2\0\1\373\1\202\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\12\202\1\373\4\202"+
    "\1\u0259\2\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\12\0\3\370\1\0\1\370\1\0\12\202\1\0"+
    "\1\371\2\202\1\372\6\202\1\u025a\3\202\1\373\7\202"+
    "\1\0\11\202\10\0\1\373\2\0\1\373\1\202\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\5\202\1\u025b\4\202\1\373\7\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\20\0\12\37\2\0"+
    "\2\37\1\254\12\37\1\0\1\u025c\6\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\1\u025d\6\37\1\0\11\37\14\0\1\37\12\0"+
    "\3\u011e\1\0\1\u011e\1\0\12\u011f\1\0\1\u0120\2\u011f"+
    "\1\u0121\12\u011f\1\u0122\3\u011f\1\u025e\3\u011f\1\0\11\u011f"+
    "\14\0\1\u011f\20\0\12\37\2\0\2\37\1\254\10\37"+
    "\1\u025f\1\37\1\0\7\37\1\0\11\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\3\37"+
    "\1\u0260\3\37\1\0\11\37\14\0\1\37\20\0\12\37"+
    "\2\0\2\37\1\254\12\37\1\0\1\37\1\u0261\5\37"+
    "\1\0\11\37\14\0\1\37\20\0\12\37\2\0\2\37"+
    "\1\254\5\37\1\u0262\4\37\1\0\7\37\1\0\11\37"+
    "\14\0\1\37\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\1\37\1\u0263\5\37\1\0\11\37\14\0\1\37"+
    "\56\0\1\u0264\43\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\10\202\1\u0265\1\202\1\373"+
    "\7\202\1\0\11\202\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\370\1\0\1\370\1\0\12\202\1\0\1\371"+
    "\2\202\1\372\12\202\1\373\3\202\1\u0266\3\202\1\0"+
    "\11\202\10\0\1\373\2\0\1\373\1\202\12\0\3\370"+
    "\1\0\1\370\1\0\12\202\1\0\1\371\2\202\1\372"+
    "\12\202\1\373\1\202\1\u0267\5\202\1\0\11\202\10\0"+
    "\1\373\2\0\1\373\1\202\12\0\3\370\1\0\1\370"+
    "\1\0\12\202\1\0\1\371\2\202\1\372\5\202\1\u0268"+
    "\4\202\1\373\7\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\370\1\0\1\370\1\0\12\202"+
    "\1\0\1\371\2\202\1\372\12\202\1\373\1\202\1\u0269"+
    "\5\202\1\0\11\202\10\0\1\373\2\0\1\373\1\202"+
    "\12\0\3\u011e\1\0\1\u011e\1\0\12\u011f\1\0\1\u0120"+
    "\2\u011f\1\u0121\12\u011f\1\u0122\6\u011f\1\u026a\1\0\11\u011f"+
    "\14\0\1\u011f\20\0\12\37\2\0\2\37\1\254\12\37"+
    "\1\0\7\37\1\0\6\37\1\u026b\2\37\14\0\1\37"+
    "\20\0\12\37\2\0\2\37\1\254\12\37\1\0\1\u026c"+
    "\6\37\1\0\11\37\14\0\1\37\44\0\1\u026d\55\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\12\202\1\373\7\202\1\0\6\202\1\u026e\2\202"+
    "\10\0\1\373\2\0\1\373\1\202\12\0\3\370\1\0"+
    "\1\370\1\0\12\202\1\0\1\371\2\202\1\372\12\202"+
    "\1\373\1\u026f\6\202\1\0\11\202\10\0\1\373\2\0"+
    "\1\373\1\202\12\0\3\u011e\1\0\1\u011e\1\0\12\u011f"+
    "\1\0\1\u0120\2\u011f\1\u0121\5\u011f\1\u0270\4\u011f\1\u0122"+
    "\7\u011f\1\0\11\u011f\14\0\1\u011f\20\0\12\37\2\0"+
    "\2\37\1\254\5\37\1\u0271\4\37\1\0\7\37\1\0"+
    "\11\37\14\0\1\37\12\0\3\370\1\0\1\370\1\0"+
    "\12\202\1\0\1\371\2\202\1\372\5\202\1\u0272\4\202"+
    "\1\373\7\202\1\0\11\202\10\0\1\373\2\0\1\373"+
    "\1\202\20\0\12\37\2\0\2\37\1\254\10\37\1\u0273"+
    "\1\37\1\0\7\37\1\0\11\37\14\0\1\37\12\0"+
    "\3\370\1\0\1\370\1\0\12\202\1\0\1\371\2\202"+
    "\1\372\10\202\1\u0274\1\202\1\373\7\202\1\0\11\202"+
    "\10\0\1\373\2\0\1\373\1\202\11\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[32904];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\32\0\1\11\1\1\1\11\11\1\1\11\6\1\1\11"+
    "\1\1\7\11\1\1\2\11\1\1\4\11\2\1\2\11"+
    "\1\1\2\11\2\1\12\11\1\1\1\11\1\1\1\11"+
    "\1\1\1\11\20\1\3\11\3\1\3\11\1\1\1\11"+
    "\4\1\2\11\2\1\1\11\1\1\1\11\1\1\3\11"+
    "\16\1\2\11\4\1\1\11\2\1\1\11\1\1\2\11"+
    "\1\1\1\11\2\1\1\11\6\1\1\0\2\1\1\11"+
    "\3\0\24\1\2\0\1\1\1\0\1\11\1\0\6\11"+
    "\2\1\3\0\1\11\2\0\1\11\1\0\2\11\14\1"+
    "\1\11\1\1\17\11\1\0\1\11\1\0\1\11\1\0"+
    "\33\1\2\0\1\11\1\0\1\11\3\0\1\11\1\0"+
    "\1\11\5\0\1\11\1\0\26\1\2\0\1\11\1\0"+
    "\1\1\1\0\3\1\2\0\12\1\1\11\1\1\1\11"+
    "\1\0\34\1\7\0\1\1\1\0\26\1\1\0\1\11"+
    "\6\0\10\1\1\11\1\0\34\1\5\0\1\11\1\0"+
    "\24\1\1\0\1\1\2\0\4\1\1\0\31\1\5\0"+
    "\21\1\1\0\27\1\1\0\13\1\1\0\20\1\1\0"+
    "\10\1\1\0\12\1\1\0\5\1\1\0\5\1\1\0"+
    "\2\1\1\11\7\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[628];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /** For the backwards DFA of general lookahead statements */
  private boolean [] zzFin = new boolean [ZZ_BUFFERSIZE+1];

  /* user code: */
	private java.io.Writer writer;
	private List<CommentHandler> commentHandlers = new ArrayList<CommentHandler>();

    private int classDepth = 0;
    private int parenDepth = 0;
    private int nestingDepth = 0;
    private int annotationDepth = 0;
    private int assignmentDepth = 0;
    private int stateDepth = 0;
    private int codeblockDepth = 0;
    private int[] stateStack = new int[10];
    private int braceMode = CODEBLOCK;
    private int parenMode = -1;
    private int annotatedElementLine = 0;
    private StringBuffer codeBody = new StringBuffer(8192);
    private boolean newMode;
    private boolean bracketMode;
    private boolean anonymousMode;
    private boolean enumConstantMode;
    private boolean appendingToCodeBody;

	private void write() {
		write( text() );
	}
 
	private void write( String text ) {
    	try {
            if( writer != null ) {
                writer.write( text );
            }
        }
        catch( java.io.IOException ioe ) {}
	}

    public String text() {
        return yytext();
    }

    public int lex() throws java.io.IOException {
    	if(annotatedElementLine < 0)
    	{
    	  annotatedElementLine = 0;
    	}
        return yylex();
    }
    
    public int getLine() {
        return ( annotatedElementLine == 0 ? yyline + 1 : Math.abs(annotatedElementLine) );
    }

    public int getColumn() {
        return yycolumn + 1;
    }

    private void pushState(int newState) {
        stateStack[stateDepth++] = zzLexicalState;
        yybegin(newState);
    }

    private void popState() {
        yybegin(stateStack[--stateDepth]);
    }
    
    public String getCodeBody(){
        String s = codeBody.toString();
        codeBody = new StringBuffer(8192);
        return s;
    }
    
    public void addCommentHandler(CommentHandler handler) {
      this.commentHandlers.add(handler);
    }
    
    private int parseValue( String value, int defaultValue )
    {
      int result;
      try 
      {
        result = Integer.parseInt( value );
      }
      catch( NumberFormatException e )
      {
        result = defaultValue;
      }
      return result;
    }
    
    private void markAnnotatedElementLine()
    {
      if( annotatedElementLine <= 0 )
      {
        annotatedElementLine = getLine();
      }
    }

    private void resetAnnotatedElementLine()
    {
      annotatedElementLine = - Math.abs(annotatedElementLine);
    }
    
    public JFlexLexer( java.io.Reader reader, java.io.Writer writer ) {
       this( reader );
       this.writer = writer;
  	}

    public JFlexLexer( java.io.InputStream stream, java.io.Writer writer ) {
       this( stream );
       this.writer = writer;
  	}



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JFlexLexer(java.io.Reader in) {
    java.io.InputStream qdoxProperties = this.getClass().getClassLoader().getResourceAsStream( "qdox.properties" );
  if( qdoxProperties != null )
  {
     Properties props = new Properties();
     try
     {
         props.load( qdoxProperties );
         stateStack = new int[ parseValue( props.getProperty( "lexer.statestack.size" ), stateStack.length ) ];
     }
     catch ( java.io.IOException e )
     {
         // failed to load qdoxProperties
     }
     finally 
     {
        try
        {
          qdoxProperties.close();
        }
        catch( java.io.IOException e )
        {
          // noop, we did our best
        }
     }
  }
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JFlexLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2280) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 113: 
          { return Parser.INT;
          }
        case 161: break;
        case 51: 
          { return Parser.PERCENT;
          }
        case 162: break;
        case 42: 
          { return Parser.MINUS;
          }
        case 163: break;
        case 122: 
          { return Parser.CHAR;
          }
        case 164: break;
        case 139: 
          { return Parser.THROWS;
          }
        case 165: break;
        case 62: 
          { pushState(CODEBLOCK);
                          braceMode = -1;
                          yypushback(1); /* (re)enter brace in right mode */
          }
        case 166: break;
        case 82: 
          { return Parser.FLOAT_LITERAL;
          }
        case 167: break;
        case 34: 
          { codeBody.append('}');
        nestingDepth--;
    	if (nestingDepth==assignmentDepth) { 
            anonymousMode=false;
        }
          }
        case 168: break;
        case 6: 
          { return Parser.COMMA;
          }
        case 169: break;
        case 25: 
          { nestingDepth++; 
        if (appendingToCodeBody) { codeBody.append("("); }
          }
        case 170: break;
        case 22: 
          { if(codeblockDepth++ > 0 ) {
            codeBody.append('{');
            }
          }
        case 171: break;
        case 70: 
          { popState(); 
                          return Parser.BRACECLOSE;
          }
        case 172: break;
        case 3: 
          { return Parser.IDENTIFIER;
          }
        case 173: break;
        case 103: 
          // general lookahead, find correct zzMarkedPos
          { int zzFState = 21;
            int zzFPos = zzStartRead;
            if (zzFin.length <= zzBufferL.length) { zzFin = new boolean[zzBufferL.length+1]; }
            boolean zzFinL[] = zzFin;
            while (zzFState != -1 && zzFPos < zzMarkedPos) {
              if ((zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 
              zzInput = zzBufferL[zzFPos++];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            }
            if (zzFState != -1 && (zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 

            zzFState = 22;
            zzFPos = zzMarkedPos;
            while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
              zzInput = zzBufferL[--zzFPos];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            };
            zzMarkedPos = zzFPos;
          }
          { return Parser.IDENTIFIER;
          }
        case 174: break;
        case 106: 
          // general lookahead, find correct zzMarkedPos
          { int zzFState = 21;
            int zzFPos = zzStartRead;
            if (zzFin.length <= zzBufferL.length) { zzFin = new boolean[zzBufferL.length+1]; }
            boolean zzFinL[] = zzFin;
            while (zzFState != -1 && zzFPos < zzMarkedPos) {
              if ((zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 
              zzInput = zzBufferL[zzFPos++];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            }
            if (zzFState != -1 && (zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 

            zzFState = 22;
            zzFPos = zzMarkedPos;
            while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
              zzInput = zzBufferL[--zzFPos];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            };
            zzMarkedPos = zzFPos;
          }
          { return Parser.IDENTIFIER;
          }
        case 175: break;
        case 117: 
          { if (appendingToCodeBody) { codeBody.append("/**/"); }
          }
        case 176: break;
        case 101: 
          { codeBody.append("\\\"");
          }
        case 177: break;
        case 39: 
          { return Parser.STAR;
          }
        case 178: break;
        case 48: 
          { nestingDepth--; return Parser.BRACECLOSE;
          }
        case 179: break;
        case 68: 
          { pushState(NAME); return Parser.COMMA;
          }
        case 180: break;
        case 74: 
          { if (appendingToCodeBody) { codeBody.append("//"); } pushState(SINGLELINECOMMENT);
          }
        case 181: break;
        case 158: 
          { markAnnotatedElementLine();
      	classDepth++;
        braceMode = ANNOTATIONTYPE;
        pushState(NAME);
        return Parser.ANNOINTERFACE;
          }
        case 182: break;
        case 31: 
          { codeBody.append('<');
        if (!bracketMode && newMode && !anonymousMode) {
            nestingDepth++; 
        }
          }
        case 183: break;
        case 19: 
          { if (appendingToCodeBody) { codeBody.append('"');  } pushState(STRING);
          }
        case 184: break;
        case 79: 
          { if (appendingToCodeBody) { codeBody.append("*/"); } popState();
          }
        case 185: break;
        case 37: 
          { if (appendingToCodeBody) { codeBody.append('\'');    } popState();
          }
        case 186: break;
        case 15: 
          { resetAnnotatedElementLine();
        if(braceMode >= 0) {
          if(braceMode == ENUM) {
            enumConstantMode = true;
          } else if (braceMode == CODEBLOCK) {
              getCodeBody(); /* reset codebody */
              appendingToCodeBody = true;
          }
          pushState(braceMode);
          braceMode = -1;
          yypushback(1); /* (re)enter brace in right mode */
        }
        else {
          nestingDepth++;
          if (enumConstantMode && yystate() == ENUM)
          {
            braceMode = TYPE;
          }
          else 
          {
            braceMode = CODEBLOCK;
          }
          return Parser.BRACEOPEN;
        }
          }
        case 187: break;
        case 138: 
          { markAnnotatedElementLine(); return Parser.STATIC;
          }
        case 188: break;
        case 114: 
          { return Parser.LESSTHAN2EQUALS;
          }
        case 189: break;
        case 97: 
          { return Parser.VERTLINE2;
          }
        case 190: break;
        case 35: 
          { codeBody.append('('); 
        parenDepth = nestingDepth++; 
        pushState(PARENBLOCK);
          }
        case 191: break;
        case 59: 
          { return Parser.TILDE;
          }
        case 192: break;
        case 80: 
          { return Parser.STAREQUALS;
          }
        case 193: break;
        case 110: 
          { return Parser.DOTDOTDOT;
          }
        case 194: break;
        case 38: 
          { if (appendingToCodeBody) { codeBody.append(yytext()); } popState();
          }
        case 195: break;
        case 141: 
          { return Parser.DOUBLE;
          }
        case 196: break;
        case 53: 
          { return Parser.CIRCUMFLEX;
          }
        case 197: break;
        case 78: 
          { if (appendingToCodeBody) { codeBody.append("\\'");  }
          }
        case 198: break;
        case 134: 
          { pushState(NAME); return Parser.OPENS;
          }
        case 199: break;
        case 46: 
          { return Parser.AT;
          }
        case 200: break;
        case 12: 
          { return Parser.AMPERSAND;
          }
        case 201: break;
        case 1: 
          { if (appendingToCodeBody) { codeBody.append(yytext()); }
          }
        case 202: break;
        case 98: 
          { return Parser.COLONCOLON;
          }
        case 203: break;
        case 76: 
          { if (appendingToCodeBody) { codeBody.append("\\\\"); }
          }
        case 204: break;
        case 120: 
          { return Parser.LONG;
          }
        case 205: break;
        case 29: 
          { codeBody.append(']'); bracketMode = false; nestingDepth--;
          }
        case 206: break;
        case 26: 
          { resetAnnotatedElementLine();
        if (nestingDepth == assignmentDepth) {
            appendingToCodeBody = true;
            newMode = false;
            popState(); 
            return Parser.SEMI; 
        } else {
            codeBody.append(';');
        }
          }
        case 207: break;
        case 112: 
          { codeBody.append("new");
        if (nestingDepth==assignmentDepth) {
            newMode=true;
        }
          }
        case 208: break;
        case 86: 
          { return Parser.LESSEQUALS;
          }
        case 209: break;
        case 17: 
          { assignmentDepth = nestingDepth;
        getCodeBody(); /* reset codebody */
        appendingToCodeBody = true;
        pushState(ASSIGNMENT);
          }
        case 210: break;
        case 72: 
          { resetAnnotatedElementLine(); popState(); return Parser.IDENTIFIER;
          }
        case 211: break;
        case 104: 
          // general lookahead, find correct zzMarkedPos
          { int zzFState = 21;
            int zzFPos = zzStartRead;
            if (zzFin.length <= zzBufferL.length) { zzFin = new boolean[zzBufferL.length+1]; }
            boolean zzFinL[] = zzFin;
            while (zzFState != -1 && zzFPos < zzMarkedPos) {
              if ((zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 
              zzInput = zzBufferL[zzFPos++];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            }
            if (zzFState != -1 && (zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 

            zzFState = 25;
            zzFPos = zzMarkedPos;
            while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
              zzInput = zzBufferL[--zzFPos];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            };
            zzMarkedPos = zzFPos;
          }
          { resetAnnotatedElementLine(); popState(); return Parser.IDENTIFIER;
          }
        case 212: break;
        case 137: 
          { if ( classDepth == 0 )
                          {
                            pushState(MODULE);
                            pushState(NAME);
                            return Parser.MODULE;
                          }
                          else
                          {
                            return Parser.IDENTIFIER;
                          }
          }
        case 213: break;
        case 5: 
          { resetAnnotatedElementLine();
            return Parser.SEMI;
          }
        case 214: break;
        case 64: 
          { popState(); return Parser.IDENTIFIER;
          }
        case 215: break;
        case 109: 
          // general lookahead, find correct zzMarkedPos
          { int zzFState = 21;
            int zzFPos = zzStartRead;
            if (zzFin.length <= zzBufferL.length) { zzFin = new boolean[zzBufferL.length+1]; }
            boolean zzFinL[] = zzFin;
            while (zzFState != -1 && zzFPos < zzMarkedPos) {
              if ((zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 
              zzInput = zzBufferL[zzFPos++];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            }
            if (zzFState != -1 && (zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 

            zzFState = 23;
            zzFPos = zzMarkedPos;
            while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
              zzInput = zzBufferL[--zzFPos];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            };
            zzMarkedPos = zzFPos;
          }
          { popState(); return Parser.IDENTIFIER;
          }
        case 216: break;
        case 153: 
          { pushState(NAME_OR_MODIFIER); return Parser.REQUIRES;
          }
        case 217: break;
        case 107: 
          // general lookahead, find correct zzMarkedPos
          { int zzFState = 21;
            int zzFPos = zzStartRead;
            if (zzFin.length <= zzBufferL.length) { zzFin = new boolean[zzBufferL.length+1]; }
            boolean zzFinL[] = zzFin;
            while (zzFState != -1 && zzFPos < zzMarkedPos) {
              if ((zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 
              zzInput = zzBufferL[zzFPos++];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            }
            if (zzFState != -1 && (zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 

            zzFState = 24;
            zzFPos = zzMarkedPos;
            while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
              zzInput = zzBufferL[--zzFPos];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            };
            zzMarkedPos = zzFPos;
          }
          { parenMode = ANNOTATION; getCodeBody(); /* reset codebody */; popState(); resetAnnotatedElementLine(); return Parser.IDENTIFIER;
          }
        case 218: break;
        case 77: 
          { if (appendingToCodeBody) { codeBody.append("\\\""); }
          }
        case 219: break;
        case 146: 
          { assignmentDepth = nestingDepth; appendingToCodeBody = true; pushState(ASSIGNMENT);
          }
        case 220: break;
        case 115: 
          { return Parser.GREATERTHAN3;
          }
        case 221: break;
        case 69: 
          { return Parser.BRACEOPEN;
          }
        case 222: break;
        case 123: 
          { return Parser.BYTE;
          }
        case 223: break;
        case 7: 
          { nestingDepth++; return Parser.SQUAREOPEN;
          }
        case 224: break;
        case 147: 
          { return Parser.DEFAULT;
          }
        case 225: break;
        case 85: 
          { return Parser.LESSTHAN2;
          }
        case 226: break;
        case 49: 
          { return Parser.EQUALS;
          }
        case 227: break;
        case 23: 
          { if (--codeblockDepth == 0) {
            popState();
            appendingToCodeBody = false;
            braceMode = CODEBLOCK;
            return Parser.CODEBLOCK;
        } else {
            codeBody.append('}');
        }
          }
        case 228: break;
        case 45: 
          { if( nestingDepth-- == annotationDepth) { popState(); } return Parser.PARENCLOSE;
          }
        case 229: break;
        case 99: 
          { return Parser.NOTEQUALS;
          }
        case 230: break;
        case 142: 
          { return Parser.STATIC;
          }
        case 231: break;
        case 4: 
          { return Parser.DOT;
          }
        case 232: break;
        case 145: 
          { return Parser.EXTENDS;
          }
        case 233: break;
        case 94: 
          { return Parser.PLUSPLUS;
          }
        case 234: break;
        case 9: 
          { nestingDepth--; return Parser.PARENCLOSE;
          }
        case 235: break;
        case 111: 
          { return Parser.NEW;
          }
        case 236: break;
        case 87: 
          { return Parser.GREATERTHAN2;
          }
        case 237: break;
        case 24: 
          { nestingDepth--;
		if (appendingToCodeBody) { codeBody.append(")"); }
        if (nestingDepth == parenDepth) {
            popState();
        }
          }
        case 238: break;
        case 67: 
          { return Parser.SEMI;
          }
        case 239: break;
        case 89: 
          { return Parser.AMPERSAND2;
          }
        case 240: break;
        case 91: 
          { return Parser.EQUALS2;
          }
        case 241: break;
        case 131: 
          { return Parser.SHORT;
          }
        case 242: break;
        case 126: 
          { pushState(NAME); return Parser.WITH;
          }
        case 243: break;
        case 119: 
          { markAnnotatedElementLine();
        classDepth++;
        braceMode = ENUM;
        pushState(NAME);
        return Parser.ENUM;
          }
        case 244: break;
        case 47: 
          { nestingDepth++; return Parser.BRACEOPEN;
          }
        case 245: break;
        case 159: 
          { return Parser.TRANSITIVE;
          }
        case 246: break;
        case 129: 
          { markAnnotatedElementLine();
        classDepth++;
        braceMode = TYPE;
        pushState(NAME);
        return Parser.CLASS;
          }
        case 247: break;
        case 135: 
          { markAnnotatedElementLine(); return Parser.PUBLIC;
          }
        case 248: break;
        case 149: 
          { markAnnotatedElementLine(); return Parser.STRICTFP;
          }
        case 249: break;
        case 8: 
          { nestingDepth--; return Parser.SQUARECLOSE;
          }
        case 250: break;
        case 56: 
          { appendingToCodeBody=true; codeBody.append("\'"); pushState(ANNOCHAR);
          }
        case 251: break;
        case 121: 
          { return Parser.BOOLEAN_LITERAL;
          }
        case 252: break;
        case 88: 
          { return Parser.GREATEREQUALS;
          }
        case 253: break;
        case 84: 
          { return Parser.MINUSEQUALS;
          }
        case 254: break;
        case 143: 
          { markAnnotatedElementLine(); pushState(NAME);
                          return Parser.PACKAGE;
          }
        case 255: break;
        case 102: 
          { codeBody.append("\\'");
          }
        case 256: break;
        case 96: 
          { return Parser.VERTLINEEQUALS;
          }
        case 257: break;
        case 152: 
          { pushState(NAME); return Parser.PROVIDES;
          }
        case 258: break;
        case 154: 
          { markAnnotatedElementLine(); return Parser.PROTECTED;
          }
        case 259: break;
        case 140: 
          { pushState(NAME);
                          return Parser.IMPORT;
          }
        case 260: break;
        case 95: 
          { return Parser.CIRCUMFLEXEQUALS;
          }
        case 261: break;
        case 10: 
          { return Parser.LESSTHAN;
          }
        case 262: break;
        case 60: 
          { codeBody.append("\""); popState(); appendingToCodeBody=false; return Parser.STRING_LITERAL;
          }
        case 263: break;
        case 55: 
          { appendingToCodeBody=true; codeBody.append("\""); pushState(ANNOSTRING);
          }
        case 264: break;
        case 21: 
          { codeBody.append(yytext());
          }
        case 265: break;
        case 100: 
          { codeBody.append("\\\\");
          }
        case 266: break;
        case 133: 
          { return Parser.FLOAT;
          }
        case 267: break;
        case 116: 
          { return Parser.GREATERTHAN2EQUALS;
          }
        case 268: break;
        case 118: 
          { if ( classDepth == 0 )
                          {
                            return Parser.OPEN;
                          }
                          else
                          {
                            return Parser.IDENTIFIER;
                          }
          }
        case 269: break;
        case 63: 
          { return Parser.BRACECLOSE;
          }
        case 270: break;
        case 58: 
          { return Parser.EXCLAMATION;
          }
        case 271: break;
        case 18: 
          { nestingDepth++;
            if( parenMode >= 0 ) {
              annotationDepth = nestingDepth;
              pushState(parenMode);
              parenMode = -1;
            }
            return Parser.PARENOPEN;
          }
        case 272: break;
        case 32: 
          { codeBody.append('>');
        if (!anonymousMode) {
	        if (!bracketMode && newMode) {
    	        nestingDepth--;
    	    	if (nestingDepth==assignmentDepth) { 
    	            newMode=false;
    	        }
        	}
        }
          }
        case 273: break;
        case 41: 
          { return Parser.INTEGER_LITERAL;
          }
        case 274: break;
        case 36: 
          { if (appendingToCodeBody) { codeBody.append('"');    } popState();
          }
        case 275: break;
        case 27: 
          { if (nestingDepth == assignmentDepth) {
            appendingToCodeBody = true;
            popState(); 
            return Parser.COMMA; 
        } else {
            codeBody.append(',');
        }
          }
        case 276: break;
        case 50: 
          { ++ nestingDepth; return Parser.PARENOPEN;
          }
        case 277: break;
        case 155: 
          { markAnnotatedElementLine(); return Parser.TRANSIENT;
          }
        case 278: break;
        case 20: 
          { if (appendingToCodeBody) { codeBody.append('\''); } pushState(CHAR);
          }
        case 279: break;
        case 13: 
          { return Parser.QUERY;
          }
        case 280: break;
        case 57: 
          { return Parser.COLON;
          }
        case 281: break;
        case 130: 
          { markAnnotatedElementLine(); return Parser.FINAL;
          }
        case 282: break;
        case 54: 
          { return Parser.VERTLINE;
          }
        case 283: break;
        case 160: 
          { markAnnotatedElementLine(); return Parser.SYNCHRONIZED;
          }
        case 284: break;
        case 132: 
          { return Parser.CLASS;
          }
        case 285: break;
        case 65: 
          { enumConstantMode = false; 
    		braceMode = CODEBLOCK; 
    		return Parser.SEMI;
          }
        case 286: break;
        case 75: 
          // lookahead expression with fixed lookahead length
          yypushback(1);
          { codeBody.append('.');
      newMode = true;
          }
        case 287: break;
        case 33: 
          { codeBody.append('{');
		anonymousMode = true;
		nestingDepth++;
          }
        case 288: break;
        case 43: 
          { return Parser.SQUAREOPEN;
          }
        case 289: break;
        case 40: 
          { return Parser.SLASH;
          }
        case 290: break;
        case 151: 
          { markAnnotatedElementLine(); return Parser.VOLATILE;
          }
        case 291: break;
        case 105: 
          { pushState(NAME); return Parser.TO;
          }
        case 292: break;
        case 127: 
          { for( CommentHandler handler: commentHandlers ) {
        handler.onComment( text(), getLine(), getColumn() );
      }
          }
        case 293: break;
        case 156: 
          { markAnnotatedElementLine();
        classDepth++;
        braceMode = TYPE;
        pushState(NAME);
        return Parser.INTERFACE;
          }
        case 294: break;
        case 128: 
          { return Parser.SUPER;
          }
        case 295: break;
        case 61: 
          { codeBody.append("\'"); popState(); appendingToCodeBody=false; return Parser.CHAR_LITERAL;
          }
        case 296: break;
        case 92: 
          { return Parser.PERCENTEQUALS;
          }
        case 297: break;
        case 71: 
          { popState();
          }
        case 298: break;
        case 144: 
          { markAnnotatedElementLine(); return Parser.PRIVATE;
          }
        case 299: break;
        case 30: 
          { codeBody.append(')');
        nestingDepth--; 
        if (nestingDepth < assignmentDepth) {
            appendingToCodeBody = true; 
            popState(); 
            return Parser.PARENCLOSE; 
        }
          }
        case 300: break;
        case 11: 
          { return Parser.GREATERTHAN;
          }
        case 301: break;
        case 73: 
          { if (appendingToCodeBody) { codeBody.append("/*"); } pushState(MULTILINECOMMENT);
          }
        case 302: break;
        case 2: 
          { popState(); return Parser.STAR;
          }
        case 303: break;
        case 81: 
          { return Parser.SLASHEQUALS;
          }
        case 304: break;
        case 93: 
          { return Parser.PLUSEQUALS;
          }
        case 305: break;
        case 14: 
          { markAnnotatedElementLine();
        pushState(ATANNOTATION);
        return Parser.AT;
          }
        case 306: break;
        case 136: 
          { markAnnotatedElementLine(); return Parser.NATIVE;
          }
        case 307: break;
        case 150: 
          { markAnnotatedElementLine(); return Parser.ABSTRACT;
          }
        case 308: break;
        case 16: 
          { nestingDepth--;
        classDepth--;
        popState();
        if ( yystate() == ENUM && enumConstantMode)
        {
          braceMode = TYPE;
        }
        else
        {
          braceMode = CODEBLOCK;
        }
        return Parser.BRACECLOSE;
          }
        case 309: break;
        case 52: 
          { return Parser.PLUS;
          }
        case 310: break;
        case 44: 
          { return Parser.SQUARECLOSE;
          }
        case 311: break;
        case 28: 
          { codeBody.append('['); bracketMode = true; nestingDepth++;
          }
        case 312: break;
        case 83: 
          { return Parser.MINUSMINUS;
          }
        case 313: break;
        case 66: 
          { nestingDepth++;
            if(parenMode >= 0) {
              annotationDepth = nestingDepth;
              pushState(parenMode);
              parenMode = -1;
              return Parser.PARENOPEN;
            }
            else if(enumConstantMode) 
            {  
              annotationDepth = nestingDepth;
              pushState(ARGUMENTS);
              return Parser.PARENOPEN;
            }
            else {
                return Parser.PARENOPEN;
            }
          }
        case 314: break;
        case 157: 
          { return Parser.IMPLEMENTS;
          }
        case 315: break;
        case 124: 
          { return Parser.GREATERTHAN3EQUALS;
          }
        case 316: break;
        case 90: 
          { return Parser.AMPERSANDEQUALS;
          }
        case 317: break;
        case 125: 
          { pushState(NAME); return Parser.USES;
          }
        case 318: break;
        case 108: 
          // general lookahead, find correct zzMarkedPos
          { int zzFState = 21;
            int zzFPos = zzStartRead;
            if (zzFin.length <= zzBufferL.length) { zzFin = new boolean[zzBufferL.length+1]; }
            boolean zzFinL[] = zzFin;
            while (zzFState != -1 && zzFPos < zzMarkedPos) {
              if ((zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 
              zzInput = zzBufferL[zzFPos++];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            }
            if (zzFState != -1 && (zzAttrL[zzFState] & 1) == 1) { zzFinL[zzFPos] = true; } 

            zzFState = 22;
            zzFPos = zzMarkedPos;
            while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
              zzInput = zzBufferL[--zzFPos];
              zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
            };
            zzMarkedPos = zzFPos;
          }
          { popState(); pushState(NAME); return Parser.IDENTIFIER;
          }
        case 319: break;
        case 148: 
          { pushState(NAME); return Parser.EXPORTS;
          }
        case 320: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              { return 0; }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
