/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSearchRequest;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSearchResult;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedSearchOperation
extends InterceptedOperation
implements InMemoryInterceptedSearchRequest,
InMemoryInterceptedSearchResult {
    @NotNull
    private SearchRequest searchRequest;
    @Nullable
    private LDAPResult searchResult;

    InterceptedSearchOperation(@NotNull LDAPListenerClientConnection clientConnection, int messageID, @NotNull SearchRequestProtocolOp requestOp, Control ... requestControls) {
        super(clientConnection, messageID);
        this.searchRequest = requestOp.toSearchRequest(requestControls);
        this.searchResult = null;
    }

    @Override
    @NotNull
    public ReadOnlySearchRequest getRequest() {
        return this.searchRequest;
    }

    @Override
    public void setRequest(@NotNull SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
    }

    @Override
    @Nullable
    public LDAPResult getResult() {
        return this.searchResult;
    }

    @Override
    public void setResult(@NotNull LDAPResult searchResult) {
        this.searchResult = searchResult;
    }

    @Override
    public void sendSearchEntry(@NotNull Entry entry) throws LDAPException {
        Control[] controls = entry instanceof SearchResultEntry ? ((SearchResultEntry)entry).getControls() : null;
        this.getClientConnection().sendSearchResultEntry(this.getMessageID(), new SearchResultEntryProtocolOp(entry), controls);
    }

    @Override
    public void sendSearchReference(@NotNull SearchResultReference reference) throws LDAPException {
        this.getClientConnection().sendSearchResultReference(this.getMessageID(), new SearchResultReferenceProtocolOp(reference), reference.getControls());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("InterceptedSearchOperation(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.searchRequest);
        buffer.append(", result=");
        buffer.append(this.searchResult);
        buffer.append(')');
    }
}

