/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.CurrentContextFactory;

public final class ArcInitConfig {
    public static final ArcInitConfig DEFAULT = ArcInitConfig.builder().build();
    private final boolean strictCompatibility;
    private final CurrentContextFactory currentContextFactory;
    private final boolean optimizeContexts;

    public static Builder builder() {
        return new Builder();
    }

    private ArcInitConfig(Builder builder) {
        this.currentContextFactory = builder.currentContextFactory;
        this.strictCompatibility = builder.strictCompatibility;
        this.optimizeContexts = builder.optimizeContexts;
    }

    public boolean isStrictCompatibility() {
        return this.strictCompatibility;
    }

    public CurrentContextFactory getCurrentContextFactory() {
        return this.currentContextFactory;
    }

    public boolean isOptimizeContexts() {
        return this.optimizeContexts;
    }

    public static class Builder {
        private boolean strictCompatibility = false;
        private CurrentContextFactory currentContextFactory = null;
        private boolean optimizeContexts = false;

        private Builder() {
        }

        public Builder setStrictCompatibility(boolean strictCompatibility) {
            this.strictCompatibility = strictCompatibility;
            return this;
        }

        public Builder setCurrentContextFactory(CurrentContextFactory currentContextFactory) {
            this.currentContextFactory = currentContextFactory;
            return this;
        }

        public Builder setOptimizeContexts(boolean value) {
            this.optimizeContexts = value;
            return this;
        }

        public ArcInitConfig build() {
            return new ArcInitConfig(this);
        }
    }
}

