/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.Arc;
import io.quarkus.arc.Components;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceImpl;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.objectweb.asm.Type;

public class ComponentsProviderGenerator
extends AbstractGenerator {
    static final String COMPONENTS_PROVIDER_SUFFIX = "_ComponentsProvider";
    static final String SETUP_PACKAGE = Arc.class.getPackage().getName() + ".setup";
    static final String ADD_OBSERVERS = "addObservers";
    static final String ADD_REMOVED_BEANS = "addRemovedBeans";
    static final String ADD_BEANS = "addBeans";
    private final AnnotationLiteralProcessor annotationLiterals;
    private final boolean detectUnusedFalsePositives;

    public ComponentsProviderGenerator(AnnotationLiteralProcessor annotationLiterals, boolean generateSources, boolean detectUnusedFalsePositives) {
        super(generateSources);
        this.annotationLiterals = annotationLiterals;
        this.detectUnusedFalsePositives = detectUnusedFalsePositives;
    }

    Collection<ResourceOutput.Resource> generate(String name, BeanDeployment beanDeployment, Map<BeanInfo, String> beanToGeneratedName, Map<ObserverInfo, String> observerToGeneratedName) {
        ResourceClassOutput classOutput = new ResourceClassOutput(true, this.generateSources);
        String generatedName = SETUP_PACKAGE + "." + name + COMPONENTS_PROVIDER_SUFFIX;
        ClassCreator componentsProvider = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{ComponentsProvider.class}).build();
        MethodCreator getComponents = (MethodCreator)componentsProvider.getMethodCreator("getComponents", Components.class, new Class[0]).setModifiers(1);
        Map<BeanInfo, List<BeanInfo>> beanToInjections = this.initBeanToInjections(beanDeployment);
        ResultHandle beanIdToBeanHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        this.processBeans(componentsProvider, getComponents, beanIdToBeanHandle, beanToInjections, beanToGeneratedName, beanDeployment);
        ResultHandle observersHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        this.processObservers(componentsProvider, getComponents, beanDeployment, beanIdToBeanHandle, observersHandle, observerToGeneratedName);
        ResultHandle contextsHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<ScopeInfo, Function<MethodCreator, ResultHandle>> entry : beanDeployment.getCustomContexts().entrySet()) {
            ResultHandle resultHandle = entry.getValue().apply(getComponents);
            getComponents.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, contextsHandle, new ResultHandle[]{resultHandle});
        }
        ResultHandle transitiveBindingsHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<DotName, Set<AnnotationInstance>> entry : beanDeployment.getTransitiveInterceptorBindings().entrySet()) {
            ResultHandle bindingsHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance annotationInstance : entry.getValue()) {
                ClassInfo bindingClass = beanDeployment.getInterceptorBinding(annotationInstance.name());
                getComponents.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.annotationLiterals.process((BytecodeCreator)getComponents, classOutput, bindingClass, annotationInstance, SETUP_PACKAGE)});
            }
            getComponents.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, transitiveBindingsHandle, new ResultHandle[]{getComponents.loadClass(entry.getKey().toString()), bindingsHandle});
        }
        ResultHandle resultHandle = getComponents.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"values", Collection.class, (Class[])new Class[0]), beanIdToBeanHandle, new ResultHandle[0]);
        ResultHandle resultHandle2 = getComponents.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
        if (this.detectUnusedFalsePositives) {
            this.processRemovedBeans(componentsProvider, getComponents, resultHandle2, beanDeployment, classOutput);
        }
        ResultHandle qualifiersNonbindingMembers = getComponents.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry entry : beanDeployment.getQualifierNonbindingMembers().entrySet()) {
            ResultHandle nonbindingMembers = getComponents.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (String member : (Set)entry.getValue()) {
                getComponents.invokeInterfaceMethod(MethodDescriptors.SET_ADD, nonbindingMembers, new ResultHandle[]{getComponents.load(member)});
            }
            getComponents.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, qualifiersNonbindingMembers, new ResultHandle[]{getComponents.load(((DotName)entry.getKey()).toString()), nonbindingMembers});
        }
        ResultHandle componentsHandle = getComponents.newInstance(MethodDescriptor.ofConstructor(Components.class, (Class[])new Class[]{Collection.class, Collection.class, Collection.class, Map.class, Collection.class, Map.class}), new ResultHandle[]{resultHandle, observersHandle, contextsHandle, transitiveBindingsHandle, resultHandle2, qualifiersNonbindingMembers});
        getComponents.returnValue(componentsHandle);
        componentsProvider.close();
        ArrayList<ResourceOutput.Resource> arrayList = new ArrayList<ResourceOutput.Resource>();
        for (ResourceOutput.Resource resource : classOutput.getResources()) {
            arrayList.add(resource);
            arrayList.add(ResourceImpl.serviceProvider(ComponentsProvider.class.getName(), resource.getName().replace('/', '.').getBytes(StandardCharsets.UTF_8), null));
        }
        return arrayList;
    }

    private void processBeans(ClassCreator componentsProvider, MethodCreator getComponents, ResultHandle beanIdToBeanHandle, Map<BeanInfo, List<BeanInfo>> beanToInjections, Map<BeanInfo, String> beanToGeneratedName, BeanDeployment beanDeployment) {
        HashSet<BeanInfo> processed = new HashSet<BeanInfo>();
        BeanAdder beanAdder = new BeanAdder(componentsProvider, getComponents, processed, beanIdToBeanHandle, beanToGeneratedName);
        boolean stuck = false;
        while (!beanToInjections.isEmpty()) {
            if (stuck) {
                throw new IllegalStateException("Circular dependencies not supported: \n" + beanToInjections.entrySet().stream().map(e -> "\t " + e.getKey() + " injected into: " + ((List)e.getValue()).stream().map(b -> b.getBeanClass().toString()).collect(Collectors.joining(", "))).collect(Collectors.joining("\n")));
            }
            stuck = true;
            stuck = this.addBeans(beanAdder, beanToInjections, processed, beanIdToBeanHandle, beanToGeneratedName, b -> !this.isDependency((BeanInfo)b, beanToInjections));
            if (!stuck || !(stuck = this.addBeans(beanAdder, beanToInjections, processed, beanIdToBeanHandle, beanToGeneratedName, b -> {
                if (b.isProducerField() || b.isProducerMethod()) {
                    return false;
                }
                return b.getScope().isNormal() || !this.isDependency((BeanInfo)b, beanToInjections);
            }))) continue;
            stuck = this.addBeans(beanAdder, beanToInjections, processed, beanIdToBeanHandle, beanToGeneratedName, b -> !this.isDependency((BeanInfo)b, beanToInjections) || b.getScope().isNormal());
        }
        for (BeanInfo beanInfo : beanDeployment.getBeans()) {
            if (processed.contains(beanInfo)) continue;
            beanAdder.addComponent(beanInfo);
        }
        for (BeanInfo beanInfo : beanDeployment.getInterceptors()) {
            if (processed.contains(beanInfo)) continue;
            beanAdder.addComponent(beanInfo);
        }
        beanAdder.close();
    }

    private void processObservers(ClassCreator componentsProvider, MethodCreator getComponents, BeanDeployment beanDeployment, ResultHandle beanIdToBeanHandle, ResultHandle observersHandle, Map<ObserverInfo, String> observerToGeneratedName) {
        try (ObserverAdder observerAdder = new ObserverAdder(componentsProvider, getComponents, observerToGeneratedName, beanIdToBeanHandle, observersHandle);){
            for (ObserverInfo observer : beanDeployment.getObservers()) {
                observerAdder.addComponent(observer);
            }
        }
    }

    private void processRemovedBeans(ClassCreator componentsProvider, MethodCreator getComponents, ResultHandle removedBeansHandle, BeanDeployment beanDeployment, ClassOutput classOutput) {
        try (RemovedBeanAdder removedBeanAdder = new RemovedBeanAdder(componentsProvider, getComponents, removedBeansHandle, classOutput);){
            for (BeanInfo remnovedBean : beanDeployment.getRemovedBeans()) {
                removedBeanAdder.addComponent(remnovedBean);
            }
        }
    }

    private Map<BeanInfo, List<BeanInfo>> initBeanToInjections(BeanDeployment beanDeployment) {
        HashMap<BeanInfo, List<BeanInfo>> beanToInjections = new HashMap<BeanInfo, List<BeanInfo>>();
        for (BeanInfo bean : beanDeployment.getBeans()) {
            if (bean.isProducerMethod() || bean.isProducerField()) {
                beanToInjections.computeIfAbsent(bean.getDeclaringBean(), d -> new ArrayList()).add(bean);
            }
            for (Injection injection : bean.getInjections()) {
                for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), d -> new ArrayList()).add(bean);
                }
            }
            if (bean.getDisposer() != null) {
                for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), d -> new ArrayList()).add(bean);
                }
            }
            for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                beanToInjections.computeIfAbsent(interceptor, d -> new ArrayList()).add(bean);
            }
        }
        for (InterceptorInfo interceptor : beanDeployment.getInterceptors()) {
            for (Injection injection : interceptor.getInjections()) {
                for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    beanToInjections.computeIfAbsent(injectionPoint.getResolvedBean(), d -> new ArrayList()).add(interceptor);
                }
            }
        }
        return beanToInjections;
    }

    private boolean addBeans(BeanAdder beanAdder, Map<BeanInfo, List<BeanInfo>> beanToInjections, Set<BeanInfo> processed, ResultHandle beanIdToBeanHandle, Map<BeanInfo, String> beanToGeneratedName, Predicate<BeanInfo> filter) {
        boolean stuck = true;
        Iterator<Map.Entry<BeanInfo, List<BeanInfo>>> iterator = beanToInjections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BeanInfo, List<BeanInfo>> entry = iterator.next();
            BeanInfo bean = entry.getKey();
            if (!filter.test(bean)) continue;
            iterator.remove();
            beanAdder.addComponent(bean);
            processed.add(bean);
            stuck = false;
        }
        return stuck;
    }

    private boolean isDependency(BeanInfo bean, Map<BeanInfo, List<BeanInfo>> beanToInjections) {
        for (Map.Entry<BeanInfo, List<BeanInfo>> entry : beanToInjections.entrySet()) {
            if (!entry.getValue().contains(bean)) continue;
            return true;
        }
        return false;
    }

    static abstract class ComponentAdder<T extends InjectionTargetInfo>
    implements AutoCloseable {
        private static final int GROUP_LIMIT = 30;
        protected int group = 1;
        private int componentsAdded;
        protected MethodCreator addMethod;
        protected final MethodCreator getComponentsMethod;
        protected final ClassCreator componentsProvider;

        public ComponentAdder(MethodCreator getComponentsMethod, ClassCreator componentsProvider) {
            this.getComponentsMethod = getComponentsMethod;
            this.componentsProvider = componentsProvider;
        }

        @Override
        public void close() {
            if (this.addMethod != null) {
                this.addMethod.returnValue(null);
            }
        }

        void addComponent(T component) {
            if (this.addMethod == null || this.componentsAdded >= 30) {
                if (this.addMethod != null) {
                    this.addMethod.returnValue(null);
                }
                this.componentsAdded = 0;
                this.addMethod = this.newAddMethod();
                this.invokeAddMethod();
            }
            ++this.componentsAdded;
            this.addComponentInternal(component);
        }

        abstract MethodCreator newAddMethod();

        abstract void invokeAddMethod();

        abstract void addComponentInternal(T var1);
    }

    static class BeanAdder
    extends ComponentAdder<BeanInfo> {
        private final Set<BeanInfo> processedBeans;
        private final ResultHandle beanIdToBeanHandle;
        private final Map<BeanInfo, String> beanToGeneratedName;

        public BeanAdder(ClassCreator componentsProvider, MethodCreator getComponentsMethod, Set<BeanInfo> processed, ResultHandle beanIdToBeanHandle, Map<BeanInfo, String> beanToGeneratedName) {
            super(getComponentsMethod, componentsProvider);
            this.processedBeans = processed;
            this.beanIdToBeanHandle = beanIdToBeanHandle;
            this.beanToGeneratedName = beanToGeneratedName;
        }

        @Override
        MethodCreator newAddMethod() {
            return (MethodCreator)this.componentsProvider.getMethodCreator(ComponentsProviderGenerator.ADD_BEANS + this.group++, Void.TYPE, new Class[]{Map.class}).setModifiers(2);
        }

        @Override
        void invokeAddMethod() {
            this.getComponentsMethod.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)this.componentsProvider.getClassName(), (String)this.addMethod.getMethodDescriptor().getName(), Void.TYPE, (Object[])new Object[]{Map.class}), this.getComponentsMethod.getThis(), new ResultHandle[]{this.beanIdToBeanHandle});
        }

        @Override
        void addComponentInternal(BeanInfo bean) {
            ResultHandle beanIdToBeanHandle = this.addMethod.getMethodParam(0);
            String beanType = this.beanToGeneratedName.get(bean);
            if (beanType == null) {
                throw new IllegalStateException("No bean type found for: " + bean);
            }
            List injectionPoints = bean.getInjections().stream().flatMap(i -> i.injectionPoints.stream()).filter(ip -> !BuiltinBean.resolvesTo(ip)).collect(Collectors.toList());
            ArrayList<ResultHandle> params = new ArrayList<ResultHandle>();
            ArrayList<String> paramTypes = new ArrayList<String>();
            if (bean.isProducerMethod() || bean.isProducerField()) {
                if (!this.processedBeans.contains(bean.getDeclaringBean())) {
                    throw new IllegalStateException("Declaring bean of a producer bean is not available - most probably an unsupported circular dependency use case \n - declaring bean: " + bean.getDeclaringBean() + "\n - producer bean: " + bean);
                }
                params.add(this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addMethod.load(bean.getDeclaringBean().getIdentifier())}));
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            for (InjectionPointInfo injectionPoint : injectionPoints) {
                if (this.processedBeans.contains(injectionPoint.getResolvedBean())) {
                    params.add(this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                } else {
                    params.add(this.addMethod.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanHandle, this.addMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                }
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            if (bean.getDisposer() != null) {
                for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                    if (BuiltinBean.resolvesTo(injectionPoint)) continue;
                    params.add(this.addMethod.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanHandle, this.addMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                    paramTypes.add(Type.getDescriptor(Supplier.class));
                }
            }
            for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                if (this.processedBeans.contains(interceptor)) {
                    params.add(this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addMethod.load(interceptor.getIdentifier())}));
                } else {
                    params.add(this.addMethod.newInstance(MethodDescriptors.MAP_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{beanIdToBeanHandle, this.addMethod.load(interceptor.getIdentifier())}));
                }
                paramTypes.add(Type.getDescriptor(Supplier.class));
            }
            ResultHandle beanInstance = this.addMethod.newInstance(MethodDescriptor.ofConstructor((String)beanType, (String[])paramTypes.toArray(new String[0])), params.toArray(new ResultHandle[0]));
            ResultHandle beanIdHandle = this.addMethod.load(bean.getIdentifier());
            this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, beanIdToBeanHandle, new ResultHandle[]{beanIdHandle, beanInstance});
        }
    }

    class RemovedBeanAdder
    extends ComponentAdder<BeanInfo> {
        private final ResultHandle removedBeansHandle;
        private final ClassOutput classOutput;
        private ResultHandle tccl;

        public RemovedBeanAdder(ClassCreator componentsProvider, MethodCreator getComponentsMethod, ResultHandle removedBeansHandle, ClassOutput classOutput) {
            super(getComponentsMethod, componentsProvider);
            this.removedBeansHandle = removedBeansHandle;
            this.classOutput = classOutput;
        }

        @Override
        MethodCreator newAddMethod() {
            MethodCreator addMethod = (MethodCreator)this.componentsProvider.getMethodCreator(ComponentsProviderGenerator.ADD_REMOVED_BEANS + this.group++, Void.TYPE, new Class[]{List.class}).setModifiers(2);
            ResultHandle currentThread = addMethod.invokeStaticMethod(MethodDescriptors.THREAD_CURRENT_THREAD, new ResultHandle[0]);
            this.tccl = addMethod.invokeVirtualMethod(MethodDescriptors.THREAD_GET_TCCL, currentThread, new ResultHandle[0]);
            return addMethod;
        }

        @Override
        void invokeAddMethod() {
            this.getComponentsMethod.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)this.componentsProvider.getClassName(), (String)this.addMethod.getMethodDescriptor().getName(), Void.TYPE, (Object[])new Object[]{List.class}), this.getComponentsMethod.getThis(), new ResultHandle[]{this.removedBeansHandle});
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void addComponentInternal(BeanInfo removedBean) {
            void var5_12;
            ResultHandle qualifiersHandle;
            ResultHandle removedBeansHandle = this.addMethod.getMethodParam(0);
            ResultHandle typesHandle = this.addMethod.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (org.jboss.jandex.Type type : removedBean.getTypes()) {
                ResultHandle typeHandle;
                if (DotNames.OBJECT.equals((Object)type.name())) continue;
                try {
                    typeHandle = Types.getTypeHandle((BytecodeCreator)this.addMethod, type, this.tccl);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Unable to construct the type handle for " + removedBean + ": " + e.getMessage());
                }
                this.addMethod.invokeInterfaceMethod(MethodDescriptors.SET_ADD, typesHandle, new ResultHandle[]{typeHandle});
            }
            if (!removedBean.getQualifiers().isEmpty() && !removedBean.hasDefaultQualifiers()) {
                qualifiersHandle = this.addMethod.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
                for (AnnotationInstance qualifierAnnotation : removedBean.getQualifiers()) {
                    if (DotNames.ANY.equals((Object)qualifierAnnotation.name())) continue;
                    BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                    if (qualifier != null) {
                        this.addMethod.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiersHandle, new ResultHandle[]{qualifier.getLiteralInstance((BytecodeCreator)this.addMethod)});
                        continue;
                    }
                    ClassInfo qualifierClass = removedBean.getDeployment().getQualifier(qualifierAnnotation.name());
                    this.addMethod.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiersHandle, new ResultHandle[]{ComponentsProviderGenerator.this.annotationLiterals.process((BytecodeCreator)this.addMethod, this.classOutput, qualifierClass, qualifierAnnotation, Types.getPackageName(this.componentsProvider.getClassName()))});
                }
                qualifiersHandle = this.addMethod.invokeStaticMethod(MethodDescriptors.COLLECTIONS_UNMODIFIABLE_SET, new ResultHandle[]{qualifiersHandle});
            } else {
                qualifiersHandle = this.addMethod.loadNull();
            }
            String description = null;
            if (removedBean.isClassBean()) {
                Object var5_8 = null;
                description = removedBean.getTarget().get().toString();
            } else if (removedBean.isProducerField()) {
                InjectableBean.Kind kind = InjectableBean.Kind.PRODUCER_FIELD;
                description = removedBean.getTarget().get().asField().declaringClass().name() + "#" + removedBean.getTarget().get().asField().name();
            } else if (removedBean.isProducerMethod()) {
                InjectableBean.Kind kind = InjectableBean.Kind.PRODUCER_METHOD;
                description = removedBean.getTarget().get().asMethod().declaringClass().name() + "#" + removedBean.getTarget().get().asMethod().name() + "()";
            } else {
                InjectableBean.Kind kind = InjectableBean.Kind.SYNTHETIC;
            }
            ResultHandle kindHandle = var5_12 != null ? this.addMethod.readStaticField(FieldDescriptor.of(InjectableBean.Kind.class, (String)var5_12.toString(), InjectableBean.Kind.class)) : this.addMethod.loadNull();
            ResultHandle removedBeanHandle = this.addMethod.newInstance(MethodDescriptors.REMOVED_BEAN_IMPL, new ResultHandle[]{kindHandle, description != null ? this.addMethod.load(description) : this.addMethod.loadNull(), typesHandle, qualifiersHandle});
            this.addMethod.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, removedBeansHandle, new ResultHandle[]{removedBeanHandle});
        }
    }

    static class ObserverAdder
    extends ComponentAdder<ObserverInfo> {
        private final Map<ObserverInfo, String> observerToGeneratedName;
        private final ResultHandle beanIdToBeanHandle;
        private final ResultHandle observersHandle;

        ObserverAdder(ClassCreator componentsProvider, MethodCreator getComponentsMethod, Map<ObserverInfo, String> observerToGeneratedName, ResultHandle beanIdToBeanHandle, ResultHandle observersHandle) {
            super(getComponentsMethod, componentsProvider);
            this.observerToGeneratedName = observerToGeneratedName;
            this.beanIdToBeanHandle = beanIdToBeanHandle;
            this.observersHandle = observersHandle;
        }

        @Override
        MethodCreator newAddMethod() {
            return (MethodCreator)this.componentsProvider.getMethodCreator(ComponentsProviderGenerator.ADD_OBSERVERS + this.group++, Void.TYPE, new Class[]{Map.class, List.class}).setModifiers(2);
        }

        @Override
        void invokeAddMethod() {
            this.getComponentsMethod.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)this.componentsProvider.getClassName(), (String)this.addMethod.getMethodDescriptor().getName(), Void.TYPE, (Object[])new Object[]{Map.class, List.class}), this.getComponentsMethod.getThis(), new ResultHandle[]{this.beanIdToBeanHandle, this.observersHandle});
        }

        @Override
        void addComponentInternal(ObserverInfo observer) {
            ResultHandle beanIdToBeanHandle = this.addMethod.getMethodParam(0);
            ResultHandle observersHandle = this.addMethod.getMethodParam(1);
            String observerType = this.observerToGeneratedName.get(observer);
            ArrayList<ResultHandle> params = new ArrayList<ResultHandle>();
            ArrayList<String> paramTypes = new ArrayList<String>();
            if (!observer.isSynthetic()) {
                List injectionPoints = observer.getInjection().injectionPoints.stream().filter(ip -> !BuiltinBean.resolvesTo(ip)).collect(Collectors.toList());
                params.add(this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addMethod.load(observer.getDeclaringBean().getIdentifier())}));
                paramTypes.add(Type.getDescriptor(Supplier.class));
                for (InjectionPointInfo injectionPoint : injectionPoints) {
                    params.add(this.addMethod.invokeInterfaceMethod(MethodDescriptors.MAP_GET, beanIdToBeanHandle, new ResultHandle[]{this.addMethod.load(injectionPoint.getResolvedBean().getIdentifier())}));
                    paramTypes.add(Type.getDescriptor(Supplier.class));
                }
            }
            ResultHandle observerInstance = this.addMethod.newInstance(MethodDescriptor.ofConstructor((String)observerType, (String[])paramTypes.toArray(new String[0])), params.toArray(new ResultHandle[0]));
            this.addMethod.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, observersHandle, new ResultHandle[]{observerInstance});
        }
    }
}

