/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.MethodDescriptor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.DeploymentException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

final class Methods {
    private static final Logger LOGGER = Logger.getLogger(Methods.class);
    public static final String INIT = "<init>";
    public static final String CLINIT = "<clinit>";
    static final int BRIDGE = 64;
    public static final String TO_STRING = "toString";
    private static final List<String> IGNORED_METHODS = Methods.initIgnoredMethods();

    private static List<String> initIgnoredMethods() {
        ArrayList<String> ignored = new ArrayList<String>();
        ignored.add(INIT);
        ignored.add(CLINIT);
        return ignored;
    }

    private Methods() {
    }

    static boolean isBridge(MethodInfo method) {
        return (method.flags() & 0x40) != 0;
    }

    static void addDelegatingMethods(IndexView index, ClassInfo classInfo, Map<MethodKey, MethodInfo> methods, Map<String, Set<NameAndDescriptor>> methodsFromWhichToRemoveFinal, boolean transformUnproxyableClasses) {
        if (classInfo != null) {
            ClassInfo superClassInfo;
            for (MethodInfo method : classInfo.methods()) {
                if (Methods.skipForClientProxy(method, transformUnproxyableClasses, methodsFromWhichToRemoveFinal)) continue;
                methods.computeIfAbsent(new MethodKey(method), key -> {
                    Type returnType = key.method.returnType();
                    Type[] params = new Type[key.method.parameters().size()];
                    for (int i = 0; i < params.length; ++i) {
                        params[i] = (Type)key.method.parameters().get(i);
                    }
                    List typeVariables = key.method.typeParameters();
                    return MethodInfo.create((ClassInfo)classInfo, (String)key.method.name(), (Type[])params, (Type)returnType, (short)key.method.flags(), (TypeVariable[])typeVariables.toArray(new TypeVariable[0]), (Type[])key.method.exceptions().toArray(Type.EMPTY_ARRAY));
                });
            }
            if (classInfo.superClassType() != null && (superClassInfo = IndexClassLookupUtils.getClassByName(index, classInfo.superName())) != null) {
                Methods.addDelegatingMethods(index, superClassInfo, methods, methodsFromWhichToRemoveFinal, transformUnproxyableClasses);
            }
            for (DotName interfaceName : classInfo.interfaceNames()) {
                ClassInfo interfaceClassInfo = IndexClassLookupUtils.getClassByName(index, interfaceName);
                if (interfaceClassInfo == null) continue;
                Methods.addDelegatingMethods(index, interfaceClassInfo, methods, methodsFromWhichToRemoveFinal, transformUnproxyableClasses);
            }
        }
    }

    private static boolean skipForClientProxy(MethodInfo method, boolean transformUnproxyableClasses, Map<String, Set<NameAndDescriptor>> methodsFromWhichToRemoveFinal) {
        if (Modifier.isStatic(method.flags()) || Modifier.isPrivate(method.flags())) {
            return true;
        }
        if (IGNORED_METHODS.contains(method.name())) {
            return true;
        }
        if (method.declaringClass().name().equals((Object)DotNames.OBJECT) && !method.name().equals(TO_STRING)) {
            return true;
        }
        if (Modifier.isFinal(method.flags())) {
            String className = method.declaringClass().name().toString();
            if (!className.startsWith("java.")) {
                if (transformUnproxyableClasses && methodsFromWhichToRemoveFinal != null) {
                    methodsFromWhichToRemoveFinal.computeIfAbsent(className, k -> new HashSet()).add(NameAndDescriptor.fromMethodInfo(method));
                    return false;
                }
                LOGGER.warn((Object)String.format("Final method %s.%s() is ignored during proxy generation and should never be invoked upon the proxy instance!", className, method.name()));
            }
            return true;
        }
        return false;
    }

    static boolean skipForDelegateSubclass(MethodInfo method) {
        if (Modifier.isStatic(method.flags())) {
            return true;
        }
        if (IGNORED_METHODS.contains(method.name())) {
            return true;
        }
        return method.declaringClass().name().equals((Object)DotNames.OBJECT);
    }

    static boolean isObjectToString(MethodInfo method) {
        return method.declaringClass().name().equals((Object)DotNames.OBJECT) && method.name().equals(TO_STRING);
    }

    static Set<MethodInfo> addInterceptedMethodCandidates(BeanDeployment beanDeployment, ClassInfo classInfo, Map<MethodKey, Set<AnnotationInstance>> candidates, List<AnnotationInstance> classLevelBindings, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        return Methods.addInterceptedMethodCandidates(beanDeployment, classInfo, classInfo, candidates, Set.copyOf(classLevelBindings), bytecodeTransformerConsumer, transformUnproxyableClasses, new SubclassSkipPredicate(beanDeployment.getAssignabilityCheck()::isAssignableFrom, beanDeployment.getBeanArchiveIndex()), false);
    }

    static Set<MethodInfo> addInterceptedMethodCandidates(BeanDeployment beanDeployment, ClassInfo classInfo, ClassInfo originalClassInfo, Map<MethodKey, Set<AnnotationInstance>> candidates, Set<AnnotationInstance> classLevelBindings, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses, SubclassSkipPredicate skipPredicate, boolean ignoreMethodLevelBindings) {
        ClassInfo superClassInfo;
        HashSet<NameAndDescriptor> methodsFromWhichToRemoveFinal = new HashSet<NameAndDescriptor>();
        HashSet<MethodInfo> finalMethodsFoundAndNotChanged = new HashSet<MethodInfo>();
        skipPredicate.startProcessing(classInfo, originalClassInfo);
        for (MethodInfo method : classInfo.methods()) {
            Set<AnnotationInstance> merged = Methods.mergeBindings(beanDeployment, originalClassInfo, classLevelBindings, ignoreMethodLevelBindings, method);
            if (merged.isEmpty() || skipPredicate.test(method)) continue;
            boolean addToCandidates = true;
            if (Modifier.isFinal(method.flags())) {
                if (transformUnproxyableClasses) {
                    methodsFromWhichToRemoveFinal.add(NameAndDescriptor.fromMethodInfo(method));
                } else {
                    addToCandidates = false;
                    finalMethodsFoundAndNotChanged.add(method);
                }
            }
            if (!addToCandidates) continue;
            candidates.computeIfAbsent(new MethodKey(method), key -> merged);
        }
        skipPredicate.methodsProcessed();
        if (!methodsFromWhichToRemoveFinal.isEmpty()) {
            bytecodeTransformerConsumer.accept(new BytecodeTransformer(classInfo.name().toString(), new RemoveFinalFromMethod(classInfo.name().toString(), methodsFromWhichToRemoveFinal)));
        }
        if (!classInfo.superName().equals((Object)DotNames.OBJECT) && (superClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), classInfo.superName())) != null) {
            finalMethodsFoundAndNotChanged.addAll(Methods.addInterceptedMethodCandidates(beanDeployment, superClassInfo, classInfo, candidates, classLevelBindings, bytecodeTransformerConsumer, transformUnproxyableClasses, skipPredicate, ignoreMethodLevelBindings));
        }
        for (DotName i : classInfo.interfaceNames()) {
            ClassInfo interfaceInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), i);
            if (interfaceInfo == null) continue;
            Methods.addInterceptedMethodCandidates(beanDeployment, interfaceInfo, originalClassInfo, candidates, classLevelBindings, bytecodeTransformerConsumer, transformUnproxyableClasses, skipPredicate, true);
        }
        return finalMethodsFoundAndNotChanged;
    }

    /*
     * WARNING - void declaration
     */
    private static Set<AnnotationInstance> mergeBindings(BeanDeployment beanDeployment, ClassInfo classInfo, Set<AnnotationInstance> classLevelBindings, boolean ignoreMethodLevelBindings, MethodInfo method) {
        Set<Object> merged;
        if (beanDeployment.getAnnotation((AnnotationTarget)method, DotNames.NO_CLASS_INTERCEPTORS) != null) {
            classLevelBindings = Set.of();
        }
        if (ignoreMethodLevelBindings) {
            return classLevelBindings;
        }
        Collection<AnnotationInstance> methodAnnotations = beanDeployment.getAnnotations((AnnotationTarget)method);
        if (methodAnnotations.isEmpty()) {
            return classLevelBindings;
        }
        ArrayList<AnnotationInstance> methodLevelBindings = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance annotationInstance : methodAnnotations) {
            methodLevelBindings.addAll(beanDeployment.extractInterceptorBindings(annotationInstance));
        }
        if (methodLevelBindings.isEmpty()) {
            merged = classLevelBindings;
        } else {
            merged = new HashSet<AnnotationInstance>(methodLevelBindings);
            for (AnnotationInstance annotationInstance : classLevelBindings) {
                if (!methodLevelBindings.stream().noneMatch(a -> binding.name().equals((Object)a.name()))) continue;
                merged.add(annotationInstance);
            }
            if (Modifier.isPrivate(method.flags()) && !Annotations.contains(methodAnnotations, DotNames.PRODUCES) && !Annotations.contains(methodAnnotations, DotNames.OBSERVES) && !Annotations.contains(methodAnnotations, DotNames.OBSERVES_ASYNC)) {
                void var8_12;
                if (methodLevelBindings.size() == 1) {
                    String string = String.format("%s will have no effect on method %s.%s() because the method is private", methodLevelBindings.iterator().next(), classInfo.name(), method.name());
                } else {
                    String string = String.format("Annotations %s will have no effect on method %s.%s() because the method is private", methodLevelBindings.stream().map(AnnotationInstance::toString).collect(Collectors.joining(",")), classInfo.name(), method.name());
                }
                if (beanDeployment.failOnInterceptedPrivateMethod) {
                    throw new DeploymentException((String)var8_12);
                }
                LOGGER.warn((Object)var8_12);
            }
        }
        return merged;
    }

    static boolean isOverriden(MethodInfo method, Collection<MethodInfo> previousMethods) {
        for (MethodInfo other : previousMethods) {
            if (!Methods.matchesSignature(method, other)) continue;
            return true;
        }
        return false;
    }

    static boolean isOverriden(MethodKey method, Collection<MethodKey> previousMethods) {
        return previousMethods.contains(method);
    }

    static boolean matchesSignature(MethodInfo method, MethodInfo subclassMethod) {
        if (!method.name().equals(subclassMethod.name())) {
            return false;
        }
        List parameters = method.parameters();
        List subParameters = subclassMethod.parameters();
        int paramCount = parameters.size();
        if (paramCount != subParameters.size()) {
            return false;
        }
        if (paramCount == 0) {
            return true;
        }
        for (int i = 0; i < paramCount; ++i) {
            if (Methods.isTypeEqual((Type)parameters.get(i), (Type)subParameters.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isTypeEqual(Type a, Type b) {
        return Methods.toRawType(a).equals((Object)Methods.toRawType(b));
    }

    static DotName toRawType(Type a) {
        switch (a.kind()) {
            case CLASS: 
            case PRIMITIVE: 
            case ARRAY: {
                return a.name();
            }
            case PARAMETERIZED_TYPE: {
                return a.asParameterizedType().name();
            }
        }
        return DotNames.OBJECT;
    }

    static void addDelegateTypeMethods(IndexView index, ClassInfo delegateTypeClass, Set<MethodKey> methods) {
        if (delegateTypeClass != null) {
            ClassInfo superClassInfo;
            for (MethodInfo method : delegateTypeClass.methods()) {
                if (Methods.skipForDelegateSubclass(method)) continue;
                methods.add(new MethodKey(method));
            }
            for (Type interfaceType : delegateTypeClass.interfaceTypes()) {
                ClassInfo interfaceClassInfo = IndexClassLookupUtils.getClassByName(index, interfaceType.name());
                if (interfaceClassInfo == null) continue;
                Methods.addDelegateTypeMethods(index, interfaceClassInfo, methods);
            }
            if (delegateTypeClass.superClassType() != null && (superClassInfo = IndexClassLookupUtils.getClassByName(index, delegateTypeClass.superName())) != null) {
                Methods.addDelegateTypeMethods(index, superClassInfo, methods);
            }
        }
    }

    static boolean containsTypeVariableParameter(MethodInfo method) {
        for (Type param : method.parameters()) {
            if (!Types.containsTypeVariable(param)) continue;
            return true;
        }
        return false;
    }

    static boolean descriptorMatches(MethodDescriptor d1, MethodDescriptor d2) {
        return d1.getName().equals(d2.getName()) && d1.getDescriptor().equals(d2.getDescriptor());
    }

    static class SubclassSkipPredicate
    implements Predicate<MethodInfo> {
        private final BiFunction<Type, Type, Boolean> assignableFromFun;
        private final IndexView beanArchiveIndex;
        private ClassInfo clazz;
        private ClassInfo originalClazz;
        private List<MethodInfo> regularMethods;
        private Set<MethodInfo> bridgeMethods = new HashSet<MethodInfo>();

        public SubclassSkipPredicate(BiFunction<Type, Type, Boolean> assignableFromFun, IndexView beanArchiveIndex) {
            this.assignableFromFun = assignableFromFun;
            this.beanArchiveIndex = beanArchiveIndex;
        }

        void startProcessing(ClassInfo clazz, ClassInfo originalClazz) {
            this.clazz = clazz;
            this.originalClazz = originalClazz;
            this.regularMethods = new ArrayList<MethodInfo>();
            for (MethodInfo method : clazz.methods()) {
                if (Modifier.isAbstract(method.flags()) || method.isSynthetic() || Methods.isBridge(method)) continue;
                this.regularMethods.add(method);
            }
        }

        void methodsProcessed() {
            for (MethodInfo method : this.clazz.methods()) {
                if (!Methods.isBridge(method)) continue;
                this.bridgeMethods.add(method);
            }
        }

        @Override
        public boolean test(MethodInfo method) {
            if (Methods.isBridge(method)) {
                return this.hasImplementation(method);
            }
            if (method.hasAnnotation(DotNames.POST_CONSTRUCT) || method.hasAnnotation(DotNames.PRE_DESTROY)) {
                return true;
            }
            if (this.isOverridenByBridgeMethod(method)) {
                return true;
            }
            if (Modifier.isStatic(method.flags())) {
                return true;
            }
            if (IGNORED_METHODS.contains(method.name())) {
                return true;
            }
            if (method.declaringClass().name().equals((Object)DotNames.OBJECT)) {
                return true;
            }
            if (Modifier.isInterface(this.clazz.flags()) && Modifier.isInterface(method.declaringClass().flags()) && Modifier.isPublic(method.flags()) && !Modifier.isAbstract(method.flags()) && !Modifier.isStatic(method.flags())) {
                return false;
            }
            List parameters = method.parameters();
            if (!parameters.isEmpty() && this.beanArchiveIndex != null) {
                String originalClassPackage = DotNames.packageName(this.originalClazz.name());
                for (Type type : parameters) {
                    ClassInfo param;
                    if (type.kind() == Type.Kind.PRIMITIVE) continue;
                    DotName typeName = type.name();
                    if (type.kind() == Type.Kind.ARRAY) {
                        Type componentType = type.asArrayType().component();
                        if (componentType.kind() == Type.Kind.PRIMITIVE) continue;
                        typeName = componentType.name();
                    }
                    if ((param = this.beanArchiveIndex.getClassByName(typeName)) == null) {
                        LOGGER.warn((Object)String.format("Parameter type info not available: %s - unable to validate the parameter type's visibility for method %s declared on %s", type.name(), method.name(), method.declaringClass().name()));
                        continue;
                    }
                    if (Modifier.isPublic(param.flags()) || Modifier.isProtected(param.flags()) || DotNames.packageName(param.name()).equals(originalClassPackage)) continue;
                    LOGGER.warn((Object)String.format("A method %s() declared on %s has a non-public parameter of type %s which prevents it from being intercepted. Please change the parameter type visibility in order to make it intercepted.", method.name(), method.declaringClass().name(), type));
                    return true;
                }
            }
            return false;
        }

        private boolean hasImplementation(MethodInfo bridge) {
            for (MethodInfo declaredMethod : this.regularMethods) {
                if (!bridge.name().equals(declaredMethod.name())) continue;
                List params = declaredMethod.parameters();
                List bridgeParams = bridge.parameters();
                if (params.size() != bridgeParams.size()) continue;
                boolean paramsNotMatching = false;
                for (int i = 0; i < bridgeParams.size(); ++i) {
                    Type param;
                    Type bridgeParam = (Type)bridgeParams.get(i);
                    if (this.assignableFromFun.apply(bridgeParam, param = (Type)params.get(i)).booleanValue()) continue;
                    paramsNotMatching = true;
                    break;
                }
                if (paramsNotMatching) continue;
                if (!Modifier.isInterface(this.clazz.flags())) {
                    if (bridge.returnType().name().equals((Object)DotNames.OBJECT) || Modifier.isAbstract(declaredMethod.flags())) {
                        return true;
                    }
                    return this.assignableFromFun.apply(bridge.returnType(), declaredMethod.returnType());
                }
                return true;
            }
            return false;
        }

        private boolean isOverridenByBridgeMethod(MethodInfo method) {
            for (MethodInfo bridge : this.bridgeMethods) {
                if (!method.name().equals(bridge.name()) || !this.parametersMatch(method, bridge)) continue;
                if (Modifier.isInterface(this.clazz.flags())) {
                    return true;
                }
                if (bridge.returnType().name().equals((Object)DotNames.OBJECT) || Modifier.isAbstract(method.flags())) {
                    return true;
                }
                if (bridge.returnType().kind() == Type.Kind.CLASS && method.returnType().kind() == Type.Kind.TYPE_VARIABLE) {
                    return true;
                }
                return bridge.returnType().equals((Object)method.returnType());
            }
            return false;
        }

        private boolean parametersMatch(MethodInfo method, MethodInfo bridge) {
            List params = method.parameters();
            List bridgeParams = bridge.parameters();
            if (bridgeParams.size() != params.size()) {
                return false;
            }
            for (int i = 0; i < params.size(); ++i) {
                Type param = (Type)params.get(i);
                Type bridgeParam = (Type)bridgeParams.get(i);
                if (bridgeParam.name().equals((Object)param.name())) continue;
                return false;
            }
            return true;
        }
    }

    static class RemoveFinalFromMethod
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        private final String classToTransform;
        private final Set<NameAndDescriptor> methodsFromWhichToRemoveFinal;

        public RemoveFinalFromMethod(String classToTransform, Set<NameAndDescriptor> methodsFromWhichToRemoveFinal) {
            this.classToTransform = classToTransform;
            this.methodsFromWhichToRemoveFinal = methodsFromWhichToRemoveFinal;
        }

        @Override
        public ClassVisitor apply(String s, ClassVisitor classVisitor) {
            return new ClassVisitor(589824, classVisitor){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    if (methodsFromWhichToRemoveFinal.contains(new NameAndDescriptor(name, descriptor))) {
                        access &= 0xFFFFFFEF;
                        LOGGER.debug((Object)("final modifier removed from method " + name + " of class " + classToTransform));
                    }
                    return super.visitMethod(access, name, descriptor, signature, exceptions);
                }
            };
        }
    }

    static class MethodKey {
        final String name;
        final List<DotName> params;
        final DotName returnType;
        final MethodInfo method;

        public MethodKey(MethodInfo method) {
            this.method = Objects.requireNonNull(method, "Method must not be null");
            this.name = method.name();
            this.returnType = method.returnType().name();
            this.params = new ArrayList<DotName>();
            for (Type i : method.parameters()) {
                this.params.add(i.name());
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.params.hashCode();
            result = 31 * result + this.returnType.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (!this.params.equals(other.params)) {
                return false;
            }
            return this.returnType.equals((Object)other.returnType);
        }
    }

    static class NameAndDescriptor {
        private final String name;
        private final String descriptor;

        public NameAndDescriptor(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public static NameAndDescriptor fromMethodInfo(MethodInfo method) {
            String returnTypeDesc = DescriptorUtils.objectToDescriptor((Object)method.returnType().name().toString());
            String[] paramTypesDesc = new String[method.parameters().size()];
            for (int i = 0; i < method.parameters().size(); ++i) {
                paramTypesDesc[i] = DescriptorUtils.objectToDescriptor((Object)((Type)method.parameters().get(i)).name().toString());
            }
            return new NameAndDescriptor(method.name(), DescriptorUtils.methodSignatureToDescriptor((String)returnTypeDesc, (String[])paramTypesDesc));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameAndDescriptor that = (NameAndDescriptor)o;
            return this.name.equals(that.name) && this.descriptor.equals(that.descriptor);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.descriptor);
        }
    }
}

