/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.constraint;

import io.smallrye.common.constraint.Messages;
import io.smallrye.common.constraint.NotNull;
import java.util.Collection;
import java.util.Map;

public final class Assert {
    private Assert() {
    }

    @NotNull
    public static <T> T checkNotNullParam(String name, T value) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked(name, value);
        return value;
    }

    private static <T> void checkNotNullParamChecked(String name, T value) {
        if (value == null) {
            throw Messages.log.nullParam(name);
        }
    }

    @NotNull
    public static <T> T checkNotNullArrayParam(String name, int index, T value) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (value == null) {
            throw Messages.log.nullArrayParam(index, name);
        }
        return value;
    }

    @NotNull
    public static String checkNotEmptyParam(String name, String value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.isEmpty()) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static CharSequence checkNotEmptyParam(String name, CharSequence value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length() == 0) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static <E, T extends Collection<E>> T checkNotEmptyParam(String name, T value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.isEmpty()) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static <K, V, T extends Map<K, V>> T checkNotEmptyParam(String name, T value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.isEmpty()) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static <T> T[] checkNotEmptyParam(String name, T[] value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static boolean[] checkNotEmptyParam(String name, boolean[] value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static byte[] checkNotEmptyParam(String name, byte[] value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static short[] checkNotEmptyParam(String name, short[] value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static int[] checkNotEmptyParam(String name, int[] value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static long[] checkNotEmptyParam(String name, long[] value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static float[] checkNotEmptyParam(String name, float[] value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static double[] checkNotEmptyParam(String name, double[] value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.length == 0) {
            throw Messages.log.emptyParam(name);
        }
        return value;
    }

    public static <T extends Comparable<T>> void checkMinimumParameter(String name, T min, T actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual.compareTo(min) < 0) {
            throw Messages.log.paramLessThan(name, min);
        }
    }

    public static void checkMinimumParameter(String name, int min, int actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual < min) {
            throw Messages.log.paramLessThan(name, min);
        }
    }

    public static void checkMinimumParameter(String name, long min, long actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual < min) {
            throw Messages.log.paramLessThan(name, min);
        }
    }

    public static void checkMinimumParameter(String name, float min, float actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual < min) {
            throw Messages.log.paramLessThan(name, min);
        }
    }

    public static void checkMinimumParameter(String name, double min, double actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual < min) {
            throw Messages.log.paramLessThan(name, min);
        }
    }

    public static <T extends Comparable<T>> void checkMaximumParameter(String name, T max, T actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual.compareTo(max) > 0) {
            throw Messages.log.paramGreaterThan(name, max);
        }
    }

    public static void checkMaximumParameter(String name, int max, int actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual > max) {
            throw Messages.log.paramGreaterThan(name, max);
        }
    }

    public static void checkMaximumParameter(String name, long max, long actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual > max) {
            throw Messages.log.paramGreaterThan(name, max);
        }
    }

    public static void checkMaximumParameter(String name, float max, float actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual > max) {
            throw Messages.log.paramGreaterThan(name, max);
        }
    }

    public static void checkMaximumParameter(String name, double max, double actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual > max) {
            throw Messages.log.paramGreaterThan(name, max);
        }
    }

    public static void checkArrayBounds(Object[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(byte[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(char[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(int[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(long[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(int arrayLength, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkMinimumParameter("offs", 0, offs);
        Assert.checkMinimumParameter("len", 0, len);
        if (offs > arrayLength) {
            throw Messages.log.arrayOffsetGreaterThanLength(offs, arrayLength);
        }
        if (offs + len > arrayLength) {
            throw Messages.log.arrayOffsetLengthGreaterThanLength(offs, len, arrayLength);
        }
    }

    @NotNull
    public static <T> T assertNotNull(T value) {
        assert (value != null) : Messages.log.unexpectedNullValue();
        return value;
    }

    @NotNull
    public static <T> T assertHoldsLock(@NotNull T monitor) {
        assert (Thread.holdsLock(Assert.checkNotNullParam("monitor", monitor))) : Messages.log.expectedLockHold(monitor);
        return monitor;
    }

    @NotNull
    public static <T> T assertNotHoldsLock(@NotNull T monitor) {
        assert (!Thread.holdsLock(Assert.checkNotNullParam("monitor", monitor))) : Messages.log.expectedLockNotHold(monitor);
        return monitor;
    }

    public static boolean assertTrue(boolean expr) {
        assert (expr) : Messages.log.expectedBoolean(true);
        return expr;
    }

    public static boolean assertFalse(boolean expr) {
        assert (!expr) : Messages.log.expectedBoolean(false);
        return expr;
    }

    public static IllegalStateException unreachableCode() {
        return Messages.log.unreachableCode();
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(@NotNull Object obj) {
        Assert.checkNotNullParamChecked("obj", obj);
        return Messages.log.impossibleSwitchCase(obj);
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(char val) {
        return Messages.log.impossibleSwitchCase(Character.valueOf(val));
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(int val) {
        return Messages.log.impossibleSwitchCase(val);
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(long val) {
        return Messages.log.impossibleSwitchCase(val);
    }

    @NotNull
    public static UnsupportedOperationException unsupported() {
        StackTraceElement element = new Throwable().getStackTrace()[1];
        return Messages.log.unsupported(element.getMethodName(), element.getClassName());
    }
}

