/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.utils.ModelUtils;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EiffelClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    static Logger LOGGER = LoggerFactory.getLogger(EiffelClientCodegen.class);
    protected String libraryTarget = "swagger_eiffel_client";
    protected String packageName = "Eiffel";
    protected String packageVersion = "1.0.0";
    protected String apiDocPath = "docs";
    protected String modelDocPath = "docs";
    protected String modelPath = "domain";
    protected UUID uuid;
    protected UUID uuidTest;
    private final Set<String> parentModels = new HashSet<String>();
    private final Multimap<String, CodegenModel> childrenByParent = ArrayListMultimap.create();

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "eiffel";
    }

    @Override
    public String getHelp() {
        return "Generates a Eiffel client library (beta).";
    }

    public EiffelClientCodegen() {
        this.uuid = UUID.randomUUID();
        this.uuidTest = UUID.randomUUID();
        this.outputFolder = "generated-code/Eiffel";
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.modelTemplateFiles.put("model.mustache", ".e");
        this.apiTemplateFiles.put("api.mustache", ".e");
        this.apiTestTemplateFiles.put("test/api_test.mustache", ".e");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "Eiffel";
        this.embeddedTemplateDir = "Eiffel";
        this.setReservedWordsLowerCase(Arrays.asList("across", "agent", "alias", "all", "and", "as", "assign", "attribute", "check", "class", "convert", "create", "Current", "debug", "deferred", "do", "else", "elseif", "end", "ensure", "expanded", "export", "external", "False", "feature", "from", "frozen", "if", "implies", "inherit", "inspect", "invariant", "like", "local", "loop", "not", "note", "obsolete", "old", "once", "only", "or", "Precursor", "redefine", "rename", "require", "rescue", "Result", "retry", "select", "separate", "then", "True", "TUPLE", "undefine", "until", "variant", "Void", "when", "xor"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("BOOLEAN", "INTEGER_8", "INTEGER_16", "INTEGER_32", "INTEGER_64", "NATURAL_8", "NATURAL_16", "NATURAL_32", "NATURAL_64", "REAL_32", "REAL_64"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "INTEGER_32");
        this.typeMapping.put("long", "INTEGER_64");
        this.typeMapping.put("number", "REAL_32");
        this.typeMapping.put("float", "REAL_32");
        this.typeMapping.put("double", "REAL_64");
        this.typeMapping.put("boolean", "BOOLEAN");
        this.typeMapping.put("string", "STRING_32");
        this.typeMapping.put("UUID", "UUID");
        this.typeMapping.put("date", "DATE");
        this.typeMapping.put("DateTime", "DATE_TIME");
        this.typeMapping.put("date-time", "DATE_TIME");
        this.typeMapping.put("password", "STRING");
        this.typeMapping.put("File", "FILE");
        this.typeMapping.put("file", "FILE");
        this.typeMapping.put("binary", "STRING_32");
        this.typeMapping.put("ByteArray", "ARRAY [NATURAL_8]");
        this.typeMapping.put("object", "ANY");
        this.typeMapping.put("map", "STRING_TABLE");
        this.typeMapping.put("array", "LIST");
        this.typeMapping.put("list", "LIST");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Eiffel Cluster name (convention: lowercase).").defaultValue("swagger"));
        this.cliOptions.add(new CliOption("packageVersion", "Eiffel package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "hides the timestamp when files were generated").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (!this.additionalProperties.containsKey("hideGenerationTimestamp")) {
            this.additionalProperties.put("hideGenerationTimestamp", Boolean.TRUE.toString());
        } else {
            this.additionalProperties.put("hideGenerationTimestamp", Boolean.valueOf(this.additionalProperties().get("hideGenerationTimestamp").toString()));
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("swagger");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.additionalProperties.put("uuid", this.uuid.toString());
        this.additionalProperties.put("uuidTest", this.uuidTest.toString());
        this.additionalProperties.put("libraryTarget", this.libraryTarget);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        String authFolder = "src/framework/auth";
        String serializerFolder = "src/framework/serialization";
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("ecf.mustache", "", "api_client.ecf"));
        this.supportingFiles.add(new SupportingFile("test/ecf_test.mustache", "test", "api_test.ecf"));
        this.supportingFiles.add(new SupportingFile("test/application.mustache", "test", "application.e"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", "src", "api_client.e"));
        this.supportingFiles.add(new SupportingFile("framework/api_i.mustache", "src/framework", "api_i.e"));
        this.supportingFiles.add(new SupportingFile("framework/api_client_request.mustache", "src/framework", "api_client_request.e"));
        this.supportingFiles.add(new SupportingFile("framework/api_client_response.mustache", "src/framework", "api_client_response.e"));
        this.supportingFiles.add(new SupportingFile("framework/api_error.mustache", "src/framework", "api_error.e"));
        this.supportingFiles.add(new SupportingFile("framework/configuration.mustache", "src/framework", "configuration.e"));
        this.supportingFiles.add(new SupportingFile("framework/auth/authentication.mustache", "src/framework/auth", "authentication.e"));
        this.supportingFiles.add(new SupportingFile("framework/auth/api_key_auth.mustache", "src/framework/auth", "api_key_auth.e"));
        this.supportingFiles.add(new SupportingFile("framework/auth/http_basic_auth.mustache", "src/framework/auth", "http_basic_auth.e"));
        this.supportingFiles.add(new SupportingFile("framework/auth/oauth.mustache", "src/framework/auth", "oauth.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/api_deserializer.mustache", "src/framework/serialization", "api_deserializer.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/api_json_deserializer.mustache", "src/framework/serialization", "api_json_deserializer.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/api_json_serializer.mustache", "src/framework/serialization", "api_json_serializer.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/api_serializer.mustache", "src/framework/serialization", "api_serializer.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/json_basic_reflector_deserializer.mustache", "src/framework/serialization", "json_basic_reflector_deserializer.e"));
        this.supportingFiles.add(new SupportingFile("framework/serialization/json_type_utilities_ext.mustache", "src/framework/serialization", "json_type_utilities_ext.e"));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return EiffelClientCodegen.camelize(name) + '_';
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + "src" + File.separator + "api";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + "src" + File.separator + this.modelPath;
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + "test" + File.separator + "apis";
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name.replaceAll("-", "_"))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.unCamelize(name))) {
            name = this.escapeReservedWord(name);
        }
        if (this.isReservedWord(name) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name).toLowerCase();
    }

    @Override
    public String toModelName(String name) {
        return this.toModelFilename(name).toUpperCase();
    }

    @Override
    public String toModelFilename(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        return EiffelClientCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return EiffelClientCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name).toLowerCase() + "_test";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DEFAULT_API";
        }
        return name.toUpperCase() + "_API";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        char firstChar = parameter.paramName.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            parameter.vendorExtensions.put("x-exportParamName", parameter.paramName);
        }
        StringBuilder sb = new StringBuilder(parameter.paramName);
        sb.setCharAt(0, Character.toUpperCase(firstChar));
        parameter.vendorExtensions.put("x-exportParamName", sb.toString());
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (!Strings.isNullOrEmpty((String)model.parent)) {
            this.parentModels.add(model.parent);
            if (!this.childrenByParent.containsEntry((Object)model.parent, (Object)model)) {
                this.childrenByParent.put((Object)model.parent, (Object)model);
            }
        }
        if (!Strings.isNullOrEmpty((String)model.parentSchema)) {
            model.parentSchema = model.parentSchema.toLowerCase();
        }
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return "LIST [" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        String swaggerType = this.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            return (String)this.typeMapping.get(swaggerType);
        }
        if (this.typeMapping.containsValue(swaggerType)) {
            return swaggerType;
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return swaggerType;
        }
        return this.toModelName(swaggerType);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        String sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord(sanitizedOperationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + EiffelClientCodegen.camelize("call_" + operationId));
            sanitizedOperationId = "call_" + sanitizedOperationId;
        }
        sanitizedOperationId = this.unCamelize(sanitizedOperationId);
        return this.toEiffelFeatureStyle(sanitizedOperationId);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        List recursiveImports;
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation operation : operations) {
            operation.httpMethod = EiffelClientCodegen.camelize(operation.httpMethod.toLowerCase());
        }
        List imports = (List)objs.get("imports");
        if (imports == null) {
            return objs;
        }
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(this.apiPackage())) continue;
            iterator.remove();
        }
        for (CodegenOperation operation : operations) {
            if (operation.returnBaseType == null || !this.needToImport(operation.returnBaseType)) continue;
            imports.add(this.createMapping("import", "encoding/json"));
            break;
        }
        for (CodegenOperation operation : operations) {
            if (operation.pathParams == null || operation.pathParams.size() <= 0) continue;
            imports.add(this.createMapping("import", "fmt"));
            break;
        }
        if ((recursiveImports = (List)objs.get("imports")) == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List imports = (List)objs.get("imports");
        String prefix = this.modelPackage();
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(prefix)) continue;
            iterator.remove();
        }
        List recursiveImports = (List)objs.get("imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> models) {
        Map<String, Object> processed = super.postProcessAllModels(models);
        this.postProcessParentModels(models);
        return processed;
    }

    private void postProcessParentModels(Map<String, Object> models) {
        for (String parent : this.parentModels) {
            CodegenModel parentModel = ModelUtils.getModelByName(parent, models);
            Collection childrenModels = this.childrenByParent.get((Object)parent);
            for (CodegenModel child : childrenModels) {
                this.processParentPropertiesInChildModel(parentModel, child);
            }
        }
    }

    private void processParentPropertiesInChildModel(CodegenModel parent, CodegenModel child) {
        HashMap<String, CodegenProperty> childPropertiesByName = new HashMap<String, CodegenProperty>(child.vars.size());
        for (CodegenProperty childProperty : child.vars) {
            childPropertiesByName.put(childProperty.name, childProperty);
        }
        for (CodegenProperty parentProperty : parent.vars) {
            CodegenProperty duplicatedByParent = (CodegenProperty)childPropertiesByName.get(parentProperty.name);
            if (duplicatedByParent == null) continue;
            duplicatedByParent.isInherited = true;
        }
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, value);
        return customImport;
    }

    public String unCamelize(String name) {
        return name.replaceAll("(.)(\\p{Upper})", "$1_$2").toLowerCase();
    }

    public String toEiffelFeatureStyle(String operationId) {
        if (operationId.startsWith("get_")) {
            return operationId.substring(4, operationId.length());
        }
        return operationId;
    }
}

