/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.cache.lock.SimpleReadWriteLock;

public class ReentrantWriterPreferenceReadWriteLockTest
extends TestCase {
    SimpleReadWriteLock lock;
    Sync rl;
    Sync wl;
    Exception thread_ex = null;
    static /* synthetic */ Class class$org$jboss$cache$tests$ReentrantWriterPreferenceReadWriteLockTest;

    protected void setUp() throws Exception {
        super.setUp();
        this.lock = new SimpleReadWriteLock();
        this.rl = this.lock.readLock();
        this.wl = this.lock.writeLock();
        this.thread_ex = null;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.lock = null;
        if (this.thread_ex != null) {
            throw this.thread_ex;
        }
    }

    public void testMultipleReadLockAcquisitions() throws InterruptedException {
        this.rl.acquire();
        this.rl.acquire();
    }

    public void testMultipleWriteLockAcquisitions() throws InterruptedException {
        this.wl.acquire();
        this.wl.acquire();
    }

    public void testMultipleReadLockReleases() throws InterruptedException {
        this.rl.acquire();
        this.rl.release();
        try {
            this.rl.release();
            ReentrantWriterPreferenceReadWriteLockTest.fail((String)"we should not get here, cannot acquire RL once but release twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void acquireReadAndWriteLocks() throws InterruptedException {
        this.rl.acquire();
        this.rl.acquire();
        boolean fl = this.wl.attempt(4000L);
        ReentrantWriterPreferenceReadWriteLockTest.assertTrue((boolean)fl);
    }

    public void acquireWriteThenReadLock() throws InterruptedException {
        this.wl.acquire();
        this.rl.acquire();
        this.wl.release();
        this.rl.release();
    }

    public void testMultipleWriteLockReleases() throws InterruptedException {
        this.wl.acquire();
        this.wl.release();
        this.wl.release();
    }

    public void testAcquireWriteLockAfterReadLock() throws InterruptedException {
        this.rl.acquire();
        this.wl.acquire();
    }

    public void testAcquiringReadLockedLockWithRead() throws InterruptedException {
        new Thread(){

            public void run() {
                try {
                    ReentrantWriterPreferenceReadWriteLockTest.this.rl.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        ReentrantWriterPreferenceReadWriteLockTest.sleep(500L);
        this.rl.acquire();
        this.rl.release();
        this.rl.release();
        this.wl.acquire();
    }

    public void testAcquiringReadLockedLock() throws InterruptedException {
        new Thread(){

            public void run() {
                try {
                    ReentrantWriterPreferenceReadWriteLockTest.this.rl.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        ReentrantWriterPreferenceReadWriteLockTest.sleep(500L);
        this.wl.acquire();
        this.rl.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test2ReadersAnd1Writer() throws InterruptedException {
        Upgrader upgrader = new Upgrader("Upgrader");
        Reader reader = new Reader("Reader");
        upgrader.start();
        reader.start();
        ReentrantWriterPreferenceReadWriteLockTest.sleep(500L);
        Thread thread = upgrader;
        synchronized (thread) {
            upgrader.notify();
        }
        ReentrantWriterPreferenceReadWriteLockTest.sleep(500L);
        thread = reader;
        synchronized (thread) {
            reader.notify();
        }
        reader.join();
        upgrader.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteThenReadByDifferentTx() throws InterruptedException {
        Writer writer = new Writer("Writer");
        Reader reader = new Reader("Reader");
        writer.start();
        ReentrantWriterPreferenceReadWriteLockTest.sleep(500L);
        reader.start();
        ReentrantWriterPreferenceReadWriteLockTest.sleep(1000L);
        Thread thread = writer;
        synchronized (thread) {
            ReentrantWriterPreferenceReadWriteLockTest.log("terminating Writer");
            writer.notify();
        }
        ReentrantWriterPreferenceReadWriteLockTest.sleep(500L);
        thread = reader;
        synchronized (thread) {
            reader.notify();
        }
        writer.join();
        reader.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadThenWriteByDifferentTx() throws InterruptedException {
        Writer writer = new Writer("Writer");
        Reader reader = new Reader("Reader");
        reader.start();
        ReentrantWriterPreferenceReadWriteLockTest.sleep(500L);
        writer.start();
        ReentrantWriterPreferenceReadWriteLockTest.sleep(1000L);
        Thread thread = reader;
        synchronized (thread) {
            ReentrantWriterPreferenceReadWriteLockTest.log("terminating Reader");
            reader.notify();
        }
        ReentrantWriterPreferenceReadWriteLockTest.sleep(500L);
        thread = writer;
        synchronized (thread) {
            writer.notify();
        }
        writer.join();
        reader.join();
    }

    private static void log(String msg) {
        System.out.println(System.currentTimeMillis() + "  " + Thread.currentThread() + " [" + Thread.currentThread().getName() + "]: " + msg);
    }

    private static void sleep(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$jboss$cache$tests$ReentrantWriterPreferenceReadWriteLockTest == null ? (class$org$jboss$cache$tests$ReentrantWriterPreferenceReadWriteLockTest = ReentrantWriterPreferenceReadWriteLockTest.class$("org.jboss.cache.tests.ReentrantWriterPreferenceReadWriteLockTest")) : class$org$jboss$cache$tests$ReentrantWriterPreferenceReadWriteLockTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ReentrantWriterPreferenceReadWriteLockTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Upgrader
    extends Thread {
        public Upgrader(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ReentrantWriterPreferenceReadWriteLockTest.log("acquiring RL");
                ReentrantWriterPreferenceReadWriteLockTest.this.rl.acquire();
                ReentrantWriterPreferenceReadWriteLockTest.log("acquired RL");
                Upgrader upgrader = this;
                synchronized (upgrader) {
                    this.wait();
                }
                ReentrantWriterPreferenceReadWriteLockTest.log("attempting to acquire WL");
                ReentrantWriterPreferenceReadWriteLockTest.this.wl.acquire();
                ReentrantWriterPreferenceReadWriteLockTest.log("acquired WL");
                ReentrantWriterPreferenceReadWriteLockTest.log("releasing WL/RL");
                ReentrantWriterPreferenceReadWriteLockTest.this.wl.release();
                ReentrantWriterPreferenceReadWriteLockTest.log("released WL/RL");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class Writer
    extends Thread {
        public Writer(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ReentrantWriterPreferenceReadWriteLockTest.log("acquiring WL");
                ReentrantWriterPreferenceReadWriteLockTest.this.wl.acquire();
                ReentrantWriterPreferenceReadWriteLockTest.log("acquired WL");
                Writer writer = this;
                synchronized (writer) {
                    this.wait();
                }
                ReentrantWriterPreferenceReadWriteLockTest.log("releasing WL");
                ReentrantWriterPreferenceReadWriteLockTest.this.wl.release();
                ReentrantWriterPreferenceReadWriteLockTest.log("released WL");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class Reader
    extends Thread {
        public Reader(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ReentrantWriterPreferenceReadWriteLockTest.log("acquiring RL");
                ReentrantWriterPreferenceReadWriteLockTest.this.rl.acquire();
                ReentrantWriterPreferenceReadWriteLockTest.log("acquired RL");
                Reader reader = this;
                synchronized (reader) {
                    this.wait();
                }
                ReentrantWriterPreferenceReadWriteLockTest.log("releasing RL");
                ReentrantWriterPreferenceReadWriteLockTest.this.rl.release();
                ReentrantWriterPreferenceReadWriteLockTest.log("released RL");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

