/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.debug;

import java.util.HashMap;
import java.util.Iterator;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;

public class Simulator {
    private Protocol[] protStack = null;
    private ProtocolAdapter ad = new ProtocolAdapter();
    private Receiver r = null;
    private Protocol top = null;
    private Protocol bottom = null;
    private Queue send_queue = new Queue();
    private Thread send_thread;
    private Queue recv_queue = new Queue();
    private Thread recv_thread;
    public static HashMap addrTable = new HashMap();
    private Address local_addr = null;
    private View view;

    public void setProtocolStack(Protocol[] stack) {
        this.protStack = stack;
        this.protStack[0].setUpProtocol(this.ad);
        this.protStack[this.protStack.length - 1].setDownProtocol(this.ad);
        this.top = this.protStack[0];
        this.bottom = this.protStack[this.protStack.length - 1];
        if (this.protStack.length > 1) {
            for (int i = 0; i < this.protStack.length; ++i) {
                Protocol p2;
                Protocol p1 = this.protStack[i];
                Protocol protocol = p2 = i + 1 >= this.protStack.length ? null : this.protStack[i + 1];
                if (p2 == null) continue;
                p1.setDownProtocol(p2);
                p2.setUpProtocol(p1);
            }
        }
    }

    public void setLocalAddress(Address addr) {
        this.local_addr = addr;
    }

    public void setView(View v) {
        this.view = v;
    }

    public void setReceiver(Receiver r) {
        this.r = r;
    }

    public void send(Event evt) {
        this.top.down(evt);
    }

    public void receive(Event evt) {
        try {
            this.recv_queue.add(evt);
        }
        catch (QueueClosedException queueClosedException) {
            // empty catch block
        }
    }

    public void start() throws Exception {
        if (this.local_addr == null) {
            throw new Exception("local_addr has to be non-null");
        }
        if (this.protStack == null) {
            throw new Exception("protocol stack is null");
        }
        this.bottom.up(new Event(8, this.local_addr));
        if (this.view != null) {
            this.top.down(new Event(6, this.view));
        }
        this.send_thread = new Thread(){

            public void run() {
                while (Simulator.this.send_thread != null) {
                    try {
                        Simulator s;
                        Event evt = (Event)Simulator.this.send_queue.remove();
                        if (evt.getType() != 1) continue;
                        Message msg = (Message)evt.getArg();
                        Address dst = msg.getDest();
                        if (msg.getSrc() == null) {
                            ((Message)evt.getArg()).setSrc(Simulator.this.local_addr);
                        }
                        if (dst == null) {
                            Iterator it = addrTable.values().iterator();
                            while (it.hasNext()) {
                                s = (Simulator)it.next();
                                s.receive(evt);
                            }
                            continue;
                        }
                        s = (Simulator)addrTable.get(dst);
                        if (s == null) continue;
                        s.receive(evt);
                    }
                    catch (QueueClosedException e) {
                        Simulator.this.send_thread = null;
                        break;
                    }
                }
            }
        };
        this.send_thread.start();
        this.recv_thread = new Thread(){

            public void run() {
                while (Simulator.this.recv_thread != null) {
                    try {
                        Event evt = (Event)Simulator.this.recv_queue.remove();
                        Simulator.this.bottom.up(evt);
                    }
                    catch (QueueClosedException e) {
                        Simulator.this.recv_thread = null;
                        break;
                    }
                }
            }
        };
        this.recv_thread.start();
    }

    public void stop() {
        this.recv_thread = null;
        this.recv_queue.close(false);
        this.send_thread = null;
        this.send_queue.close(false);
    }

    class ProtocolAdapter
    extends Protocol {
        ProtocolAdapter() {
        }

        public String getName() {
            return "ProtocolAdapter";
        }

        public void up(Event evt) {
            if (Simulator.this.r != null) {
                Simulator.this.r.receive(evt);
            }
        }

        public void down(Event evt) {
            try {
                Simulator.this.send_queue.add(evt);
            }
            catch (QueueClosedException queueClosedException) {
                // empty catch block
            }
        }
    }

    public static interface Receiver {
        public void receive(Event var1);
    }
}

