/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.service;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;

public abstract class AbstractService
implements MembershipListener {
    protected final Channel serviceChannel;
    protected final PullPushAdapter serviceAdapter;
    protected final Channel clientChannel;
    protected final LinkedList members;
    protected boolean blocked;
    protected final Object blockMonitor;
    protected final Object threadMonitor;
    protected boolean runThread;
    protected final Log log;

    public AbstractService(Channel serviceChannel, Channel clientChannel) {
        block2: {
            this.members = new LinkedList();
            this.blockMonitor = new Object();
            this.threadMonitor = new Object();
            this.log = LogFactory.getLog(this.getClass());
            this.serviceChannel = serviceChannel;
            this.serviceAdapter = new PullPushAdapter((Transport)serviceChannel, this);
            this.clientChannel = clientChannel;
            try {
                serviceChannel.getState(null, 1000L);
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block2;
                this.log.error((Object)("exception fetching state: " + ex));
            }
        }
    }

    public abstract String getName();

    protected void setMessageListener(MessageListener listener) {
        this.serviceAdapter.setListener(listener);
    }

    public Address getAddress() {
        return this.serviceChannel.getLocalAddress();
    }

    public boolean isCoordinator() {
        return this.getAddress().equals(this.members.getFirst());
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnBlocked() throws InterruptedException {
        Object object = this.blockMonitor;
        synchronized (object) {
            this.blockMonitor.wait();
        }
    }

    public void block() {
        this.blocked = true;
    }

    public void suspect(Address suspectedMember) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewAccepted(View view) {
        Object object = this.members;
        synchronized (object) {
            this.members.clear();
            this.members.addAll(view.getMembers());
        }
        object = this.blockMonitor;
        synchronized (object) {
            this.blocked = false;
            this.blockMonitor.notifyAll();
        }
    }

    public void start() {
        this.runThread = true;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (AbstractService.this.runThread) {
                    Object object = AbstractService.this.threadMonitor;
                    synchronized (object) {
                        try {
                            AbstractService.this.threadMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        Thread thread = new Thread(runnable, this.getName() + " Thread [" + this.getAddress() + ']');
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.runThread) {
            return;
        }
        this.runThread = false;
        Object object = this.threadMonitor;
        synchronized (object) {
            this.threadMonitor.notifyAll();
        }
    }
}

