/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import org.jgroups.Address;

public class GossipData
implements Externalizable {
    public static final int REGISTER_REQ = 1;
    public static final int GET_REQ = 2;
    public static final int GET_RSP = 3;
    int type = 0;
    String group = null;
    Address mbr = null;
    Vector mbrs = null;

    public GossipData() {
    }

    public GossipData(int type, String group, Address mbr, Vector mbrs) {
        this.type = type;
        this.group = group;
        this.mbr = mbr;
        this.mbrs = mbrs;
    }

    public int getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    public Address getMbr() {
        return this.mbr;
    }

    public Vector getMbrs() {
        return this.mbrs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(GossipData.type2String(this.type));
        switch (this.type) {
            case 1: {
                sb.append(" group=" + this.group + ", mbr=" + this.mbr);
                break;
            }
            case 2: {
                sb.append(" group=" + this.group);
                break;
            }
            case 3: {
                sb.append(" group=" + this.group + ", mbrs=" + this.mbrs);
            }
        }
        return sb.toString();
    }

    public static String type2String(int t) {
        switch (t) {
            case 1: {
                return "REGISTER_REQ";
            }
            case 2: {
                return "GET_REQ";
            }
            case 3: {
                return "GET_RSP";
            }
        }
        return "<unknown>";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeUTF(this.group);
        out.writeObject(this.mbr);
        out.writeObject(this.mbrs);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.group = in.readUTF();
        this.mbr = (Address)in.readObject();
        this.mbrs = (Vector)in.readObject();
    }
}

