/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.service.lease;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Header;

public class LeaseRequestHeader
extends Header {
    public static final String HEADER_KEY = "leaseRequestHeader";
    private static final int NONE = 0;
    public static final int NEW_LEASE_REQUEST = 1;
    public static final int RENEW_LEASE_REQUEST = 2;
    public static final int CANCEL_LEASE_REQUEST = 3;
    private int headerType;
    private long duration;
    private boolean isAbsolute;
    private Object tenant;

    public LeaseRequestHeader() {
        this.headerType = 0;
        this.duration = -1L;
        this.isAbsolute = false;
        this.tenant = null;
    }

    public LeaseRequestHeader(int headerType, long duration, boolean isAbsolute, Object tenant) {
        if (headerType < 1 || headerType > 3) {
            throw new IllegalArgumentException("Unknown header type " + headerType);
        }
        this.headerType = headerType;
        this.duration = duration;
        this.isAbsolute = isAbsolute;
        this.tenant = tenant;
    }

    public int getType() {
        return this.headerType;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.headerType = in.readInt();
        if (this.headerType != 3) {
            this.duration = in.readLong();
            this.isAbsolute = in.readBoolean();
        }
        this.tenant = in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.headerType);
        if (this.headerType != 3) {
            out.writeLong(this.duration);
            out.writeBoolean(this.isAbsolute);
        }
        out.writeObject(this.tenant);
    }
}

