/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.Serializable;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.TunnelHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.List;
import org.jgroups.util.Util;

public class RouterStub {
    String router_host = null;
    int router_port = 0;
    Socket sock = null;
    final ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(512);
    DataOutputStream output = null;
    DataInputStream input = null;
    Address local_addr = null;
    static final long RECONNECT_TIMEOUT = 5000L;
    private volatile boolean connected = false;
    private volatile boolean reconnect = false;
    protected static final Log log = LogFactory.getLog((Class)RouterStub.class);

    public RouterStub(String router_host, int router_port) {
        this.router_host = router_host != null ? router_host : "localhost";
        this.router_port = router_port;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized Address connect() throws Exception {
        Address ret = null;
        int len = 0;
        try {
            this.sock = new Socket(this.router_host, this.router_port);
            this.sock.setSoLinger(true, 500);
            this.input = new DataInputStream(this.sock.getInputStream());
            len = this.input.readInt();
            byte[] buf = new byte[len];
            this.input.readFully(buf);
            ret = (Address)Util.objectFromByteBuffer(buf);
            this.output = new DataOutputStream(this.sock.getOutputStream());
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            if (this.sock != null) {
                this.sock.close();
            }
            throw e;
        }
        if (ret == null && this.sock != null) {
            ret = new IpAddress(this.sock.getLocalPort());
        }
        if (this.local_addr == null) {
            this.local_addr = ret;
        }
        return ret;
    }

    public synchronized void disconnect() {
        if (this.output != null) {
            try {
                this.output.close();
                this.output = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.input != null) {
            try {
                this.input.close();
                this.input = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.sock != null) {
            try {
                this.sock.close();
                this.sock = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connected = false;
        this.reconnect = false;
    }

    public boolean register(String groupname) {
        byte[] buf = null;
        if (this.sock == null || this.output == null || this.input == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("no connection to router (groupname=" + groupname + ')'));
            }
            this.connected = false;
            return false;
        }
        if (groupname == null || groupname.length() == 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)"groupname is null");
            }
            return false;
        }
        if (this.local_addr == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"local_addr is null");
            }
            return false;
        }
        try {
            buf = Util.objectToByteBuffer(this.local_addr);
            this.output.writeInt(-11);
            this.output.writeUTF(groupname);
            this.output.writeInt(buf.length);
            this.output.write(buf, 0, buf.length);
            this.output.flush();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("failure: " + Util.getStackTrace(e)));
            }
            this.connected = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List get(String groupname) {
        List ret;
        block41: {
            byte[] buf;
            int len;
            FilterInputStream tmpInput;
            FilterOutputStream tmpOutput;
            Socket tmpsock;
            block35: {
                ret = null;
                tmpsock = null;
                tmpOutput = null;
                tmpInput = null;
                if (groupname == null || groupname.length() == 0) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"groupname is null");
                    }
                    return null;
                }
                tmpsock = new Socket(this.router_host, this.router_port);
                tmpsock.setSoLinger(true, 500);
                tmpInput = new DataInputStream(tmpsock.getInputStream());
                len = ((DataInputStream)tmpInput).readInt();
                buf = new byte[len];
                ((DataInputStream)tmpInput).readFully(buf);
                tmpOutput = new DataOutputStream(tmpsock.getOutputStream());
                ((DataOutputStream)tmpOutput).writeInt(-10);
                ((DataOutputStream)tmpOutput).writeUTF(groupname);
                len = ((DataInputStream)tmpInput).readInt();
                if (len != 0) break block35;
                List list = null;
                Object var10_10 = null;
                try {
                    if (tmpOutput != null) {
                        tmpOutput.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (tmpInput != null) {
                        tmpInput.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (tmpsock != null) {
                        tmpsock.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                return list;
            }
            buf = new byte[len];
            ((DataInputStream)tmpInput).readFully(buf);
            ret = (List)Util.objectFromByteBuffer(buf);
            Object var10_11 = null;
            try {
                if (tmpOutput != null) {
                    tmpOutput.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (tmpInput != null) {
                    tmpInput.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (tmpsock != null) {
                    tmpsock.close();
                }
                break block41;
            }
            catch (Exception e2) {}
            break block41;
            {
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("exception=" + e));
                    }
                    Object var10_12 = null;
                    try {
                        if (tmpOutput != null) {
                            tmpOutput.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (tmpInput != null) {
                            tmpInput.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (tmpsock != null) {
                            tmpsock.close();
                        }
                        break block41;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (tmpOutput != null) {
                        tmpOutput.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (tmpInput != null) {
                        tmpInput.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (tmpsock != null) {
                        tmpsock.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return ret;
    }

    public boolean send(Message msg, String groupname) {
        Address dst_addr = null;
        if (this.sock == null || this.output == null || this.input == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("no connection to router (groupname=" + groupname + ')'));
            }
            this.connected = false;
            return false;
        }
        if (msg == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"message is null");
            }
            return false;
        }
        try {
            dst_addr = msg.getDest();
            this.out_stream.reset();
            DataOutputStream tmp = new DataOutputStream(this.out_stream);
            msg.writeTo(tmp);
            tmp.close();
            Buffer buf = new Buffer(this.out_stream.getRawBuffer(), 0, this.out_stream.size());
            this.output.writeUTF(groupname);
            Util.writeAddress(dst_addr, this.output);
            this.output.writeInt(buf.getLength());
            this.output.write(buf.getBuf(), 0, buf.getLength());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("failed sending message to " + dst_addr), (Throwable)e);
            }
            this.connected = false;
            return false;
        }
        return true;
    }

    public Message receive() {
        Message ret = null;
        byte[] buf = null;
        if (this.sock == null || this.output == null || this.input == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"no connection to router");
            }
            this.connected = false;
            return null;
        }
        try {
            int len = this.input.readInt();
            if (len == 0) {
                ret = null;
            } else {
                buf = new byte[len];
                this.input.readFully(buf, 0, len);
                ret = new Message();
                ByteArrayInputStream tmp = new ByteArrayInputStream(buf);
                DataInputStream in = new DataInputStream(tmp);
                ret.readFrom(in);
                in.close();
            }
        }
        catch (Exception e) {
            if (this.connected && log.isTraceEnabled()) {
                log.trace((Object)"failed receiving message", (Throwable)e);
            }
            this.connected = false;
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("received " + ret));
        }
        return ret;
    }

    public boolean reconnect(int max_attempts) {
        Address new_addr = null;
        int num_atttempts = 0;
        if (this.connected) {
            return false;
        }
        this.disconnect();
        this.reconnect = true;
        while (this.reconnect && (num_atttempts++ < max_attempts || max_attempts == -1)) {
            block7: {
                try {
                    new_addr = this.connect();
                    if (new_addr != null) {
                        break;
                    }
                }
                catch (Exception ex) {
                    if (!log.isWarnEnabled()) break block7;
                    log.warn((Object)("exception is " + ex));
                }
            }
            if (max_attempts != -1) continue;
            Util.sleep(5000L);
        }
        if (new_addr == null) {
            return false;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("client reconnected, new address is " + new_addr));
        }
        return true;
    }

    public boolean reconnect() {
        return this.reconnect(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("RouterStub <host> <port>");
            return;
        }
        RouterStub stub = new RouterStub(args[0], Integer.parseInt(args[1]));
        String groupname = "BelaGroup";
        try {
            Message msg;
            int i;
            Address my_addr = stub.connect();
            System.out.println("My address is " + my_addr);
            System.out.println("Registering under BelaGroup");
            boolean rc = stub.register("BelaGroup");
            System.out.println("Done, rc=" + rc);
            System.out.println("Getting members of BelaGroup: ");
            List mbrs = stub.get("BelaGroup");
            System.out.println("Done, mbrs are " + mbrs);
            for (i = 0; i < 10; ++i) {
                msg = new Message(null, my_addr, (Serializable)((Object)("Bela #" + i)));
                msg.putHeader("TUNNEL", new TunnelHeader("BelaGroup"));
                rc = stub.send(msg, "BelaGroup");
                System.out.println("Sent msg, rc=" + rc);
            }
            for (i = 0; i < 10; ++i) {
                System.out.println("stub.receive():");
                msg = stub.receive();
                System.out.println("Received msg");
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            stub.disconnect();
        }
    }
}

