/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class BinaryEditsVisitor
implements OfflineEditsVisitor {
    private final EditLogFileOutputStream elfos;

    public BinaryEditsVisitor(String outputName) throws IOException {
        this.elfos = new EditLogFileOutputStream(new Configuration(), new File(outputName), 0);
        this.elfos.create();
    }

    @Override
    public void start(int version) throws IOException {
    }

    @Override
    public void close(Throwable error) throws IOException {
        this.elfos.setReadyToFlush();
        this.elfos.flushAndSync(true);
        this.elfos.close();
    }

    @Override
    public void visitOp(FSEditLogOp op) throws IOException {
        this.elfos.write(op);
    }
}

