/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.api.config.sharding;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.api.config.sharding.KeyGeneratorConfiguration;
import org.apache.shardingsphere.api.config.sharding.strategy.ShardingStrategyConfiguration;

public final class TableRuleConfiguration {
    private final String logicTable;
    private final String actualDataNodes;
    private ShardingStrategyConfiguration databaseShardingStrategyConfig;
    private ShardingStrategyConfiguration tableShardingStrategyConfig;
    private KeyGeneratorConfiguration keyGeneratorConfig;

    public TableRuleConfiguration(String logicTable) {
        this(logicTable, null);
    }

    public TableRuleConfiguration(String logicTable, String actualDataNodes) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)logicTable) ? 1 : 0) != 0, (Object)"LogicTable is required.");
        this.logicTable = logicTable;
        this.actualDataNodes = actualDataNodes;
    }

    @Generated
    public String getLogicTable() {
        return this.logicTable;
    }

    @Generated
    public String getActualDataNodes() {
        return this.actualDataNodes;
    }

    @Generated
    public ShardingStrategyConfiguration getDatabaseShardingStrategyConfig() {
        return this.databaseShardingStrategyConfig;
    }

    @Generated
    public ShardingStrategyConfiguration getTableShardingStrategyConfig() {
        return this.tableShardingStrategyConfig;
    }

    @Generated
    public KeyGeneratorConfiguration getKeyGeneratorConfig() {
        return this.keyGeneratorConfig;
    }

    @Generated
    public void setDatabaseShardingStrategyConfig(ShardingStrategyConfiguration databaseShardingStrategyConfig) {
        this.databaseShardingStrategyConfig = databaseShardingStrategyConfig;
    }

    @Generated
    public void setTableShardingStrategyConfig(ShardingStrategyConfiguration tableShardingStrategyConfig) {
        this.tableShardingStrategyConfig = tableShardingStrategyConfig;
    }

    @Generated
    public void setKeyGeneratorConfig(KeyGeneratorConfiguration keyGeneratorConfig) {
        this.keyGeneratorConfig = keyGeneratorConfig;
    }
}

