/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.SequenceTableFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)FilteredDataSet.class);
    private final IDataSet _dataSet;
    private final ITableFilter _filter;

    public FilteredDataSet(String[] tableNames, IDataSet dataSet) throws AmbiguousTableNameException {
        this._filter = new SequenceTableFilter(tableNames, dataSet.isCaseSensitiveTableNames());
        this._dataSet = dataSet;
    }

    public FilteredDataSet(ITableFilter filter, IDataSet dataSet) {
        this._dataSet = dataSet;
        this._filter = filter;
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        }
        return this._filter.iterator(this._dataSet, reversed);
    }

    public String[] getTableNames() throws DataSetException {
        return this._filter.getTableNames(this._dataSet);
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        if (!this._filter.accept(tableName)) {
            throw new NoSuchTableException(tableName);
        }
        return this._dataSet.getTableMetaData(tableName);
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName={}) - start", (Object)tableName);
        if (!this._filter.accept(tableName)) {
            throw new NoSuchTableException(tableName);
        }
        return this._dataSet.getTable(tableName);
    }
}

