/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.excel;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsDataSetWriter {
    public static final String ZEROS = "0000000000000000000000000000000000000000000000000000";
    public static final String DATE_FORMAT_AS_NUMBER_DBUNIT = "####################";
    private static final Logger logger = LoggerFactory.getLogger((Class)XlsDataSetWriter.class);
    private HSSFCellStyle dateCellStyle;

    public void write(IDataSet dataSet, OutputStream out) throws IOException, DataSetException {
        logger.debug("write(dataSet={}, out={}) - start", (Object)dataSet, (Object)out);
        HSSFWorkbook workbook = new HSSFWorkbook();
        this.dateCellStyle = XlsDataSetWriter.createDateCellStyle(workbook);
        int index = 0;
        ITableIterator iterator = dataSet.iterator();
        while (iterator.next()) {
            int j;
            ITable table = iterator.getTable();
            ITableMetaData metaData = table.getTableMetaData();
            HSSFSheet sheet = workbook.createSheet(metaData.getTableName());
            workbook.setSheetName(index, metaData.getTableName());
            HSSFRow headerRow = sheet.createRow(0);
            Column[] columns = metaData.getColumns();
            for (j = 0; j < columns.length; ++j) {
                Column column = columns[j];
                HSSFCell cell = headerRow.createCell(j);
                cell.setCellValue(new HSSFRichTextString(column.getColumnName()));
            }
            for (j = 0; j < table.getRowCount(); ++j) {
                HSSFRow row = sheet.createRow(j + 1);
                for (int k = 0; k < columns.length; ++k) {
                    Column column = columns[k];
                    Object value = table.getValue(j, column.getColumnName());
                    if (value == null) continue;
                    HSSFCell cell = row.createCell(k);
                    if (value instanceof Date) {
                        this.setDateCell(cell, (Date)value, workbook);
                        continue;
                    }
                    if (value instanceof BigDecimal) {
                        this.setNumericCell(cell, (BigDecimal)value, workbook);
                        continue;
                    }
                    if (value instanceof Long) {
                        this.setDateCell(cell, new Date((Long)value), workbook);
                        continue;
                    }
                    cell.setCellValue(new HSSFRichTextString(DataType.asString(value)));
                }
            }
            ++index;
        }
        workbook.write(out);
        out.flush();
    }

    protected static HSSFCellStyle createDateCellStyle(HSSFWorkbook workbook) {
        HSSFDataFormat format = workbook.createDataFormat();
        short dateFormatCode = format.getFormat(DATE_FORMAT_AS_NUMBER_DBUNIT);
        HSSFCellStyle dateCellStyle = workbook.createCellStyle();
        dateCellStyle.setDataFormat(dateFormatCode);
        return dateCellStyle;
    }

    protected void setDateCell(HSSFCell cell, Date value, HSSFWorkbook workbook) {
        long timeMillis = value.getTime();
        cell.setCellValue((double)timeMillis);
        cell.setCellType(0);
        cell.setCellStyle(this.dateCellStyle);
    }

    protected void setNumericCell(HSSFCell cell, BigDecimal value, HSSFWorkbook workbook) {
        short format;
        if (logger.isDebugEnabled()) {
            logger.debug("setNumericCell(cell={}, value={}, workbook={}) - start", new Object[]{cell, value, workbook});
        }
        cell.setCellValue(value.doubleValue());
        HSSFDataFormat df = workbook.createDataFormat();
        int scale = value.scale();
        if (scale <= 0) {
            format = df.getFormat("####");
        } else {
            String zeros = XlsDataSetWriter.createZeros(value.scale());
            format = df.getFormat("####." + zeros);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Using format '{}' for value '{}'.", (Object)String.valueOf(format), (Object)value);
        }
        HSSFCellStyle cellStyleNumber = workbook.createCellStyle();
        cellStyleNumber.setDataFormat(format);
        cell.setCellStyle(cellStyleNumber);
    }

    private static String createZeros(int count) {
        return ZEROS.substring(0, count);
    }
}

