/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.dbunit.DatabaseUnitRuntimeException;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLHelper {
    public static final String DB_PRODUCT_SYBASE = "Sybase";
    private static final Logger logger = LoggerFactory.getLogger((Class)SQLHelper.class);

    private SQLHelper() {
    }

    public static String getPrimaryKeyColumn(Connection conn, String table) throws SQLException {
        logger.debug("getPrimaryKeyColumn(conn={}, table={}) - start", (Object)conn, (Object)table);
        DatabaseMetaData metadata = conn.getMetaData();
        ResultSet rs = metadata.getPrimaryKeys(null, null, table);
        rs.next();
        String pkColumn = rs.getString(4);
        return pkColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(ResultSet rs, Statement stmt) throws SQLException {
        logger.debug("close(rs={}, stmt={}) - start", (Object)rs, (Object)stmt);
        try {
            SQLHelper.close(rs);
        }
        finally {
            SQLHelper.close(stmt);
        }
    }

    public static void close(Statement stmt) throws SQLException {
        logger.debug("close(stmt={}) - start", (Object)stmt);
        if (stmt != null) {
            stmt.close();
        }
    }

    public static void close(ResultSet resultSet) throws SQLException {
        logger.debug("close(resultSet={}) - start", (Object)resultSet);
        if (resultSet != null) {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean schemaExists(Connection connection, String schema) throws SQLException {
        logger.trace("schemaExists(connection={}, schema={}) - start", (Object)connection, (Object)schema);
        if (schema == null) {
            throw new NullPointerException("The parameter 'schema' must not be null");
        }
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet rs = metaData.getSchemas();
        try {
            while (rs.next()) {
                String foundSchema = rs.getString("TABLE_SCHEM");
                if (!foundSchema.equals(schema)) continue;
                boolean bl = true;
                return bl;
            }
            if (SQLHelper.catalogExists(connection, schema)) {
                logger.debug("Found catalog with name {}. Returning true because DB is probably on MySQL", (Object)schema);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean catalogExists(Connection connection, String catalog) throws SQLException {
        logger.trace("catalogExists(connection={}, catalog={}) - start", (Object)connection, (Object)catalog);
        if (catalog == null) {
            throw new NullPointerException("The parameter 'catalog' must not be null");
        }
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet rs = metaData.getCatalogs();
        try {
            while (rs.next()) {
                String foundCatalog = rs.getString("TABLE_CAT");
                if (!foundCatalog.equals(catalog)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(DatabaseMetaData metaData, String schema, String tableName) throws SQLException {
        ResultSet tableRs = metaData.getTables(null, schema, tableName, null);
        try {
            boolean bl = tableRs.next();
            return bl;
        }
        finally {
            SQLHelper.close(tableRs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printAllTables(DatabaseMetaData metaData, PrintStream outputStream) throws SQLException {
        ResultSet rs = metaData.getTables(null, null, null, null);
        try {
            while (rs.next()) {
                String catalog = rs.getString("TABLE_CAT");
                String schema = rs.getString("TABLE_SCHEM");
                String table = rs.getString("TABLE_NAME");
                StringBuffer tableInfo = new StringBuffer();
                if (catalog != null) {
                    tableInfo.append(catalog).append(".");
                }
                if (schema != null) {
                    tableInfo.append(schema).append(".");
                }
                tableInfo.append(table);
                outputStream.println(tableInfo);
            }
            outputStream.flush();
        }
        finally {
            SQLHelper.close(rs);
        }
    }

    public static String getDatabaseInfo(DatabaseMetaData metaData) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        String dbInfo = null;
        dbInfo = new ExceptionWrapper(){

            public String wrappedCall(DatabaseMetaData metaData) throws Exception {
                return metaData.getDatabaseProductName();
            }
        }.executeWrappedCall(metaData);
        sb.append("\tdatabase product name=").append(dbInfo).append("\n");
        dbInfo = new ExceptionWrapper(){

            public String wrappedCall(DatabaseMetaData metaData) throws Exception {
                return metaData.getDatabaseProductVersion();
            }
        }.executeWrappedCall(metaData);
        sb.append("\tdatabase version=").append(dbInfo).append("\n");
        dbInfo = new ExceptionWrapper(){

            public String wrappedCall(DatabaseMetaData metaData) throws Exception {
                return String.valueOf(metaData.getDatabaseMajorVersion());
            }
        }.executeWrappedCall(metaData);
        sb.append("\tdatabase major version=").append(dbInfo).append("\n");
        dbInfo = new ExceptionWrapper(){

            public String wrappedCall(DatabaseMetaData metaData) throws Exception {
                return String.valueOf(metaData.getDatabaseMinorVersion());
            }
        }.executeWrappedCall(metaData);
        sb.append("\tdatabase minor version=").append(dbInfo).append("\n");
        dbInfo = new ExceptionWrapper(){

            public String wrappedCall(DatabaseMetaData metaData) throws Exception {
                return metaData.getDriverName();
            }
        }.executeWrappedCall(metaData);
        sb.append("\tjdbc driver name=").append(dbInfo).append("\n");
        dbInfo = new ExceptionWrapper(){

            public String wrappedCall(DatabaseMetaData metaData) throws Exception {
                return metaData.getDriverVersion();
            }
        }.executeWrappedCall(metaData);
        sb.append("\tjdbc driver version=").append(dbInfo).append("\n");
        dbInfo = new ExceptionWrapper(){

            public String wrappedCall(DatabaseMetaData metaData) throws Exception {
                return String.valueOf(metaData.getDriverMajorVersion());
            }
        }.executeWrappedCall(metaData);
        sb.append("\tjdbc driver major version=").append(dbInfo).append("\n");
        dbInfo = new ExceptionWrapper(){

            public String wrappedCall(DatabaseMetaData metaData) throws Exception {
                return String.valueOf(metaData.getDriverMinorVersion());
            }
        }.executeWrappedCall(metaData);
        sb.append("\tjdbc driver minor version=").append(dbInfo).append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDatabaseInfo(DatabaseMetaData metaData, PrintStream outputStream) throws SQLException {
        String dbInfo = SQLHelper.getDatabaseInfo(metaData);
        try {
            outputStream.println(dbInfo);
        }
        finally {
            outputStream.flush();
        }
    }

    public static boolean isSybaseDb(DatabaseMetaData metaData) throws SQLException {
        String dbProductName = metaData.getDatabaseProductName();
        boolean isSybase = dbProductName != null && dbProductName.equals(DB_PRODUCT_SYBASE);
        return isSybase;
    }

    public static final Column createColumn(ResultSet resultSet, IDataTypeFactory dataTypeFactory, boolean datatypeWarning) throws SQLException, DataTypeException {
        String isAutoIncrement;
        String columnDefaultValue;
        String remarks;
        int nullable;
        String sqlTypeName;
        int sqlType;
        String columnName;
        String tableName;
        block4: {
            tableName = resultSet.getString(3);
            columnName = resultSet.getString(4);
            sqlType = resultSet.getInt(5);
            sqlTypeName = resultSet.getString(6);
            nullable = resultSet.getInt(11);
            remarks = resultSet.getString(12);
            columnDefaultValue = resultSet.getString(13);
            isAutoIncrement = Column.AutoIncrement.NO.getKey();
            try {
                isAutoIncrement = resultSet.getString(23);
            }
            catch (SQLException e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Could not retrieve the 'isAutoIncrement' property because not yet running on Java 1.5 - defaulting to NO. Table=" + tableName + ", Column=" + columnName, (Throwable)e);
            }
        }
        DataType dataType = dataTypeFactory.createDataType(sqlType, sqlTypeName, tableName, columnName);
        if (dataType != DataType.UNKNOWN) {
            Column column = new Column(columnName, dataType, sqlTypeName, Column.nullableValue(nullable), columnDefaultValue, remarks, Column.AutoIncrement.autoIncrementValue(isAutoIncrement));
            return column;
        }
        if (datatypeWarning) {
            logger.warn(tableName + "." + columnName + " data type (" + sqlType + ", '" + sqlTypeName + "') not recognized and will be ignored. See FAQ for more information.");
        }
        return null;
    }

    public static boolean matches(ResultSet resultSet, String schema, String table, boolean caseSensitive) throws SQLException {
        return SQLHelper.matches(resultSet, null, schema, table, null, caseSensitive);
    }

    public static boolean matches(ResultSet resultSet, String catalog, String schema, String table, String column, boolean caseSensitive) throws SQLException {
        String catalogName = resultSet.getString(1);
        String schemaName = resultSet.getString(2);
        String tableName = resultSet.getString(3);
        String columnName = resultSet.getString(4);
        if (schema != null && schemaName == null && catalog == null && catalogName != null) {
            logger.debug("Switching catalog/schema because the are mutually null");
            schemaName = catalogName;
            catalogName = null;
        }
        boolean areEqual = SQLHelper.areEqualIgnoreNull(catalog, catalogName, caseSensitive) && SQLHelper.areEqualIgnoreNull(schema, schemaName, caseSensitive) && SQLHelper.areEqualIgnoreNull(table, tableName, caseSensitive) && SQLHelper.areEqualIgnoreNull(column, columnName, caseSensitive);
        return areEqual;
    }

    public static final boolean areEqualIgnoreNull(String value1, String value2, boolean caseSensitive) {
        if (value1 == null || value1.equals("")) {
            return true;
        }
        if (caseSensitive && value1.equals(value2)) {
            return true;
        }
        return !caseSensitive && value1.equalsIgnoreCase(value2);
    }

    public static final String correctCase(String databaseIdentifier, Connection connection) {
        logger.trace("correctCase(tableName={}, connection={}) - start", (Object)databaseIdentifier, (Object)connection);
        try {
            return SQLHelper.correctCase(databaseIdentifier, connection.getMetaData());
        }
        catch (SQLException e) {
            throw new DatabaseUnitRuntimeException("Exception while trying to access database metadata", e);
        }
    }

    public static final String correctCase(String databaseIdentifier, DatabaseMetaData databaseMetaData) {
        logger.trace("correctCase(tableName={}, databaseMetaData={}) - start", (Object)databaseIdentifier, (Object)databaseMetaData);
        if (databaseIdentifier == null) {
            throw new NullPointerException("The parameter 'databaseIdentifier' must not be null");
        }
        if (databaseMetaData == null) {
            throw new NullPointerException("The parameter 'databaseMetaData' must not be null");
        }
        try {
            String resultTableName = databaseIdentifier;
            String dbIdentifierQuoteString = databaseMetaData.getIdentifierQuoteString();
            if (!SQLHelper.isEscaped(databaseIdentifier, dbIdentifierQuoteString)) {
                if (databaseMetaData.storesLowerCaseIdentifiers()) {
                    resultTableName = databaseIdentifier.toLowerCase(Locale.ENGLISH);
                } else if (databaseMetaData.storesUpperCaseIdentifiers()) {
                    resultTableName = databaseIdentifier.toUpperCase(Locale.ENGLISH);
                } else {
                    logger.debug("Database does not store upperCase or lowerCase identifiers. Will not correct case of the table names.");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("The tableName '{}' is escaped. Will not correct case.", (Object)databaseIdentifier);
            }
            return resultTableName;
        }
        catch (SQLException e) {
            throw new DatabaseUnitRuntimeException("Exception while trying to access database metadata", e);
        }
    }

    public static final void logInfoIfValueChanged(String oldValue, String newValue, String message, Class source) {
        if (logger.isInfoEnabled() && oldValue != null && !oldValue.equals(newValue)) {
            logger.debug("{}. {} oldValue={} newValue={}", new Object[]{source, message, oldValue, newValue});
        }
    }

    private static final boolean isEscaped(String tableName, String dbIdentifierQuoteString) {
        boolean isEscaped;
        logger.trace("isEscaped(tableName={}, dbIdentifierQuoteString={}) - start", (Object)tableName, (Object)dbIdentifierQuoteString);
        if (dbIdentifierQuoteString == null) {
            throw new NullPointerException("The parameter 'dbIdentifierQuoteString' must not be null");
        }
        boolean bl = isEscaped = tableName != null && tableName.startsWith(dbIdentifierQuoteString);
        if (logger.isDebugEnabled()) {
            logger.debug("isEscaped returns '{}' for tableName={} (dbIdentifierQuoteString={})", new Object[]{isEscaped, tableName, dbIdentifierQuoteString});
        }
        return isEscaped;
    }

    static abstract class ExceptionWrapper {
        public static final String NOT_AVAILABLE_TEXT = "<not available>";

        public final String executeWrappedCall(DatabaseMetaData metaData) {
            try {
                String result = this.wrappedCall(metaData);
                return result;
            }
            catch (Exception e) {
                logger.trace("Problem retrieving DB information via DatabaseMetaData", (Throwable)e);
                return NOT_AVAILABLE_TEXT;
            }
        }

        public abstract String wrappedCall(DatabaseMetaData var1) throws Exception;
    }
}

