/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.netezza;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.database.IMetadataHandler;
import org.dbunit.util.SQLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetezzaMetadataHandler
implements IMetadataHandler {
    private static final Logger logger = LoggerFactory.getLogger((Class)NetezzaMetadataHandler.class);

    public NetezzaMetadataHandler() {
        logger.debug("Created object of metadatahandler");
    }

    public ResultSet getColumns(DatabaseMetaData databaseMetaData, String schemaName, String tableName) throws SQLException {
        ResultSet resultSet = databaseMetaData.getColumns(schemaName, null, tableName, "%");
        return resultSet;
    }

    public boolean matches(ResultSet resultSet, String schema, String table, boolean caseSensitive) throws SQLException {
        return this.matches(resultSet, null, schema, table, null, caseSensitive);
    }

    public boolean matches(ResultSet columnsResultSet, String catalog, String schema, String table, String column, boolean caseSensitive) throws SQLException {
        String catalogName = columnsResultSet.getString(1);
        String schemaName = columnsResultSet.getString(2);
        String tableName = columnsResultSet.getString(3);
        String columnName = columnsResultSet.getString(4);
        logger.debug("inputCatalog=" + catalog + " inputSchema=" + schema + " inputTable=" + table + " inputColumn=" + column);
        logger.debug("catalogName=" + catalogName + " schemaName=" + schemaName + "tableName=" + tableName + " columnName=" + columnName);
        if (catalog == null && catalogName != null && schemaName != null) {
            logger.debug("Netezza uses catalogs");
            schema = schemaName;
            catalog = catalogName;
        }
        boolean areEqual = this.areEqualIgnoreNull(catalog, catalogName, caseSensitive) && this.areEqualIgnoreNull(schema, schemaName, caseSensitive) && this.areEqualIgnoreNull(table, tableName, caseSensitive) && this.areEqualIgnoreNull(column, columnName, caseSensitive);
        return areEqual;
    }

    private boolean areEqualIgnoreNull(String value1, String value2, boolean caseSensitive) {
        return SQLHelper.areEqualIgnoreNull(value1, value2, caseSensitive);
    }

    public String getSchema(ResultSet resultSet) throws SQLException {
        String catalogName = resultSet.getString(1);
        String schemaName = resultSet.getString(2);
        if (schemaName == null && catalogName != null) {
            logger.debug("Using catalogName '" + catalogName + "' as schema since the schema is null but the catalog is set (probably in Netezza environment).");
            schemaName = catalogName;
        }
        return schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(DatabaseMetaData metaData, String schema, String tableName) throws SQLException {
        ResultSet tableRs = metaData.getTables(schema, null, tableName, null);
        try {
            boolean bl = tableRs.next();
            return bl;
        }
        finally {
            SQLHelper.close(tableRs);
        }
    }

    public ResultSet getTables(DatabaseMetaData metaData, String schemaName, String[] tableType) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("tableExists(metaData={}, schemaName={}, tableType={}) - start", new Object[]{metaData, schemaName, tableType});
        }
        return metaData.getTables(schemaName, null, "%", tableType);
    }

    public ResultSet getPrimaryKeys(DatabaseMetaData metaData, String schemaName, String tableName) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("getPrimaryKeys(metaData={}, schemaName={}, tableName={}) - start", new Object[]{metaData, schemaName, tableName});
        }
        ResultSet resultSet = metaData.getPrimaryKeys(schemaName, null, tableName);
        return resultSet;
    }
}

