/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.fileloader;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.dbunit.DatabaseUnitRuntimeException;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.util.fileloader.DataFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataFileLoader
implements DataFileLoader {
    private final Logger LOG = LoggerFactory.getLogger((Class)AbstractDataFileLoader.class);
    private Map replacementObjects;
    private Map replacementSubstrings;

    public AbstractDataFileLoader() {
        this(new HashMap(), new HashMap());
    }

    public AbstractDataFileLoader(Map ro) {
        this(ro, new HashMap());
    }

    public AbstractDataFileLoader(Map ro, Map rs) {
        if (ro == null) {
            throw new IllegalArgumentException("Replacement object map is null.");
        }
        if (rs == null) {
            throw new IllegalArgumentException("Replacement substrings map is null.");
        }
        this.replacementObjects = ro;
        this.replacementSubstrings = rs;
    }

    public IDataSet load(String filename) throws DatabaseUnitRuntimeException {
        IDataSet ds = new DefaultDataSet();
        this.LOG.debug("load: processing file={}", (Object)filename);
        if (filename == null || "".equals(filename)) {
            String msg = "load: filename is null or empty string, using DefaultDataSet()";
            this.LOG.debug("load: filename is null or empty string, using DefaultDataSet()");
        } else {
            URL url = this.getClass().getResource(filename);
            if (url == null) {
                String msg = "Could not find file named=" + filename;
                throw new DatabaseUnitRuntimeException(msg);
            }
            try {
                ds = this.loadDataSet(url);
                ds = this.processReplacementTokens(ds);
            }
            catch (DataSetException e) {
                String msg = "DataSetException occurred loading data set file name='" + filename + "', msg='" + e.getLocalizedMessage() + "'";
                throw new DatabaseUnitRuntimeException(msg, e);
            }
            catch (IOException e) {
                String msg = "IOException occurred loading data set file name='" + filename + '\'' + ", msg='" + e.getLocalizedMessage() + "'";
                throw new DatabaseUnitRuntimeException(msg, e);
            }
        }
        return ds;
    }

    protected abstract IDataSet loadDataSet(URL var1) throws DataSetException, IOException;

    protected ReplacementDataSet processReplacementTokens(IDataSet ds) {
        ReplacementDataSet rds = new ReplacementDataSet(ds, this.replacementObjects, this.replacementSubstrings);
        return rds;
    }

    public void addReplacementObjects(Map ro) {
        this.replacementObjects.putAll(ro);
    }

    public void addReplacementSubstrings(Map rs) {
        this.replacementSubstrings.putAll(rs);
    }

    public void removeAllReplacementObjects() {
        this.replacementObjects.clear();
    }

    public void removeAllReplacementSubstrings() {
        this.replacementSubstrings.clear();
    }
}

