/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.asm.AnnotationVisitor;
import org.eclipse.persistence.asm.ClassVisitor;
import org.eclipse.persistence.asm.FieldVisitor;
import org.eclipse.persistence.asm.Label;
import org.eclipse.persistence.asm.MethodVisitor;
import org.eclipse.persistence.asm.Opcodes;
import org.eclipse.persistence.asm.Type;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.weaving.AttributeDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassDetails;
import org.eclipse.persistence.internal.jpa.weaving.MethodWeaver;

public class ClassWeaver
extends ClassVisitor {
    public static final String PERSISTENCE_WEAVED_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeaved";
    public static final String TW_LAZY_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeavedLazy";
    public static final String VHI_CLASSNAME = "org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface";
    public static final String VH_SHORT_SIGNATURE = "org/eclipse/persistence/indirection/ValueHolder";
    public static final String VHI_SHORT_SIGNATURE = "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface";
    public static final String VHI_SIGNATURE = "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;";
    public static final String TW_CT_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeavedChangeTracking";
    public static final String PCL_SHORT_SIGNATURE = "java/beans/PropertyChangeListener";
    public static final String PCL_SIGNATURE = "Ljava/beans/PropertyChangeListener;";
    public static final String CT_SHORT_SIGNATURE = "org/eclipse/persistence/descriptors/changetracking/ChangeTracker";
    public static final String PCE_SHORT_SIGNATURE = "java/beans/PropertyChangeEvent";
    public static final String PCE_SIGNATURE = "Ljava/beans/PropertyChangeEvent;";
    public static final String PERSISTENCE_ENTITY_SHORT_SIGNATURE = "org/eclipse/persistence/internal/descriptors/PersistenceEntity";
    public static final String PERSISTENCE_OBJECT_SHORT_SIGNATURE = "org/eclipse/persistence/internal/descriptors/PersistenceObject";
    public static final String PERSISTENCE_OBJECT_SIGNATURE = "Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;";
    public static final String VECTOR_SIGNATURE = "Ljava/util/Vector;";
    public static final String OBJECT_SIGNATURE = "Ljava/lang/Object;";
    public static final String STRING_SIGNATURE = "Ljava/lang/String;";
    public static final String CACHEKEY_SIGNATURE = "Lorg/eclipse/persistence/internal/identitymaps/CacheKey;";
    public static final String WEAVED_FETCHGROUPS_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeavedFetchGroups";
    public static final String FETCHGROUP_TRACKER_SIGNATURE = "Lorg/eclipse/persistence/queries/FetchGroupTracker;";
    public static final String FETCHGROUP_TRACKER_SHORT_SIGNATURE = "org/eclipse/persistence/queries/FetchGroupTracker";
    public static final String FETCHGROUP_SHORT_SIGNATURE = "org/eclipse/persistence/queries/FetchGroup";
    public static final String FETCHGROUP_SIGNATURE = "Lorg/eclipse/persistence/queries/FetchGroup;";
    public static final String SESSION_SIGNATURE = "Lorg/eclipse/persistence/sessions/Session;";
    public static final String ENTITY_MANAGER_IMPL_SHORT_SIGNATURE = "org/eclipse/persistence/internal/jpa/EntityManagerImpl";
    public static final String PBOOLEAN_SIGNATURE = "Z";
    public static final String LONG_SIGNATURE = "J";
    public static final String WEAVED_REST_LAZY_SHORT_SIGNATURE = "org/eclipse/persistence/internal/jpa/rs/weaving/PersistenceWeavedRest";
    public static final String LIST_RELATIONSHIP_INFO_SIGNATURE = "Ljava/util/List;";
    public static final String LIST_RELATIONSHIP_INFO_GENERIC_SIGNATURE = "Ljava/util/List<Lorg/eclipse/persistence/internal/jpa/rs/weaving/RelationshipInfo;>;";
    public static final String LINK_SIGNATURE = "Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/Link;";
    public static final String ITEM_LINKS_SIGNATURE = "Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/ItemLinks;";
    public static final String CLONEABLE_SHORT_SIGNATURE = "java/lang/Cloneable";
    public static final String JPA_TRANSIENT_DESCRIPTION = "Ljakarta/persistence/Transient;";
    public static final String XML_TRANSIENT_DESCRIPTION = "Ljakarta/xml/bind/annotation/XmlTransient;";
    public static final String PERSISTENCE_SET = "_persistence_set_";
    public static final String PERSISTENCE_GET = "_persistence_get_";
    public static final String PERSISTENCE_FIELDNAME_PREFIX = "_persistence_";
    public static final String PERSISTENCE_FIELDNAME_POSTFIX = "_vh";
    public static final String VIRTUAL_GETTER_SIGNATURE = "(Ljava/lang/String;)Ljava/lang/Object;";
    public static final String VIRTUAL_SETTER_SIGNATURE = "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;";
    private static Boolean isJAXBOnPath = null;
    protected ClassDetails classDetails;
    protected boolean alreadyWeaved = false;
    public boolean weaved = false;
    public boolean weavedLazy = false;
    public boolean weavedPersistenceEntity = false;
    public boolean weavedChangeTracker = false;
    public boolean weavedFetchGroups = false;
    public boolean weavedRest = false;
    private ClassVisitor cw;

    public static String wrapperFor(int sort) {
        if (sort == Type.BOOLEAN) {
            return "java/lang/Boolean";
        }
        if (sort == Type.BYTE) {
            return "java/lang/Byte";
        }
        if (sort == Type.CHAR) {
            return "java/lang/Character";
        }
        if (sort == Type.SHORT) {
            return "java/lang/Short";
        }
        if (sort == Type.INT) {
            return "java/lang/Integer";
        }
        if (sort == Type.FLOAT) {
            return "java/lang/Float";
        }
        if (sort == Type.LONG) {
            return "java/lang/Long";
        }
        if (sort == Type.DOUBLE) {
            return "java/lang/Double";
        }
        return null;
    }

    public static void unwrapPrimitive(AttributeDetails attribute, MethodVisitor visitor) {
        String wrapper = ClassWeaver.wrapperFor(attribute.getReferenceClassType().getSort());
        int sort = attribute.getReferenceClassType().getSort();
        if (sort == Type.BOOLEAN) {
            visitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), wrapper, "booleanValue", "()Z", false);
            return;
        }
        if (sort == Type.BYTE) {
            visitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), wrapper, "byteValue", "()B", false);
            return;
        }
        if (sort == Type.CHAR) {
            visitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), wrapper, "charValue", "()C", false);
            return;
        }
        if (sort == Type.SHORT) {
            visitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), wrapper, "shortValue", "()S", false);
            return;
        }
        if (sort == Type.INT) {
            visitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), wrapper, "intValue", "()I", false);
            return;
        }
        if (sort == Type.FLOAT) {
            visitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), wrapper, "floatValue", "()F", false);
            return;
        }
        if (sort == Type.LONG) {
            visitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), wrapper, "longValue", "()J", false);
            return;
        }
        if (sort == Type.DOUBLE) {
            visitor.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), wrapper, "doubleValue", "()D", false);
            return;
        }
    }

    public static String getWeavedValueHolderGetMethodName(String attributeName) {
        return Helper.getWeavedValueHolderGetMethodName(attributeName);
    }

    public static String getWeavedValueHolderSetMethodName(String attributeName) {
        return Helper.getWeavedValueHolderSetMethodName(attributeName);
    }

    public static boolean isJAXBOnPath() {
        if (isJAXBOnPath == null) {
            try {
                Class.forName("jakarta.xml.bind.annotation.XmlTransient");
                isJAXBOnPath = true;
            }
            catch (Exception notThere) {
                isJAXBOnPath = false;
            }
        }
        return isJAXBOnPath;
    }

    public ClassWeaver(ClassVisitor classWriter, ClassDetails classDetails) {
        super(ASMFactory.ASM_API_SELECTED, classWriter);
        super.setCustomClassVisitor(this);
        this.cw = classWriter;
        this.classDetails = classDetails;
    }

    public void addValueHolder(AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        FieldVisitor fv = this.cv.visitField(Opcodes.valueInt("ACC_PROTECTED"), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE, null, null);
        if (attributeDetails.getGetterMethodName() == null || attributeDetails.getGetterMethodName().equals("") || attributeDetails.weaveTransientFieldValueHolders()) {
            fv.visitAnnotation(JPA_TRANSIENT_DESCRIPTION, true).visitEnd();
            if (ClassWeaver.isJAXBOnPath()) {
                fv.visitAnnotation(XML_TRANSIENT_DESCRIPTION, true).visitEnd();
            }
        }
        fv.visitEnd();
    }

    public void addPropertyChangeListener(boolean attributeAccess) {
        this.cv.visitField(Opcodes.valueInt("ACC_PROTECTED") + Opcodes.valueInt("ACC_TRANSIENT"), "_persistence_listener", PCL_SIGNATURE, null, null);
    }

    public void addGetPropertyChangeListener(ClassDetails classDetails) {
        MethodVisitor cv_getPCL = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_getPropertyChangeListener", "()Ljava/beans/PropertyChangeListener;", null, null);
        cv_getPCL.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_getPCL.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        cv_getPCL.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_getPCL.visitMaxs(0, 0);
    }

    public void addSetPropertyChangeListener(ClassDetails classDetails) {
        MethodVisitor cv_setPCL = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_setPropertyChangeListener", "(Ljava/beans/PropertyChangeListener;)V", null, null);
        cv_setPCL.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_setPCL.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_setPCL.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        cv_setPCL.visitInsn(Opcodes.valueInt("RETURN"));
        cv_setPCL.visitMaxs(0, 0);
    }

    public void addPropertyChange(ClassDetails classDetails) {
        MethodVisitor cv_addPC = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
        cv_addPC.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_addPC.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        Label l0 = ASMFactory.createLabel();
        cv_addPC.visitJumpInsn(Opcodes.valueInt("IFNULL"), l0);
        cv_addPC.visitVarInsn(Opcodes.valueInt("ALOAD"), 2);
        cv_addPC.visitVarInsn(Opcodes.valueInt("ALOAD"), 3);
        cv_addPC.visitJumpInsn(Opcodes.valueInt("IF_ACMPEQ"), l0);
        cv_addPC.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_addPC.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        cv_addPC.visitTypeInsn(Opcodes.valueInt("NEW"), PCE_SHORT_SIGNATURE);
        cv_addPC.visitInsn(Opcodes.valueInt("DUP"));
        cv_addPC.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_addPC.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_addPC.visitVarInsn(Opcodes.valueInt("ALOAD"), 2);
        cv_addPC.visitVarInsn(Opcodes.valueInt("ALOAD"), 3);
        cv_addPC.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), PCE_SHORT_SIGNATURE, "<init>", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", false);
        cv_addPC.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), PCL_SHORT_SIGNATURE, "propertyChange", "(Ljava/beans/PropertyChangeEvent;)V", true);
        cv_addPC.visitLabel(l0);
        cv_addPC.visitInsn(Opcodes.valueInt("RETURN"));
        cv_addPC.visitMaxs(0, 0);
    }

    public void addInitializerForValueHolder(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        String className = classDetails.getClassName();
        MethodVisitor cv_init_VH = this.cv.visitMethod(Opcodes.valueInt("ACC_PROTECTED"), "_persistence_initialize_" + attribute + PERSISTENCE_FIELDNAME_POSTFIX, "()V", null, null);
        cv_init_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_init_VH.visitFieldInsn(Opcodes.valueInt("GETFIELD"), className, PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        Label l0 = ASMFactory.createLabel();
        cv_init_VH.visitJumpInsn(Opcodes.valueInt("IFNONNULL"), l0);
        cv_init_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_init_VH.visitTypeInsn(Opcodes.valueInt("NEW"), VH_SHORT_SIGNATURE);
        cv_init_VH.visitInsn(Opcodes.valueInt("DUP"));
        if (attributeDetails.hasField()) {
            cv_init_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_init_VH.visitFieldInsn(Opcodes.valueInt("GETFIELD"), className, attribute, attributeDetails.getReferenceClassType().getDescriptor());
            cv_init_VH.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), VH_SHORT_SIGNATURE, "<init>", "(Ljava/lang/Object;)V", false);
        } else {
            cv_init_VH.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), VH_SHORT_SIGNATURE, "<init>", "()V", false);
        }
        cv_init_VH.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), className, PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_init_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_init_VH.visitFieldInsn(Opcodes.valueInt("GETFIELD"), className, PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_init_VH.visitInsn(Opcodes.valueInt("ICONST_1"));
        cv_init_VH.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), VHI_SHORT_SIGNATURE, "setIsNewlyWeavedValueHolder", "(Z)V", true);
        cv_init_VH.visitLabel(l0);
        cv_init_VH.visitInsn(Opcodes.valueInt("RETURN"));
        cv_init_VH.visitMaxs(0, 0);
    }

    public void addGetterMethodForValueHolder(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        String className = classDetails.getClassName();
        MethodVisitor cv_get_VH = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), PERSISTENCE_GET + attribute + PERSISTENCE_FIELDNAME_POSTFIX, "()Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;", null, null);
        cv_get_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_get_VH.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, "()V", false);
        cv_get_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_get_VH.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), VHI_SHORT_SIGNATURE, "isCoordinatedWithProperty", "()Z", true);
        Label l0 = ASMFactory.createLabel();
        cv_get_VH.visitJumpInsn(Opcodes.valueInt("IFNE"), l0);
        cv_get_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_get_VH.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), VHI_SHORT_SIGNATURE, "isNewlyWeavedValueHolder", "()Z", true);
        Label l1 = ASMFactory.createLabel();
        cv_get_VH.visitJumpInsn(Opcodes.valueInt("IFEQ"), l1);
        cv_get_VH.visitLabel(l0);
        cv_get_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        if (attributeDetails.getGetterMethodName() != null) {
            cv_get_VH.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), attributeDetails.getGetterMethodName(), "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";", false);
            cv_get_VH.visitTypeInsn(Opcodes.valueInt("CHECKCAST"), attributeDetails.getReferenceClassName().replace('.', '/'));
        } else {
            cv_get_VH.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), PERSISTENCE_GET + attributeDetails.attributeName, "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";", false);
        }
        cv_get_VH.visitVarInsn(Opcodes.valueInt("ASTORE"), 1);
        cv_get_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_get_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_get_VH.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;", true);
        cv_get_VH.visitJumpInsn(Opcodes.valueInt("IF_ACMPEQ"), l1);
        cv_get_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_get_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        if (attributeDetails.getSetterMethodName() != null) {
            cv_get_VH.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), attributeDetails.getSetterMethodName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V", false);
        } else {
            cv_get_VH.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), PERSISTENCE_SET + attributeDetails.getAttributeName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V", false);
        }
        cv_get_VH.visitLabel(l1);
        cv_get_VH.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_get_VH.visitFieldInsn(Opcodes.valueInt("GETFIELD"), className, PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_get_VH.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_get_VH.visitMaxs(0, 0);
    }

    public void addSetterMethodForValueHolder(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        String className = classDetails.getClassName();
        MethodVisitor cv_set_value = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), PERSISTENCE_SET + attribute + PERSISTENCE_FIELDNAME_POSTFIX, "(Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;)V", null, null);
        cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_set_value.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), className, PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_set_value.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), VHI_SHORT_SIGNATURE, "isInstantiated", "()Z", true);
        Label l0 = ASMFactory.createLabel();
        cv_set_value.visitJumpInsn(Opcodes.valueInt("IFEQ"), l0);
        cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        if (attributeDetails.getGetterMethodName() != null) {
            cv_set_value.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), className, attributeDetails.getGetterMethodName(), "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";", false);
        } else {
            cv_set_value.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), className, PERSISTENCE_GET + attributeDetails.attributeName, "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";", false);
        }
        cv_set_value.visitVarInsn(Opcodes.valueInt("ASTORE"), 2);
        cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_set_value.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;", true);
        cv_set_value.visitVarInsn(Opcodes.valueInt("ASTORE"), 3);
        cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 2);
        cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 3);
        if (attributeDetails.getSetterMethodName() != null) {
            cv_set_value.visitJumpInsn(Opcodes.valueInt("IF_ACMPEQ"), l0);
            cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 3);
            cv_set_value.visitTypeInsn(Opcodes.valueInt("CHECKCAST"), attributeDetails.getReferenceClassName().replace('.', '/'));
            cv_set_value.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), className, attributeDetails.getSetterMethodName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V", false);
            cv_set_value.visitLabel(l0);
        } else {
            Label l1 = ASMFactory.createLabel();
            cv_set_value.visitJumpInsn(Opcodes.valueInt("IF_ACMPEQ"), l1);
            cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 3);
            cv_set_value.visitTypeInsn(Opcodes.valueInt("CHECKCAST"), attributeDetails.getReferenceClassName().replace('.', '/'));
            cv_set_value.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), className, PERSISTENCE_SET + attributeDetails.getAttributeName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V", false);
            cv_set_value.visitLabel(l1);
            cv_set_value.visitFrame(Opcodes.valueInt("F_SAME"), 0, null, 0, null);
            Label l2 = ASMFactory.createLabel();
            cv_set_value.visitJumpInsn(Opcodes.valueInt("GOTO"), l2);
            cv_set_value.visitLabel(l0);
            cv_set_value.visitFrame(Opcodes.valueInt("F_SAME"), 0, null, 0, null);
            cv_set_value.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set_value.visitInsn(Opcodes.valueInt("ACONST_NULL"));
            cv_set_value.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), className, attributeDetails.attributeName, attributeDetails.getReferenceClassType().getDescriptor());
            cv_set_value.visitLabel(l2);
            cv_set_value.visitFrame(Opcodes.valueInt("F_SAME"), 0, null, 0, null);
        }
        cv_set_value.visitInsn(Opcodes.valueInt("RETURN"));
        cv_set_value.visitMaxs(0, 0);
    }

    public void addSetterMethodForFieldAccess(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        MethodVisitor cv_set = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), PERSISTENCE_SET + attribute, "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V", null, null);
        int opcode = attributeDetails.getReferenceClassType().getOpcode(Opcodes.valueInt("ILOAD"));
        if (classDetails.shouldWeaveFetchGroups()) {
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set.visitLdcInsn(attribute);
            cv_set.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), "_persistence_checkFetchedForSet", "(Ljava/lang/String;)V", false);
        }
        if (classDetails.shouldWeaveChangeTracking()) {
            if (attributeDetails.weaveValueHolders()) {
                cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                cv_set.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, "()V", false);
                cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                cv_set.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
                cv_set.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;", true);
                cv_set.visitTypeInsn(Opcodes.valueInt("CHECKCAST"), attributeDetails.getReferenceClassName().replace('.', '/'));
                cv_set.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
            }
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set.visitLdcInsn(attribute);
            String wrapper = ClassWeaver.wrapperFor(attributeDetails.getReferenceClassType().getSort());
            if (wrapper != null) {
                cv_set.visitTypeInsn(Opcodes.valueInt("NEW"), wrapper);
                cv_set.visitInsn(Opcodes.valueInt("DUP"));
            }
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
            if (wrapper != null) {
                cv_set.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), wrapper, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V", false);
                cv_set.visitTypeInsn(Opcodes.valueInt("NEW"), wrapper);
                cv_set.visitInsn(Opcodes.valueInt("DUP"));
                cv_set.visitVarInsn(opcode, 1);
                cv_set.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), wrapper, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V", false);
            } else {
                cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
            }
            cv_set.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", false);
        } else if (attributeDetails.weaveValueHolders()) {
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, "()V", false);
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
            cv_set.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;", true);
            cv_set.visitTypeInsn(Opcodes.valueInt("CHECKCAST"), attributeDetails.getReferenceClassName().replace('.', '/'));
            cv_set.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
        }
        cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_set.visitVarInsn(opcode, 1);
        cv_set.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
        if (attributeDetails.weaveValueHolders()) {
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
            cv_set.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), VHI_SHORT_SIGNATURE, "setValue", "(Ljava/lang/Object;)V", true);
        }
        cv_set.visitInsn(Opcodes.valueInt("RETURN"));
        cv_set.visitMaxs(0, 0);
    }

    public void addGetterMethodForFieldAccess(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        MethodVisitor cv_get = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), PERSISTENCE_GET + attribute, "()" + attributeDetails.getReferenceClassType().getDescriptor(), null, null);
        if (classDetails.shouldWeaveFetchGroups()) {
            cv_get.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_get.visitLdcInsn(attribute);
            cv_get.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), "_persistence_checkFetched", "(Ljava/lang/String;)V", false);
        }
        if (attributeDetails.weaveValueHolders()) {
            cv_get.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_get.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, "()V", false);
            cv_get.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_get.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_get.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
            cv_get.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;", true);
            cv_get.visitTypeInsn(Opcodes.valueInt("CHECKCAST"), attributeDetails.getReferenceClassName().replace('.', '/'));
            cv_get.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
        }
        cv_get.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_get.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
        int opcode = attributeDetails.getReferenceClassType().getOpcode(Opcodes.valueInt("IRETURN"));
        cv_get.visitInsn(opcode);
        cv_get.visitMaxs(0, 0);
    }

    public void addPersistenceEntityVariables() {
        this.cv.visitField(Opcodes.valueInt("ACC_PROTECTED") + Opcodes.valueInt("ACC_TRANSIENT"), "_persistence_primaryKey", OBJECT_SIGNATURE, null, null);
        this.cv.visitField(Opcodes.valueInt("ACC_PROTECTED") + Opcodes.valueInt("ACC_TRANSIENT"), "_persistence_cacheKey", CACHEKEY_SIGNATURE, null, null);
    }

    public void addPersistencePostClone(ClassDetails classDetails) {
        MethodVisitor cv_clone = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_post_clone", "()Ljava/lang/Object;", null, null);
        if (classDetails.getSuperClassDetails() != null && classDetails.getSuperClassDetails().shouldWeaveInternal()) {
            cv_clone.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_clone.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), classDetails.getSuperClassName(), "_persistence_post_clone", "()Ljava/lang/Object;", false);
        }
        if (classDetails.shouldWeaveValueHolders()) {
            for (AttributeDetails attributeDetails : classDetails.getAttributesMap().values()) {
                if (!attributeDetails.weaveValueHolders()) continue;
                cv_clone.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                cv_clone.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
                Label label = ASMFactory.createLabel();
                cv_clone.visitJumpInsn(Opcodes.valueInt("IFNULL"), label);
                cv_clone.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                cv_clone.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
                cv_clone.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
                cv_clone.visitMethodInsn(Opcodes.valueInt("INVOKEINTERFACE"), VHI_SHORT_SIGNATURE, "clone", "()Ljava/lang/Object;", true);
                cv_clone.visitTypeInsn(Opcodes.valueInt("CHECKCAST"), VHI_SHORT_SIGNATURE);
                cv_clone.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
                cv_clone.visitLabel(label);
            }
        }
        if (classDetails.shouldWeaveChangeTracking()) {
            cv_clone.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_clone.visitInsn(Opcodes.valueInt("ACONST_NULL"));
            cv_clone.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        }
        if (classDetails.shouldWeaveFetchGroups()) {
            cv_clone.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_clone.visitInsn(Opcodes.valueInt("ACONST_NULL"));
            cv_clone.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
            cv_clone.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_clone.visitInsn(Opcodes.valueInt("ACONST_NULL"));
            cv_clone.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_session", SESSION_SIGNATURE);
        }
        if (!classDetails.isEmbedable()) {
            cv_clone.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_clone.visitInsn(Opcodes.valueInt("ACONST_NULL"));
            cv_clone.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_primaryKey", OBJECT_SIGNATURE);
        }
        cv_clone.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_clone.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_clone.visitMaxs(0, 0);
    }

    public void addPersistenceRestMethods(ClassDetails classDetails) {
        MethodVisitor cv_getPKVector = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_getRelationships", "()Ljava/util/List;", "()Ljava/util/List<Lorg/eclipse/persistence/internal/jpa/rs/weaving/RelationshipInfo;>;", null);
        cv_getPKVector.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_getPKVector.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_relationshipInfo", LIST_RELATIONSHIP_INFO_SIGNATURE);
        cv_getPKVector.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_getPKVector.visitMaxs(0, 0);
        MethodVisitor cv_setPKVector = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_setRelationships", "(Ljava/util/List;)V", "(Ljava/util/List<Lorg/eclipse/persistence/internal/jpa/rs/weaving/RelationshipInfo;>;)V", null);
        cv_setPKVector.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_setPKVector.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_setPKVector.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_relationshipInfo", LIST_RELATIONSHIP_INFO_SIGNATURE);
        cv_setPKVector.visitInsn(Opcodes.valueInt("RETURN"));
        cv_setPKVector.visitMaxs(0, 0);
        MethodVisitor cv_getHref = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_getHref", "()Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/Link;", null, null);
        cv_getHref.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_getHref.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_href", LINK_SIGNATURE);
        cv_getHref.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_getHref.visitMaxs(0, 0);
        MethodVisitor cv_setHref = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_setHref", "(Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/Link;)V", null, null);
        cv_setHref.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_setHref.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_setHref.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_href", LINK_SIGNATURE);
        cv_setHref.visitInsn(Opcodes.valueInt("RETURN"));
        cv_setHref.visitMaxs(0, 0);
        MethodVisitor cv_getLinks = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_getLinks", "()Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/ItemLinks;", null, null);
        cv_getLinks.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_getLinks.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_links", ITEM_LINKS_SIGNATURE);
        cv_getLinks.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_getLinks.visitMaxs(0, 0);
        MethodVisitor cv_setLinks = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_setLinks", "(Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/ItemLinks;)V", null, null);
        cv_setLinks.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_setLinks.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_setLinks.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_links", ITEM_LINKS_SIGNATURE);
        cv_setLinks.visitInsn(Opcodes.valueInt("RETURN"));
        cv_setLinks.visitMaxs(0, 0);
    }

    public void addPersistenceRestVariables() {
        this.cv.visitField(Opcodes.valueInt("ACC_PROTECTED") | Opcodes.valueInt("ACC_TRANSIENT"), "_persistence_relationshipInfo", LIST_RELATIONSHIP_INFO_SIGNATURE, LIST_RELATIONSHIP_INFO_GENERIC_SIGNATURE, null);
        this.cv.visitField(Opcodes.valueInt("ACC_PROTECTED") | Opcodes.valueInt("ACC_TRANSIENT"), "_persistence_href", LINK_SIGNATURE, null, null);
        this.cv.visitField(Opcodes.valueInt("ACC_PROTECTED") | Opcodes.valueInt("ACC_TRANSIENT"), "_persistence_links", ITEM_LINKS_SIGNATURE, null, null);
    }

    public void addShallowClone(ClassDetails classDetails) {
        MethodVisitor cv_clone = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_shallow_clone", "()Ljava/lang/Object;", null, null);
        cv_clone.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_clone.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), "java/lang/Object", "clone", "()Ljava/lang/Object;", false);
        cv_clone.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_clone.visitMaxs(0, 0);
    }

    public void addPersistenceNew(ClassDetails classDetails) {
        MethodVisitor cv_new = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_new", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)Ljava/lang/Object;", null, null);
        cv_new.visitTypeInsn(Opcodes.valueInt("NEW"), classDetails.getClassName());
        cv_new.visitInsn(Opcodes.valueInt("DUP"));
        if (!classDetails.canWeaveConstructorOptimization()) {
            cv_new.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), classDetails.getClassName(), "<init>", "()V", false);
            cv_new.visitInsn(Opcodes.valueInt("ARETURN"));
            cv_new.visitMaxs(0, 0);
            return;
        }
        cv_new.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_new.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), classDetails.getClassName(), "<init>", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)V", false);
        cv_new.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_new.visitMaxs(0, 0);
        MethodVisitor cv_constructor = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "<init>", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)V", null, null);
        cv_constructor.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        if (classDetails.getSuperClassDetails() == null) {
            cv_constructor.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), classDetails.getSuperClassName(), "<init>", "()V", false);
        } else {
            cv_constructor.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
            cv_constructor.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), classDetails.getSuperClassName(), "<init>", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)V", false);
        }
        cv_constructor.visitInsn(Opcodes.valueInt("RETURN"));
        cv_constructor.visitMaxs(0, 0);
    }

    public void addPersistenceGetSet(ClassDetails classDetails) {
        MethodVisitor cv_get = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_get", VIRTUAL_GETTER_SIGNATURE, null, null);
        Label label = null;
        for (AttributeDetails attributeDetails : classDetails.getAttributesMap().values()) {
            if (attributeDetails.isAttributeOnSuperClass() || attributeDetails.isVirtualProperty()) continue;
            if (label != null) {
                cv_get.visitLabel(label);
            }
            cv_get.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
            cv_get.visitLdcInsn(attributeDetails.getAttributeName().intern());
            label = ASMFactory.createLabel();
            cv_get.visitJumpInsn(Opcodes.valueInt("IF_ACMPNE"), label);
            cv_get.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_get.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), attributeDetails.getAttributeName(), attributeDetails.getReferenceClassType().getDescriptor());
            String wrapper = ClassWeaver.wrapperFor(attributeDetails.getReferenceClassType().getSort());
            if (wrapper != null) {
                cv_get.visitMethodInsn(Opcodes.valueInt("INVOKESTATIC"), wrapper, "valueOf", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")L" + wrapper + ";", false);
            }
            cv_get.visitInsn(Opcodes.valueInt("ARETURN"));
        }
        if (label != null) {
            cv_get.visitLabel(label);
        }
        if (classDetails.getSuperClassDetails() == null) {
            cv_get.visitInsn(Opcodes.valueInt("ACONST_NULL"));
        } else {
            cv_get.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_get.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
            cv_get.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), classDetails.getSuperClassName(), "_persistence_get", VIRTUAL_GETTER_SIGNATURE, false);
        }
        cv_get.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_get.visitMaxs(0, 0);
        MethodVisitor cv_set = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_set", "(Ljava/lang/String;Ljava/lang/Object;)V", null, null);
        label = null;
        for (AttributeDetails attribute : classDetails.getAttributesMap().values()) {
            if (attribute.isAttributeOnSuperClass() || attribute.isVirtualProperty()) continue;
            if (label != null) {
                cv_set.visitLabel(label);
            }
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
            cv_set.visitLdcInsn(attribute.getAttributeName().intern());
            label = ASMFactory.createLabel();
            cv_set.visitJumpInsn(Opcodes.valueInt("IF_ACMPNE"), label);
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 2);
            String wrapper = ClassWeaver.wrapperFor(attribute.getReferenceClassType().getSort());
            if (wrapper == null) {
                wrapper = attribute.getReferenceClassName().replace('.', '/');
            }
            cv_set.visitTypeInsn(Opcodes.valueInt("CHECKCAST"), wrapper);
            ClassWeaver.unwrapPrimitive(attribute, cv_set);
            cv_set.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), attribute.getAttributeName(), attribute.getReferenceClassType().getDescriptor());
            cv_set.visitInsn(Opcodes.valueInt("RETURN"));
        }
        if (label != null) {
            cv_set.visitLabel(label);
        }
        if (classDetails.getSuperClassDetails() != null) {
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
            cv_set.visitVarInsn(Opcodes.valueInt("ALOAD"), 2);
            cv_set.visitMethodInsn(Opcodes.valueInt("INVOKESPECIAL"), classDetails.getSuperClassName(), "_persistence_set", "(Ljava/lang/String;Ljava/lang/Object;)V", false);
        }
        cv_set.visitInsn(Opcodes.valueInt("RETURN"));
        cv_set.visitMaxs(0, 0);
    }

    public void addPersistenceEntityMethods(ClassDetails classDetails) {
        MethodVisitor cv_getPKVector = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_getId", "()Ljava/lang/Object;", null, null);
        cv_getPKVector.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_getPKVector.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_primaryKey", OBJECT_SIGNATURE);
        cv_getPKVector.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_getPKVector.visitMaxs(0, 0);
        MethodVisitor cv_setPKVector = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_setId", "(Ljava/lang/Object;)V", null, null);
        cv_setPKVector.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_setPKVector.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_setPKVector.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_primaryKey", OBJECT_SIGNATURE);
        cv_setPKVector.visitInsn(Opcodes.valueInt("RETURN"));
        cv_setPKVector.visitMaxs(0, 0);
        MethodVisitor cv_getCacheKey = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_getCacheKey", "()Lorg/eclipse/persistence/internal/identitymaps/CacheKey;", null, null);
        cv_getCacheKey.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_getCacheKey.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_cacheKey", CACHEKEY_SIGNATURE);
        cv_getCacheKey.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_getCacheKey.visitMaxs(0, 0);
        MethodVisitor cv_setCacheKey = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_setCacheKey", "(Lorg/eclipse/persistence/internal/identitymaps/CacheKey;)V", null, null);
        cv_setCacheKey.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_setCacheKey.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_setCacheKey.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_cacheKey", CACHEKEY_SIGNATURE);
        cv_setCacheKey.visitInsn(Opcodes.valueInt("RETURN"));
        cv_setCacheKey.visitMaxs(0, 0);
    }

    public void addFetchGroupVariables() {
        FieldVisitor fv = this.cv.visitField(Opcodes.valueInt("ACC_PROTECTED"), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE, null, null);
        if (this.classDetails.usesAttributeAccess()) {
            fv.visitAnnotation(JPA_TRANSIENT_DESCRIPTION, true).visitEnd();
        }
        if (ClassWeaver.isJAXBOnPath()) {
            fv.visitAnnotation(XML_TRANSIENT_DESCRIPTION, true).visitEnd();
        }
        fv.visitEnd();
        this.cv.visitField(Opcodes.valueInt("ACC_PROTECTED") + Opcodes.valueInt("ACC_TRANSIENT"), "_persistence_shouldRefreshFetchGroup", PBOOLEAN_SIGNATURE, null, null).visitEnd();
        this.cv.visitField(Opcodes.valueInt("ACC_PROTECTED") + Opcodes.valueInt("ACC_TRANSIENT"), "_persistence_session", SESSION_SIGNATURE, null, null).visitEnd();
    }

    public void addFetchGroupMethods(ClassDetails classDetails) {
        MethodVisitor cv_getSession = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_getSession", "()Lorg/eclipse/persistence/sessions/Session;", null, null);
        cv_getSession.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_getSession.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_session", SESSION_SIGNATURE);
        cv_getSession.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_getSession.visitMaxs(0, 0);
        MethodVisitor cv_setSession = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_setSession", "(Lorg/eclipse/persistence/sessions/Session;)V", null, null);
        cv_setSession.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_setSession.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_setSession.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_session", SESSION_SIGNATURE);
        cv_setSession.visitInsn(Opcodes.valueInt("RETURN"));
        cv_setSession.visitMaxs(0, 0);
        MethodVisitor cv_getFetchGroup = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_getFetchGroup", "()Lorg/eclipse/persistence/queries/FetchGroup;", null, null);
        cv_getFetchGroup.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_getFetchGroup.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        cv_getFetchGroup.visitInsn(Opcodes.valueInt("ARETURN"));
        cv_getFetchGroup.visitMaxs(0, 0);
        MethodVisitor cv_setFetchGroup = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_setFetchGroup", "(Lorg/eclipse/persistence/queries/FetchGroup;)V", null, null);
        cv_setFetchGroup.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_setFetchGroup.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_setFetchGroup.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        cv_setFetchGroup.visitInsn(Opcodes.valueInt("RETURN"));
        cv_setFetchGroup.visitMaxs(0, 0);
        MethodVisitor cv_shouldRefreshFetchGroup = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_shouldRefreshFetchGroup", "()Z", null, null);
        cv_shouldRefreshFetchGroup.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_shouldRefreshFetchGroup.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_shouldRefreshFetchGroup", PBOOLEAN_SIGNATURE);
        cv_shouldRefreshFetchGroup.visitInsn(Opcodes.valueInt("IRETURN"));
        cv_shouldRefreshFetchGroup.visitMaxs(0, 0);
        MethodVisitor cv_setShouldRefreshFetchGroup = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_setShouldRefreshFetchGroup", "(Z)V", null, null);
        cv_setShouldRefreshFetchGroup.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_setShouldRefreshFetchGroup.visitVarInsn(Opcodes.valueInt("ILOAD"), 1);
        cv_setShouldRefreshFetchGroup.visitFieldInsn(Opcodes.valueInt("PUTFIELD"), classDetails.getClassName(), "_persistence_shouldRefreshFetchGroup", PBOOLEAN_SIGNATURE);
        cv_setShouldRefreshFetchGroup.visitInsn(Opcodes.valueInt("RETURN"));
        cv_setShouldRefreshFetchGroup.visitMaxs(0, 0);
        MethodVisitor cv_resetFetchGroup = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_resetFetchGroup", "()V", null, null);
        cv_resetFetchGroup.visitInsn(Opcodes.valueInt("RETURN"));
        cv_resetFetchGroup.visitMaxs(0, 0);
        MethodVisitor cv_isAttributeFetched = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_isAttributeFetched", "(Ljava/lang/String;)Z", null, null);
        cv_isAttributeFetched.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_isAttributeFetched.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        Label gotoTrue = ASMFactory.createLabel();
        cv_isAttributeFetched.visitJumpInsn(Opcodes.valueInt("IFNULL"), gotoTrue);
        cv_isAttributeFetched.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_isAttributeFetched.visitFieldInsn(Opcodes.valueInt("GETFIELD"), classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        cv_isAttributeFetched.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_isAttributeFetched.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), FETCHGROUP_SHORT_SIGNATURE, "containsAttributeInternal", "(Ljava/lang/String;)Z", false);
        Label gotoFalse = ASMFactory.createLabel();
        cv_isAttributeFetched.visitJumpInsn(Opcodes.valueInt("IFEQ"), gotoFalse);
        cv_isAttributeFetched.visitLabel(gotoTrue);
        cv_isAttributeFetched.visitInsn(Opcodes.valueInt("ICONST_1"));
        Label gotoReturn = ASMFactory.createLabel();
        cv_isAttributeFetched.visitJumpInsn(Opcodes.valueInt("GOTO"), gotoReturn);
        cv_isAttributeFetched.visitLabel(gotoFalse);
        cv_isAttributeFetched.visitInsn(Opcodes.valueInt("ICONST_0"));
        cv_isAttributeFetched.visitLabel(gotoReturn);
        cv_isAttributeFetched.visitInsn(Opcodes.valueInt("IRETURN"));
        cv_isAttributeFetched.visitMaxs(0, 0);
        MethodVisitor cv_checkFetched = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_checkFetched", "(Ljava/lang/String;)V", null, null);
        cv_checkFetched.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_checkFetched.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_checkFetched.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), "_persistence_isAttributeFetched", "(Ljava/lang/String;)Z", false);
        gotoReturn = ASMFactory.createLabel();
        cv_checkFetched.visitJumpInsn(Opcodes.valueInt("IFNE"), gotoReturn);
        cv_checkFetched.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_checkFetched.visitTypeInsn(Opcodes.valueInt("CHECKCAST"), FETCHGROUP_TRACKER_SHORT_SIGNATURE);
        cv_checkFetched.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_checkFetched.visitMethodInsn(Opcodes.valueInt("INVOKESTATIC"), ENTITY_MANAGER_IMPL_SHORT_SIGNATURE, "processUnfetchedAttribute", "(Lorg/eclipse/persistence/queries/FetchGroupTracker;Ljava/lang/String;)V", false);
        cv_checkFetched.visitLabel(gotoReturn);
        cv_checkFetched.visitInsn(Opcodes.valueInt("RETURN"));
        cv_checkFetched.visitMaxs(0, 0);
        MethodVisitor cv_checkFetchedForSet = this.cv.visitMethod(Opcodes.valueInt("ACC_PUBLIC"), "_persistence_checkFetchedForSet", "(Ljava/lang/String;)V", null, null);
        cv_checkFetchedForSet.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_checkFetchedForSet.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_checkFetchedForSet.visitMethodInsn(Opcodes.valueInt("INVOKEVIRTUAL"), classDetails.getClassName(), "_persistence_isAttributeFetched", "(Ljava/lang/String;)Z", false);
        gotoReturn = ASMFactory.createLabel();
        cv_checkFetchedForSet.visitJumpInsn(Opcodes.valueInt("IFNE"), gotoReturn);
        cv_checkFetchedForSet.visitVarInsn(Opcodes.valueInt("ALOAD"), 0);
        cv_checkFetchedForSet.visitTypeInsn(Opcodes.valueInt("CHECKCAST"), FETCHGROUP_TRACKER_SHORT_SIGNATURE);
        cv_checkFetchedForSet.visitVarInsn(Opcodes.valueInt("ALOAD"), 1);
        cv_checkFetchedForSet.visitMethodInsn(Opcodes.valueInt("INVOKESTATIC"), ENTITY_MANAGER_IMPL_SHORT_SIGNATURE, "processUnfetchedAttributeForSet", "(Lorg/eclipse/persistence/queries/FetchGroupTracker;Ljava/lang/String;)V", false);
        cv_checkFetchedForSet.visitLabel(gotoReturn);
        cv_checkFetchedForSet.visitInsn(Opcodes.valueInt("RETURN"));
        cv_checkFetchedForSet.visitMaxs(0, 0);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean weaveRest;
        boolean fetchGroupTracker;
        boolean persistenceEntity;
        boolean weaveCloneable = true;
        for (int index = 0; index < interfaces.length; ++index) {
            String existingInterface = interfaces[index];
            if (PERSISTENCE_WEAVED_SHORT_SIGNATURE.equals(existingInterface)) {
                this.alreadyWeaved = true;
                super.visitSuper(version, access, name, signature, superName, interfaces);
                return;
            }
            if (CT_SHORT_SIGNATURE.equals(existingInterface)) {
                this.classDetails.setShouldWeaveChangeTracking(false);
                continue;
            }
            if (!CLONEABLE_SHORT_SIGNATURE.equals(existingInterface)) continue;
            weaveCloneable = false;
        }
        int newInterfacesLength = interfaces.length;
        int cloneableIndex = 0;
        boolean bl = weaveCloneable = this.classDetails.shouldWeaveInternal() && weaveCloneable && this.classDetails.getSuperClassDetails() == null;
        if (weaveCloneable) {
            cloneableIndex = newInterfacesLength++;
        }
        int persistenceWeavedIndex = newInterfacesLength++;
        int persistenceEntityIndex = 0;
        boolean bl2 = persistenceEntity = this.classDetails.shouldWeaveInternal() && this.classDetails.getSuperClassDetails() == null && !this.classDetails.isEmbedable();
        if (persistenceEntity) {
            persistenceEntityIndex = newInterfacesLength++;
        }
        int persistenceObjectIndex = 0;
        boolean persistenceObject = this.classDetails.shouldWeaveInternal();
        if (persistenceObject) {
            persistenceObjectIndex = newInterfacesLength++;
        }
        int fetchGroupTrackerIndex = 0;
        boolean bl3 = fetchGroupTracker = this.classDetails.shouldWeaveFetchGroups() && this.classDetails.getSuperClassDetails() == null;
        if (fetchGroupTracker) {
            fetchGroupTrackerIndex = newInterfacesLength++;
        }
        int persistenceWeavedFetchGroupsIndex = 0;
        if (this.classDetails.shouldWeaveFetchGroups()) {
            persistenceWeavedFetchGroupsIndex = newInterfacesLength++;
        }
        int persistenceWeavedLazyIndex = 0;
        if (this.classDetails.shouldWeaveValueHolders()) {
            persistenceWeavedLazyIndex = newInterfacesLength++;
        }
        boolean changeTracker = !this.classDetails.doesSuperclassWeaveChangeTracking() && this.classDetails.shouldWeaveChangeTracking();
        int persistenceWeavedChangeTrackingIndex = 0;
        int changeTrackerIndex = 0;
        if (changeTracker) {
            changeTrackerIndex = newInterfacesLength++;
        }
        if (this.classDetails.shouldWeaveChangeTracking()) {
            persistenceWeavedChangeTrackingIndex = newInterfacesLength++;
        }
        int persistenceWeavedRestIndex = 0;
        boolean bl4 = weaveRest = this.classDetails.shouldWeaveREST() && this.classDetails.getSuperClassDetails() == null;
        if (weaveRest) {
            persistenceWeavedRestIndex = newInterfacesLength++;
        }
        String[] newInterfaces = new String[newInterfacesLength];
        System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
        newInterfaces[persistenceWeavedIndex] = PERSISTENCE_WEAVED_SHORT_SIGNATURE;
        this.weaved = true;
        if (weaveCloneable) {
            newInterfaces[cloneableIndex] = CLONEABLE_SHORT_SIGNATURE;
        }
        if (persistenceEntity) {
            newInterfaces[persistenceEntityIndex] = PERSISTENCE_ENTITY_SHORT_SIGNATURE;
        }
        if (persistenceObject) {
            newInterfaces[persistenceObjectIndex] = PERSISTENCE_OBJECT_SHORT_SIGNATURE;
        }
        if (fetchGroupTracker) {
            newInterfaces[fetchGroupTrackerIndex] = FETCHGROUP_TRACKER_SHORT_SIGNATURE;
        }
        if (this.classDetails.shouldWeaveFetchGroups()) {
            newInterfaces[persistenceWeavedFetchGroupsIndex] = WEAVED_FETCHGROUPS_SHORT_SIGNATURE;
        }
        if (this.classDetails.shouldWeaveValueHolders()) {
            newInterfaces[persistenceWeavedLazyIndex] = TW_LAZY_SHORT_SIGNATURE;
        }
        if (changeTracker) {
            newInterfaces[changeTrackerIndex] = CT_SHORT_SIGNATURE;
        }
        if (this.classDetails.shouldWeaveChangeTracking()) {
            newInterfaces[persistenceWeavedChangeTrackingIndex] = TW_CT_SHORT_SIGNATURE;
        }
        if (weaveRest) {
            newInterfaces[persistenceWeavedRestIndex] = WEAVED_REST_LAZY_SHORT_SIGNATURE;
        }
        String newSignature = null;
        if (signature != null) {
            StringBuffer newSignatureBuf = new StringBuffer();
            newSignatureBuf.append(signature);
            for (int i = interfaces.length; i < newInterfaces.length; ++i) {
                newSignatureBuf.append("L" + newInterfaces[i] + ";");
            }
            newSignature = newSignatureBuf.toString();
        }
        if (this.cw != null) {
            this.cv = this.cw;
        }
        this.cv.visit(version, access, name, newSignature, superName, newInterfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethodSuper(access, methodName, desc, signature, exceptions);
        if (!(this.alreadyWeaved || "<init>".equals(methodName) || "<cinit>".equals(methodName))) {
            mv = new MethodWeaver(this, methodName, desc, mv);
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        if (!this.alreadyWeaved) {
            if (this.classDetails.shouldWeaveInternal()) {
                this.addPersistencePostClone(this.classDetails);
                if (this.classDetails.getSuperClassDetails() == null) {
                    this.addShallowClone(this.classDetails);
                    if (!this.classDetails.isEmbedable()) {
                        this.addPersistenceEntityVariables();
                        this.addPersistenceEntityMethods(this.classDetails);
                        this.weavedPersistenceEntity = true;
                    }
                }
                this.addPersistenceNew(this.classDetails);
                this.addPersistenceGetSet(this.classDetails);
            }
            boolean attributeAccess = false;
            for (AttributeDetails attributeDetails : this.classDetails.getAttributesMap().values()) {
                if (attributeDetails.isAttributeOnSuperClass()) continue;
                if (attributeDetails.weaveValueHolders() && !attributeDetails.isAttributeOnSuperClass()) {
                    this.weaved = true;
                    this.weavedLazy = true;
                    this.addValueHolder(attributeDetails);
                    this.addInitializerForValueHolder(this.classDetails, attributeDetails);
                    this.addGetterMethodForValueHolder(this.classDetails, attributeDetails);
                    this.addSetterMethodForValueHolder(this.classDetails, attributeDetails);
                }
                if (!this.classDetails.shouldWeaveChangeTracking() && !this.classDetails.shouldWeaveFetchGroups() && !attributeDetails.weaveValueHolders() || !attributeDetails.hasField()) continue;
                this.weaved = true;
                this.addGetterMethodForFieldAccess(this.classDetails, attributeDetails);
                this.addSetterMethodForFieldAccess(this.classDetails, attributeDetails);
                attributeAccess = true;
            }
            if (this.classDetails.shouldWeaveChangeTracking()) {
                this.weaved = true;
                this.weavedChangeTracker = true;
                if (this.classDetails.getSuperClassDetails() == null || !this.classDetails.doesSuperclassWeaveChangeTracking()) {
                    this.addPropertyChangeListener(attributeAccess);
                    this.addGetPropertyChangeListener(this.classDetails);
                    this.addSetPropertyChangeListener(this.classDetails);
                    this.addPropertyChange(this.classDetails);
                }
            }
            if (this.classDetails.shouldWeaveFetchGroups()) {
                this.weaved = true;
                this.weavedFetchGroups = true;
                if (this.classDetails.getSuperClassDetails() == null) {
                    this.addFetchGroupVariables();
                    this.addFetchGroupMethods(this.classDetails);
                }
            }
        }
        if (this.classDetails.shouldWeaveREST() && this.classDetails.getSuperClassDetails() == null) {
            this.weavedRest = true;
            this.addPersistenceRestVariables();
            this.addPersistenceRestMethods(this.classDetails);
        }
        if (this.cw != null) {
            this.cw.visitEnd();
        } else {
            this.cv.visitEnd();
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return super.visitAnnotationSuper(desc, visible);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return super.visitFieldSuper(access, name, desc, signature, value);
    }
}

