/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.compile;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.FelEngineImpl;
import com.greenpineyu.fel.common.Callable;
import com.greenpineyu.fel.common.ReflectUtil;
import com.greenpineyu.fel.common.StringUtils;
import com.greenpineyu.fel.compile.ConstExpSrc;
import com.greenpineyu.fel.compile.JavaSource;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.compile.SourceGenerator;
import com.greenpineyu.fel.compile.VarBuffer;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.optimizer.ConstExpOpti;
import com.greenpineyu.fel.optimizer.ConstOpti;
import com.greenpineyu.fel.optimizer.Optimizer;
import com.greenpineyu.fel.parser.AbstFelNode;
import com.greenpineyu.fel.parser.ConstNode;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.parser.VarAstNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SourceGeneratorImpl
implements SourceGenerator {
    private List<Optimizer> opt = new ArrayList<Optimizer>();
    private static String template;
    private static int count;
    private Map<String, StringKeyValue> localvars = new HashMap<String, StringKeyValue>();
    static final String PACKAGE;
    public static final Callable<Boolean, FelNode> varsFilter;

    static {
        count = 0;
        String fullName = SourceGeneratorImpl.class.getName();
        PACKAGE = fullName.substring(0, fullName.lastIndexOf("."));
        StringBuilder sb = new StringBuilder();
        InputStream in = SourceGeneratorImpl.class.getResourceAsStream("java.template");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        template = sb.toString();
        varsFilter = new Callable<Boolean, FelNode>(){

            public Boolean call(FelNode ... node) {
                FelNode n = node[0];
                return VarAstNode.isVar(n);
            }
        };
    }

    public SourceGeneratorImpl() {
        this.initOpti();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaSource getSource(FelContext ctx, FelNode node) {
        String src = "";
        String className = this.getClassName();
        SourceGeneratorImpl sourceGeneratorImpl = this;
        synchronized (sourceGeneratorImpl) {
            node = this.optimize(ctx, node);
            if (node instanceof ConstNode) {
                ConstNode n = (ConstNode)node;
                return new ConstExpSrc(n.interpret(null, null));
            }
            SourceBuilder builder = node.toMethod(ctx);
            String exp = builder.source(ctx, node);
            src = this.buildsource(exp, className);
            this.localvars.clear();
        }
        JavaSource returnMe = new JavaSource();
        returnMe.setSimpleName(className);
        returnMe.setSource(src);
        returnMe.setPackageName(PACKAGE);
        return returnMe;
    }

    private String buildsource(String expression, String className) {
        String src = StringUtils.replace(template, "${classname}", className);
        StringBuilder attrs = new StringBuilder();
        String pop = VarBuffer.pop();
        if (pop != null) {
            attrs.append(pop).append("\r\n");
            pop = VarBuffer.pop();
        }
        while (pop != null) {
            attrs.append("    ").append(pop).append("\r\n");
            pop = VarBuffer.pop();
        }
        src = StringUtils.replace(src, "${attrs}", attrs.toString());
        src = StringUtils.replace(src, "${localVars}", this.getLocalVarsCode());
        src = StringUtils.replace(src, "${expression}", expression);
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getClassName() {
        String className = null;
        Class<SourceGeneratorImpl> clazz = SourceGeneratorImpl.class;
        synchronized (SourceGeneratorImpl.class) {
            className = "Fel_" + count++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return className;
        }
    }

    private String getLocalVarsCode() {
        StringBuilder sb = new StringBuilder();
        Collection<StringKeyValue> values = this.localvars.values();
        boolean isFirst = true;
        for (StringKeyValue code : values) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("        ");
            }
            sb.append(code.value).append("\r\n");
        }
        this.removeLastEnter(sb);
        return sb.toString();
    }

    private void removeLastEnter(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
    }

    private FelNode optimize(FelContext ctx, FelNode node) {
        for (Optimizer o : this.opt) {
            node = o.call(ctx, node);
        }
        return node;
    }

    private void initOpti() {
        ConstOpti constOpti = new ConstOpti();
        this.addOpti(constOpti);
        ConstExpOpti constExpOpti = new ConstExpOpti();
        this.addOpti(constExpOpti);
        Optimizer optimizVars = this.getVarOpti();
        this.addOpti(optimizVars);
    }

    private Optimizer getVarOpti() {
        Optimizer optimizVars = new Optimizer(){

            public FelNode call(FelContext ctx, FelNode node) {
                List<FelNode> nodes = AbstFelNode.getNodes(node, varsFilter);
                HashMap<String, ArrayList<FelNode>> repeatNodeMap = new HashMap<String, ArrayList<FelNode>>();
                for (FelNode n : nodes) {
                    String name = n.getText();
                    ArrayList<FelNode> repeatNodes = (ArrayList<FelNode>)repeatNodeMap.get(name);
                    if (repeatNodes == null) {
                        repeatNodes = new ArrayList<FelNode>();
                        repeatNodeMap.put(name, repeatNodes);
                    }
                    repeatNodes.add(n);
                }
                for (List repeatNodes : repeatNodeMap.values()) {
                    if (repeatNodes.size() <= 1) continue;
                    for (FelNode n : repeatNodes) {
                        n.setSourcebuilder(this.getVarSrcBuilder(n.toMethod(ctx)));
                    }
                }
                return node;
            }

            private void setVarSourceBuilder(FelContext ctx, FelNode node) {
                if (node instanceof VarAstNode) {
                    node.setSourcebuilder(this.getVarSrcBuilder(node.toMethod(ctx)));
                } else {
                    List<FelNode> children = node.getChildren();
                    if (children != null && !children.isEmpty()) {
                        for (FelNode child : children) {
                            this.setVarSourceBuilder(ctx, child);
                        }
                    }
                }
            }

            private SourceBuilder getVarSrcBuilder(final SourceBuilder old) {
                return new SourceBuilder(){

                    @Override
                    public String source(FelContext ctx, FelNode node) {
                        String text = node.getText();
                        if (SourceGeneratorImpl.this.localvars.containsKey(text)) {
                            StringKeyValue kv = (StringKeyValue)SourceGeneratorImpl.this.localvars.get(text);
                            return kv.key;
                        }
                        String varName = text;
                        Class<?> type = this.returnType(ctx, node);
                        String declare = "";
                        String typeDeclare = type.getCanonicalName();
                        if (ReflectUtil.isPrimitiveOrWrapNumber(type)) {
                            Class<?> primitiveClass = ReflectUtil.toPrimitiveClass(type);
                            typeDeclare = primitiveClass.getSimpleName();
                        } else if (Number.class.isAssignableFrom(type)) {
                            typeDeclare = "double";
                        }
                        declare = String.valueOf(typeDeclare) + " " + varName + " = " + old.source(ctx, node) + ";   //" + text;
                        StringKeyValue kv = new StringKeyValue(varName, declare);
                        SourceGeneratorImpl.this.localvars.put(text, kv);
                        return varName;
                    }

                    @Override
                    public Class<?> returnType(FelContext ctx, FelNode n) {
                        return old.returnType(ctx, n);
                    }
                };
            }
        };
        return optimizVars;
    }

    public void addOpti(Optimizer opti) {
        this.opt.add(opti);
    }

    public static void main(String[] args) {
        FelEngineImpl engine = new FelEngineImpl();
        FelContext ctx = engine.getContext();
        ctx.set("i", 100);
        ctx.set("pi", Float.valueOf(3.14f));
        String exp = "pi*i*i*pi";
        Expression expObj = engine.compile(exp, ctx, new Optimizer[0]);
        Object eval = expObj.eval(ctx);
        SourceGeneratorImpl.cost(ctx, expObj);
        System.out.println(eval);
    }

    private static void cost(FelContext ctx, Expression expObj) {
        int count = 10000000;
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < count) {
            expObj.eval(ctx);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println(end - start);
    }

    class StringKeyValue {
        String key;
        String value;

        public StringKeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

